/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.pbx.chatMessage.service;

import com.coraltele.db.telephony.pbx.entity.ChatMessage;
import com.coraltele.db.telephony.pbx.entity.Extension;
import com.coraltele.db.telephony.pbx.repository.ChatMessageRepository;
import com.coraltele.db.telephony.pbx.repository.ExtensionsRepository;
import com.coraltele.helper.ChannelMessage;
import com.coraltele.helper.Constants;
import com.coraltele.helper.HttpUtils;
import com.coraltele.helper.RequestResponse;
import com.coraltele.service.pbx.chatMessage.model.ChatMessageModel;
import com.coraltele.service.pbx.chatMessage.model.SendMessageModel;
import com.coraltele.service.pbx.chatMessage.model.SendSingleMessageModel;
import com.coraltele.service.pbx.conferenceSettings.service.ConferenceSettingsService;
import com.coraltele.service.pbx.extension.service.ExtensionsService;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class ChatMessageService {
    private static final Logger logger = LogManager.getLogger(ConferenceSettingsService.class);
    @Autowired
    ChatMessageRepository chatMessageRepository;
    @Autowired
    private ExtensionsService extensionsService;
    @Autowired
    private ExtensionsRepository extensionsRepository;

    public RequestResponse sendMessageByDepartment(SendMessageModel data, Principal principal) {
        RequestResponse returnValue = new RequestResponse();
        String sender = this.extensionsService.getExtensionOfUser(principal.getName());
        ArrayList<String> receiverList = new ArrayList<String>();
        logger.info("message send for selected department:{}", (Object)data.getDepartment());
        if (!StringUtils.hasLength((String)data.getDepartment()) || !StringUtils.hasLength((String)data.getDepartment())) {
            logger.error("Invalid Department type:{}", (Object)data.getDepartment());
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Invalid Department");
            return returnValue;
        }
        try {
            List extensionList = this.extensionsRepository.findByExtensionTypeAndDepartment("phone", data.getDepartment());
            if (!extensionList.isEmpty()) {
                for (Extension extensionData : extensionList) {
                    String extensionNumber = extensionData.getExtension();
                    if (extensionNumber.equals(sender)) continue;
                    receiverList.add(extensionNumber);
                }
            } else {
                logger.error("Not any record exist of given Department:{}", (Object)data.getDepartment());
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("No data present in given Department");
                return returnValue;
            }
            logger.info("List of Reciever number:{}", receiverList);
            long currentTime = System.currentTimeMillis();
            if (!receiverList.isEmpty()) {
                ChatMessage record;
                for (String receiver : receiverList) {
                    record = new ChatMessage();
                    record.setEpoch(Long.valueOf(currentTime));
                    record.setSender(sender);
                    record.setReceiver(receiver);
                    record.setType("S");
                    record.setMessageDetails(data.getMessageDetail());
                    record.setUsers(sender);
                    this.chatMessageRepository.save((Object)record);
                    logger.info("New message created - Sender: {}, Receiver: {}, Type: {}", (Object)sender, (Object)receiver, (Object)record.getType());
                }
                for (String receiver : receiverList) {
                    record = new ChatMessage();
                    record.setEpoch(Long.valueOf(currentTime));
                    record.setSender(sender);
                    record.setReceiver(receiver);
                    record.setType("R");
                    record.setMessageDetails(data.getMessageDetail());
                    record.setUsers(receiver);
                    this.chatMessageRepository.save((Object)record);
                    logger.info("New message created - Sender: {}, Receiver: {}, Type: {}", (Object)sender, (Object)receiver, (Object)record.getType());
                }
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("Message Send successfully");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("error during sending message:{}", (Object)e.getMessage());
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Unable to send message");
        }
        return returnValue;
    }

    public RequestResponse sendMessageByZone(SendMessageModel data, Principal principal) {
        RequestResponse returnValue = new RequestResponse();
        String sender = this.extensionsService.getExtensionOfUser(principal.getName());
        ArrayList<String> receiverList = new ArrayList<String>();
        logger.info("message send for selected zone:{}", (Object)data.getZone());
        if (!StringUtils.hasLength((String)data.getZone()) || !StringUtils.hasLength((String)data.getZone())) {
            logger.error("Invalid Zone type:{}", (Object)data.getZone());
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Invalid Zone");
            return returnValue;
        }
        try {
            List extensionList = this.extensionsRepository.findByExtensionTypeAndZone("phone", data.getZone());
            if (!extensionList.isEmpty()) {
                for (Extension extensionData : extensionList) {
                    String extensionNumber = extensionData.getExtension();
                    if (extensionNumber.equals(sender)) continue;
                    receiverList.add(extensionNumber);
                }
            } else {
                logger.error("Not any record exist of given zone:{}", (Object)data.getZone());
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("No data present in given zone");
                return returnValue;
            }
            logger.info("List of Reciever number:{}", receiverList);
            long currentTime = System.currentTimeMillis();
            if (!receiverList.isEmpty()) {
                ChatMessage record;
                for (String receiver : receiverList) {
                    record = new ChatMessage();
                    record.setEpoch(Long.valueOf(currentTime));
                    record.setSender(sender);
                    record.setReceiver(receiver);
                    record.setType("S");
                    record.setMessageDetails(data.getMessageDetail());
                    record.setUsers(sender);
                    this.chatMessageRepository.save((Object)record);
                    logger.info("New message created - Sender: {}, Receiver: {}, Type: {}", (Object)sender, (Object)receiver, (Object)record.getType());
                }
                for (String receiver : receiverList) {
                    record = new ChatMessage();
                    record.setEpoch(Long.valueOf(currentTime));
                    record.setSender(sender);
                    record.setReceiver(receiver);
                    record.setType("R");
                    record.setMessageDetails(data.getMessageDetail());
                    record.setUsers(receiver);
                    this.chatMessageRepository.save((Object)record);
                    logger.info("New message created - Sender: {}, Receiver: {}, Type: {}", (Object)sender, (Object)receiver, (Object)record.getType());
                }
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("Message Send successfully");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("error during sending message:{}", (Object)e.getMessage());
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Unable to send message");
        }
        return returnValue;
    }

    public RequestResponse getAllData(Principal principal) {
        String userExtension = this.extensionsService.getExtensionOfUser(principal.getName());
        List list = this.chatMessageRepository.findByUsers(userExtension);
        ArrayList<ChatMessageModel> addValue = new ArrayList<ChatMessageModel>();
        RequestResponse returnValue = new RequestResponse();
        for (ChatMessage data : list) {
            ChatMessageModel chatMessageModel = new ChatMessageModel();
            chatMessageModel.setId(data.getId());
            chatMessageModel.setEpoch(data.getEpoch());
            chatMessageModel.setMessageDetails(data.getMessageDetails());
            chatMessageModel.setSender(data.getSender());
            chatMessageModel.setReceiver(data.getReceiver());
            chatMessageModel.setType(data.getType());
            chatMessageModel.setUsers(data.getUsers());
            addValue.add(chatMessageModel);
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setData(addValue);
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse sendSocketMessageByZone(SendMessageModel data) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList<String> receiverList = new ArrayList<String>();
        logger.info("message send for selected zone:{}", (Object)data.getZone());
        if (!StringUtils.hasLength((String)data.getZone()) || !StringUtils.hasLength((String)data.getZone())) {
            logger.error("Invalid Zone type:{}", (Object)data.getZone());
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Invalid Zone");
            return returnValue;
        }
        try {
            List extensionList = this.extensionsRepository.findByExtensionTypeAndZone("phone", data.getZone());
            if (!extensionList.isEmpty()) {
                for (Extension extensionData : extensionList) {
                    String extensionNumber = extensionData.getExtension();
                    receiverList.add(extensionNumber);
                }
            } else {
                logger.error("Not any record exist of given zone:{}", (Object)data.getZone());
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("No data present in given zone");
                return returnValue;
            }
            logger.info("List of Receiver number:{}", receiverList);
            if (!receiverList.isEmpty()) {
                for (String receiver : receiverList) {
                    ChannelMessage message = new ChannelMessage();
                    message.setTopic(String.format("dm_%s_alert", receiver));
                    message.setSubTopic(data.getZone());
                    message.setNumber(receiver);
                    message.setName(data.getMessageDetail());
                    HttpUtils.sendToWebSocket((ChannelMessage)message);
                }
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("Message Send successfully");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("error during sending message:{}", (Object)e.getMessage());
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Unable to send message");
        }
        return returnValue;
    }

    public RequestResponse sendSocketMessageByDepartment(SendMessageModel data) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList<String> receiverList = new ArrayList<String>();
        logger.info("message send for selected department:{}", (Object)data.getDepartment());
        if (!StringUtils.hasLength((String)data.getDepartment()) || !StringUtils.hasLength((String)data.getDepartment())) {
            logger.error("Invalid Department type:{}", (Object)data.getDepartment());
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Invalid Department");
            return returnValue;
        }
        try {
            List extensionList = this.extensionsRepository.findByExtensionTypeAndDepartment("phone", data.getDepartment());
            if (!extensionList.isEmpty()) {
                for (Extension extensionData : extensionList) {
                    String extensionNumber = extensionData.getExtension();
                    receiverList.add(extensionNumber);
                }
            } else {
                logger.error("Not any record exist of given department:{}", (Object)data.getZone());
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("No data present in given department");
                return returnValue;
            }
            logger.info("List of Receiver number:{}", receiverList);
            if (!receiverList.isEmpty()) {
                for (String receiver : receiverList) {
                    ChannelMessage message = new ChannelMessage();
                    message.setTopic(String.format("dm_%s_alert", receiver));
                    message.setSubTopic(data.getZone());
                    message.setNumber(receiver);
                    message.setName(data.getMessageDetail());
                    HttpUtils.sendToWebSocket((ChannelMessage)message);
                }
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("Message Send successfully");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("error during sending message:{}", (Object)e.getMessage());
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Unable to send message");
        }
        return returnValue;
    }

    public RequestResponse sendMessageToExtension(SendSingleMessageModel data) {
        RequestResponse returnValue = new RequestResponse();
        logger.info("Message send for selected extension: {}", (Object)data);
        try {
            Extension extensionData = (Extension)this.extensionsRepository.findByExtension(data.getExtension()).orElseThrow(() -> new NoSuchElementException("Selected extension does not exist: " + data.getExtension()));
            ChannelMessage message = new ChannelMessage();
            message.setTopic(String.format("dm_%s_alert", extensionData.getExtension()));
            message.setSubTopic(extensionData.getExtension());
            message.setNumber(extensionData.getExtension());
            message.setName(data.getMessageDetail());
            HttpUtils.sendToWebSocket((ChannelMessage)message);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("Message sent successfully");
        }
        catch (NoSuchElementException e) {
            logger.error(e.getMessage());
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage(e.getMessage());
        }
        catch (Exception e) {
            logger.error("Error during sending message: {}", (Object)e.getMessage());
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Unable to send message");
        }
        return returnValue;
    }
}

