/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.coralApps.callcenter.dnd.service;

import com.coraltele.db.coralapps.callcenter.entity.DND;
import com.coraltele.db.coralapps.callcenter.repository.DNDRepository;
import com.coraltele.db.coralapps.callcenter.specification.DNDSpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.coralApps.callcenter.dnd.model.DNDModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class DNDService {
    private static final Logger logger = LogManager.getLogger(DNDService.class);
    @Autowired
    DNDRepository dndRepository;

    public RequestResponse createDataInDnd(DNDModel data) {
        logger.debug("create new DND : {} ", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        try {
            DND dnd = new DND();
            dnd.setPhoneNo(data.getPhoneNo());
            dnd.setRefNo(data.getRefNo());
            this.dndRepository.save((Object)dnd);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("OK");
            returnValue.setMessageDetail("DND Created Successfully");
            logger.info(returnValue.getMessage());
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.BAD_CREDENTIAL);
            returnValue.setMessage("Unable to Create DND");
            returnValue.setMessageDetail("Contact with Administrator");
            logger.error(returnValue.getMessageDetail(), (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse updateById(DNDModel data) {
        logger.debug("Update DND {}", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        Optional dnd = this.dndRepository.findById((Object)data.getId());
        if (!dnd.isPresent()) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("not found");
            returnValue.setMessageDetail("DND not found");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        if (data.getPhoneNo() != null) {
            ((DND)dnd.get()).setPhoneNo(data.getPhoneNo());
        }
        if (data.getRefNo() != null) {
            ((DND)dnd.get()).setRefNo(data.getRefNo());
        }
        this.dndRepository.save(dnd.get());
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Updated");
        returnValue.setMessageDetail("DND Updated successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse deleteAgentById(InputIdModel data) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList addValue = new ArrayList();
        for (Integer ids : data.getIntId()) {
            Optional dnd = this.dndRepository.findById((Object)ids);
            if (dnd.isPresent()) {
                addValue.add(dnd.get());
                this.dndRepository.deleteAll(addValue);
                continue;
            }
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Records not found ");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setMessageDetail("Records Deleted Successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getAllByFilter(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = DNDSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.getSortDirection().equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "id" : searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.getSortDirection().equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "id" : searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.dndRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.dndRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)this.entityToModelConversion(page.getContent()));
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public List<DNDModel> entityToModelConversion(List<DND> dnd) {
        ArrayList<DNDModel> addValue = new ArrayList<DNDModel>();
        for (DND row : dnd) {
            DNDModel data = new DNDModel();
            data.setId(row.getId());
            data.setPhoneNo(row.getPhoneNo());
            data.setRefNo(row.getRefNo());
            addValue.add(data);
        }
        return addValue;
    }
}

