/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.complaint.complaintDetail.service;

import com.coraltele.db.telephony.complaint.entity.ComplaintHistory;
import com.coraltele.db.telephony.complaint.repository.ComplaintDetailApprovalRepository;
import com.coraltele.db.telephony.complaint.repository.ComplaintDetailAssignmentRepository;
import com.coraltele.db.telephony.complaint.repository.ComplaintDetailClosedRepository;
import com.coraltele.db.telephony.complaint.repository.ComplaintDetailEngineerRepository;
import com.coraltele.db.telephony.complaint.repository.ComplaintDetailRepository;
import com.coraltele.db.telephony.complaint.repository.ComplaintHistoryRepository;
import com.coraltele.db.telephony.complaint.specification.ComplaintDetailApprovalSpecification;
import com.coraltele.db.telephony.complaint.specification.ComplaintDetailAssignmentSpecification;
import com.coraltele.db.telephony.complaint.specification.ComplaintDetailClosedSpecification;
import com.coraltele.db.telephony.complaint.specification.ComplaintDetailEngineerSpecification;
import com.coraltele.db.telephony.complaint.specification.ComplaintDetailSpecification;
import com.coraltele.db.telephony.pbx.entity.SystemConfig;
import com.coraltele.db.telephony.pbx.entity.TCdr;
import com.coraltele.db.telephony.pbx.repository.ControlRluServerRepository;
import com.coraltele.db.telephony.pbx.repository.SystemConfigRepository;
import com.coraltele.db.telephony.pbx.repository.TCdrRepository;
import com.coraltele.db.users.main.entity.User;
import com.coraltele.db.users.main.entity.UserRole;
import com.coraltele.db.users.main.repository.RoleRepository;
import com.coraltele.db.users.main.repository.UserRepository;
import com.coraltele.db.users.main.repository.UserRoleRepository;
import com.coraltele.helper.BashCmd;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.helper.Telephony;
import com.coraltele.helper.TelephonyCommand;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.billing.main.fax.service.FaxService;
import com.coraltele.service.pbx.t_cdr.model.TCdrModel;
import com.coraltele.service.user.service.UserRoleService;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.Principal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.ini4j.Ini;
import org.ini4j.Profile;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class ComplaintDetailService {
    private static final Logger logger = LogManager.getLogger(ComplaintDetailService.class);
    @Autowired
    ComplaintDetailRepository complaintDetailRepo;
    @Autowired
    ComplaintDetailAssignmentRepository complaintDetailAssignmentRepository;
    @Autowired
    ComplaintDetailEngineerRepository complaintDetailEngineerRepository;
    @Autowired
    ComplaintDetailClosedRepository closedRepository;
    @Autowired
    ComplaintDetailApprovalRepository complaintDetailApprovalRepository;
    @Autowired
    ComplaintHistoryRepository complaintHistoryRepository;
    @Autowired
    TCdrRepository tCdrRepository;
    @Autowired
    UserRepository userRepository;
    @Autowired
    UserRoleRepository userRoleRepository;
    @Autowired
    RoleRepository roleRepository;
    @Autowired
    UserRoleService userRoleService;
    @Autowired
    SystemConfigRepository systemConfigRepository;
    @Autowired
    ControlRluServerRepository controlRluServerRepository;
    @Autowired
    FaxService faxService;
    @Autowired
    TelephonyCommand telephonyCommand;
    @Autowired
    BashCmd bashCmd;

    public RequestResponse getAllCloseComplaint(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = ComplaintDetailSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.getSortDirection().equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "complaintNo" : searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.getSortDirection().equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "complaintNo" : searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.complaintDetailRepo.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.complaintDetailRepo.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)page.getContent());
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getAllComplaintAssignment(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = ComplaintDetailAssignmentSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.sortDirection.equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).ascending();
        } else if (searchRequestData.sortDirection.equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).descending();
        }
        Page page = null;
        page = sort == null ? this.complaintDetailAssignmentRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.complaintDetailAssignmentRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)page.getContent());
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getAllComplaintEngineer(SearchRequest searchRequestData, Principal principal) {
        RequestResponse returnValue = new RequestResponse();
        String agentId = "";
        if (!this.checkAdminOrHead(principal.getName())) {
            agentId = principal.getName();
        }
        Specification filters = ComplaintDetailEngineerSpecification.generateFilters((SearchRequest)searchRequestData, (String)agentId);
        Sort sort = null;
        if (searchRequestData.sortDirection.equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).ascending();
        } else if (searchRequestData.sortDirection.equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).descending();
        }
        Page page = null;
        page = sort == null ? this.complaintDetailEngineerRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.complaintDetailEngineerRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)page.getContent());
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getAllComplaintClosed(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = ComplaintDetailClosedSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.sortDirection.equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).ascending();
        } else if (searchRequestData.sortDirection.equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).descending();
        }
        Page page = null;
        page = sort == null ? this.closedRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.closedRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)page.getContent());
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getAllComplaintDetailApproval(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = ComplaintDetailApprovalSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.sortDirection.equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).ascending();
        } else if (searchRequestData.sortDirection.equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).descending();
        }
        Page page = null;
        page = sort == null ? this.complaintDetailApprovalRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.complaintDetailApprovalRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)page.getContent());
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse updateByComplaintNoForAssignment(TCdrModel data, Principal principal) {
        logger.debug("Update {}", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        Optional tCdr = this.tCdrRepository.findByCoralDialId(data.getCoralDialId());
        if (!tCdr.isPresent()) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("not found");
            returnValue.setMessageDetail("TCdr not found");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        ((TCdr)tCdr.get()).setCoralBalance(Long.valueOf(1L));
        ((TCdr)tCdr.get()).setCcAgent(data.getCcAgent());
        ComplaintHistory complaintHistory = new ComplaintHistory();
        complaintHistory.setComplaintNo(((TCdr)tCdr.get()).getCoralDialId());
        complaintHistory.setActor(principal.getName());
        complaintHistory.setAction("assigned to agent");
        complaintHistory.setActionDate(LocalDateTime.now());
        complaintHistory.setRemarks(data.getRemarks());
        complaintHistory.setToUser(((TCdr)tCdr.get()).getCcAgent());
        this.tCdrRepository.save(tCdr.get());
        this.complaintHistoryRepository.save((Object)complaintHistory);
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Updated");
        returnValue.setMessageDetail("TCdr Updated successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse updateByComplaintNoForEngineerForAdminAndHed(TCdrModel data, Principal principal) {
        logger.debug("Update {}", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        Optional tCdr = this.tCdrRepository.findByCoralDialId(data.getCoralDialId());
        if (!tCdr.isPresent()) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("not found");
            returnValue.setMessageDetail("TCdr not found");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        Optional user = this.userRepository.findByUsername(principal.getName());
        List userRole = this.userRoleRepository.findByUser((User)user.get());
        for (UserRole infRole : userRole) {
            if (!infRole.getRole().getShortCode().equals("ROLE_ADMIN") && !infRole.getRole().getShortCode().equals("ROLE_DEPTHEAD")) continue;
            ((TCdr)tCdr.get()).setCoralBalance(Long.valueOf(1L));
            ((TCdr)tCdr.get()).setCcAgent(data.getCcAgent());
            ComplaintHistory complaintHistory = new ComplaintHistory();
            complaintHistory.setComplaintNo(((TCdr)tCdr.get()).getCoralDialId());
            complaintHistory.setActor(principal.getName());
            complaintHistory.setAction("assigned to agent");
            complaintHistory.setActionDate(LocalDateTime.now());
            complaintHistory.setRemarks(data.getRemarks());
            complaintHistory.setToUser(((TCdr)tCdr.get()).getCcAgent());
            this.tCdrRepository.save(tCdr.get());
            this.complaintHistoryRepository.save((Object)complaintHistory);
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Updated");
        returnValue.setMessageDetail("TCdr Updated successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse updateByComplaintNoForEngineer(TCdrModel data, Principal principal) {
        logger.debug("Update", (Object)data);
        logger.info("Update CMS for calling:{}", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        Optional tCdr = this.tCdrRepository.findByCoralDialId(data.getCoralDialId());
        if (!tCdr.isPresent()) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("not found");
            returnValue.setMessageDetail("TCdr not found");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        logger.info("markAsRead:{}", (Object)data.getMarkAsRead());
        if (data.getMarkAsRead() != null && data.getMarkAsRead().booleanValue()) {
            Boolean cmsConfirmation = this.getCmsConfirmation();
            Optional user = this.userRepository.findByUsername(principal.getName());
            List userRole = this.userRoleRepository.findByUser((User)user.get());
            if (cmsConfirmation.booleanValue()) {
                for (UserRole infRole : userRole) {
                    try {
                        if (!infRole.getRole().getShortCode().equals("ROLE_ENGINEER")) continue;
                        ((TCdr)tCdr.get()).setCoralBalance(Long.valueOf(2L));
                        ((TCdr)tCdr.get()).setCcAgent(data.getCcAgent());
                        ComplaintHistory complaintHistory = new ComplaintHistory();
                        complaintHistory.setComplaintNo(((TCdr)tCdr.get()).getCoralDialId());
                        complaintHistory.setActor(principal.getName());
                        complaintHistory.setActionDate(LocalDateTime.now());
                        complaintHistory.setRemarks("WAITING_FOR_RESPONSE");
                        this.tCdrRepository.save(tCdr.get());
                        this.complaintHistoryRepository.save((Object)complaintHistory);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        logger.error("Error while updating data");
                    }
                }
                List systemConfigs = this.systemConfigRepository.findAll();
                Integer cliNumber = ((SystemConfig)systemConfigs.get(0)).getComplaintCliNumber();
                logger.info("cliNumber:{}", (Object)cliNumber);
                String command1 = String.format("fs_cli -x \"bgapi originate {origination_caller_id_number=%s,origination_caller_id_name=CMS-Support,id1=%s,id2=%s,ignore_early_media=true}%s '&lua(cms.lua)'\"", cliNumber, data.getCoralDialId(), data.getCcAgent(), this.bashCmd.dialString1(data.getExt()));
                logger.info("Command for CMS:{}", (Object)command1);
                Telephony.makeCallBackCall((String)command1);
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("Executed");
                returnValue.setMessageDetail("Command Executed Successfully");
            } else {
                for (UserRole infRole : userRole) {
                    if (!infRole.getRole().getShortCode().equals("ROLE_ENGINEER")) continue;
                    ((TCdr)tCdr.get()).setCoralBalance(Long.valueOf(2L));
                    ((TCdr)tCdr.get()).setCcAgent(data.getCcAgent());
                    ComplaintHistory complaintHistory = new ComplaintHistory();
                    complaintHistory.setComplaintNo(((TCdr)tCdr.get()).getCoralDialId());
                    complaintHistory.setActor(principal.getName());
                    complaintHistory.setAction("Solution Given");
                    complaintHistory.setActionDate(LocalDateTime.now());
                    complaintHistory.setLatitude("undefined");
                    complaintHistory.setLongitude("undefined");
                    complaintHistory.setRemarks(data.getRemarks());
                    this.tCdrRepository.save(tCdr.get());
                    this.complaintHistoryRepository.save((Object)complaintHistory);
                }
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("Updated");
                returnValue.setMessageDetail("TCdr Updated successfully");
                logger.info(returnValue.getMessage());
            }
        } else {
            Optional user = this.userRepository.findByUsername(principal.getName());
            List userRole = this.userRoleRepository.findByUser((User)user.get());
            for (UserRole infRole : userRole) {
                if (!infRole.getRole().getShortCode().equals("ROLE_ENGINEER")) continue;
                ((TCdr)tCdr.get()).setCoralBalance(Long.valueOf(1L));
                ((TCdr)tCdr.get()).setCcAgent(data.getCcAgent());
                ComplaintHistory complaintHistory = new ComplaintHistory();
                complaintHistory.setComplaintNo(((TCdr)tCdr.get()).getCoralDialId());
                complaintHistory.setActor(principal.getName());
                complaintHistory.setAction("Solution Given");
                complaintHistory.setActionDate(LocalDateTime.now());
                complaintHistory.setLatitude("undefined");
                complaintHistory.setLongitude("undefined");
                complaintHistory.setRemarks(data.getRemarks());
                this.tCdrRepository.save(tCdr.get());
                this.complaintHistoryRepository.save((Object)complaintHistory);
            }
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("Updated");
            returnValue.setMessageDetail("TCdr Updated successfully");
            logger.info(returnValue.getMessage());
        }
        return returnValue;
    }

    public RequestResponse updateByComplaintNoForApproved(TCdrModel data, Principal principal) {
        logger.debug("Update {}", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        Optional tCdr = this.tCdrRepository.findByCoralDialId(data.getCoralDialId());
        if (!tCdr.isPresent()) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("not found");
            returnValue.setMessageDetail("TCdr not found");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        ((TCdr)tCdr.get()).setCoralBalance(Long.valueOf(3L));
        ComplaintHistory complaintHistory = new ComplaintHistory();
        complaintHistory.setComplaintNo(((TCdr)tCdr.get()).getCoralDialId());
        complaintHistory.setActor(principal.getName());
        complaintHistory.setAction("Task Closed");
        complaintHistory.setActionDate(LocalDateTime.now());
        complaintHistory.setRemarks("Closed");
        this.tCdrRepository.save(tCdr.get());
        this.complaintHistoryRepository.save((Object)complaintHistory);
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Updated");
        returnValue.setMessageDetail("TCdr Updated successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse updateByComplaintNoForAssignToOtherUser(TCdrModel data, Principal principal) {
        logger.debug("Update {}", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        Optional tCdr = this.tCdrRepository.findByCoralDialId(data.getCoralDialId());
        if (!tCdr.isPresent()) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("not found");
            returnValue.setMessageDetail("TCdr not found");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        ((TCdr)tCdr.get()).setCoralBalance(Long.valueOf(1L));
        ((TCdr)tCdr.get()).setCcAgent(data.getCcAgent());
        ComplaintHistory complaintHistory = new ComplaintHistory();
        complaintHistory.setComplaintNo(((TCdr)tCdr.get()).getCoralDialId());
        complaintHistory.setActor(principal.getName());
        complaintHistory.setAction("assigned to agent");
        complaintHistory.setActionDate(LocalDateTime.now());
        complaintHistory.setToUser(((TCdr)tCdr.get()).getCcAgent());
        complaintHistory.setRemarks(data.getRemarks());
        this.tCdrRepository.save(tCdr.get());
        this.complaintHistoryRepository.save((Object)complaintHistory);
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Updated");
        returnValue.setMessageDetail("TCdr Updated successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public boolean checkAdminOrHead(String userName) {
        Optional roleHead = this.roleRepository.findByShortCode("ROLE_DEPTHEAD");
        Optional roleAdmin = this.roleRepository.findByShortCode("ROLE_ADMIN");
        ArrayList roleId = new ArrayList();
        roleHead.ifPresent(role -> roleId.add(role.getId()));
        roleAdmin.ifPresent(role -> roleId.add(role.getId()));
        List havingRole = this.userRoleService.roleIdOfParticularUser(userName);
        for (Integer id : roleId) {
            if (!havingRole.contains(id)) continue;
            return true;
        }
        return false;
    }

    public Boolean getCmsConfirmation() {
        String configurationFile = "/etc/coraltele/conf/app.config";
        boolean cmsConfirmation = false;
        Properties properties = new Properties();
        try (FileInputStream input = new FileInputStream(configurationFile);){
            properties.load(input);
            cmsConfirmation = Boolean.parseBoolean(properties.getProperty("cmsconfirmation"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return cmsConfirmation;
    }

    public String getIpFeatureServerByRLU() {
        String coralFilePath = "/etc/default/coral";
        String ipFeatureServer = "";
        try {
            File file = new File(coralFilePath);
            if (file.exists()) {
                Profile.Section cscfSection;
                Ini ini = new Ini(file);
                List controlRluServers = this.controlRluServerRepository.findAllByOrderByIdAsc();
                if (controlRluServers.size() >= 1) {
                    Profile.Section cscfSection2;
                    if (ini.containsKey((Object)"CSCF-2") && (cscfSection2 = (Profile.Section)ini.get((Object)"CSCF-2")).containsKey((Object)"IP-FEATURE-SERVER")) {
                        ipFeatureServer = (String)cscfSection2.get((Object)"IP-FEATURE-SERVER");
                    }
                } else if (ini.containsKey((Object)"CSCF-1") && (cscfSection = (Profile.Section)ini.get((Object)"CSCF-1")).containsKey((Object)"IP-FEATURE-SERVER")) {
                    ipFeatureServer = (String)cscfSection.get((Object)"IP-FEATURE-SERVER");
                }
            }
        }
        catch (Exception e) {
            e.getMessage();
        }
        return ipFeatureServer;
    }
}

