/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.cliServices.services;

import com.coraltele.db.telephony.pbx.entity.CLIServerCommandLog;
import com.coraltele.db.telephony.pbx.repository.CLIServerCommandLogRepository;
import com.coraltele.db.telephony.pbx.specification.CliServerCommandLogSpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.DateFormatUtility;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.cliServices.model.CLiServerModel;
import java.io.FileInputStream;
import java.io.UnsupportedEncodingException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Enumeration;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.PostConstruct;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.WebAuthenticationDetails;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class CliServerCommandServices {
    private static final Logger logger = LogManager.getLogger(CliServerCommandServices.class);
    private String serverCode = "s";
    private static long lastAccessTime = 0L;
    private Lock lock = new ReentrantLock();
    @Autowired
    private CLIServerCommandLogRepository cliServerCommandLogRepository;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostConstruct
    public void init() {
        String fileName = "/etc/coraltelecom/callserver.manager.conf";
        Properties prop = new Properties();
        try (FileInputStream input = new FileInputStream(fileName);){
            prop.load(input);
            this.serverCode = prop.getProperty("servercode", "s");
            input.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.serverCode = "s";
        }
        finally {
            logger.info("Server code is :: {}", (Object)this.serverCode);
        }
    }

    public RequestResponse getAllApprovalCommands(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = CliServerCommandLogSpecification.generateFilters((SearchRequest)searchRequestData, (String)this.serverCode);
        Sort sort = null;
        if (searchRequestData.getSortDirection().equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "id" : searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.getSortDirection().equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "id" : searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.cliServerCommandLogRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.cliServerCommandLogRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)this.entityToModelConversion(page.getContent()));
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public List<CLiServerModel> entityToModelConversion(List<CLIServerCommandLog> entities) {
        ArrayList<CLiServerModel> models = new ArrayList<CLiServerModel>();
        for (CLIServerCommandLog row : entities) {
            CLiServerModel model = new CLiServerModel();
            model.setId(row.getId());
            model.setRecordCreatedOn(DateFormatUtility.formatToString((LocalDateTime)row.getRecordCreatedOn()));
            model.setRecordCreatedBy(row.getRecordCreatedBy());
            model.setOutputFileName(row.getOutputFileName());
            model.setOutputFilePath(row.getOutputFilePath());
            model.setExecutionStarted(row.getExecutionStarted());
            model.setExecutionStartTime(DateFormatUtility.formatToString((LocalDateTime)row.getExecutionStartTime()));
            model.setExecutionEndTime(DateFormatUtility.formatToString((LocalDateTime)row.getExecutionEndTime()));
            model.setExecutionCommand(row.getExecutionCommand());
            model.setExecutionDoneBy(row.getExecutionDoneBy());
            model.setFileMovedToProcessed(row.getFileMovedToProcessed());
            model.setProcessedFolderPath(row.getProcessedFolderPath());
            model.setIsError(row.getIsError());
            model.setErrorMessage(row.getErrorMessage());
            model.setRemarks(row.getRemarks());
            model.setExecuted("Pending");
            if (row.getCLICommand() != null && !row.getCLICommand().isEmpty()) {
                model.setCLICommand(this.decryptCliServiceContains(row.getCLICommand()));
            } else {
                model.setCLICommand("");
            }
            model.setRecordId(row.getRecordId());
            model.setServerCode(row.getServerCode());
            model.setRecordSource(row.getRecordSource());
            model.setApprovedBy(row.getApprovedBy());
            model.setApprovedOn(DateFormatUtility.formatToString((LocalDateTime)row.getApprovedOn()));
            model.setCommandExecutedByClientIP(row.getCommandExecutedByClientIP());
            model.setCommandExecutedOnServerIP(row.getCommandExecutedOnServerIP());
            model.setRemoteUserType(row.getRemoteUserType());
            model.setRemoteUserIP(row.getRemoteUserIP());
            model.setIsCommandSynced(row.getIsCommandSynced());
            model.setCommonOutputFileName(row.getCommonOutputFileName());
            model.setSourceServerCode(row.getSourceServerCode());
            models.add(model);
        }
        return models;
    }

    public synchronized RequestResponse approveCommand1(InputIdModel input) {
        RequestResponse response = new RequestResponse();
        String systemApprove = "system approval ";
        String apprCmd = "apprcmd";
        if (input == null || input.getStringId() == null || input.getStringId().isEmpty()) {
            response.setStatus(Constants.Error.ERROR);
            response.setMessage("No command IDs provided for approval!");
            return response;
        }
        try {
            for (String commandToApprove : input.getStringId()) {
                if (commandToApprove == null || commandToApprove.trim().isEmpty()) continue;
                CLIServerCommandLog cliLog = new CLIServerCommandLog();
                cliLog.setRemarks(apprCmd);
                cliLog.setCLICommand(systemApprove + commandToApprove.trim());
                this.cliServerCommandLog2(cliLog);
            }
            response.setStatus(Constants.Error.OK);
            response.setMessage("Execution successful");
            response.setMessageDetail("All commands approved successfully.");
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setStatus(Constants.Error.ERROR);
            logger.error("Error while approving command {}", (Object)e.getMessage());
            response.setMessage("Execution successful");
            response.setMessageDetail("Error approving commands: " + e.getMessage());
        }
        return response;
    }

    public synchronized RequestResponse approveCommand(InputIdModel input) {
        RequestResponse response = new RequestResponse();
        String systemApprove = "system approval ";
        String apprCmd = "apprcmd";
        if (input == null || input.getStringId() == null || input.getStringId().isEmpty()) {
            response.setStatus(Constants.Error.ERROR);
            response.setMessage("No command IDs provided for approval!");
            return response;
        }
        try {
            ArrayList<String> createdCommands = new ArrayList<String>();
            for (String commandToApprove : input.getStringId()) {
                if (commandToApprove == null || commandToApprove.trim().isEmpty()) continue;
                CLIServerCommandLog cliLog = new CLIServerCommandLog();
                cliLog.setRemarks(apprCmd);
                cliLog.setCLICommand(systemApprove + commandToApprove.trim());
                String command = this.cliServerCommandLog2(cliLog);
                createdCommands.add(command);
            }
            for (String command : createdCommands) {
                boolean executed = this.waitUntilExecuted(command, 30000L);
                if (executed) continue;
                response.setStatus(Constants.Error.ERROR);
                response.setMessage("Timeout while waiting for command execution");
                response.setMessageDetail("Command [" + command + "] did not finish in time.");
                return response;
            }
            response.setStatus(Constants.Error.OK);
            response.setMessage("Execution successful");
            response.setMessageDetail("All commands approved and executed successfully.");
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setStatus(Constants.Error.ERROR);
            logger.error("Error while approving command {}", (Object)e.getMessage());
            response.setMessage("Error while approving commands");
            response.setMessageDetail("Error approving commands: " + e.getMessage());
        }
        return response;
    }

    private boolean waitUntilExecuted(String outputFileName, long timeoutMillis) {
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() - startTime < timeoutMillis) {
            Optional logOpt = this.cliServerCommandLogRepository.findByOutputFileName(outputFileName);
            if (logOpt.isPresent() && "Y".equalsIgnoreCase(((CLIServerCommandLog)logOpt.get()).getExecuted())) {
                return true;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return false;
            }
        }
        return false;
    }

    public synchronized RequestResponse rejectCommand(InputIdModel input) {
        RequestResponse response = new RequestResponse();
        String systemReject = "system rejected ";
        if (input == null || input.getStringId() == null || input.getStringId().isEmpty()) {
            response.setStatus(Constants.Error.ERROR);
            response.setMessage("No command IDs provided for rejection!");
            return response;
        }
        try {
            ArrayList<String> createdCommands = new ArrayList<String>();
            for (String commandToReject : input.getStringId()) {
                if (commandToReject == null || commandToReject.trim().isEmpty()) continue;
                CLIServerCommandLog cliLog = new CLIServerCommandLog();
                cliLog.setCLICommand(systemReject + commandToReject.trim());
                String command = this.cliServerCommandLog2(cliLog);
                createdCommands.add(command);
            }
            for (String command : createdCommands) {
                boolean executed = this.waitUntilExecuted(command, 30000L);
                if (executed) continue;
                response.setStatus(Constants.Error.ERROR);
                response.setMessage("Timeout while waiting for command rejection");
                response.setMessageDetail("Command [" + command + "] did not finish in time.");
                return response;
            }
            response.setStatus(Constants.Error.OK);
            response.setMessage("Execution successful");
            response.setMessageDetail("All commands rejected and processed successfully.");
        }
        catch (Exception e) {
            logger.error("Error while rejecting commands", (Throwable)e);
            response.setStatus(Constants.Error.ERROR);
            response.setMessage("Error while rejecting commands");
            response.setMessageDetail("Error rejecting commands: " + e.getMessage());
        }
        return response;
    }

    public String decryptCliServiceContains(String encryptedValue) {
        String rtrVal = "";
        try {
            String privatekey = "9221375a0cd0-5adb3f6d--f6ea-4d1e-81ed-a719175d-1e40-dd24b91a7c87-c5600ed3";
            byte[] key = privatekey.getBytes("UTF-8");
            MessageDigest sha = MessageDigest.getInstance("SHA-1");
            key = sha.digest(key);
            key = Arrays.copyOf(key, 16);
            SecretKeySpec secretKey = new SecretKeySpec(key, "AES");
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(2, secretKey);
            byte[] decodedValue = Base64.getDecoder().decode(encryptedValue);
            byte[] original = cipher.doFinal(decodedValue);
            rtrVal = new String(original, "UTF-8");
        }
        catch (Exception e) {
            logger.error("Decryption failed: {}", (Object)e.getMessage(), (Object)e);
        }
        return rtrVal;
    }

    protected String encryptCliServiceContains(String keyvalue) {
        String rtrVal = "";
        if (!keyvalue.isEmpty()) {
            String privatekey;
            MessageDigest sha = null;
            String passwordkey = privatekey = "9221375a0cd0-5adb3f6d--f6ea-4d1e-81ed-a719175d-1e40-dd24b91a7c87-c5600ed3";
            try {
                byte[] key = passwordkey.getBytes("UTF-8");
                sha = MessageDigest.getInstance("SHA-1");
                key = sha.digest(key);
                key = Arrays.copyOf(key, 16);
                SecretKeySpec secretKey = new SecretKeySpec(key, "AES");
                Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
                cipher.init(1, secretKey);
                byte[] rtv = cipher.doFinal(keyvalue.getBytes("UTF-8"));
                rtrVal = Base64.getEncoder().encodeToString(rtv);
            }
            catch (NoSuchAlgorithmException e) {
                logger.error(e.getMessage());
            }
            catch (UnsupportedEncodingException e) {
                logger.error(e.getMessage());
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
        }
        return rtrVal;
    }

    public synchronized String cliServerCommandLog2(CLIServerCommandLog cliServerCommandLog) {
        try {
            Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
            String clientIp = CliServerCommandServices.getCurrentUserIp((Authentication)authentication);
            long currentTime = System.currentTimeMillis();
            if (currentTime == lastAccessTime) {
                Thread.sleep(1L);
                logger.info("Time conflict comes but handled");
            }
            lastAccessTime = System.currentTimeMillis();
            String ip = CliServerCommandServices.getLocalIPAddress();
            Long epochValue = lastAccessTime;
            String fileName = epochValue + "-" + this.serverCode;
            CLIServerCommandLog cliServerCommandLog2 = new CLIServerCommandLog();
            cliServerCommandLog2.setRecordCreatedBy(CliServerCommandServices.getCurrentUsername());
            cliServerCommandLog2.setOutputFileName(fileName);
            cliServerCommandLog2.setOutputFilePath("");
            cliServerCommandLog2.setCLICommand(this.encryptCliServiceContains(cliServerCommandLog.getCLICommand()));
            cliServerCommandLog2.setServerCode(this.serverCode);
            if (cliServerCommandLog.getCLICommand().contains("delete")) {
                cliServerCommandLog2.setExecuted("P");
            } else {
                cliServerCommandLog2.setExecuted("N");
            }
            cliServerCommandLog2.setCommandExecutedByClientIP(clientIp);
            cliServerCommandLog2.setCommandExecutedOnServerIP(ip);
            cliServerCommandLog2.setRemarks(cliServerCommandLog.getRemarks());
            CLIServerCommandLog returnCliServerCommand = (CLIServerCommandLog)this.cliServerCommandLogRepository.save((Object)cliServerCommandLog2);
            return returnCliServerCommand.getOutputFileName();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            System.err.println("Thread was interrupted: " + e.getMessage());
            logger.error(e.getMessage());
            return "";
        }
        catch (Exception e) {
            logger.error("Unexpected error while saving CLI command: {}", (Object)e.getMessage(), (Object)e);
            return "";
        }
    }

    public static String getCurrentUsername() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication != null && authentication.isAuthenticated()) {
            return authentication.getName();
        }
        return null;
    }

    public static String getCurrentUserIp(Authentication authentication) {
        if (authentication != null && authentication.getDetails() instanceof WebAuthenticationDetails) {
            WebAuthenticationDetails authDetails = (WebAuthenticationDetails)authentication.getDetails();
            String remoteIP = authDetails.getRemoteAddress();
            return remoteIP != null ? remoteIP : "127.0.0.1";
        }
        return "127.0.0.1";
    }

    public static String getLocalIPAddress() {
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface networkInterface = networkInterfaces.nextElement();
                if (!networkInterface.isUp() || networkInterface.isLoopback()) continue;
                Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
                while (inetAddresses.hasMoreElements()) {
                    InetAddress inetAddress = inetAddresses.nextElement();
                    if (!(inetAddress instanceof Inet4Address)) continue;
                    return inetAddress.getHostAddress();
                }
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        return null;
    }
}

