/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.telemetry.main.extensionCDRDetal.controller;

import com.coraltele.db.telemetry.main.entity.BillingCDR;
import com.coraltele.db.telemetry.main.repository.BillingCDRRepository;
import com.coraltele.db.telemetry.main.specification.ExtensionCDRSpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.DateFormatUtility;
import com.coraltele.helper.DownloadPdfService;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.SearchRequest;
import com.coraltele.service.background.DynamicPdfThreadService;
import com.coraltele.service.telemetry.main.extensionCDRDetal.service.ExtensonCDRService;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/v2/extensionCDR"})
@RestController
public class ExtensionCDRController {
    private static final Logger logger = LogManager.getLogger(ExtensionCDRController.class);
    @Autowired
    ExtensonCDRService extensionCDRService;
    @Autowired
    DateFormatUtility dateFormatUtility;
    @Autowired
    BillingCDRRepository billingCDRRepository;
    @Autowired
    private DynamicPdfThreadService dynamicReportThreadService;
    @Autowired
    DownloadPdfService pdfDownloadService;
    private static final ConcurrentHashMap<String, String> columnMappings = new ConcurrentHashMap();

    @PostMapping(value={"/list"})
    public ResponseEntity<RequestResponse> getAllByFilter(@RequestBody SearchRequest searchRequest) {
        RequestResponse returnValue = this.extensionCDRService.getAllByFilter(searchRequest);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    private String formatNullableDate(Long epochMillis) {
        return epochMillis != null ? DateFormatUtility.dateAndTimeFormatterForSeconds((LocalDateTime)DateFormatUtility.epochToLocalDateTimeAsStringForSecond((Long)epochMillis)) : "";
    }

    private String checkNull(Object value) {
        return value != null ? value.toString() : "";
    }

    @PostMapping(value={"/downloadCSV"})
    public ResponseEntity<byte[]> downloadFilteredDataToCSVForCallerCall(@RequestBody SearchRequest searchRequestData) {
        try {
            logger.info("CSV file download started for billing-CDR-");
            Specification filters = ExtensionCDRSpecification.generateFilters((SearchRequest)searchRequestData);
            Sort sort = null;
            if ("asc".equals(searchRequestData.getSortDirection())) {
                sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().isEmpty() || searchRequestData.getSortBy() == null ? "startEpoch" : searchRequestData.getSortBy()}).ascending();
            } else if ("desc".equals(searchRequestData.getSortDirection())) {
                sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().isEmpty() || searchRequestData.getSortBy() == null ? "startEpoch" : searchRequestData.getSortBy()}).descending();
            }
            List filteredData = sort != null ? this.billingCDRRepository.findAll(filters, sort) : this.billingCDRRepository.findAll(filters);
            StringWriter stringWriter = new StringWriter();
            try (CSVPrinter csvPrinter = new CSVPrinter((Appendable)stringWriter, CSVFormat.DEFAULT);){
                logger.info("Original column names: " + searchRequestData.getColumnNames());
                List displayNames = searchRequestData.getColumnNames().stream().map(columnName -> columnMappings.getOrDefault(columnName, columnName)).collect(Collectors.toList());
                logger.info("Display names: " + displayNames);
                csvPrinter.printRecord(displayNames);
                for (BillingCDR item : filteredData) {
                    ArrayList<Object> values = new ArrayList<Object>();
                    for (String columnName2 : searchRequestData.getColumnNames()) {
                        values.add(this.getColumnValueForCallerCall(item, columnName2));
                    }
                    csvPrinter.printRecord(values);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                logger.error("Error while traversing data for billing-CDR", (Object)e.getMessage());
            }
            String csvContent = stringWriter.toString();
            byte[] csvBytes = csvContent.getBytes(StandardCharsets.UTF_8);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
            headers.setContentDispositionFormData("attachment", "filtered_data.csv");
            logger.info("CSV data download successfully.");
            return new ResponseEntity((Object)csvBytes, (MultiValueMap)headers, HttpStatus.OK);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error while downloading billing-CDR CSV file!", (Object)e.getMessage());
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }

    private Object getColumnValueForCallerCall(BillingCDR item, String columnName) {
        switch (columnName) {
            case "callerIdNumber": {
                return this.checkNull((Object)item.getCallerIdNumber());
            }
            case "destinationNumber": {
                return this.checkNull((Object)item.getDestinationNumber());
            }
            case "coralCallDirection": {
                return this.checkNull((Object)item.getCoralCallDirection());
            }
            case "startEpoch": {
                return DateFormatUtility.epochToLocalDateTimeAsStringForSecondToHandleZero((Long)item.getStartEpoch());
            }
            case "answerEpoch": {
                return DateFormatUtility.epochToLocalDateTimeAsStringForSecondToHandleZero((Long)item.getAnswerEpoch());
            }
            case "endEpoch": {
                return DateFormatUtility.epochToLocalDateTimeAsStringForSecondToHandleZero((Long)item.getEndEpoch());
            }
            case "duration": {
                return DateFormatUtility.findLocalTime((Long)item.getDuration());
            }
            case "talkDuration": {
                return DateFormatUtility.findLocalTime((Long)item.getTalkDuration());
            }
            case "callConnected": {
                if (item.getCallConnected() != null) {
                    if (item.getCallConnected().booleanValue()) {
                        return this.checkNull((Object)"Yes");
                    }
                    return this.checkNull((Object)"No");
                }
                return this.checkNull((Object)"No");
            }
            case "startDate": {
                return this.dateFormatUtility.epochToLocalDate(item.getStartEpoch());
            }
            case "mos": {
                if (item.getMos().compareTo(BigDecimal.valueOf(0.0)) == 0) {
                    return 4.3;
                }
                return item.getMos();
            }
            case "coralFeatureCode": {
                return this.checkNull((Object)item.getCoralFeatureCode());
            }
            case "destinationName": {
                return this.checkNull((Object)item.getDestinationNumber());
            }
            case "callerName": {
                return this.checkNull((Object)item.getCallerName());
            }
            case "callType": {
                return this.checkNull((Object)item.getCallType());
            }
        }
        return null;
    }

    @PostMapping(value={"/generateAndDownloadPdf"})
    public CompletableFuture<ResponseEntity<?>> generateAndDownloadPdf(@RequestParam String reportType, @RequestBody SearchRequest searchRequestData, Principal principal) {
        String folderPath = "/tmp/";
        File folder = new File(folderPath);
        String fileNamePrefix = reportType + "_";
        File[] files = folder.listFiles((dir, name) -> name.startsWith(fileNamePrefix));
        if (files != null) {
            for (File file : files) {
                if (file.delete()) {
                    logger.info("Deleted existing report: {}" + file.getName());
                    continue;
                }
                logger.error("Failed to delete existing report: {}" + file.getName());
            }
        }
        String filePath = "/tmp/" + reportType + "_" + System.currentTimeMillis() + ".pdf";
        String id = UUID.randomUUID().toString();
        CompletableFuture generationFuture = this.dynamicReportThreadService.startGeneratingReportAsync(reportType, id, searchRequestData, filePath, principal);
        return generationFuture.thenApply(response -> {
            if (response.getStatus().equals((Object)Constants.Error.OK)) {
                ResponseEntity downloadResponse = this.pdfDownloadService.getPdfFile(filePath);
                if (downloadResponse.getStatusCode().is2xxSuccessful()) {
                    return ResponseEntity.ok().body(downloadResponse.getBody());
                }
                return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("Failed to download PDF. Reason: " + downloadResponse.getStatusCode()));
            }
            return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body(response);
        });
    }

    static {
        columnMappings.put("callerIdNumber", "Caller No");
        columnMappings.put("destinationNumber", "Destination No");
        columnMappings.put("coralCallDirection", "Call Direction");
        columnMappings.put("startEpoch", "Start Time");
        columnMappings.put("answerEpoch", "Answer Time");
        columnMappings.put("endEpoch", "End Time");
        columnMappings.put("talkDuration", "TalkTime (HH:MM:SS)");
        columnMappings.put("callConnected", "Call Answered");
        columnMappings.put("startDate", "Date");
        columnMappings.put("mos", "MOS");
        columnMappings.put("coralFeatureCode", " Feature Name");
        columnMappings.put("destinationName", "Destination Name");
        columnMappings.put("callerName", "caller Name");
        columnMappings.put("callType", "call Type");
    }
}

