/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.telemetry.main.activityLogs.controller;

import com.coraltele.db.telemetry.main.entity.ActivityLogs;
import com.coraltele.db.telemetry.main.repository.ActivityLogsRepository;
import com.coraltele.db.telemetry.main.specification.ActivityLogSpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.SearchRequest;
import com.coraltele.service.telemetry.main.activityLogs.model.ActivityLogModel;
import com.coraltele.service.telemetry.main.activityLogs.service.ActivityLogService;
import com.coraltele.service.user.service.UserService;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/v2/activityLog"})
@RestController
public class ActivityLogController {
    private static final Logger logger = LogManager.getLogger(ActivityLogController.class);
    @Autowired
    ActivityLogService activityLogService;
    @Autowired
    ActivityLogsRepository activityLogsRepository;
    @Autowired
    UserService userService;
    private static final ConcurrentHashMap<String, String> columnMappings = new ConcurrentHashMap();

    @PostMapping(value={"/create"})
    public ResponseEntity<RequestResponse> create(@RequestBody ActivityLogModel data, Principal principal) {
        RequestResponse returnValue = this.activityLogService.createData(data, principal);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/last50Records"})
    public ResponseEntity<RequestResponse> lastRecords(Principal principal) {
        RequestResponse returnValue = this.activityLogService.last50Records(principal);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/list/{eventType}"})
    public ResponseEntity<RequestResponse> getAllAlertHistory(@PathVariable(value="eventType") String eventType, @RequestBody SearchRequest searchRequest, Principal principal) {
        RequestResponse returnValue = this.activityLogService.getALLLogs(searchRequest, principal, eventType);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/downloadCSV/{eventType}"})
    public ResponseEntity<byte[]> downloadFilteredDataToCSV(@PathVariable(value="eventType") String eventType, @RequestBody SearchRequest searchRequestData, Principal principal) {
        try {
            logger.info("CSV file download started for activityLog--");
            boolean adminUser = false;
            boolean dispatcherRole = false;
            if (this.userService.checkAdminUser(principal.getName())) {
                adminUser = true;
            } else if (this.userService.checkRoleDispatcher(principal.getName())) {
                dispatcherRole = true;
            }
            Specification filters = ActivityLogSpecification.generateFilters((SearchRequest)searchRequestData, (boolean)adminUser, (boolean)dispatcherRole, (String)principal.getName(), (String)eventType);
            Sort sort = null;
            if ("asc".equals(searchRequestData.getSortDirection())) {
                sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().isEmpty() || searchRequestData.getSortBy() == null ? "alertGeneratedOn" : searchRequestData.getSortBy()}).ascending();
            } else if ("desc".equals(searchRequestData.getSortDirection())) {
                sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().isEmpty() || searchRequestData.getSortBy() == null ? "alertGeneratedOn" : searchRequestData.getSortBy()}).descending();
            }
            List filteredData = sort != null ? this.activityLogsRepository.findAll(filters, sort) : this.activityLogsRepository.findAll(filters);
            StringWriter stringWriter = new StringWriter();
            try (CSVPrinter csvPrinter = new CSVPrinter((Appendable)stringWriter, CSVFormat.DEFAULT);){
                logger.info("Original column names: " + searchRequestData.getColumnNames());
                List displayNames = searchRequestData.getColumnNames().stream().map(columnName -> columnMappings.getOrDefault(columnName, columnName)).collect(Collectors.toList());
                logger.info("Display names: " + displayNames);
                csvPrinter.printRecord(displayNames);
                for (ActivityLogs item : filteredData) {
                    ArrayList<Object> values = new ArrayList<Object>();
                    for (String columnName2 : searchRequestData.getColumnNames()) {
                        values.add(this.getColumnValue(item, columnName2));
                    }
                    csvPrinter.printRecord(values);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                logger.error("Error while traversing data for activityLog", (Object)e.getMessage());
            }
            String csvContent = stringWriter.toString();
            byte[] csvBytes = csvContent.getBytes(StandardCharsets.UTF_8);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
            headers.setContentDispositionFormData("attachment", "filtered_data.csv");
            logger.info("CSV data download successfully.");
            return new ResponseEntity((Object)csvBytes, (MultiValueMap)headers, HttpStatus.OK);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error while downloading alertHistory CSV file!", (Object)e.getMessage());
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }

    private Object getColumnValue(ActivityLogs item, String columnName) {
        switch (columnName) {
            case "eventStatus": {
                return this.checkNull((Object)item.getEventStatus());
            }
            case "eventCategory": {
                return this.checkNull((Object)item.getEventCategory());
            }
            case "callerNumber": {
                return this.checkNull((Object)item.getCallerNumber());
            }
            case "eventGroup": {
                return this.checkNull((Object)item.getEventGroup());
            }
            case "createdBy": {
                return this.checkNull((Object)item.getCreatedBy());
            }
            case "createdOn": {
                return this.checkNull((Object)item.getCreatedOn());
            }
            case "destinationNumber": {
                return this.checkNull((Object)item.getDestinationNumber());
            }
            case "event": {
                return this.checkNull((Object)item.getEvent());
            }
        }
        return null;
    }

    private String checkNull(Object value) {
        return value != null ? value.toString() : "";
    }

    static {
        columnMappings.put("eventStatus", "Event Status");
        columnMappings.put("eventCategory", "Type Of Event Category");
        columnMappings.put("callerNumber", "Caller Number");
        columnMappings.put("callingGroup", "Calling Group");
        columnMappings.put("createdBy", "Created By");
        columnMappings.put("createdOn", "Created On");
        columnMappings.put("destinationNumber", "Destination Number");
        columnMappings.put("eventType", "Event Type");
    }
}

