/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.coralApps.callcenter.dynamicPopUpData.controller;

import com.coraltele.db.coralapps.callcenter.entity.DynamicPopUpData;
import com.coraltele.db.coralapps.callcenter.entity.Queue;
import com.coraltele.db.coralapps.callcenter.repository.DynamicPopUpDataRepository;
import com.coraltele.db.coralapps.callcenter.repository.QueueRepository;
import com.coraltele.db.coralapps.callcenter.specification.DynamicPopUpDataReportSpecification;
import com.coraltele.db.users.main.entity.User;
import com.coraltele.db.users.main.repository.UserRepository;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.SearchRequest;
import com.coraltele.service.coralApps.callcenter.dynamicPopUpData.model.DynamicPopUpDataModel;
import com.coraltele.service.coralApps.callcenter.dynamicPopUpData.service.DynamicPopUpDataService;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.Principal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/v2/dynamicPopUpData"})
@RestController
public class DynamicPopUpDataController {
    private static final Logger logger = LogManager.getLogger(DynamicPopUpDataController.class);
    @Autowired
    DynamicPopUpDataService dynamicPopUpDataService;
    @Autowired
    DynamicPopUpDataRepository dynamicPopUpDataRepository;
    @Autowired
    QueueRepository queueRepository;
    @Autowired
    UserRepository userRepository;

    @PostMapping(value={"/create"})
    public ResponseEntity<RequestResponse> getData(Principal principal, @RequestBody DynamicPopUpDataModel data) throws JsonProcessingException {
        RequestResponse returnValue = this.dynamicPopUpDataService.createRecord(principal, data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/list/{formCode}"})
    public ResponseEntity<RequestResponse> getAllByFilter(@RequestBody SearchRequest searchRequest, @PathVariable(value="formCode") String formCode) {
        RequestResponse returnValue = this.dynamicPopUpDataService.getAllByFilter(searchRequest, formCode);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/states"})
    public ResponseEntity<RequestResponse> getAllStates() {
        RequestResponse returnValue = this.dynamicPopUpDataService.getAllStates();
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/cities"})
    public ResponseEntity<RequestResponse> getCitiesByState(@RequestParam(required=false) Integer stateId) {
        RequestResponse returnValue = this.dynamicPopUpDataService.getCitiesByStateId(stateId);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/updateCallback/{callbackId}"})
    public ResponseEntity<RequestResponse> updateCallback(@PathVariable(required=false) Integer callbackId) {
        RequestResponse returnValue = this.dynamicPopUpDataService.updateCallBack(callbackId);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/listWithQueue/{queueId}"})
    public ResponseEntity<RequestResponse> getAllByFilter(@RequestBody SearchRequest searchRequest, @PathVariable Long queueId) {
        RequestResponse returnValue = this.dynamicPopUpDataService.getAllByFilterByQueueId(searchRequest, queueId);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/headers/{queueId}"})
    public ResponseEntity<RequestResponse> getAllowedFormFieldObjectsByQueueId(@PathVariable String queueId) {
        RequestResponse returnValue = this.dynamicPopUpDataService.getAllowedFormFieldObjectsByQueueId(queueId);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/listAll/queue"})
    public ResponseEntity<RequestResponse> getAllDistinctQueue() {
        RequestResponse returnValue = this.dynamicPopUpDataService.getAllDistinctQueue();
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/downloadCSV/{queueId}"})
    public ResponseEntity<byte[]> downloadFilteredDataToCSV(@RequestBody SearchRequest searchRequestData, @PathVariable Long queueId) {
        try {
            String formFileName;
            logger.info("CSV file download started for disposition report--");
            Queue queue = this.queueRepository.findBySystemName(queueId.toString()).orElse(null);
            String string = formFileName = queue != null && queue.getDispositionForm() != null ? queue.getDispositionForm() : null;
            if (formFileName == null) {
                throw new RuntimeException("Form file not found for queueId: " + queueId);
            }
            ObjectMapper objectMapper = new ObjectMapper();
            Path path = Paths.get("/etc/coraltele/forms/" + formFileName + ".json", new String[0]);
            byte[] jsonData = Files.readAllBytes(path);
            JsonNode rootNode = objectMapper.readTree(jsonData);
            JsonNode contentNode = rootNode.get("content");
            if (contentNode == null || !contentNode.isArray()) {
                throw new RuntimeException("Invalid form schema structure. 'content' array missing.");
            }
            List<String> fixedHeaders = Arrays.asList("Record Created On", "Queue", "Queue Name", "Agent Id", "Agent Name");
            List<String> fixedAccessors = Arrays.asList("recordCreatedOn", "queue", "queueName", "recordCreatedBy", "agentName");
            HashSet<String> fixedAccessorSet = new HashSet<String>(fixedAccessors);
            ArrayList<String> dynamicHeaders = new ArrayList<String>();
            ArrayList<String> dynamicAccessors = new ArrayList<String>();
            String phoneHeader = null;
            String customerNameHeader = null;
            for (JsonNode field : contentNode) {
                JsonNode accessorNode = field.get("accessor");
                JsonNode headerNode = field.get("Header");
                JsonNode allowInFormNode = field.get("allowInForm");
                if (allowInFormNode == null || !allowInFormNode.asBoolean() || accessorNode == null || headerNode == null) continue;
                String accessor = accessorNode.asText();
                String header = headerNode.asText();
                if ("phoneNumber".equals(accessor)) {
                    phoneHeader = header;
                    continue;
                }
                if ("description".equals(accessor)) {
                    customerNameHeader = header;
                    continue;
                }
                if (fixedAccessorSet.contains(accessor)) continue;
                dynamicAccessors.add(accessor);
                dynamicHeaders.add(header);
            }
            ArrayList<String> headers = new ArrayList<String>(fixedHeaders);
            ArrayList<String> accessors = new ArrayList<String>(fixedAccessors);
            if (customerNameHeader != null) {
                headers.add(5, customerNameHeader);
                accessors.add(5, "description");
            }
            if (phoneHeader != null) {
                headers.add(6, phoneHeader);
                accessors.add(6, "phoneNumber");
            }
            headers.addAll(dynamicHeaders);
            accessors.addAll(dynamicAccessors);
            Specification filters = DynamicPopUpDataReportSpecification.generateFilters((SearchRequest)searchRequestData, (Long)queueId);
            Sort sort = null;
            if ("asc".equals(searchRequestData.getSortDirection())) {
                sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().isEmpty() || searchRequestData.getSortBy() == null ? "recordCreatedOn" : searchRequestData.getSortBy()}).ascending();
            } else if ("desc".equals(searchRequestData.getSortDirection())) {
                sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().isEmpty() || searchRequestData.getSortBy() == null ? "recordCreatedOn" : searchRequestData.getSortBy()}).descending();
            }
            List filteredData = sort != null ? this.dynamicPopUpDataRepository.findAll(filters, sort) : this.dynamicPopUpDataRepository.findAll(filters);
            StringWriter stringWriter = new StringWriter();
            try (CSVPrinter csvPrinter = new CSVPrinter((Appendable)stringWriter, CSVFormat.DEFAULT);){
                csvPrinter.printRecord(headers);
                for (DynamicPopUpData item : filteredData) {
                    ArrayList<Object> values = new ArrayList<Object>();
                    for (String accessor : accessors) {
                        values.add(this.getFieldValueDynamically((Object)item, accessor));
                    }
                    csvPrinter.printRecord(values);
                }
            }
            byte[] csvBytes = stringWriter.toString().getBytes(StandardCharsets.UTF_8);
            HttpHeaders headersResp = new HttpHeaders();
            headersResp.setContentType(MediaType.APPLICATION_OCTET_STREAM);
            headersResp.setContentDispositionFormData("attachment", "filtered_data.csv");
            logger.info("CSV data download successfully.");
            return new ResponseEntity((Object)csvBytes, (MultiValueMap)headersResp, HttpStatus.OK);
        }
        catch (Exception e) {
            logger.error("Error while downloading Code Blue Report CSV file!", (Throwable)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }

    private Object getFieldValueDynamically(Object item, String fieldName) {
        try {
            if ("agentName".equals(fieldName)) {
                Field createdByField = ReflectionUtils.findField(item.getClass(), (String)"recordCreatedBy");
                if (createdByField != null) {
                    createdByField.setAccessible(true);
                    Object createdByValue = createdByField.get(item);
                    if (createdByValue != null) {
                        Optional user = this.userRepository.findByUsername(createdByValue.toString());
                        return user.map(User::getDescription).orElse("");
                    }
                }
                return "";
            }
            if ("queueName".equals(fieldName)) {
                Field queueField = ReflectionUtils.findField(item.getClass(), (String)"queue");
                if (queueField != null) {
                    queueField.setAccessible(true);
                    Object queueValue = queueField.get(item);
                    if (queueValue != null) {
                        Optional queue = this.queueRepository.findBySystemName(queueValue.toString());
                        return queue.map(Queue::getDescription).orElse("");
                    }
                }
                return "";
            }
            Field field = ReflectionUtils.findField(item.getClass(), (String)fieldName);
            if (field != null) {
                field.setAccessible(true);
                Object value = field.get(item);
                if (value instanceof LocalDateTime) {
                    DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
                    return formatter.format((LocalDateTime)value);
                }
                return value;
            }
        }
        catch (IllegalAccessException e) {
            logger.error("Error accessing field: " + fieldName, (Throwable)e);
        }
        return "";
    }
}

