/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.billing.log.service;

import com.coraltele.db.billing.main.entity.view.ViewChannels;
import com.coraltele.db.billing.main.entity.view.ViewChannelsV1;
import com.coraltele.db.billing.main.repository.ViewChannelRepositoryV1;
import com.coraltele.db.billing.main.repository.ViewChannelsRepository;
import com.coraltele.db.billing.main.specification.ViewChannelSpecificationV1;
import com.coraltele.db.billing.main.specification.ViewChannelsSpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.billing.log.model.ViewChannelBillingCDRModel;
import java.io.File;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.ini4j.Ini;
import org.ini4j.Profile;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class ViewChannelService {
    private static final Logger logger = LogManager.getLogger(ViewChannelService.class);
    @Autowired
    private ViewChannelsRepository repository;
    @Autowired
    private ViewChannelRepositoryV1 repositoryV1;

    public RequestResponse getBillingRecords(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = ViewChannelsSpecification.generateFilters((SearchRequest)searchRequestData);
        Specification filters1 = ViewChannelSpecificationV1.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.getSortDirection().equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "answerStamp" : searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.getSortDirection().equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "answerStamp" : searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        Page page1 = null;
        if (sort == null) {
            if (ViewChannelService.getTraceCall()) {
                page1 = this.repositoryV1.findAll(filters1, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize())));
            } else {
                page = this.repository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize())));
            }
        } else if (ViewChannelService.getTraceCall()) {
            page1 = this.repositoryV1.findAll(filters1, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        } else {
            page = this.repository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        }
        List convertedRecords1 = new ArrayList();
        List convertedRecords = new ArrayList();
        if (ViewChannelService.getTraceCall()) {
            convertedRecords1 = this.entityToModelConversion2(page1.getContent());
        } else {
            convertedRecords = this.entityToModelConversion(page.getContent());
        }
        if (ViewChannelService.getTraceCall()) {
            SearchResponse responseData = new SearchResponse();
            responseData.setCurrentPage(searchRequestData.getCurrentPage() > page1.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
            responseData.setPageSize((long)page1.getSize());
            responseData.setTotalPages((long)page1.getTotalPages());
            responseData.setTotalRecords(page1.getTotalElements());
            responseData.setCurrentPageData(convertedRecords1);
            returnValue.setData((Object)responseData);
            returnValue.setMessage("List of Filtered Data");
            logger.info(returnValue.getMessage());
        } else {
            SearchResponse responseData = new SearchResponse();
            responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
            responseData.setPageSize((long)page.getSize());
            responseData.setTotalPages((long)page.getTotalPages());
            responseData.setTotalRecords(page.getTotalElements());
            responseData.setCurrentPageData(convertedRecords);
            returnValue.setData((Object)responseData);
            returnValue.setMessage("List of Filtered Data");
            logger.info(returnValue.getMessage());
        }
        return returnValue;
    }

    public List<ViewChannelBillingCDRModel> entityToModelConversion(List<ViewChannels> viewChannels) {
        ArrayList<ViewChannelBillingCDRModel> addValue = new ArrayList<ViewChannelBillingCDRModel>();
        for (ViewChannels row : viewChannels) {
            ViewChannelBillingCDRModel data = new ViewChannelBillingCDRModel();
            data.setAnswerStamp(row.getAnswerStamp());
            data.setBillSec(row.getBillSec());
            data.setBillingUuid(row.getBillingUuid());
            data.setCallCost(row.getCallCost());
            data.setCallType(row.getCallType());
            data.setCallerIdName(row.getCallerIdName());
            data.setCallerIdNumber(row.getCallerIdNumber());
            data.setDestinationNumber(row.getDestinationNumber());
            data.setDidNumber(row.getDidNumber());
            data.setDirection(row.getDirection());
            data.setDodNumber(row.getDodNumber());
            data.setDuration(row.getDuration());
            data.setEndStamp(row.getEndStamp());
            data.setFormattedDuration(row.getFormattedDuration());
            data.setId(row.getId());
            data.setPulse(row.getPulse());
            data.setStartStamp(row.getStartStamp());
            data.setUuid(row.getUuid());
            if (row.getMos().compareTo(BigDecimal.valueOf(0.0)) == 0) {
                data.setMos(BigDecimal.valueOf(4.3));
            } else {
                data.setMos(row.getMos());
            }
            data.setRtpJitterMinVariance(row.getRtpJitterMinVariance());
            data.setRtpJitterMaxVariance(row.getRtpJitterMaxVariance());
            data.setRtpJitterLossRate(row.getRtpJitterLossRate());
            data.setStatus(row.getStatus());
            data.setDestinationName(row.getDestinationName());
            addValue.add(data);
        }
        return addValue;
    }

    public List<ViewChannelBillingCDRModel> entityToModelConversion2(List<ViewChannelsV1> viewChannels) {
        ArrayList<ViewChannelBillingCDRModel> addValue = new ArrayList<ViewChannelBillingCDRModel>();
        for (ViewChannelsV1 row : viewChannels) {
            ViewChannelBillingCDRModel data = new ViewChannelBillingCDRModel();
            data.setAnswerStamp(row.getAnswerStamp());
            data.setBillSec(row.getBillSec());
            data.setBillingUuid(row.getBillingUuid());
            data.setCallCost(row.getCallCost());
            data.setCallType(row.getCallType());
            data.setCallerIdName(row.getCallerIdName());
            data.setCallerIdNumber(row.getCallerIdNumber());
            data.setDestinationNumber(row.getDestinationNumber());
            data.setDidNumber(row.getDidNumber());
            data.setDirection(row.getDirection());
            data.setDodNumber(row.getDodNumber());
            data.setDuration(row.getDuration());
            data.setEndStamp(row.getEndStamp());
            data.setFormattedDuration(row.getFormattedDuration());
            data.setId(row.getId());
            data.setPulse(row.getPulse());
            data.setStartStamp(row.getStartStamp());
            data.setUuid(row.getUuid());
            if (row.getMos().compareTo(BigDecimal.valueOf(0.0)) == 0) {
                data.setMos(BigDecimal.valueOf(4.3));
            } else {
                data.setMos(row.getMos());
            }
            data.setRtpJitterMinVariance(row.getRtpJitterMinVariance());
            data.setRtpJitterMaxVariance(row.getRtpJitterMaxVariance());
            data.setRtpJitterLossRate(row.getRtpJitterLossRate());
            data.setStatus(row.getStatus());
            data.setCallTrace(row.getCallTrace());
            data.setDestinationName(row.getDestinationName());
            addValue.add(data);
        }
        return addValue;
    }

    public RequestResponse getAllCallType() {
        List list = this.repository.findAll();
        HashSet<String> callType = new HashSet<String>();
        RequestResponse returnValue = new RequestResponse();
        for (ViewChannels viewChannels : list) {
            callType.add(viewChannels.getCallType());
        }
        ArrayList<ViewChannelBillingCDRModel> addValue = new ArrayList<ViewChannelBillingCDRModel>();
        for (String type : callType) {
            if (type == null) continue;
            ViewChannelBillingCDRModel data = new ViewChannelBillingCDRModel();
            data.setCallType(type);
            addValue.add(data);
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setData(addValue);
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getBillSecSummation(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = ViewChannelsSpecification.generateFilters((SearchRequest)searchRequestData);
        Object[] result = this.repository.findBillSecAndCallCostSum(filters);
        int totalBillSec = result[0] != null ? ((Number)result[0]).intValue() : 0;
        double totalCallCost = result[1] != null ? ((Number)result[1]).doubleValue() : 0.0;
        HashMap<String, Number> responseData = new HashMap<String, Number>();
        responseData.put("totalBillSec", totalBillSec);
        responseData.put("totalCallCost", totalCallCost);
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setData(responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public static boolean getTraceCall() {
        String coralFilePath = "/etc/default/coral";
        try {
            Profile.Section cluster;
            Ini ini;
            File file = new File(coralFilePath);
            if (file.exists() && (ini = new Ini(file)).containsKey((Object)"CLUSTER") && (cluster = (Profile.Section)ini.get((Object)"CLUSTER")).containsKey((Object)"ENABLE-TRACE-CALL")) {
                String value = ((String)cluster.get((Object)"ENABLE-TRACE-CALL")).trim();
                return value.equalsIgnoreCase("true");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }
}

