/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.helper;

import com.coraltele.helper.CorsConfig;
import java.io.IOException;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CustomCorsFilter
implements Filter {
    private static final Logger logger = LogManager.getLogger(CustomCorsFilter.class);
    @Autowired
    private CorsConfig corsConfig;
    private List<String> allowedOrigins;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.allowedOrigins == null) {
            this.allowedOrigins = this.corsConfig.getAllowedOrigins();
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String origin = httpRequest.getHeader("Origin");
        if (this.allowedOrigins.contains(origin)) {
            httpResponse.setHeader("Access-Control-Allow-Origin", origin);
        } else {
            logger.warn("Origin not allowed: " + origin);
        }
        httpResponse.setHeader("Access-Control-Allow-Methods", "GET, POST, PUT, DELETE");
        httpResponse.setHeader("Access-Control-Allow-Headers", "Authorization, Content-Type, X-Requested-With");
        httpResponse.setHeader("Access-Control-Allow-Credentials", "true");
        if ("OPTIONS".equalsIgnoreCase(httpRequest.getMethod())) {
            httpResponse.setHeader("Access-Control-Max-Age", "3600");
            logger.info("Preflight request handled for: " + origin);
        }
        chain.doFilter(request, response);
    }
}

