/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.db.billing.main.repository;

import com.coraltele.db.billing.main.entity.view.ViewChannels;
import com.coraltele.db.billing.main.repository.CustomViewChannelsRepository;
import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.jpa.domain.Specification;

public class CustomViewChannelsRepositoryImpl
implements CustomViewChannelsRepository {
    private final EntityManager entityManager;

    public CustomViewChannelsRepositoryImpl(@Qualifier(value="billingEntityManagerFactory") EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    public Object[] findBillSecAndCallCostSum(Specification<ViewChannels> spec) {
        CriteriaBuilder cb = this.entityManager.getCriteriaBuilder();
        CriteriaQuery query = cb.createQuery(Object[].class);
        Root root = query.from(ViewChannels.class);
        Predicate predicate = spec.toPredicate(root, query, cb);
        Predicate billSecCondition = cb.greaterThan((Expression)root.get("billSec"), (Comparable)Integer.valueOf(0));
        Predicate callCostCondition = cb.greaterThan((Expression)root.get("callCost"), (Comparable)Integer.valueOf(0));
        Predicate combinedPredicate = cb.and(new Predicate[]{predicate, billSecCondition, callCostCondition});
        query.multiselect(new Selection[]{cb.sum((Expression)root.get("billSec")), cb.sum((Expression)root.get("callCost"))}).where((Expression)combinedPredicate);
        return (Object[])this.entityManager.createQuery(query).getSingleResult();
    }
}

