/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.uc.service;

import com.coraltele.db.billing.main.entity.SendFaxProgress;
import com.coraltele.db.billing.main.entity.view.Fax;
import com.coraltele.db.billing.main.repository.FaxRepository;
import com.coraltele.db.billing.main.repository.SendFaxProgressRepository;
import com.coraltele.db.telephony.pbx.entity.Extension;
import com.coraltele.db.telephony.pbx.repository.ExtensionsRepository;
import com.coraltele.db.telephony.uc.entity.CustomerAccount;
import com.coraltele.db.telephony.uc.repository.CustomerAccountRepository;
import com.coraltele.db.telephony.uc.repository.UcFunctionRepository;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.service.billing.main.fax.model.FaxTransferDetailsModel;
import com.coraltele.service.billing.main.uc_notification.service.UcNotificationService;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service
public class FaxTransferDetailsService {
    private static final Logger logger = LogManager.getLogger(FaxTransferDetailsService.class);
    @Autowired
    SendFaxProgressRepository sendFaxProgressRepository;
    @Autowired
    FaxRepository faxRepository;
    @Autowired
    UcFunctionRepository ucFunctionRepository;
    @Autowired
    CustomerAccountRepository customerAccountRepository;
    @Autowired
    ExtensionsRepository extensionsRepository;
    @Autowired
    UcNotificationService ucNotificationService;

    public RequestResponse createFaxTransferDetail(FaxTransferDetailsModel data, Authentication authentication) {
        RequestResponse returnValue = new RequestResponse();
        List extensions = data.getExtension();
        if (extensions.size() == 0 || extensions.isEmpty() || data.getId() == null) {
            returnValue.setStatus(Constants.Error.BAD_INPUT_DATA);
            returnValue.setMessage("Data Can Not Be Transferred");
            returnValue.setMessageDetail("Users Must Be Selected For Transferring The fax ");
            logger.info(returnValue.getMessageDetail());
            return returnValue;
        }
        Optional faxView = this.faxRepository.findById(data.getId());
        for (String destination : extensions) {
            SendFaxProgress sendFaxProgress = new SendFaxProgress();
            Optional destinationUser = this.customerAccountRepository.findByProfileId(destination);
            sendFaxProgress.setCreatedOn(LocalDateTime.now());
            sendFaxProgress.setSourceUser(authentication.getName());
            sendFaxProgress.setDestinationUser(((CustomerAccount)destinationUser.get()).getProfileId());
            sendFaxProgress.setRemarks1(data.getRemarks());
            if (((Fax)faxView.get()).getUploadedFileId() != null) {
                sendFaxProgress.setFileId(((Fax)faxView.get()).getUploadedFileId());
            } else {
                sendFaxProgress.setFileId(null);
            }
            sendFaxProgress.setChannelCallUuid(UUID.randomUUID().toString());
            this.sendFaxProgressRepository.save((Object)sendFaxProgress);
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("FaxTransferDetails Created");
        returnValue.setMessageDetail("Fax Transferred Successfully");
        logger.info(returnValue.getMessageDetail());
        return returnValue;
    }

    public RequestResponse deleteNotification(InputIdModel data) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList addValue = new ArrayList();
        for (Long ids : data.getId()) {
            Optional currentRecord = this.sendFaxProgressRepository.findById(ids.intValue());
            if (!currentRecord.isPresent()) continue;
            addValue.add(currentRecord.get());
        }
        this.sendFaxProgressRepository.deleteAll(addValue);
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("message deleted");
        returnValue.setMessageDetail("Records Deleted Successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse createFaxTransferDetailNew(FaxTransferDetailsModel data, Authentication authentication) {
        RequestResponse returnValue = new RequestResponse();
        List extensions = data.getExtension();
        ArrayList<String> ucUsers = new ArrayList<String>();
        if (extensions.size() == 0 || extensions.isEmpty() || data.getId() == null) {
            returnValue.setStatus(Constants.Error.BAD_INPUT_DATA);
            returnValue.setMessage("Data Can Not Be Transferred");
            returnValue.setMessageDetail("Users Must Be Selected For Transferring The fax ");
            logger.info(returnValue.getMessageDetail());
            return returnValue;
        }
        for (String destination : extensions) {
            SendFaxProgress sendFaxProgress = new SendFaxProgress();
            Optional currentFaxRecord = this.sendFaxProgressRepository.findById((Object)data.getId());
            if (currentFaxRecord.isPresent()) {
                Optional extension = this.extensionsRepository.findByExtension(destination);
                sendFaxProgress.setVariableCoralApp(((SendFaxProgress)currentFaxRecord.get()).getVariableCoralApp());
                sendFaxProgress.setVariableOtherLoopbackLegUuid(((SendFaxProgress)currentFaxRecord.get()).getVariableOtherLoopbackLegUuid());
                sendFaxProgress.setVariableLoopbackLeg(((SendFaxProgress)currentFaxRecord.get()).getVariableLoopbackLeg());
                sendFaxProgress.setVariableCallUuid(((SendFaxProgress)currentFaxRecord.get()).getVariableCallUuid());
                sendFaxProgress.setVariableCurrentApplication(((SendFaxProgress)currentFaxRecord.get()).getVariableCurrentApplication());
                sendFaxProgress.setVariableCurrentApplicationData(((SendFaxProgress)currentFaxRecord.get()).getVariableCurrentApplicationData());
                sendFaxProgress.setVariableFaxFilename(((SendFaxProgress)currentFaxRecord.get()).getVariableFaxFilename());
                sendFaxProgress.setFaxSuccess(((SendFaxProgress)currentFaxRecord.get()).getFaxSuccess());
                sendFaxProgress.setFaxResultCode(((SendFaxProgress)currentFaxRecord.get()).getFaxResultCode());
                sendFaxProgress.setFaxResultText(((SendFaxProgress)currentFaxRecord.get()).getFaxResultText());
                sendFaxProgress.setFaxDocumentTransferredPages(((SendFaxProgress)currentFaxRecord.get()).getFaxDocumentTransferredPages());
                sendFaxProgress.setFaxDocumentTotalPages(((SendFaxProgress)currentFaxRecord.get()).getFaxDocumentTotalPages());
                sendFaxProgress.setFaxImageResolution(((SendFaxProgress)currentFaxRecord.get()).getFaxImageResolution());
                sendFaxProgress.setFaxImageSize(((SendFaxProgress)currentFaxRecord.get()).getFaxImageSize());
                sendFaxProgress.setFaxBadRows(((SendFaxProgress)currentFaxRecord.get()).getFaxBadRows());
                sendFaxProgress.setFaxTransferRate(((SendFaxProgress)currentFaxRecord.get()).getFaxTransferRate());
                sendFaxProgress.setRemarks1(data.getRemarks());
                sendFaxProgress.setRemarks2(((SendFaxProgress)currentFaxRecord.get()).getRemarks2());
                sendFaxProgress.setFileId(((SendFaxProgress)currentFaxRecord.get()).getFileId());
                sendFaxProgress.setMailSent(((SendFaxProgress)currentFaxRecord.get()).getMailSent());
                sendFaxProgress.setNoOfTry(((SendFaxProgress)currentFaxRecord.get()).getNoOfTry());
                sendFaxProgress.setSourceUser(authentication.getName());
                if (extension.isPresent()) {
                    sendFaxProgress.setDestinationUser(((Extension)extension.get()).getAssignedUser());
                }
                sendFaxProgress.setIsNotified(Boolean.valueOf(false));
                sendFaxProgress.setIsRead(Boolean.valueOf(false));
                sendFaxProgress.setCreatedBy(((SendFaxProgress)currentFaxRecord.get()).getCreatedBy());
                sendFaxProgress.setCreatedOn(((SendFaxProgress)currentFaxRecord.get()).getCreatedOn());
                sendFaxProgress.setSwitchIpV4(((SendFaxProgress)currentFaxRecord.get()).getSwitchIpV4());
                sendFaxProgress.setEventDateLocal(LocalDateTime.now());
                sendFaxProgress.setEventDateTimestamp(((SendFaxProgress)currentFaxRecord.get()).getEventDateTimestamp());
                sendFaxProgress.setChannelCallUuid(UUID.randomUUID().toString());
                sendFaxProgress.setCallerOrigCallerIdNumber(((SendFaxProgress)currentFaxRecord.get()).getCallerOrigCallerIdNumber());
                sendFaxProgress.setCallerCalleeIdNumber(((SendFaxProgress)currentFaxRecord.get()).getCallerCalleeIdNumber());
                sendFaxProgress.setCallerAni(((SendFaxProgress)currentFaxRecord.get()).getCallerAni());
                sendFaxProgress.setCallerDestinationNumber(((SendFaxProgress)currentFaxRecord.get()).getCallerDestinationNumber());
                sendFaxProgress.setCallerUniqueId(((SendFaxProgress)currentFaxRecord.get()).getCallerUniqueId());
                sendFaxProgress.setCallerContext(((SendFaxProgress)currentFaxRecord.get()).getCallerContext());
                this.sendFaxProgressRepository.save((Object)sendFaxProgress);
                ucUsers.add(((Extension)extension.get()).getAssignedUser());
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("FaxTransferDetails Created");
                returnValue.setMessageDetail("Fax Transferred Successfully");
                logger.info(returnValue.getMessageDetail());
            } else {
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("selected records Not present");
            }
            this.ucNotificationService.updateFaxCount(ucUsers);
        }
        return returnValue;
    }
}

