/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.pbx.taxonomyCategory.service;

import com.coraltele.db.telephony.pbx.entity.TaxonomyCategory;
import com.coraltele.db.telephony.pbx.repository.TaxonomyCategoryRepository;
import com.coraltele.db.telephony.pbx.specification.TaxonomyCategorySpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.pbx.taxonomyCategory.model.TaxonomyCategoryModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class TaxonomyCategoryService {
    private static final Logger logger = LogManager.getLogger(TaxonomyCategoryService.class);
    @Autowired
    TaxonomyCategoryRepository taxonomyCategoryRepository;

    public RequestResponse createData(TaxonomyCategoryModel data) {
        logger.info("Create new taxonomyCategory : {} ", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        try {
            TaxonomyCategory record = new TaxonomyCategory();
            record.setCode(data.getCode());
            record.setDescription(data.getDescription());
            this.taxonomyCategoryRepository.save((Object)record);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("OK");
            returnValue.setMessageDetail("New TaxonomyCategory Created Successfully");
            logger.info(returnValue.getMessage());
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.BAD_CREDENTIAL);
            returnValue.setMessage("Unable To Create TaxonomyCategory");
            returnValue.setMessageDetail("Contact With administrator");
            logger.error(returnValue.getMessageDetail(), (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse updateById(TaxonomyCategoryModel data) {
        logger.info("Update TaxonomyCategory {}", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        Optional taxonomyCategory = this.taxonomyCategoryRepository.findById((Object)data.getId());
        if (!taxonomyCategory.isPresent()) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Not Found");
            returnValue.setMessageDetail("Taxonomy Not Found");
            logger.error(returnValue.getMessage());
            return returnValue;
        }
        if (data.getCode() != null) {
            ((TaxonomyCategory)taxonomyCategory.get()).setCode(data.getCode());
        }
        if (data.getDescription() != null) {
            ((TaxonomyCategory)taxonomyCategory.get()).setDescription(data.getDescription());
        }
        this.taxonomyCategoryRepository.save(taxonomyCategory.get());
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Updated");
        returnValue.setMessageDetail("TaxonomyCategory Updated Successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse deleteById(InputIdModel data) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList addValue = new ArrayList();
        for (Integer ids : data.getIntId()) {
            Optional taxonomy = this.taxonomyCategoryRepository.findById((Object)ids);
            if (taxonomy.isPresent()) {
                addValue.add(taxonomy.get());
                this.taxonomyCategoryRepository.deleteAll(addValue);
                continue;
            }
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Records Not Found ");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setMessageDetail("Records Deleted Successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getAll() {
        List list = (List)this.taxonomyCategoryRepository.findAll();
        ArrayList<TaxonomyCategoryModel> addValue = new ArrayList<TaxonomyCategoryModel>();
        RequestResponse returnValue = new RequestResponse();
        for (TaxonomyCategory taxonomy : list) {
            TaxonomyCategoryModel data = new TaxonomyCategoryModel();
            data.setId(taxonomy.getId());
            data.setCode(taxonomy.getCode());
            data.setDescription(taxonomy.getDescription());
            addValue.add(data);
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setData(addValue);
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getAllByFilter(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = TaxonomyCategorySpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.sortDirection.equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).ascending();
        } else if (searchRequestData.sortDirection.equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).descending();
        }
        Page page = null;
        page = sort == null ? this.taxonomyCategoryRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.taxonomyCategoryRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)page.getContent());
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }
}

