/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.pbx.formJson.service;

import com.coraltele.db.telephony.pbx.entity.FormJson;
import com.coraltele.db.telephony.pbx.repository.FormJsonRepository;
import com.coraltele.db.telephony.pbx.specification.FormJsonSpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.pbx.formJson.model.DynamicFormFieldModel;
import com.coraltele.service.pbx.formJson.model.DynamicFormModel;
import com.coraltele.service.pbx.formJson.model.DynamicFormTabModel;
import com.coraltele.service.pbx.formJson.model.JsonFormModel;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.Principal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class FormJsonService {
    private static final Logger logger = LogManager.getLogger(FormJsonService.class);
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final String directoryPath = "/etc/coraltele/forms/";
    @Autowired
    FormJsonRepository formJsonRepository;

    public RequestResponse createJsonForm(JsonFormModel data, Principal principal) throws IOException {
        RequestResponse returnValue = new RequestResponse();
        try {
            FormJson record = new FormJson();
            record.setCreatedBy(principal.getName());
            record.setCreatedOn(LocalDateTime.now());
            record.setFormName(data.getFormName());
            record.setFormCode(data.getFormCode());
            record.setMenuName(data.getMenuName());
            record.setUuid(UUID.randomUUID().toString());
            this.formJsonRepository.save((Object)record);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("data created successfully:" + data.getFormName());
            logger.info("data created successfully:{}", (Object)data.getFormName());
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error on creating data:{}", (Object)e.getMessage());
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Invalid data:" + e.getMessage());
        }
        return returnValue;
    }

    public RequestResponse updateJsonForm(JsonFormModel data, Principal principal) throws IOException {
        RequestResponse returnValue = new RequestResponse();
        try {
            FormJson existingData;
            Optional formJson = this.formJsonRepository.findById((Object)data.getId());
            if (formJson.isPresent()) {
                existingData = (FormJson)formJson.get();
                if (!existingData.getFormCode().equals(data.getFormCode())) {
                    this.renameJsonFile(existingData.getFormCode(), data.getFormCode());
                }
                if (data.getFormCode() != null) {
                    existingData.setFormCode(data.getFormCode());
                }
                if (data.getMenuName() != null) {
                    existingData.setMenuName(data.getMenuName());
                }
                if (data.getFormName() != null) {
                    existingData.setFormName(data.getFormName());
                }
            } else {
                logger.error("Invalid data:{}", (Object)data.getId());
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("fail to updated:" + data.getFormName());
                return returnValue;
            }
            existingData.setUpdatedBy(principal.getName());
            existingData.setUpdatedOn(LocalDateTime.now());
            this.formJsonRepository.save((Object)existingData);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("data updated successfully");
            logger.info("data updated successfully:{}", (Object)data.getFormName());
        }
        catch (Exception e) {
            e.printStackTrace();
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Invalid data:" + e.getMessage());
            logger.error("Error on creating data:{}", (Object)e.getMessage());
        }
        return returnValue;
    }

    public RequestResponse deleteFormData(InputIdModel data) {
        RequestResponse returnValue = new RequestResponse();
        try {
            for (Integer id : data.getIntId()) {
                Optional formJson = this.formJsonRepository.findById((Object)id);
                if (!formJson.isPresent()) continue;
                this.formJsonRepository.deleteById((Object)((FormJson)formJson.get()).getId());
                String filePath = directoryPath + ((FormJson)formJson.get()).getFormCode() + ".json";
                File file = new File(filePath);
                if (!file.exists()) continue;
                if (file.delete()) {
                    logger.info("Existing JSON file deleted successfully: " + filePath);
                    continue;
                }
                logger.error("Failed to delete existing JSON file: " + filePath);
            }
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("data deleted Successfully");
            logger.info(returnValue.getMessage());
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Something went wrong");
            returnValue.setMessageDetail("Contact with Administrator");
            logger.error(e.getMessage());
        }
        return returnValue;
    }

    public RequestResponse getFormData(String formCode) throws IOException {
        RequestResponse returnValue = new RequestResponse();
        try {
            String filePath = directoryPath + formCode + ".json";
            File file = new File(filePath);
            if (file.exists()) {
                String fileContent = new String(Files.readAllBytes(Paths.get(filePath, new String[0])));
                ObjectMapper objectMapper = new ObjectMapper();
                DynamicFormModel jsonData = (DynamicFormModel)objectMapper.readValue(fileContent, DynamicFormModel.class);
                returnValue.setMessage("form data read Successfully");
                DynamicFormModel data = new DynamicFormModel();
                data.setFormCode(formCode);
                data.setContent(jsonData.getContent());
                data.setTabs(jsonData.getTabs());
                data.setFormType(jsonData.getFormType());
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("Data Retrieved Successfully");
                returnValue.setData((Object)data);
                logger.info(returnValue.getMessage());
            } else {
                DynamicFormModel data = new DynamicFormModel();
                data.setFormCode(formCode);
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("Data Retrieved Successfully");
                returnValue.setData((Object)data);
                logger.error(returnValue.getMessage());
            }
        }
        catch (UnknownError e) {
            e.printStackTrace();
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Something went wrong");
            returnValue.setMessageDetail("Contact with Administrator");
            logger.error(e.getMessage());
        }
        return returnValue;
    }

    public RequestResponse getAllByFilter(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = FormJsonSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.sortDirection.equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).ascending();
        } else if (searchRequestData.sortDirection.equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).descending();
        }
        Page page = null;
        page = sort == null ? this.formJsonRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.formJsonRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)page.getContent());
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getList() {
        RequestResponse returnValue = new RequestResponse();
        ArrayList<JsonFormModel> addValue = new ArrayList<JsonFormModel>();
        try {
            List formList = (List)this.formJsonRepository.findAll();
            if (!formList.isEmpty()) {
                for (FormJson formJson : formList) {
                    JsonFormModel data = new JsonFormModel();
                    data.setId(formJson.getId());
                    data.setFormName(formJson.getFormName());
                    data.setMenuName(formJson.getMenuName());
                    data.setFormCode(formJson.getFormCode());
                    addValue.add(data);
                }
                logger.info("list of file fetched successfully");
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("list of records");
                returnValue.setData(addValue);
            } else {
                logger.info("Not any record exist on table formJson");
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("empty list present");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error on getting file list:{}", (Object)e.getMessage());
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Error on getting file list");
        }
        return returnValue;
    }

    public RequestResponse createJsonFile(String formCode, DynamicFormModel data) throws IOException {
        RequestResponse returnValue = new RequestResponse();
        File directory = new File(directoryPath);
        directory.mkdirs();
        String filePath = directoryPath + formCode + ".json";
        File file = new File(filePath);
        if (file.exists()) {
            if (file.delete()) {
                logger.info("Existing JSON file deleted successfully: " + filePath);
            } else {
                logger.error("Failed to delete existing JSON file: " + filePath);
            }
        }
        try {
            List tabs = this.extractTabs(data.getContent());
            LinkedHashMap<String, Object> jsonObject = new LinkedHashMap<String, Object>();
            jsonObject.put("content", data.getContent());
            jsonObject.put("formType", data.getFormType());
            if (tabs.size() > 1) {
                jsonObject.put("tabs", tabs);
            }
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
            objectMapper.writeValue(file, jsonObject);
            logger.info("JSON file created successfully at: " + filePath);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("Form created successfully");
        }
        catch (IOException e) {
            logger.error("Error occurred while writing JSON file: " + e.getMessage());
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("failed to create form");
            throw e;
        }
        return returnValue;
    }

    private List<DynamicFormTabModel> extractTabs(List<DynamicFormFieldModel> content) {
        ArrayList<DynamicFormTabModel> tabs = new ArrayList<DynamicFormTabModel>();
        HashSet<String> uniqueTabs = new HashSet<String>();
        if (!content.isEmpty()) {
            for (DynamicFormFieldModel item : content) {
                Integer tabId = item.tabId;
                String tabName = item.tabName;
                String tabKey = tabId + ":" + tabName;
                if (uniqueTabs.contains(tabKey)) continue;
                DynamicFormTabModel tab = new DynamicFormTabModel();
                tab.setId(tabId);
                tab.setName(tabName);
                tabs.add(tab);
                uniqueTabs.add(tabKey);
            }
        }
        return tabs;
    }

    private void renameJsonFile(String oldFormCode, String newFormCode) {
        String oldFilePath = directoryPath + oldFormCode + ".json";
        String newFilePath = directoryPath + newFormCode + ".json";
        File oldFile = new File(oldFilePath);
        File newFile = new File(newFilePath);
        if (oldFile.exists() && !newFile.exists()) {
            if (oldFile.renameTo(newFile)) {
                logger.info("File renamed successfully from {} to {}", (Object)oldFilePath, (Object)newFilePath);
            } else {
                logger.error("Failed to rename file from {} to {}", (Object)oldFilePath, (Object)newFilePath);
            }
        }
    }
}

