/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.pbx.extension.controller;

import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.service.externalApi.model.ClickToCall;
import com.coraltele.service.pbx.extension.model.ExtensionCreateModel;
import com.coraltele.service.pbx.extension.model.ExtensionModelCreate;
import com.coraltele.service.pbx.extension.model.ExtensionNewModel;
import com.coraltele.service.pbx.extension.model.ExtensionPhoneModel;
import com.coraltele.service.pbx.extension.model.ExtensionTypeModel;
import com.coraltele.service.pbx.extension.model.ExtensionZoneModel;
import com.coraltele.service.pbx.extension.model.ExtensionsModel;
import com.coraltele.service.pbx.extension.model.MCXCallModel;
import com.coraltele.service.pbx.extension.model.PlayFileModel;
import com.coraltele.service.pbx.extension.model.ShuntingStatusModel;
import com.coraltele.service.pbx.extension.model.group.CallingFeatureModel;
import com.coraltele.service.pbx.extension.model.group.CodeBlueModel;
import com.coraltele.service.pbx.extension.model.group.CodecModel;
import com.coraltele.service.pbx.extension.model.group.CosModel;
import com.coraltele.service.pbx.extension.model.group.ExtensionFeatureModel;
import com.coraltele.service.pbx.extension.model.group.ModeModel;
import com.coraltele.service.pbx.extension.model.group.ProvisioningFeatureModel;
import com.coraltele.service.pbx.extension.model.group.SecurityModel;
import com.coraltele.service.pbx.extension.model.group.SetOperationDayAndTimeModel;
import com.coraltele.service.pbx.extension.model.group.UCFeatureModel;
import com.coraltele.service.pbx.extension.model.group.VoNrVoLteModel;
import com.coraltele.service.pbx.extension.model.groupMultipleUpdates.CallingFeatureMultipleUpdate;
import com.coraltele.service.pbx.extension.model.groupMultipleUpdates.CodeBlueMultipleUpdate;
import com.coraltele.service.pbx.extension.model.groupMultipleUpdates.CodecMultipleUpdate;
import com.coraltele.service.pbx.extension.model.groupMultipleUpdates.CosMultipleUpdate;
import com.coraltele.service.pbx.extension.model.groupMultipleUpdates.ExtensionCosMultipleUpdate;
import com.coraltele.service.pbx.extension.model.groupMultipleUpdates.ExtensionFeatureMultipleUpdate;
import com.coraltele.service.pbx.extension.model.groupMultipleUpdates.ModeMultipleUpdate;
import com.coraltele.service.pbx.extension.model.groupMultipleUpdates.ProvisioningFeaturesMultipleUpdate;
import com.coraltele.service.pbx.extension.model.groupMultipleUpdates.SecurityMultipleUpdate;
import com.coraltele.service.pbx.extension.model.groupMultipleUpdates.SetOperationDayAndTimeMultipleUpdate;
import com.coraltele.service.pbx.extension.model.groupMultipleUpdates.UCFeaturesMultipleUpdate;
import com.coraltele.service.pbx.extension.model.groupMultipleUpdates.VoNrVoLteMultipleUpdate;
import com.coraltele.service.pbx.extension.service.ExtensionRegistrationService;
import com.coraltele.service.pbx.extension.service.ExtensionSecondaryService;
import com.coraltele.service.pbx.extension.service.ExtensionsService;
import com.coraltele.service.pbx.extension_service.model.ServiceCodeAttribute;
import com.coraltele.service.telemetry.main.userCoordinate.service.UserCoordinateService;
import java.io.IOException;
import java.security.Principal;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/v2/extensions"})
@RestController
public class ExtensionsController {
    @Autowired
    private ExtensionsService extensionsService;
    @Autowired
    ExtensionRegistrationService extRegistrationService;
    @Autowired
    ExtensionSecondaryService extensionSecondaryService;
    @Autowired
    UserCoordinateService userCoordinateService;

    @PostMapping(value={"/create"})
    public ResponseEntity<RequestResponse> createExtensionByRange(@RequestBody ServiceCodeAttribute data, HttpServletRequest request) {
        RequestResponse returnValue = this.extensionsService.createExtensionByGivenRange(request, data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/list"})
    public ResponseEntity<RequestResponse> getFilterExtension(@RequestBody SearchRequest searchRequest) {
        RequestResponse returnValue = this.extensionsService.getFilteredExtension(searchRequest);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/delete/{extension}"})
    public ResponseEntity<RequestResponse> deleteByExtension(@PathVariable(value="extension") String extension) {
        RequestResponse returnValue = this.extensionsService.deleteBySingleExtensionValue(extension);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/multiDelete"})
    public ResponseEntity<RequestResponse> deleteMultipleExtension(@RequestBody List<String> extensions) {
        RequestResponse returnValue = this.extensionsService.deleteMultipleExtensions(extensions);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/{extension}"})
    public ResponseEntity<RequestResponse> getSingleRecordsAlongWithExtension(@PathVariable(value="extension") String extension) {
        RequestResponse returnValue = this.extensionsService.getSingleExtension(extension);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/callingFeature/{extension}"})
    public ResponseEntity<RequestResponse> getSingleCallingFeatures(@PathVariable(value="extension") String extension) {
        RequestResponse returnValue = this.extensionsService.getSingleCallingFeatures(extension);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/callingFeature/list"})
    public ResponseEntity<RequestResponse> getAllCallingFeatures(@RequestBody SearchRequest searchRequest) {
        RequestResponse returnValue = this.extensionsService.getAllCallingFeature(searchRequest);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/codeBlue/{extension}"})
    public ResponseEntity<RequestResponse> getSingleCodeBlue(@PathVariable(value="extension") String extension) {
        RequestResponse returnValue = this.extensionsService.getSingleCodeBlue(extension);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/codeBlue/list"})
    public ResponseEntity<RequestResponse> getAllCodeBlue(@RequestBody SearchRequest searchRequest) {
        RequestResponse returnValue = this.extensionsService.getAllCodeBlue(searchRequest);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/codec/{extension}"})
    public ResponseEntity<RequestResponse> getSingleCodec(@PathVariable(value="extension") String extension) {
        RequestResponse returnValue = this.extensionsService.getSingleCodec(extension);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/codec/list"})
    public ResponseEntity<RequestResponse> getAllCodec(@RequestBody SearchRequest searchRequest) {
        RequestResponse returnValue = this.extensionsService.getAllCodec(searchRequest);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/cos/{extension}"})
    public ResponseEntity<RequestResponse> getSingleCos(@PathVariable(value="extension") String extension) {
        RequestResponse returnValue = this.extensionsService.getSingleCos(extension);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/cos/list"})
    public ResponseEntity<RequestResponse> getAllCos(@RequestBody SearchRequest searchRequest) {
        RequestResponse returnValue = this.extensionsService.getAllCos(searchRequest);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/extensionFeature/{extension}"})
    public ResponseEntity<RequestResponse> getSingleExtensionFeature(@PathVariable(value="extension") String extension) {
        RequestResponse returnValue = this.extensionsService.getSingleExtensionFeature(extension);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/extensionFeature/list"})
    public ResponseEntity<RequestResponse> getAllExtensionFeature(@RequestBody SearchRequest searchRequest) {
        RequestResponse returnValue = this.extensionsService.getAllExtensionFeature(searchRequest);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/security/{extension}"})
    public ResponseEntity<RequestResponse> getSingleSecurity(@PathVariable(value="extension") String extension) {
        RequestResponse returnValue = this.extensionsService.getSingleSecurity(extension);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/security/list"})
    public ResponseEntity<RequestResponse> getAllSecurity(@RequestBody SearchRequest searchRequest) {
        RequestResponse returnValue = this.extensionsService.getAllSecurity(searchRequest);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/uc/{extension}"})
    public ResponseEntity<RequestResponse> getSingleUC(@PathVariable(value="extension") String extension) {
        RequestResponse returnValue = this.extensionsService.getSingleUC(extension);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/uc/list"})
    public ResponseEntity<RequestResponse> getAllUC(@RequestBody SearchRequest searchRequest) {
        RequestResponse returnValue = this.extensionsService.getAllUCFeature(searchRequest);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/provisioning/{extension}"})
    public ResponseEntity<RequestResponse> getSingleProvisioning(@PathVariable(value="extension") String extension) {
        RequestResponse returnValue = this.extensionsService.getSingleProvisioning(extension);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/provisioning/list"})
    public ResponseEntity<RequestResponse> getAllProvisioning(@RequestBody SearchRequest searchRequest) {
        RequestResponse returnValue = this.extensionsService.getAllProvisioning(searchRequest);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/setOperationDayAndTime/{extension}"})
    public ResponseEntity<RequestResponse> getSingleSetOperationDayAndTime(@PathVariable(value="extension") String extension) {
        RequestResponse returnValue = this.extensionsService.getSingleSetOperationDayAndTime(extension);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/setOperationDayAndTime/list"})
    public ResponseEntity<RequestResponse> GetAllSetOperationDayAndTime(@RequestBody SearchRequest searchRequest) {
        RequestResponse returnValue = this.extensionsService.getAllSetOperationDayAndTime(searchRequest);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/mode/{extension}"})
    public ResponseEntity<RequestResponse> getSingleMode(@PathVariable(value="extension") String extension) {
        RequestResponse returnValue = this.extensionsService.getSingleMode(extension);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/mode/list"})
    public ResponseEntity<RequestResponse> getAllMode(@RequestBody SearchRequest searchRequest) {
        RequestResponse returnValue = this.extensionsService.getAllMode(searchRequest);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/voNrVoLte/{extension}"})
    public ResponseEntity<RequestResponse> getVoNrVoLte(@PathVariable(value="extension") String extension) {
        RequestResponse returnValue = this.extensionsService.getVoNrVoLte(extension);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/voNrVoLte/list"})
    public ResponseEntity<RequestResponse> getAllVoipVonr(@RequestBody SearchRequest searchRequest) {
        RequestResponse returnValue = this.extensionsService.getAllVoNrVoLte(searchRequest);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/update/callingFeature/{extension}"})
    public ResponseEntity<RequestResponse> updateSingleCallingFeatures(HttpServletRequest request, @PathVariable(value="extension") String extension, @RequestBody CallingFeatureModel data, Authentication authentication) throws IOException {
        RequestResponse returnValue = this.extensionsService.updateSingleCallingFeature(request, extension, data, authentication);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/multiUpdate/callingFeature"})
    public ResponseEntity<RequestResponse> updateMultipleCallingFeatures(@RequestBody CallingFeatureMultipleUpdate data) {
        RequestResponse returnValue = this.extensionsService.updateMultipleCallingFeatures(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/update/setOperationDayAndTime/{extension}"})
    public ResponseEntity<RequestResponse> updateSingleSetOperationDayAndTime(HttpServletRequest request, @PathVariable(value="extension") String extension, @RequestBody SetOperationDayAndTimeModel data, Authentication authentication) throws IOException {
        RequestResponse returnValue = this.extensionsService.updateSingleSetOperationDayAndTime(request, extension, data, authentication);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/update/ucFeature/{extension}"})
    public ResponseEntity<RequestResponse> updateSingleUCFeatures(HttpServletRequest request, @PathVariable(value="extension") String extension, @RequestBody UCFeatureModel data, Authentication authentication) throws IOException {
        RequestResponse returnValue = this.extensionsService.updateSingleUCFeatures(request, extension, data, authentication);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/update/voNrVoLte/{extension}"})
    public ResponseEntity<RequestResponse> updateSingleVoNrVoLte(HttpServletRequest request, @PathVariable(value="extension") String extension, @RequestBody VoNrVoLteModel data, Authentication authentication) throws IOException {
        RequestResponse returnValue = this.extensionsService.updateSingleVoNrVoLte(request, extension, data, authentication);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/update/security/{extension}"})
    public ResponseEntity<RequestResponse> updateSingleSecurity(HttpServletRequest request, @PathVariable(value="extension") String extension, @RequestBody SecurityModel data, Authentication authentication) throws IOException {
        RequestResponse returnValue = this.extensionsService.updateSingleSecurity(request, extension, data, authentication);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/update/provisioningFeature/{extension}"})
    public ResponseEntity<RequestResponse> updateSingleProvisioning(@PathVariable(value="extension") String extension, @RequestBody ProvisioningFeatureModel data) {
        RequestResponse returnValue = this.extensionsService.updateSingleProvisioning(extension, data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/update/mode/{extension}"})
    public ResponseEntity<RequestResponse> updateSingleMode(HttpServletRequest request, @PathVariable(value="extension") String extension, @RequestBody ModeModel data, Authentication authentication) throws IOException {
        RequestResponse returnValue = this.extensionsService.updateSingleMode(request, extension, data, authentication);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/update/codec/{extension}"})
    public ResponseEntity<RequestResponse> updateCodecFeature(HttpServletRequest request, @PathVariable(value="extension") String extension, @RequestBody CodecModel data, Authentication authentication) throws IOException {
        RequestResponse returnValue = this.extensionsService.updateSingleCodec(request, extension, data, authentication);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/update/cos/{extension}"})
    public ResponseEntity<RequestResponse> updateSingleCos(HttpServletRequest request, @PathVariable(value="extension") String extension, @RequestBody CosModel data, Authentication authentication) throws IOException {
        RequestResponse returnValue = this.extensionsService.updateSingleCos(request, extension, data, authentication);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/update/extensionFeature/{extension}"})
    public ResponseEntity<RequestResponse> updateExtensionFeature(@PathVariable(value="extension") String extension, @RequestBody ExtensionFeatureModel data) {
        RequestResponse returnValue = this.extensionsService.updateSingleExtensionFeature(extension, data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/update/codeBlue/{extension}"})
    public ResponseEntity<RequestResponse> updateSingleCodeBlue(HttpServletRequest request, @PathVariable(value="extension") String extension, @RequestBody CodeBlueModel data, Authentication authentication) throws IOException {
        RequestResponse returnValue = this.extensionsService.updateSingleCodeBlue(request, extension, data, authentication);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/multiUpdate/mode"})
    public ResponseEntity<RequestResponse> updateMultipleMode(HttpServletRequest request, @RequestBody ModeMultipleUpdate data, Authentication authentication) throws IOException {
        RequestResponse returnValue = this.extensionsService.updateMultipleMode(request, data, authentication);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/multiUpdate/voNrVoLte"})
    public ResponseEntity<RequestResponse> updateMultipleVoNrVoLte(HttpServletRequest request, @RequestBody VoNrVoLteMultipleUpdate data, Authentication authentication) throws IOException {
        RequestResponse returnValue = this.extensionsService.updateMultipleVoNrVoLte(request, data, authentication);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/multiUpdate/codec"})
    public ResponseEntity<RequestResponse> updateMultipleCodec(HttpServletRequest request, @RequestBody CodecMultipleUpdate data, Authentication authentication) throws IOException {
        RequestResponse returnValue = this.extensionsService.updateMultipleCodec(request, data, authentication);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/multiUpdate/cos"})
    public ResponseEntity<RequestResponse> updateMultipleCos(HttpServletRequest request, @RequestBody CosMultipleUpdate data, Authentication authentication) throws IOException {
        RequestResponse returnValue = this.extensionsService.updateMultipleCos(request, data, authentication);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/multiUpdate/security"})
    public ResponseEntity<RequestResponse> updateMultipleSecurity(HttpServletRequest request, @RequestBody SecurityMultipleUpdate data, Authentication authentication) throws IOException {
        RequestResponse returnValue = this.extensionsService.updateMultipleSecurity(request, data, authentication);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/multiUpdate/setOperationDayAndTime"})
    public ResponseEntity<RequestResponse> updateMultipleSetOperationDayAndTime(HttpServletRequest request, @RequestBody SetOperationDayAndTimeMultipleUpdate data, Authentication authentication) throws IOException {
        RequestResponse returnValue = this.extensionsService.updateMultipleSetOperationDayAndTime(request, data, authentication);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/multiUpdate/ucFeature"})
    public ResponseEntity<RequestResponse> updateMultipleUCFeatures(HttpServletRequest request, @RequestBody UCFeaturesMultipleUpdate data, Authentication authentication) throws IOException {
        RequestResponse returnValue = this.extensionsService.updateMultipleUCFeatures(request, data, authentication);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/multiUpdate/codeBlue"})
    public ResponseEntity<RequestResponse> updateMultipleCodeBlue(HttpServletRequest request, @RequestBody CodeBlueMultipleUpdate data, Authentication authentication) throws IOException {
        RequestResponse returnValue = this.extensionsService.updateMultipleCodeBlue(request, data, authentication);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/multiUpdate/provisioningFeature"})
    public ResponseEntity<RequestResponse> updateMultipleProvisioning(@RequestBody ProvisioningFeaturesMultipleUpdate data) {
        RequestResponse returnValue = this.extensionsService.updateMultipleProvisioning(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/multiUpdate/extensionFeature"})
    public ResponseEntity<RequestResponse> updateMultipleExtensionFeature(@RequestBody ExtensionFeatureMultipleUpdate data) {
        RequestResponse returnValue = this.extensionsService.updateMultipleExtensionFeature(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/updateHSS/{extensionNumber}"})
    public ResponseEntity<RequestResponse> updateHSS(@PathVariable(value="extensionNumber") String extensionNumber) {
        RequestResponse returnValue = this.extensionsService.updateHSS(extensionNumber);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @DeleteMapping(value={"/updateHSS/{extensionNumber}"})
    public ResponseEntity<RequestResponse> deleteHSS(@PathVariable(value="extensionNumber") String extensionNumber) {
        RequestResponse returnValue = this.extensionsService.deleteHSS(extensionNumber);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/extension/list"})
    public ResponseEntity<RequestResponse> getAllExtensionView(@RequestBody SearchRequest searchRequest) {
        RequestResponse returnValue = this.extensionsService.getAllExtensionView(searchRequest);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/list/registered"})
    public ResponseEntity<RequestResponse> getList() {
        RequestResponse returnValue = this.extRegistrationService.getAllRecords();
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/registered/list"})
    public ResponseEntity<RequestResponse> getFilterList(@RequestBody SearchRequest searchRequest) {
        RequestResponse returnValue = this.extRegistrationService.getFilteredList(searchRequest);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/conferenceNumber"})
    public ResponseEntity<RequestResponse> getAllConferenceNumberAsExtensionNumber() {
        RequestResponse returnValue = this.extensionsService.getAllConferenceNumberAsExtensionNumber();
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/extensionDropDown"})
    public ResponseEntity<RequestResponse> listOfExtension() {
        RequestResponse returnValue = this.extensionsService.extensionList();
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/registeredList"})
    public ResponseEntity<RequestResponse> getRegisteredAndUnregistered() {
        RequestResponse returnValue = this.extensionsService.getRegisteredAndUnregistered();
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/listAll"})
    public ResponseEntity<RequestResponse> getAllRLUCode() {
        RequestResponse returnValue = this.extensionsService.getAllRLUCode();
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/listAllAgent"})
    public ResponseEntity<RequestResponse> getAllAgent() {
        RequestResponse returnValue = this.extensionsService.getAllAgent();
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @GetMapping(value={"/listAllContacts"})
    public ResponseEntity<RequestResponse> getContacts() {
        RequestResponse returnValue = this.extensionsService.getContacts();
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/listAllDepartment"})
    public ResponseEntity<RequestResponse> getListOfDepartment() {
        RequestResponse returnValue = this.extensionsService.getListOfExtensionTypePhoneWithDepartmentNotNull();
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/listAllZone"})
    public ResponseEntity<RequestResponse> getListOfZone() {
        RequestResponse returnValue = this.extensionsService.getListOfExtensionTypePhoneWithZoneNotNull();
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/call/department"})
    public ResponseEntity<RequestResponse> callForDepartment(Principal principal, @RequestBody MCXCallModel data) {
        RequestResponse returnValue = this.extensionsService.departmentCall1(principal, data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/call/zone"})
    public ResponseEntity<RequestResponse> calForZone(Principal principal, @RequestBody MCXCallModel data) {
        RequestResponse returnValue = this.userCoordinateService.zoneCall(principal, data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/play/zone"})
    public ResponseEntity<RequestResponse> playForZone(Principal principal, @RequestBody PlayFileModel data) {
        RequestResponse returnValue = this.userCoordinateService.playFileForZone(principal, data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/play/department"})
    public ResponseEntity<RequestResponse> playForDepartment(Principal principal, @RequestBody PlayFileModel data) {
        RequestResponse returnValue = this.extensionsService.playFileForDepartment1(principal, data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/updateApplicationId"})
    public ResponseEntity<RequestResponse> updateApplicationIdByExtension(@RequestBody ExtensionsModel data) {
        RequestResponse returnValue = this.extensionsService.updateApplicationIdByExtension(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/createExtension"})
    public ResponseEntity<RequestResponse> createDataInExtension(@RequestBody ExtensionModelCreate data) {
        RequestResponse returnValue = this.extensionsService.createDataInExtension(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/deleteExtension"})
    public ResponseEntity<RequestResponse> deleteById(@RequestBody InputIdModel id) {
        RequestResponse returnValue = this.extensionsService.deleteExtensionById(id);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/list/{extType}"})
    public ResponseEntity<RequestResponse> getFilterExtensionByType(@PathVariable(value="extType") String extType, @RequestBody SearchRequest searchRequest) {
        RequestResponse returnValue = this.extensionsService.getFilteredExtensionByType(searchRequest, extType);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/updateExtension"})
    public ResponseEntity<RequestResponse> updateExtensionById(@RequestBody ExtensionModelCreate data) {
        RequestResponse returnValue = this.extensionsService.updateExtensionById(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/listAll/{extTypeList}"})
    public ResponseEntity<RequestResponse> getAcdPickUpGroup(@PathVariable(value="extTypeList") List<String> extTypeList) {
        RequestResponse returnValue = this.extensionsService.getAcdPickUpGroup(extTypeList);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/listAll/extensionTypePhone"})
    public ResponseEntity<RequestResponse> getAllExtensionOfPhoneType() {
        RequestResponse returnValue = this.extensionSecondaryService.getAllExtensionOfPhoneType();
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/update/assignedUser"})
    public ResponseEntity<RequestResponse> updateAssignedUser(@RequestBody ExtensionPhoneModel data) {
        RequestResponse returnValue = this.extensionSecondaryService.updateAssignedUser(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/departmentShuntingStatus/{extension}"})
    public ResponseEntity<RequestResponse> shuntingByDepartmentExtension(@PathVariable(value="extension") String extension) {
        RequestResponse returnValue = this.extensionSecondaryService.getShuntingOfDepartmentGroup(extension);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/update/shuntingMode"})
    public ResponseEntity<RequestResponse> updateShuntingStatus(@RequestBody ShuntingStatusModel data) {
        RequestResponse returnValue = this.extensionSecondaryService.updateShuntingStatus(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/getShuntingMode/{extension}"})
    public ResponseEntity<RequestResponse> getShuntingStatus(@PathVariable(value="extension") String extension) {
        RequestResponse returnValue = this.extensionSecondaryService.getShuntingStatus(extension);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/ec"})
    public ResponseEntity<RequestResponse> getAllExtensionTypeEC() {
        RequestResponse returnValue = this.extensionsService.getExtensionTypeEC();
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/dynamicCreate"})
    public ResponseEntity<RequestResponse> createExtNew(@RequestBody ExtensionNewModel data) {
        RequestResponse returnValue = this.extensionSecondaryService.createExtensionByGivenRange(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/listAllExtensionPhone"})
    public ResponseEntity<RequestResponse> getAllExtensionPhone() {
        RequestResponse returnValue = this.extensionSecondaryService.getAllExtensionPhone();
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/dragCall"})
    public ResponseEntity<RequestResponse> callBetweenNumber(@RequestBody ClickToCall data) {
        RequestResponse returnValue = this.extensionSecondaryService.makeCallTransfer(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/listAllExtensionType"})
    public ResponseEntity<RequestResponse> getAllExtensionType() {
        RequestResponse returnValue = this.extensionSecondaryService.getAllExtensionType();
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/listExtensionType/{extensionType}"})
    public ResponseEntity<RequestResponse> getAllExtensionsByExtensionType(@PathVariable(value="extensionType") String extension) {
        RequestResponse returnValue = this.extensionSecondaryService.getAllExtensionsByExtensionType(extension);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/update/extension"})
    public ResponseEntity<RequestResponse> updateExtension(@RequestBody ExtensionZoneModel data) {
        RequestResponse returnValue = this.extensionSecondaryService.updateExtension(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/update/zoneAndDepartment"})
    public ResponseEntity<RequestResponse> updateZoneAndDepartmentByExtension(@RequestBody ExtensionFeatureMultipleUpdate data) {
        RequestResponse returnValue = this.extensionSecondaryService.updateZoneAndDepartmentByExtension(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/list/extensions"})
    public ResponseEntity<RequestResponse> getFilteredExtensions(@RequestBody SearchRequest searchRequest) {
        RequestResponse returnValue = this.extensionSecondaryService.getFilteredExtensions(searchRequest);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/list/zone/{zone}"})
    public ResponseEntity<RequestResponse> getExtensionListByZone(@PathVariable(value="zone") String zone) {
        RequestResponse returnValue = this.extensionsService.selectedZoneList(zone);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/list/department/{department}"})
    public ResponseEntity<RequestResponse> getExtensionListByDepartment(@PathVariable(value="department") String department) {
        RequestResponse returnValue = this.extensionsService.selectedDepartmentList(department);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/updateDid/{extension}/{didNumber}"})
    public ResponseEntity<RequestResponse> updateDidByExtension(@PathVariable(value="extension") String extension, @PathVariable(value="didNumber") String didNumber) {
        RequestResponse returnValue = this.extensionsService.updateDidByExtension(extension, didNumber);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/listAll/phoneStatus"})
    public ResponseEntity<RequestResponse> getNameByPhoneStatus() {
        RequestResponse returnValue = this.extensionSecondaryService.getNameByPhoneStatus();
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/listAll/acdGroup"})
    public ResponseEntity<RequestResponse> getExtensionByAcdGroup() {
        RequestResponse returnValue = this.extensionSecondaryService.getExtensionByAcdGroup();
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/delete/Extension"})
    public ResponseEntity<RequestResponse> deleteCampaignById(@RequestBody InputIdModel id) {
        RequestResponse returnValue = this.extensionSecondaryService.deleteByExtension(id);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/updateDepartment"})
    public ResponseEntity<RequestResponse> updateDepartment(@RequestParam(value="extension") String extension, @RequestParam(value="emergencyExtension") String emergencyExtension) {
        RequestResponse returnValue = new RequestResponse();
        try {
            if (extension == null || extension.isEmpty() || emergencyExtension == null || emergencyExtension.isEmpty()) {
                throw new IllegalArgumentException("Extension or Emergency Extension cannot be null or empty.");
            }
            this.extensionSecondaryService.updateDepartment(extension, emergencyExtension);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("Department updated successfully.");
            return ResponseEntity.ok((Object)returnValue);
        }
        catch (IllegalArgumentException e) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Validation error: " + e.getMessage());
            return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body((Object)returnValue);
        }
        catch (IllegalStateException e) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Error: " + e.getMessage());
            return ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).body((Object)returnValue);
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Unexpected error occurred while updating department.");
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)returnValue);
        }
    }

    @PostMapping(value={"/extensionType/list"})
    public ResponseEntity<RequestResponse> getExtensionTypeList() {
        RequestResponse returnValue = this.extensionsService.getExtensionTypeList();
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/multipleUpdate/cos"})
    public ResponseEntity<RequestResponse> updateMultipleInboundOutboundCosByExtension(@RequestBody ExtensionCosMultipleUpdate data) {
        RequestResponse returnValue = this.extensionSecondaryService.updateMultipleInboundOutboundCosByExtension(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/create/actionCodeList"})
    public ResponseEntity<RequestResponse> createDataActionCodeList(@RequestBody ExtensionCreateModel data) {
        RequestResponse returnValue = this.extensionSecondaryService.createDataActionCodeList(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/list/actionCodeList"})
    public ResponseEntity<RequestResponse> createDataActionCodeList(@RequestBody SearchRequest data) {
        RequestResponse returnValue = this.extensionSecondaryService.getAllByFilter(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/delete/extension"})
    public ResponseEntity<RequestResponse> deleteExtension(@RequestBody InputIdModel id) {
        RequestResponse returnValue = this.extensionSecondaryService.deleteExtension(id);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/create/fxoCode"})
    public ResponseEntity<RequestResponse> createDataInExtensionForFxoCode(@RequestBody ExtensionModelCreate data) {
        RequestResponse returnValue = this.extensionSecondaryService.createDataInExtensionForFxoCode(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/update/fxoCode"})
    public ResponseEntity<RequestResponse> updateDataInExtensionForFxoCode(@RequestBody ExtensionModelCreate data) {
        RequestResponse returnValue = this.extensionSecondaryService.updateDataInExtensionForFxoCode(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/list/fxoCode"})
    public ResponseEntity<RequestResponse> getAllByFilterForFXOCode(@RequestBody SearchRequest data) {
        RequestResponse returnValue = this.extensionSecondaryService.getAllByFilterForFXOCode(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/create/voiceGuidance"})
    public ResponseEntity<RequestResponse> createDataForVoiceGuidance(@RequestBody ExtensionCreateModel data) {
        RequestResponse returnValue = this.extensionSecondaryService.createDataForVoiceGuidance(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/list/voiceGuidance"})
    public ResponseEntity<RequestResponse> getAllByFilterForVoiceGuidance(@RequestBody SearchRequest data) {
        RequestResponse returnValue = this.extensionSecondaryService.getAllByFilterForVoiceGuidance(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/list/pbxService"})
    public ResponseEntity<RequestResponse> getAllByFilterForPbxService(@RequestBody SearchRequest data) {
        RequestResponse returnValue = this.extensionSecondaryService.getAllByFilterForPbxService(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/codeMaster/listAll"})
    public ResponseEntity<RequestResponse> getAllCodeMaster() {
        RequestResponse returnValue = this.extensionSecondaryService.getAllCodeMaster();
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/create/pbxService"})
    public ResponseEntity<RequestResponse> createDataForPbxService(@RequestBody ExtensionCreateModel data) {
        RequestResponse returnValue = this.extensionSecondaryService.createDataForPbxService(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/list/trunkAccessCode"})
    public ResponseEntity<RequestResponse> getAllByFilterForTrunkAccessCode(@RequestBody SearchRequest data) {
        RequestResponse returnValue = this.extensionSecondaryService.getAllByFilterForTrunkAccessCode(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/create/trunkAccessCode"})
    public ResponseEntity<RequestResponse> createDataForTrunkAccessCode(@RequestBody ExtensionCreateModel data) {
        RequestResponse returnValue = this.extensionSecondaryService.createDataForTrunkAccessCode(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/update/trunkAccessCode"})
    public ResponseEntity<RequestResponse> updateDidMapping(@RequestBody ExtensionCreateModel data) {
        RequestResponse returnValue = this.extensionSecondaryService.updateDidMapping(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/listAllExtnsionType"})
    public ResponseEntity<RequestResponse> getExtnsionTypeFilter(@RequestBody ExtensionTypeModel extTypeList) {
        RequestResponse returnValue = this.extensionsService.getExtnsionTypeFilter(extTypeList);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }
}

