/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.pbx.emailDetail.service;

import com.coraltele.db.telephony.pbx.entity.EmailDetail;
import com.coraltele.db.telephony.pbx.entity.SmsDetails;
import com.coraltele.db.telephony.pbx.entity.SystemConfig;
import com.coraltele.db.telephony.pbx.repository.EmailDetailRepository;
import com.coraltele.db.telephony.pbx.repository.SmsDetailsRepository;
import com.coraltele.db.telephony.pbx.repository.SystemConfigRepository;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.service.pbx.emailDetail.model.MessagingAgentModel;
import java.time.LocalDateTime;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;

@Service
public class MessagingAgentService {
    @Autowired
    private SystemConfigRepository systemConfigRepository;
    @Autowired
    private EmailDetailRepository emailDetailRepository;
    @Autowired
    private SmsDetailsRepository smsDetailsRepository;

    public RequestResponse sendEmail(MessagingAgentModel data) {
        String messageType;
        RequestResponse response = new RequestResponse();
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        String currentUsername = authentication != null ? authentication.getName() : "";
        List listSystemConfig = this.systemConfigRepository.findAll();
        switch (messageType = data.getMessageType() != null ? data.getMessageType().toUpperCase() : "") {
            case "EMAIL": {
                EmailDetail emailDetails = new EmailDetail();
                if (!data.getEmailCc().isEmpty()) {
                    emailDetails.setEmailCc(data.getEmailCc());
                }
                emailDetails.setToUser(data.getToUser());
                if (!data.getSubject().isEmpty()) {
                    emailDetails.setMailSubject(data.getSubject());
                }
                emailDetails.setRemarks(data.getMessage());
                emailDetails.setCreatedTime(LocalDateTime.now());
                this.emailDetailRepository.save((Object)emailDetails);
                response.setMessage("Email sent successfully");
                break;
            }
            case "SMS": {
                if (listSystemConfig.isEmpty() || ((SystemConfig)listSystemConfig.get(0)).getSmsUrl() == null || ((SystemConfig)listSystemConfig.get(0)).getSmsUrl().isEmpty()) {
                    response.setStatus(Constants.Error.ERROR);
                    response.setMessage("SMS URL not found in system configuration");
                    return response;
                }
                SmsDetails smsDetails = new SmsDetails();
                smsDetails.setSmsText(data.getSmsText());
                smsDetails.setCli("agent");
                smsDetails.setAccessCode(currentUsername);
                smsDetails.setDestination(data.getDestination());
                smsDetails.setSmsUrl(((SystemConfig)listSystemConfig.get(0)).getSmsUrl());
                this.smsDetailsRepository.save((Object)smsDetails);
                response.setMessage("SMS sent successfully");
                break;
            }
            default: {
                response.setStatus(Constants.Error.ERROR);
                response.setMessage("Invalid message type: " + data.getMessageType());
                return response;
            }
        }
        response.setStatus(Constants.Error.OK);
        return response;
    }
}

