/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.pbx.cos.controller;

import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.service.pbx.cos.model.InboundCosModel;
import com.coraltele.service.pbx.cos.model.InboundCosMultipleUpdates;
import com.coraltele.service.pbx.cos.service.InboundCosService;
import java.io.IOException;
import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/v2/inboundCos"})
@RestController
public class InboundCosController {
    @Autowired
    private InboundCosService inboundCosService;

    @PostMapping(value={"/create"})
    public ResponseEntity<RequestResponse> addInboundCos(@RequestBody InboundCosModel data) {
        RequestResponse returnValue = this.inboundCosService.createInboundCos(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/{id}"})
    public ResponseEntity<RequestResponse> getInboundCosById(@PathVariable(value="id") int id) {
        RequestResponse returnValue = this.inboundCosService.getById(id);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/list"})
    public ResponseEntity<RequestResponse> getAllInboundCos(@RequestBody SearchRequest searchRequest) {
        RequestResponse returnValue = this.inboundCosService.getInboundCosByFilter(searchRequest);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/update"})
    public ResponseEntity<RequestResponse> updateInboundCos(HttpServletRequest request, @RequestBody InboundCosModel data, Principal principal) throws IOException {
        RequestResponse returnValue = this.inboundCosService.updateInboundCosById(request, data, principal);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/multiUpdate"})
    public ResponseEntity<RequestResponse> partialUpdateInboundCos(HttpServletRequest request, @RequestBody InboundCosMultipleUpdates data, Authentication authentication) throws IOException {
        RequestResponse returnValue = this.inboundCosService.updateAll(request, data, authentication);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/delete"})
    public ResponseEntity<RequestResponse> delete(@RequestBody InputIdModel id) {
        RequestResponse returnValue = this.inboundCosService.delete(id);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/list/cos"})
    public ResponseEntity<RequestResponse> listOfCos() {
        RequestResponse returnValue = this.inboundCosService.getAllCos();
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }
}

