/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.pbx.blfExtension.controller;

import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.service.pbx.blfExtension.BLFExtService;
import com.coraltele.service.pbx.blfExtension.model.BLFModel;
import java.security.Principal;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/v2/blfExtension"})
@RestController
public class BLFExtController {
    @Autowired
    BLFExtService blfExtService;

    @PostMapping(value={"/{sourceExtension}"})
    public ResponseEntity<RequestResponse> getAllByFilter(@PathVariable(value="sourceExtension") String sourceExtension) {
        RequestResponse returnValue = this.blfExtService.getSelectedExtension(sourceExtension);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/status"})
    public ResponseEntity<RequestResponse> getBLFData(@RequestParam(value="blfList", required=true) String extList) {
        RequestResponse returnValue = this.blfExtService.getBLFData(extList);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/dispatcherCall"})
    public ResponseEntity<RequestResponse> dispatcherCall() {
        RequestResponse returnValue = this.blfExtService.callDispatcher();
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/create"})
    public ResponseEntity<RequestResponse> createRecord(@RequestBody BLFModel data, Principal principal) {
        RequestResponse returnValue = this.blfExtService.createData(data, principal);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/delete/{ext}"})
    public ResponseEntity<RequestResponse> createRecord(@PathVariable(value="ext") String data, Principal principal) {
        RequestResponse returnValue = this.blfExtService.deleteData(data, principal);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }
}

