/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.pbx.autoAttendant.controller;

import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.SearchRequest;
import com.coraltele.service.pbx.autoAttendant.model.AutoAttendantModel;
import com.coraltele.service.pbx.autoAttendant.model.IVRTree;
import com.coraltele.service.pbx.autoAttendant.service.AutoattendantServiceNew;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RequestMapping(value={"/api/v2/autoAttendant"})
@RestController
public class AutoAttendantController {
    @Autowired
    private AutoattendantServiceNew autoAttendantService;

    @PostMapping(value={"/filteredList"})
    public ResponseEntity<RequestResponse> getAutoAttendantByFilter(@RequestBody SearchRequest searchRequest) {
        RequestResponse returnValue = this.autoAttendantService.getAutoAttendantByFilter(searchRequest);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/create"})
    public ResponseEntity<RequestResponse> createAutoAttendant(@RequestBody AutoAttendantModel data) {
        RequestResponse returnValue = this.autoAttendantService.createAutoAttendant(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/update"})
    public ResponseEntity<RequestResponse> updateAttendant(@RequestBody IVRTree data) {
        RequestResponse returnValue = this.autoAttendantService.updateAutoAttendant(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @GetMapping(value={"/ivrDetails/{ivrGroup}"})
    public ResponseEntity<RequestResponse> getIVRData(@PathVariable(value="ivrGroup") String ivrGroup) {
        RequestResponse returnValue = this.autoAttendantService.getIVRGroup(ivrGroup);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/list"})
    public ResponseEntity<RequestResponse> getSimpleList() {
        RequestResponse returnValue = this.autoAttendantService.getSimpleList();
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/fileList"})
    public ResponseEntity<RequestResponse> getFileList() {
        RequestResponse returnValue = this.autoAttendantService.getFileList();
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/{folderName}/uploadFile"})
    public ResponseEntity<RequestResponse> uploadFile(@RequestParam(value="file") MultipartFile file, @PathVariable(value="folderName") String folderName) {
        RequestResponse returnValue = this.autoAttendantService.fileUpload(file, folderName);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/listAll"})
    public ResponseEntity<RequestResponse> getDropdownList() {
        RequestResponse returnValue = this.autoAttendantService.getDropdownList();
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }
}

