/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.coralApps.main.service;

import com.coraltele.db.coralapps.callcenter.entity.Queue;
import com.coraltele.db.coralapps.callcenter.repository.QueueRepository;
import com.coraltele.db.coralapps.main.entity.Agent;
import com.coraltele.db.coralapps.main.entity.OperatorTiers;
import com.coraltele.db.coralapps.main.entity.Tiers;
import com.coraltele.db.coralapps.main.repository.AgentRepository;
import com.coraltele.db.coralapps.main.repository.MemberRepository;
import com.coraltele.db.coralapps.main.repository.OperatorTiersRepository;
import com.coraltele.db.coralapps.main.repository.TiersRepository;
import com.coraltele.db.coralapps.main.specification.TiersSpecification;
import com.coraltele.db.users.main.entity.User;
import com.coraltele.db.users.main.repository.UserRepository;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.coralApps.main.model.AgentTiersQueueModel;
import com.coraltele.service.coralApps.main.model.TiersModel;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class TiersService {
    private static final Logger logger = LogManager.getLogger(TiersService.class);
    @Autowired
    TiersRepository tiersRepository;
    @Autowired
    AgentRepository agentRepository;
    @Autowired
    QueueRepository queueRepository;
    @Autowired
    MemberRepository memberRepository;
    @Autowired
    UserRepository userRepository;
    @Autowired
    OperatorTiersRepository operatorTiersRepository;

    public RequestResponse deleteTiersAgent(String agent) {
        RequestResponse returnValue = new RequestResponse();
        List tiers = this.tiersRepository.findByAgent(agent);
        try {
            if (tiers != null && !tiers.isEmpty()) {
                this.tiersRepository.deleteAll((Iterable)tiers);
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("deleted");
                returnValue.setMessageDetail("Record deleted successfully");
                logger.info(returnValue.getMessage());
            } else {
                returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                returnValue.setMessage("not found");
                returnValue.setMessageDetail("Records not found");
                logger.info(returnValue.getMessage());
            }
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.UNKNOWN_ERROR);
            returnValue.setMessage("Unable to delete user");
            returnValue.setMessageDetail("please Contact to administrator");
            logger.info(returnValue.getMessage());
        }
        return returnValue;
    }

    public RequestResponse updateTier(TiersModel data) {
        RequestResponse returnValue = new RequestResponse();
        Optional tiersData = this.tiersRepository.findById(data.getId());
        if (tiersData.isPresent()) {
            Optional existingTiersWithAgent = this.tiersRepository.findByQueueAndAgent(((Tiers)tiersData.get()).getQueue(), data.getAgent());
            if (existingTiersWithAgent.isPresent()) {
                returnValue.setStatus(Constants.Error.BAD_CREDENTIAL);
                returnValue.setMessage("Agent already assigned to the queue");
                returnValue.setMessageDetail("Please choose a different agent");
                return returnValue;
            }
            Tiers tiers = (Tiers)tiersData.get();
            if (data.getLevel() != null) {
                tiers.setLevel(data.getLevel());
            }
            if (data.getPosition() != null) {
                tiers.setPosition(data.getPosition());
            }
            if (data.getAgent() != null) {
                tiers.setAgent(data.getAgent());
            }
            if (data.getState() != null) {
                tiers.setState(data.getState());
            }
            this.tiersRepository.save((Object)tiers);
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Updated");
        returnValue.setMessageDetail("category Updated successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse createDataInTiers(TiersModel data) {
        logger.debug("Create new Tiers : {} ", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        try {
            Optional existingTiersWithAgent = this.tiersRepository.findByQueueAndAgent(data.getQueue(), data.getAgent());
            if (existingTiersWithAgent.isPresent()) {
                returnValue.setStatus(Constants.Error.BAD_CREDENTIAL);
                returnValue.setMessage("Agent already assigned to the queue");
                returnValue.setMessageDetail("Please choose a different agent or queue.");
                logger.warn(returnValue.getMessageDetail());
                return returnValue;
            }
            Tiers tiers = new Tiers();
            tiers.setAgent(data.getAgent());
            if (data.getLevel() != null) {
                tiers.setLevel(data.getLevel());
            } else {
                tiers.setLevel(Integer.valueOf(1));
            }
            if (data.getPosition() != null) {
                tiers.setPosition(data.getPosition());
            } else {
                tiers.setPosition(Integer.valueOf(1));
            }
            tiers.setQueue(data.getQueue());
            tiers.setState(data.getState());
            this.tiersRepository.save((Object)tiers);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("OK");
            returnValue.setMessageDetail("Tiers Created Successfully");
            logger.info(returnValue.getMessage());
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.BAD_CREDENTIAL);
            returnValue.setMessage("Unable To Create Tiers");
            returnValue.setMessageDetail("Contact with administrator");
            logger.error(returnValue.getMessageDetail(), (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse getAllByFilter(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = TiersSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.getSortDirection().equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "id" : searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.getSortDirection().equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "id" : searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.tiersRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.tiersRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)this.entityToModelConversion(page.getContent()));
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public List<TiersModel> entityToModelConversion(List<Tiers> tiers) {
        ArrayList<TiersModel> addValue = new ArrayList<TiersModel>();
        for (Tiers row : tiers) {
            TiersModel data = new TiersModel();
            Optional agent = this.agentRepository.findByName(row.getAgent());
            String agentFullName = ((Agent)agent.get()).getAgentFullName();
            if (agentFullName != null && !agentFullName.isEmpty()) {
                data.setAgent(((Agent)agent.get()).getName() + "-" + agentFullName);
            } else {
                data.setAgent(((Agent)agent.get()).getName() + "-");
            }
            Optional queue = this.queueRepository.findBySystemName(row.getQueue());
            if (queue.isPresent()) {
                data.setQueue(((Queue)queue.get()).getDescription());
            }
            data.setId(row.getId());
            data.setLevel(row.getLevel());
            data.setPosition(row.getPosition());
            data.setState(row.getState());
            addValue.add(data);
        }
        return addValue;
    }

    public RequestResponse deleteTiersById(InputIdModel data) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList addValue = new ArrayList();
        for (Integer ids : data.getIntId()) {
            Optional tiers = this.tiersRepository.findById(Integer.valueOf(ids));
            if (tiers.isPresent()) {
                addValue.add(tiers.get());
                this.tiersRepository.deleteAll(addValue);
                continue;
            }
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Records not found ");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setMessageDetail("Records Deleted Successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse swapOrUpdate(TiersModel data) {
        RequestResponse returnValue = new RequestResponse();
        List positionList = this.tiersRepository.findByQueue(data.getQueue());
        HashMap<Integer, Integer> idWithPosition = new HashMap<Integer, Integer>();
        ArrayList<Integer> existingPositions = new ArrayList<Integer>();
        if (positionList != null && !positionList.isEmpty()) {
            for (Tiers tiers : positionList) {
                idWithPosition.put(tiers.getId(), tiers.getPosition());
                existingPositions.add(tiers.getPosition());
            }
            if (existingPositions.contains(data.getPosition())) {
                Integer oldTierId = this.getKeyByValue(idWithPosition, data.getPosition());
                if (oldTierId != null) {
                    Optional optional = this.tiersRepository.findById(oldTierId);
                    Optional currentId = this.tiersRepository.findById(data.getId());
                    if (optional.isPresent() && currentId.isPresent()) {
                        ((Tiers)optional.get()).setPosition(((Tiers)currentId.get()).getPosition());
                        this.tiersRepository.save(optional.get());
                        ((Tiers)currentId.get()).setPosition(data.getPosition());
                        this.tiersRepository.save(currentId.get());
                    }
                    logger.info("old queue position swapped with new queue:{},{}", (Object)data.getPosition(), idWithPosition.get(data.getPosition()));
                    returnValue.setStatus(Constants.Error.OK);
                    returnValue.setMessage("Position swapped successfully");
                }
            } else {
                Optional assignedNewPosition = this.tiersRepository.findById(data.getId());
                if (assignedNewPosition.isPresent()) {
                    ((Tiers)assignedNewPosition.get()).setPosition(data.getPosition());
                    this.tiersRepository.save(assignedNewPosition.get());
                }
                logger.info("new position updated:{}", (Object)data.getPosition());
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("Position updated successfully");
            }
            for (Map.Entry entry : idWithPosition.entrySet()) {
                Tiers tierToUpdate;
                if (((Integer)entry.getKey()).equals(data.getId()) || (tierToUpdate = (Tiers)this.tiersRepository.findById((Integer)entry.getKey()).orElse(null)) == null) continue;
                int newPosition = ((Integer)entry.getValue()).equals(data.getPosition()) ? ((Integer)idWithPosition.get(data.getId())).intValue() : ((Integer)entry.getValue()).intValue();
                tierToUpdate.setPosition(Integer.valueOf(newPosition));
                this.tiersRepository.save((Object)tierToUpdate);
            }
        } else {
            logger.error("Selected queue not exist", (Object)data.getQueue());
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Data not exist");
        }
        return returnValue;
    }

    public Integer getKeyByValue(Map<Integer, Integer> map, Integer value) {
        for (Map.Entry<Integer, Integer> entry : map.entrySet()) {
            if (!Objects.equals(value, entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    public RequestResponse getWhatsAppQueueAgentList() {
        RequestResponse returnValue = new RequestResponse();
        ArrayList<AgentTiersQueueModel> addValue = new ArrayList<AgentTiersQueueModel>();
        List whatsAppQueueList = this.queueRepository.findByAcdType(Integer.valueOf(3));
        if (!whatsAppQueueList.isEmpty()) {
            for (Queue queue : whatsAppQueueList) {
                List tiers = this.tiersRepository.findByQueue(queue.getSystemName());
                if (tiers.isEmpty()) continue;
                for (Tiers tier : tiers) {
                    Optional agent = this.agentRepository.findByName(tier.getAgent());
                    if (!agent.isPresent()) continue;
                    AgentTiersQueueModel agentUserModel = new AgentTiersQueueModel();
                    agentUserModel.setAgentFullName(((Agent)agent.get()).getAgentFullName());
                    agentUserModel.setName(((Agent)agent.get()).getName());
                    agentUserModel.setQueue(tier.getQueue());
                    agentUserModel.setId(tier.getId());
                    agentUserModel.setPosition(tier.getPosition());
                    addValue.add(agentUserModel);
                }
            }
        }
        if (!addValue.isEmpty()) {
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("list of queue with agent");
            returnValue.setMessageDetail("records fetched successfully");
            returnValue.setData(addValue);
        } else {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Data not found");
            returnValue.setMessageDetail("Not any whatsApp queue present");
            logger.error(returnValue.getMessage());
        }
        return returnValue;
    }

    public List<String> getAgentListByQueueId(Integer queue) {
        List agents;
        ArrayList<String> agentList = new ArrayList<String>();
        Optional queueData = this.queueRepository.findById(queue);
        if (queueData.isPresent() && !(agents = this.tiersRepository.findByQueue(((Queue)queueData.get()).getSystemName())).isEmpty()) {
            for (Tiers data : agents) {
                agentList.add(data.getAgent());
            }
            return agentList;
        }
        logger.error("Invalid queue selected for TL Association");
        return Collections.emptyList();
    }

    public RequestResponse getCountOfAgent(Principal principal) {
        RequestResponse returnValue = new RequestResponse();
        try {
            Optional userOptional = this.userRepository.findByUsername(principal.getName());
            if (!userOptional.isPresent()) {
                HashMap<String, Integer> result = new HashMap<String, Integer>();
                result.put("count", 0);
                result.put("AS", 0);
                result.put("AV", 0);
                result.put("AT", 0);
                result.put("AR", 0);
                result.put("AB", 0);
                returnValue.setData(result);
                returnValue.setStatus(Constants.Error.BAD_CREDENTIAL);
                returnValue.setMessage("User not found");
                returnValue.setMessageDetail(null);
                return returnValue;
            }
            User user = (User)userOptional.get();
            List list = this.operatorTiersRepository.findByAgent(user.getContactNo());
            HashSet<String> processedQueues = new HashSet<String>();
            long totalCount = 0L;
            long countAS = 0L;
            long countAV = 0L;
            long countAT = 0L;
            long countAR = 0L;
            long countAB = 0L;
            for (OperatorTiers row : list) {
                String queue;
                String string = queue = row.getQueue() != null ? row.getQueue().trim() : null;
                if (processedQueues.contains(queue)) continue;
                logger.info("Checking queue: {}", (Object)queue);
                List members = this.memberRepository.findByQueue(queue);
                if (members == null || members.isEmpty()) continue;
                members.stream().filter(Objects::nonNull).forEach(m -> {
                    if (m.getQueue() != null) {
                        m.setQueue(m.getQueue().trim());
                    }
                });
                long matching = members.stream().filter(Objects::nonNull).filter(m -> m.getState() != null && !m.getState().trim().equalsIgnoreCase("Answered")).filter(m -> !m.getState().trim().equalsIgnoreCase("Abandoned")).filter(m -> !m.getState().trim().equalsIgnoreCase("Trying")).count();
                logger.info("Members for queue {} => {} (matching={}, member.getState())", (Object)queue, (Object)members.size(), (Object)matching);
                if (matching <= 0L) continue;
                totalCount += matching;
                if (queue.endsWith("_AS")) {
                    countAS += matching;
                } else if (queue.endsWith("_AV")) {
                    countAV += matching;
                } else if (queue.endsWith("_AT")) {
                    countAT += matching;
                } else if (queue.contains("_AR")) {
                    countAR += matching;
                } else if (queue.contains("_AB")) {
                    countAB += matching;
                }
                processedQueues.add(queue);
            }
            HashMap<String, Long> result = new HashMap<String, Long>();
            result.put("count", totalCount);
            result.put("AS", countAS);
            result.put("AV", countAV);
            result.put("AT", countAT);
            result.put("AR", countAR);
            result.put("AB", countAB);
            returnValue.setData(result);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("OK");
            returnValue.setMessageDetail("Records Fetched Successfully");
        }
        catch (Exception e) {
            HashMap<String, Integer> result = new HashMap<String, Integer>();
            result.put("count", 0);
            result.put("AS", 0);
            result.put("AV", 0);
            result.put("AT", 0);
            result.put("AR", 0);
            result.put("AB", 0);
            returnValue.setData(result);
            returnValue.setStatus(Constants.Error.BAD_CREDENTIAL);
            returnValue.setMessage("Unable To Fecth Records");
            returnValue.setMessageDetail(null);
            logger.error("Error in getCountOfAgent", (Throwable)e);
        }
        return returnValue;
    }
}

