/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.billing.log.controller;

import com.coraltele.db.billing.main.entity.view.ViewChannels;
import com.coraltele.db.billing.main.entity.view.ViewChannelsV1;
import com.coraltele.db.billing.main.repository.ViewChannelRepositoryV1;
import com.coraltele.db.billing.main.repository.ViewChannelsRepository;
import com.coraltele.db.billing.main.specification.ViewChannelSpecificationV1;
import com.coraltele.db.billing.main.specification.ViewChannelsSpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.DateFormatUtility;
import com.coraltele.helper.DownloadPdfService;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.SearchRequest;
import com.coraltele.service.background.DynamicPdfThreadService;
import com.coraltele.service.billing.log.service.BillingPdfService;
import com.coraltele.service.billing.log.service.ViewChannelService;
import com.coraltele.service.complaint.complaintDetail.controller.ComplaintDetailController;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/*
 * Exception performing whole class analysis ignored.
 */
@RequestMapping(value={"/api/v2/viewChannels"})
@RestController
public class ViewChannelController {
    private static final Logger logger = LogManager.getLogger(ComplaintDetailController.class);
    @Autowired
    private ViewChannelService service;
    @Autowired
    BillingPdfService pdfGenerator;
    @Autowired
    DownloadPdfService pdfDownloadService;
    @Autowired
    private DynamicPdfThreadService dynamicReportThreadServiceTest;
    @Autowired
    ViewChannelsRepository repository;
    @Autowired
    ViewChannelRepositoryV1 repositoryV1;
    @Autowired
    DateFormatUtility dateFormatUtility;
    private static final ConcurrentHashMap<String, String> columnMappings = new ConcurrentHashMap();

    @PostMapping(value={"/list/billing"})
    public ResponseEntity<RequestResponse> getAllBilling(@RequestBody SearchRequest searchRequest) {
        RequestResponse returnValue = this.service.getBillingRecords(searchRequest);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/generateAndDownloadPdf"})
    public CompletableFuture<ResponseEntity<?>> generateAndDownloadPdf(@RequestParam String reportType, @RequestBody SearchRequest searchRequestData, Principal principal) {
        String folderPath = "/tmp/";
        String fileNamePrefix = reportType + "_";
        String reportType1 = "";
        File folder = new File(folderPath);
        File[] files = folder.listFiles((dir, name) -> name.startsWith(fileNamePrefix));
        if (files != null) {
            for (File file : files) {
                if (file.delete()) {
                    logger.info("Deleted existing report: {}" + file.getName());
                    continue;
                }
                logger.error("Failed to delete existing report: {}" + file.getName());
            }
        }
        String filePath = "/tmp/" + reportType + "_" + System.currentTimeMillis() + ".pdf";
        String id = UUID.randomUUID().toString();
        reportType1 = ViewChannelService.getTraceCall() ? "billingPdfV1" : reportType;
        CompletableFuture generationFuture = this.dynamicReportThreadServiceTest.startGeneratingReportAsync(reportType1, id, searchRequestData, filePath, principal);
        return generationFuture.thenApply(response -> {
            if (response.getStatus().equals((Object)Constants.Error.OK)) {
                ResponseEntity downloadResponse = this.pdfDownloadService.getPdfFile(filePath);
                if (downloadResponse.getStatusCode().is2xxSuccessful()) {
                    return ResponseEntity.ok().body(downloadResponse.getBody());
                }
                return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("Failed to download PDF. Reason: " + downloadResponse.getStatusCode()));
            }
            return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body(response);
        });
    }

    @PostMapping(value={"/downloadCSV"})
    public ResponseEntity<byte[]> downloadFilteredDataToCSV(@RequestBody SearchRequest searchRequestData) {
        try {
            logger.info("CSV file download started for billing--");
            Specification filters = ViewChannelsSpecification.generateFilters((SearchRequest)searchRequestData);
            Specification filter1 = ViewChannelSpecificationV1.generateFilters((SearchRequest)searchRequestData);
            Sort sort = null;
            if (searchRequestData.sortDirection.equals("asc")) {
                sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).ascending();
            } else if (searchRequestData.sortDirection.equals("desc")) {
                sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).descending();
            }
            List filteredData = new ArrayList();
            List filteredData1 = new ArrayList();
            if (sort != null) {
                if (ViewChannelService.getTraceCall()) {
                    filteredData1 = this.repositoryV1.findAll(filter1, sort);
                } else {
                    filteredData = this.repository.findAll(filters, sort);
                }
            } else if (ViewChannelService.getTraceCall()) {
                filteredData1 = this.repositoryV1.findAll(filter1);
            } else {
                filteredData = this.repository.findAll(filters);
            }
            StringWriter stringWriter = new StringWriter();
            try (CSVPrinter csvPrinter = new CSVPrinter((Appendable)stringWriter, CSVFormat.DEFAULT);){
                logger.info("Original column names: " + searchRequestData.getColumnNames());
                List<Object> displayNames = new ArrayList();
                displayNames = ViewChannelService.getTraceCall() ? searchRequestData.getColumnNames().stream().map(columnName -> ViewChannelController.getDynamicColumnMappings().getOrDefault(columnName, columnName)).collect(Collectors.toList()) : searchRequestData.getColumnNames().stream().map(columnName -> columnMappings.getOrDefault(columnName, columnName)).collect(Collectors.toList());
                logger.info("Display names: " + displayNames);
                csvPrinter.printRecord(displayNames);
                if (ViewChannelService.getTraceCall()) {
                    for (ViewChannelsV1 item : filteredData1) {
                        ArrayList<Object> values = new ArrayList<Object>();
                        for (String selectedColumn : searchRequestData.getColumnNames()) {
                            values.add(this.getColumnValue1(item, selectedColumn));
                        }
                        csvPrinter.printRecord(values);
                    }
                } else {
                    for (ViewChannels item : filteredData) {
                        ArrayList<Object> values = new ArrayList<Object>();
                        for (String selectedColumn : searchRequestData.getColumnNames()) {
                            values.add(this.getColumnValue(item, selectedColumn));
                        }
                        csvPrinter.printRecord(values);
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                logger.error("Error while traversing data for billing cdr", (Object)e.getMessage());
            }
            String csvContent = stringWriter.toString();
            byte[] csvBytes = csvContent.getBytes(StandardCharsets.UTF_8);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
            headers.setContentDispositionFormData("attachment", "filtered_data.csv");
            logger.info("CSV data download successfully.");
            return new ResponseEntity((Object)csvBytes, (MultiValueMap)headers, HttpStatus.OK);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error while downloading billing CSV file!", (Object)e.getMessage());
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }

    private Object getColumnValue(ViewChannels item, String columnName) {
        switch (columnName) {
            case "uuid": {
                return this.checkNull((Object)item.getUuid());
            }
            case "callerIdNumber": {
                return this.checkNull((Object)item.getCallerIdNumber());
            }
            case "callerIdName": {
                return this.checkNull((Object)item.getCallerIdName());
            }
            case "didNumber": {
                return this.checkNull((Object)item.getDidNumber());
            }
            case "dodNumber": {
                return this.checkNull((Object)item.getDodNumber());
            }
            case "direction": {
                return this.checkNull((Object)item.getDirection());
            }
            case "destinationNumber": {
                return this.checkNull((Object)item.getDestinationNumber());
            }
            case "startStamp": {
                return this.checkNull((Object)DateFormatUtility.dateAndTimeFormatterForSeconds((LocalDateTime)item.getStartStamp()));
            }
            case "answerStamp": {
                return this.checkNull((Object)DateFormatUtility.dateAndTimeFormatterForSeconds((LocalDateTime)item.getAnswerStamp()));
            }
            case "endStamp": {
                return this.checkNull((Object)DateFormatUtility.dateAndTimeFormatterForSeconds((LocalDateTime)item.getEndStamp()));
            }
            case "billSec": {
                return this.checkNull((Object)item.getBillSec());
            }
            case "formattedDuration": {
                return this.checkNull((Object)item.getFormattedDuration());
            }
            case "callType": {
                return this.checkNull((Object)item.getCallType());
            }
            case "pulse": {
                return this.checkNull((Object)item.getPulse());
            }
            case "callCost": {
                return this.checkNull((Object)item.getCallCost());
            }
            case "billingUuid": {
                return this.checkNull((Object)item.getBillingUuid());
            }
            case "status": {
                return this.checkNull((Object)item.getStatus());
            }
            case "mos": {
                if (item.getMos().compareTo(BigDecimal.valueOf(0.0)) == 0) {
                    return 4.3;
                }
                return item.getMos();
            }
            case "rtpJitterMinVariance": {
                return this.checkNull((Object)item.getRtpJitterMinVariance());
            }
            case "rtpJitterMaxVariance": {
                return this.checkNull((Object)item.getRtpJitterMaxVariance());
            }
            case "rtpJitterLossRate": {
                return this.checkNull((Object)item.getRtpJitterLossRate());
            }
            case "destinationName": {
                return this.checkNull((Object)item.getDestinationName());
            }
        }
        return null;
    }

    private Object getColumnValue1(ViewChannelsV1 item, String columnName) {
        switch (columnName) {
            case "uuid": {
                return this.checkNull((Object)item.getUuid());
            }
            case "callerIdNumber": {
                return this.checkNull((Object)item.getCallerIdNumber());
            }
            case "callerIdName": {
                return this.checkNull((Object)item.getCallerIdName());
            }
            case "didNumber": {
                return this.checkNull((Object)item.getDidNumber());
            }
            case "dodNumber": {
                return this.checkNull((Object)item.getDodNumber());
            }
            case "direction": {
                return this.checkNull((Object)item.getDirection());
            }
            case "destinationNumber": {
                return this.checkNull((Object)item.getDestinationNumber());
            }
            case "startStamp": {
                return this.checkNull((Object)DateFormatUtility.dateAndTimeFormatterForSeconds((LocalDateTime)item.getStartStamp()));
            }
            case "answerStamp": {
                return this.checkNull((Object)DateFormatUtility.dateAndTimeFormatterForSeconds((LocalDateTime)item.getAnswerStamp()));
            }
            case "endStamp": {
                return this.checkNull((Object)DateFormatUtility.dateAndTimeFormatterForSeconds((LocalDateTime)item.getEndStamp()));
            }
            case "billSec": {
                return this.checkNull((Object)item.getBillSec());
            }
            case "formattedDuration": {
                return this.checkNull((Object)item.getFormattedDuration());
            }
            case "callType": {
                return this.checkNull((Object)item.getCallType());
            }
            case "pulse": {
                return this.checkNull((Object)item.getPulse());
            }
            case "callCost": {
                return this.checkNull((Object)item.getCallCost());
            }
            case "billingUuid": {
                return this.checkNull((Object)item.getBillingUuid());
            }
            case "status": {
                return this.checkNull((Object)item.getStatus());
            }
            case "mos": {
                if (item.getMos().compareTo(BigDecimal.valueOf(0.0)) == 0) {
                    return 4.3;
                }
                return item.getMos();
            }
            case "callTrace": {
                return this.checkNull((Object)item.getCallTrace());
            }
            case "destinationName": {
                return this.checkNull((Object)item.getDestinationName());
            }
        }
        return null;
    }

    private String checkNull(Object value) {
        return value != null ? value.toString() : "";
    }

    @PostMapping(value={"/listAll"})
    public ResponseEntity<RequestResponse> getAllCallType() {
        RequestResponse returnValue = this.service.getAllCallType();
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/total/billSec"})
    public ResponseEntity<RequestResponse> getBillSecSummation(@RequestBody SearchRequest searchRequest) {
        RequestResponse returnValue = this.service.getBillSecSummation(searchRequest);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    public static Map<String, String> getDynamicColumnMappings() {
        ConcurrentHashMap<String, String> dynamicMappings = new ConcurrentHashMap<String, String>(columnMappings);
        if (!ViewChannelService.getTraceCall()) {
            dynamicMappings.put("callTrace", "Call Trace");
        }
        return dynamicMappings;
    }

    static {
        columnMappings.put("uuid", "Uuid");
        columnMappings.put("callerIdNumber", "Caller Number");
        columnMappings.put("callerIdName", "Caller Name");
        columnMappings.put("didNumber", "Did Number");
        columnMappings.put("dodNumber", "Dod Number");
        columnMappings.put("direction", "Direction");
        columnMappings.put("destinationNumber", "Destination Number");
        columnMappings.put("startStamp", "Start Time");
        columnMappings.put("answerStamp", "Answer Time");
        columnMappings.put("endStamp", "End Time");
        columnMappings.put("billSec", "TalkTime");
        columnMappings.put("formattedDuration", "Duration (HH:MM:SS)");
        columnMappings.put("callType", "Call Type");
        columnMappings.put("pulse", "Pulse");
        columnMappings.put("callCost", "Call Cost");
        columnMappings.put("billingUuid", "Billing Uuid");
        columnMappings.put("mos", "MOS");
        columnMappings.put("status", "Status");
        columnMappings.put("destinationName", "Destination Name");
    }
}

