/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.archiving.billingCdrHistorical.controller;

import com.coraltele.helper.BackupRestoreHelper;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.mvc.method.annotation.StreamingResponseBody;

@RestController
@RequestMapping(value={"/api/v2/node-control"})
public class NodeControlController {
    private static final Logger logger = LogManager.getLogger(NodeControlController.class);
    @Autowired
    private BackupRestoreHelper backupRestoreHelper;

    @PostMapping(value={"/backup/system/configuration"})
    public ResponseEntity<RequestResponse> backupDatabasesConfiguration() {
        logger.info("Received request to backup databases for configuration");
        try {
            RequestResponse result = this.backupRestoreHelper.backupDatabases(false);
            if (Constants.Error.OK.equals((Object)result.getStatus())) {
                logger.info("Database backup completed successfully: {}", (Object)result.getMessage());
                return ResponseEntity.ok((Object)result);
            }
            logger.error("Database backup failed: {}", (Object)result.getMessage());
            return new ResponseEntity((Object)result, HttpStatus.BAD_REQUEST);
        }
        catch (Exception e) {
            logger.error("Database backup failed with exception", (Throwable)e);
            RequestResponse errorResponse = new RequestResponse();
            errorResponse.setStatus(Constants.Error.ERROR);
            errorResponse.setMessage("Database backup failed: " + e.getMessage());
            return new ResponseEntity((Object)errorResponse, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @PostMapping(value={"/backup/system/with-data"})
    public ResponseEntity<RequestResponse> backupDatabasesFull() {
        logger.info("Received request to backup databases for full data");
        try {
            RequestResponse result = this.backupRestoreHelper.backupDatabases(true);
            if (Constants.Error.OK.equals((Object)result.getStatus())) {
                logger.info("Database backup completed successfully: {}", (Object)result.getMessage());
                return ResponseEntity.ok((Object)result);
            }
            logger.error("Database backup failed: {}", (Object)result.getMessage());
            return new ResponseEntity((Object)result, HttpStatus.BAD_REQUEST);
        }
        catch (Exception e) {
            logger.error("Database backup failed with exception", (Throwable)e);
            RequestResponse errorResponse = new RequestResponse();
            errorResponse.setStatus(Constants.Error.ERROR);
            errorResponse.setMessage("Database backup failed: " + e.getMessage());
            return new ResponseEntity((Object)errorResponse, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @PostMapping(value={"/restore/system/configuration"})
    public ResponseEntity<RequestResponse> restoreDatabases(@RequestParam String archivePath) {
        logger.info("Received request to restore databases from: {}", (Object)archivePath);
        try {
            RequestResponse result = this.backupRestoreHelper.restoreDatabases(archivePath);
            if (Constants.Error.OK.equals((Object)result.getStatus())) {
                logger.info("Database restore completed successfully: {}", (Object)result.getMessage());
                return ResponseEntity.ok((Object)result);
            }
            logger.error("Database restore failed: {}", (Object)result.getMessage());
            return new ResponseEntity((Object)result, HttpStatus.BAD_REQUEST);
        }
        catch (Exception e) {
            logger.error("Database restore failed with exception", (Throwable)e);
            RequestResponse errorResponse = new RequestResponse();
            errorResponse.setStatus(Constants.Error.ERROR);
            errorResponse.setMessage("Database restore failed: " + e.getMessage());
            return new ResponseEntity((Object)errorResponse, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @GetMapping(value={"/backups/system/configuration"})
    public ResponseEntity<RequestResponse> listBackups() {
        logger.info("Received request to list backups");
        try {
            RequestResponse result = this.backupRestoreHelper.listBackups();
            if (Constants.Error.OK.equals((Object)result.getStatus())) {
                logger.info("Successfully retrieved backup list: {}", (Object)result.getMessage());
                return ResponseEntity.ok((Object)result);
            }
            logger.error("Failed to retrieve backup list: {}", (Object)result.getMessage());
            return new ResponseEntity((Object)result, HttpStatus.BAD_REQUEST);
        }
        catch (Exception e) {
            logger.error("Failed to list backups", (Throwable)e);
            RequestResponse errorResponse = new RequestResponse();
            errorResponse.setStatus(Constants.Error.ERROR);
            errorResponse.setMessage("Failed to list backups: " + e.getMessage());
            return new ResponseEntity((Object)errorResponse, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @DeleteMapping(value={"/backup/system/configuration"})
    public ResponseEntity<RequestResponse> deleteBackup(@RequestParam String timestamp) {
        logger.info("Received request to delete backup: {}", (Object)timestamp);
        try {
            RequestResponse result = this.backupRestoreHelper.deleteBackup(timestamp);
            if (Constants.Error.OK.equals((Object)result.getStatus())) {
                logger.info("Successfully deleted backup: {}", (Object)result.getMessage());
                return ResponseEntity.ok((Object)result);
            }
            logger.error("Failed to delete backup: {}", (Object)result.getMessage());
            return new ResponseEntity((Object)result, HttpStatus.BAD_REQUEST);
        }
        catch (Exception e) {
            logger.error("Failed to delete backup", (Throwable)e);
            RequestResponse errorResponse = new RequestResponse();
            errorResponse.setStatus(Constants.Error.ERROR);
            errorResponse.setMessage("Failed to delete backup: " + e.getMessage());
            return new ResponseEntity((Object)errorResponse, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @GetMapping(value={"/backup/system/configuration/download"})
    public ResponseEntity<StreamingResponseBody> downloadBackup(@RequestParam String timestamp) {
        logger.info("Received request to download backup for timestamp: {}", (Object)timestamp);
        try {
            File backupFile = this.backupRestoreHelper.getBackupFile(timestamp);
            if (backupFile == null || !backupFile.exists() || !backupFile.isFile()) {
                logger.error("Requested backup not found for timestamp: {}", (Object)timestamp);
                RequestResponse notFound = new RequestResponse();
                notFound.setStatus(Constants.Error.ERROR);
                notFound.setMessage("Backup not found for timestamp: " + timestamp);
                return new ResponseEntity((Object)notFound, HttpStatus.BAD_REQUEST);
            }
            StreamingResponseBody stream = outputStream -> {
                try (FileInputStream inputStream = new FileInputStream(backupFile);){
                    int bytesRead;
                    byte[] buffer = new byte[8192];
                    while ((bytesRead = ((InputStream)inputStream).read(buffer)) != -1) {
                        outputStream.write(buffer, 0, bytesRead);
                    }
                    outputStream.flush();
                }
            };
            return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{"attachment; filename=\"" + backupFile.getName() + "\""})).header("Content-Length", new String[]{String.valueOf(backupFile.length())})).contentType(MediaType.APPLICATION_OCTET_STREAM).body((Object)stream);
        }
        catch (Exception e) {
            logger.error("Failed to download backup for timestamp: {}", (Object)timestamp, (Object)e);
            RequestResponse errorResponse = new RequestResponse();
            errorResponse.setStatus(Constants.Error.ERROR);
            errorResponse.setMessage("Failed to download backup: " + e.getMessage());
            return new ResponseEntity((Object)errorResponse, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
}

