/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.db.users.main.entity;

import com.coraltele.db.users.main.entity.Role;
import com.coraltele.db.users.main.entity.User;
import com.coraltele.helper.UuidUpdatable;
import com.coraltele.helper.UuidUpdateListener;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.time.LocalDateTime;
import java.util.UUID;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.PrePersist;
import javax.persistence.Table;
import lombok.Generated;

@Entity
@Table(name="m_userrole")
@EntityListeners(value={UuidUpdateListener.class})
public class UserRole
implements UuidUpdatable {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Integer id;
    @Column(name="createdon", columnDefinition="TIMESTAMP DEFAULT CURRENT_TIMESTAMP", nullable=true)
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    LocalDateTime createdOn;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="\"user\"")
    private User user = new User();
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="role")
    private Role role = new Role();
    @Column(name="createdby")
    private String createdBy;
    @Column(name="updatedon", columnDefinition="TIMESTAMP DEFAULT CURRENT_TIMESTAMP", nullable=true)
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private LocalDateTime updatedOn;
    @Column(name="updatedby", nullable=true, columnDefinition="bigint default 0")
    private Long updatedBy;
    @Column(name="menugroup")
    private String menuGroup;
    private String uuid;

    @PrePersist
    public void setValues() {
        if (this.uuid == null) {
            this.uuid = UUID.randomUUID().toString();
        }
        if (this.createdOn == null) {
            this.createdOn = LocalDateTime.now();
        }
        if (this.updatedOn == null) {
            this.updatedOn = LocalDateTime.now();
        }
        if (this.updatedBy == null) {
            this.updatedBy = 0L;
        }
    }

    @Generated
    public Integer getId() {
        return this.id;
    }

    @Generated
    public LocalDateTime getCreatedOn() {
        return this.createdOn;
    }

    @Generated
    public User getUser() {
        return this.user;
    }

    @Generated
    public Role getRole() {
        return this.role;
    }

    @Generated
    public String getCreatedBy() {
        return this.createdBy;
    }

    @Generated
    public LocalDateTime getUpdatedOn() {
        return this.updatedOn;
    }

    @Generated
    public Long getUpdatedBy() {
        return this.updatedBy;
    }

    @Generated
    public String getMenuGroup() {
        return this.menuGroup;
    }

    @Generated
    public String getUuid() {
        return this.uuid;
    }

    @Generated
    public void setId(Integer id) {
        this.id = id;
    }

    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Generated
    public void setCreatedOn(LocalDateTime createdOn) {
        this.createdOn = createdOn;
    }

    @Generated
    public void setUser(User user) {
        this.user = user;
    }

    @Generated
    public void setRole(Role role) {
        this.role = role;
    }

    @Generated
    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Generated
    public void setUpdatedOn(LocalDateTime updatedOn) {
        this.updatedOn = updatedOn;
    }

    @Generated
    public void setUpdatedBy(Long updatedBy) {
        this.updatedBy = updatedBy;
    }

    @Generated
    public void setMenuGroup(String menuGroup) {
        this.menuGroup = menuGroup;
    }

    @Generated
    public void setUuid(String uuid) {
        this.uuid = uuid;
    }
}

