/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.config;

import com.coraltele.config.StompConnectChannelInterceptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.messaging.simp.config.ChannelRegistration;
import org.springframework.messaging.simp.config.MessageBrokerRegistry;
import org.springframework.messaging.support.ChannelInterceptor;
import org.springframework.web.socket.config.annotation.EnableWebSocketMessageBroker;
import org.springframework.web.socket.config.annotation.StompEndpointRegistry;
import org.springframework.web.socket.config.annotation.WebSocketMessageBrokerConfigurer;

@Configuration
@EnableWebSocketMessageBroker
public class WebSocketConfig
implements WebSocketMessageBrokerConfigurer {
    @Autowired
    StompConnectChannelInterceptor stompConnectChannelInterceptor;

    public void configureClientInboundChannel(ChannelRegistration registration) {
        registration.interceptors(new ChannelInterceptor[]{this.stompConnectChannelInterceptor});
    }

    public void configureMessageBroker(MessageBrokerRegistry config) {
        config.enableSimpleBroker(new String[]{"/app/v2/messaging/topic"});
        config.setApplicationDestinationPrefixes(new String[]{"/app/v2/messaging/app"});
    }

    public void registerStompEndpoints(StompEndpointRegistry registry) {
        registry.addEndpoint(new String[]{"/app/v2/messaging/messages"}).setAllowedOriginPatterns(new String[]{"*"});
        registry.addEndpoint(new String[]{"/app/v2/messaging/messages"}).setAllowedOriginPatterns(new String[]{"*"}).withSockJS();
    }
}

