/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.uc.controller;

import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.service.uc.model.CustomerAccountServiceCode;
import com.coraltele.service.uc.model.UserStatusModel;
import com.coraltele.service.uc.model.search.CustomerAccountSearchRequest;
import com.coraltele.service.uc.service.CustomerAccountService;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.security.Principal;
import java.text.MessageFormat;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/v2/customerAccount"})
@RestController
public class CustomerAccountController {
    private static final Logger logger = LogManager.getLogger(CustomerAccountController.class);
    private static final String CONTROLLER_NAME = "Customer Account";
    @Autowired
    CustomerAccountService customerAccountService;

    @PostMapping(value={"/update"})
    public ResponseEntity<RequestResponse> updateCustomerAccount(@RequestBody CustomerAccountServiceCode data, Principal authentication) throws IOException {
        RequestResponse returnValue = this.customerAccountService.updateNew(data, authentication);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/list"})
    public ResponseEntity<RequestResponse> getAllCustomerAccount(Authentication authentication, @RequestBody CustomerAccountSearchRequest data) {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            String dataReceived = objectMapper.writeValueAsString((Object)data);
            String message = MessageFormat.format("{1} received for listing : {0}", CONTROLLER_NAME, dataReceived);
            logger.info(message);
            RequestResponse returnValue = this.customerAccountService.getList(data, authentication);
            if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
                message = MessageFormat.format("{1} data processed successfully for listing : {0}", CONTROLLER_NAME, dataReceived);
                logger.info(message);
                return ResponseEntity.ok((Object)returnValue);
            }
            message = MessageFormat.format("{1} unable to process data for listing: {0}", CONTROLLER_NAME, dataReceived);
            logger.info(message);
            return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
        }
        catch (JsonProcessingException e) {
            RequestResponse returnValue = new RequestResponse();
            returnValue.setStatus(Constants.Error.UNKNOWN_ERROR);
            returnValue.setMessage("Invalid json data");
            return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
        }
    }

    @PostMapping(value={"/"})
    public ResponseEntity<RequestResponse> getByLoggedInUSer(Authentication authentication) {
        RequestResponse returnValue = this.customerAccountService.getByLoggedInUser(authentication.getName());
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/status"})
    public ResponseEntity<RequestResponse> getUserStatus(Authentication authentication) {
        RequestResponse returnValue = this.customerAccountService.userExist(authentication);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/update/userStatus"})
    public ResponseEntity<RequestResponse> updateUserStatus(@RequestBody UserStatusModel data) {
        RequestResponse returnValue = this.customerAccountService.updateUserStatus(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }
}

