/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.pbx.emailDetail.service;

import com.coraltele.db.telephony.pbx.entity.PredefinedMessages;
import com.coraltele.db.telephony.pbx.repository.PredefinedMessagesRepository;
import com.coraltele.db.telephony.pbx.specification.PredefinedMessagesSpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.pbx.emailDetail.model.PredefinedMessagesModel;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;

@Service
public class PredefinedMessagesServices {
    private static final Logger logger = LogManager.getLogger(PredefinedMessagesServices.class);
    @Autowired
    private PredefinedMessagesRepository predefinedMessagesRepository;

    public RequestResponse createPredefinedMessages(PredefinedMessagesModel model) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        String currentUsername = authentication != null ? authentication.getName() : "";
        RequestResponse response = new RequestResponse();
        PredefinedMessages predefinedMessages = new PredefinedMessages();
        predefinedMessages.setType(model.getType());
        predefinedMessages.setMessageType(model.getMessageType());
        predefinedMessages.setMessageContent(model.getMessageContent());
        predefinedMessages.setCreatedBy(currentUsername);
        predefinedMessages.setCreatedOn(LocalDateTime.now());
        this.predefinedMessagesRepository.save((Object)predefinedMessages);
        response.setStatus(Constants.Error.OK);
        response.setMessage("Predefined message created successfully.");
        return response;
    }

    public RequestResponse updatePredefinedMessages(PredefinedMessagesModel model) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        String currentUsername = authentication != null ? authentication.getName() : "";
        RequestResponse response = new RequestResponse();
        Optional optional = this.predefinedMessagesRepository.findById((Object)model.getId());
        if (!optional.isPresent()) {
            response.setStatus(Constants.Error.ERROR);
            response.setMessage("Predefined message not found with ID: " + model.getId());
            return response;
        }
        PredefinedMessages predefinedMessages = (PredefinedMessages)optional.get();
        predefinedMessages.setType(model.getType());
        predefinedMessages.setMessageType(model.getMessageType());
        predefinedMessages.setMessageContent(model.getMessageContent());
        predefinedMessages.setUpdatedBy(currentUsername);
        predefinedMessages.setUpdatedOn(LocalDateTime.now());
        this.predefinedMessagesRepository.save((Object)predefinedMessages);
        response.setStatus(Constants.Error.OK);
        response.setMessage("Predefined message updated successfully.");
        return response;
    }

    public RequestResponse deletePredefinedMessages(InputIdModel data) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList addValue = new ArrayList();
        for (Integer ids : data.getIntId()) {
            Optional predefinedMessagesOptional = this.predefinedMessagesRepository.findById((Object)ids);
            if (predefinedMessagesOptional.isPresent()) {
                addValue.add(predefinedMessagesOptional.get());
                continue;
            }
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Records not found ");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        this.predefinedMessagesRepository.deleteAll(addValue);
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setMessageDetail("Records Deleted Successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getFilteredList(SearchRequest searchRequest) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = PredefinedMessagesSpecification.generateFilters((SearchRequest)searchRequest);
        Sort sort = null;
        if (searchRequest.getSortDirection().equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequest.getSortBy()}).ascending();
        } else if (searchRequest.getSortDirection().equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequest.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.predefinedMessagesRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequest.getCurrentPage(), (int)(searchRequest.getPageSize() == 0 ? 10 : searchRequest.getPageSize()))) : this.predefinedMessagesRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequest.getCurrentPage(), (int)(searchRequest.getPageSize() == 0 ? 10 : searchRequest.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequest.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequest.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)page.getContent());
        returnValue.setData((Object)responseData);
        returnValue.setMessage("node-cluster list rendered successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getAllPredefinedMessages(String type) {
        RequestResponse response = new RequestResponse();
        List list = new ArrayList();
        list = type != null ? this.predefinedMessagesRepository.findByType(type) : (List)this.predefinedMessagesRepository.findAll();
        if (list.isEmpty()) {
            response.setStatus(Constants.Error.ERROR);
            response.setMessage("No predefined messages found.");
            return response;
        }
        response.setStatus(Constants.Error.OK);
        response.setMessage("Predefined messages fetched successfully.");
        response.setData(list);
        return response;
    }
}

