/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.pbx.conferenceMeeting.conferenceMeetingRoom.service;

import com.coraltele.db.billing.main.entity.PdfReportFilters;
import com.coraltele.db.billing.main.repository.PdfReportRepository;
import com.coraltele.db.telemetry.main.entity.TrainAlert;
import com.coraltele.db.telephony.main.entity.Channels;
import com.coraltele.db.telephony.main.entity.McxParticipant;
import com.coraltele.db.telephony.main.repository.ChannelsRepository;
import com.coraltele.db.telephony.main.repository.McxParticipantRepository;
import com.coraltele.db.telephony.pbx.entity.ConferenceParticipant;
import com.coraltele.db.telephony.pbx.entity.ConferenceRoom;
import com.coraltele.db.telephony.pbx.entity.ConfigureConference;
import com.coraltele.db.telephony.pbx.entity.EmailDetail;
import com.coraltele.db.telephony.pbx.entity.view.ConferenceDetails;
import com.coraltele.db.telephony.pbx.repository.ConferenceBackupViewRepository;
import com.coraltele.db.telephony.pbx.repository.ConferenceDetailsRepository;
import com.coraltele.db.telephony.pbx.repository.ConferenceParticipantRepository;
import com.coraltele.db.telephony.pbx.repository.ConferenceRoomRepository;
import com.coraltele.db.telephony.pbx.repository.ConfigureConferenceRepository;
import com.coraltele.db.telephony.pbx.repository.EmailDetailRepository;
import com.coraltele.db.telephony.pbx.specification.ConferenceBackupViewSpecification;
import com.coraltele.db.telephony.pbx.specification.ConferenceMeetingSpecification;
import com.coraltele.db.telephony.pbx.specification.ConferenceRoomSpecification;
import com.coraltele.db.telephony.uc.entity.view.ConfPhoneBook;
import com.coraltele.db.telephony.uc.repository.ConfPhoneBookRepository;
import com.coraltele.db.users.main.entity.User;
import com.coraltele.db.users.main.repository.UserRepository;
import com.coraltele.helper.BashCmd;
import com.coraltele.helper.Constants;
import com.coraltele.helper.DateFormatUtility;
import com.coraltele.helper.DbUtility;
import com.coraltele.helper.EventDetail;
import com.coraltele.helper.EventNotification;
import com.coraltele.helper.EventNotifyModel;
import com.coraltele.helper.HttpUtils;
import com.coraltele.helper.Messaging;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.pbx.conferenceMeeting.conferenceMeetingRoom.model.ActiveConfModel;
import com.coraltele.service.pbx.conferenceMeeting.conferenceMeetingRoom.model.ConfRecListModel;
import com.coraltele.service.pbx.conferenceMeeting.conferenceMeetingRoom.model.ConfRecProcessModel;
import com.coraltele.service.pbx.conferenceMeeting.conferenceMeetingRoom.model.ConferenceMeetingModel;
import com.coraltele.service.pbx.conferenceMeeting.conferenceMeetingRoom.model.ConferenceRecordingModel;
import com.coraltele.service.pbx.conferenceMeeting.conferenceMeetingRoom.model.ExternalParticipantModel;
import com.coraltele.service.pbx.conferenceMeeting.conferenceMeetingRoom.model.MeetingAddressedModel;
import com.coraltele.service.pbx.conferenceMeeting.conferenceMeetingRoom.model.MeetingAndActiveParticipantModel;
import com.coraltele.service.pbx.conferenceMeeting.conferenceMeetingRoom.model.MeetingDetailModel;
import com.coraltele.service.pbx.conferenceMeeting.conferenceMeetingRoom.model.MeetingStatusUpdateModel;
import com.coraltele.service.pbx.conferenceMeeting.conferenceMeetingRoom.model.MemberListModel;
import com.coraltele.service.pbx.conferenceMeeting.conferenceMeetingRoom.model.ParticipantModel;
import com.coraltele.service.pbx.conferenceMeeting.conferenceMeetingRoom.model.PastMeetingModel;
import com.coraltele.service.pbx.conferenceMeeting.conferenceMeetingRoom.model.RdSOMeetingModel;
import com.coraltele.service.pbx.conferenceMeeting.conferenceMeetingRoom.model.RecBackupModel;
import com.coraltele.service.pbx.extension.service.ExtensionSecondaryService;
import com.coraltele.service.pbx.extension.service.ExtensionsService;
import com.coraltele.service.syncData.service.RestoreByClusterService;
import com.coraltele.service.telemetry.main.trainAlert.service.TrainAlertService;
import com.coraltele.service.user.service.UserService;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.Principal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hibernate.exception.DataException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ConferenceMeetingService {
    private ExecutorService executorService = Executors.newFixedThreadPool(5);
    private static final Logger logger = LogManager.getLogger(ConferenceMeetingService.class);
    @Autowired
    ConferenceDetailsRepository conferenceRoomParticipantRepository;
    @Autowired
    DbUtility db;
    @Autowired
    ConferenceRoomRepository conferenceRoomRepository;
    @Autowired
    ConfigureConferenceRepository configureConferenceRepository;
    @Autowired
    ConferenceParticipantRepository conferenceParticipantRepository;
    @Autowired
    EmailDetailRepository emailDetailsRepository;
    @Autowired
    UserRepository userRepository;
    @Autowired
    UserService userService;
    @Autowired
    BashCmd command;
    @Autowired
    ConfPhoneBookRepository confPhoneBookRepository;
    @Autowired
    ConferenceBackupViewRepository conferenceBackupViewRepository;
    @Autowired
    BashCmd executer;
    @Autowired
    PdfReportRepository pdfReportRepository;
    @Autowired
    DateFormatUtility dateFormatUtility;
    @Autowired
    ChannelsRepository channelsRepository;
    @Autowired
    ExtensionSecondaryService extensionSecondaryService;
    @Autowired
    TrainAlertService trainAlertService;
    @Autowired
    ExtensionsService extensionsService;
    @Autowired
    McxParticipantRepository mcxParticipantRepository;
    @Autowired
    RestoreByClusterService restoreByClusterService;
    @Value(value="${freeSpace.size}")
    private Integer freeSpace;
    private static final String txtFile = "backupFile.txt";
    private static final String backupFilePath = "/mnt/backupfiles/";

    public RequestResponse getListOfMeetings(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        this.db.initializeSequenceForCofigureConference();
        this.db.initializeSequenceForConferenceRoom();
        Specification filters = ConferenceMeetingSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.sortDirection.equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).ascending();
        } else if (searchRequestData.sortDirection.equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).descending();
        }
        Page page = null;
        page = sort == null ? this.conferenceRoomParticipantRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.conferenceRoomParticipantRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)page.getContent());
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public Long generateFourDigitRandom() {
        Random random = new Random();
        int randomValue = random.nextInt(9000) + 1000;
        return Long.parseLong(String.valueOf(randomValue));
    }

    @Transactional(value="switchTransactionManager")
    public RequestResponse createNewConferenceMeeting(ConferenceMeetingModel data, Principal principal) {
        RequestResponse returnValue = new RequestResponse();
        try {
            Optional sameRoomName = this.conferenceRoomRepository.findByRoomName(data.getRoomName());
            if (sameRoomName.isPresent()) {
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("Same meeting name already exist");
                returnValue.setMessageDetail("Select different name for new meeting");
                return returnValue;
            }
            this.db.initializeSequenceForCofigureConference();
            this.db.initializeSequenceForConferenceRoom();
            Integer roomId = this.conferenceRoomRepository.findMaxId() != null ? this.conferenceRoomRepository.findMaxId() + 1 : 1;
            Integer conferenceId = this.configureConferenceRepository.findMaxId() != null ? this.configureConferenceRepository.findMaxId() + 1 : 1;
            String accessCode = String.valueOf(this.generateFourDigitRandom());
            ConferenceRoom confRoom = new ConferenceRoom();
            confRoom.setCreatedBy(principal.getName());
            confRoom.setCreatedOn(LocalDateTime.now());
            confRoom.setDidMapping(data.getDidMapping());
            confRoom.setRoomName(this.replaceRoomNameForCreate(data.getRoomName()));
            confRoom.setBeepInterval(data.getBeepInterval());
            confRoom.setRetryCount(data.getRetryCount());
            confRoom.setFromTime(data.getFromTime());
            confRoom.setToTime(data.getToTime());
            confRoom.setMaxParticipants(data.getMaxParticipants());
            confRoom.setAuthenticationRetry(data.getAuthenticationRetry());
            confRoom.setDetail(data.getDetail());
            confRoom.setActive(Boolean.valueOf(true));
            confRoom.setAuthenticationRetry(Integer.valueOf(1));
            confRoom.setAccessCode(accessCode);
            this.conferenceRoomRepository.save((Object)confRoom);
            ConfigureConference conference = new ConfigureConference();
            conference.setCreatedBy(principal.getName());
            conference.setCreatedOn(LocalDateTime.now());
            conference.setScheduledDate(data.getMeetingScheduledDate());
            conference.setScheduledToDate(data.getScheduledToDate());
            conference.setFromTime(data.getFromTime());
            conference.setToTime(data.getToTime());
            conference.setMainModerator(principal.getName());
            conference.setRoomId(roomId);
            conference.setAccessCode(accessCode);
            conference.setRetryCount(data.getRetryCount());
            conference.setVoiceRecognition(Integer.valueOf(data.getVoiceRecognition() != false ? 1 : 0));
            conference.setPasswordRequired(Integer.valueOf(data.getPasswordRequired() != false ? 1 : 0));
            conference.setNameAnnouncementRequired(Integer.valueOf(data.getNameAnnouncementRequired() != false ? 1 : 0));
            conference.setDialerAssisted(Integer.valueOf("Dial Assisted".equals(data.getMeetingType()) ? 1 : 0));
            conference.setMeetMeConference(Integer.valueOf("Meet Me Conference".equals(data.getMeetingType()) ? 1 : 0));
            conference.setRetryDelay(data.getRetryDelay());
            conference.setRecording(Integer.valueOf(data.getRecording() != false ? 1 : 0));
            conference.setSource("uc");
            conference.setConferenceType("v".equals(data.getConferenceType()) ? "v" : "a");
            conference.setRPtt(Integer.valueOf(data.getRPtt() != false ? 1 : 0));
            conference.setCoralConfGreetingsPath("ivr/conf_" + conferenceId + ".wav");
            conference.setStatus("N");
            conference.setActive(Boolean.valueOf(true));
            conference.setConferenceMode(data.getConferenceMode().equals("C") ? "C" : "I");
            this.configureConferenceRepository.save((Object)conference);
            Optional userData = this.userRepository.findByUsername(principal.getName());
            this.saveParticipant(principal.getName(), (User)userData.get(), accessCode, confRoom.getId(), true, data.getRetryDelay().intValue(), data.getMeetingScheduledDate(), data.getScheduledToDate(), data.getFromTime(), data.getToTime(), data.getAuthenticationRetry(), conferenceId, confRoom.getRoomName());
            for (MemberListModel memberModel : data.getParticipantList()) {
                if (memberModel.getMemberType().equals("U")) {
                    Optional userInfo = this.userRepository.findByUsernameAndContactNo(memberModel.getUsername(), memberModel.getExtension());
                    userInfo.ifPresent(user -> this.saveParticipant(principal.getName(), (User)userInfo.get(), accessCode, confRoom.getId(), false, data.getRetryDelay().intValue(), data.getMeetingScheduledDate(), data.getScheduledToDate(), data.getFromTime(), data.getToTime(), data.getAuthenticationRetry(), conferenceId, confRoom.getRoomName()));
                    continue;
                }
                if (!memberModel.getMemberType().equals("D")) continue;
                Optional directoryData = this.confPhoneBookRepository.findById((Object)memberModel.getId());
                this.saveDirectoryMember(principal.getName(), accessCode, (ConfPhoneBook)directoryData.get(), roomId, conferenceId, data.getRetryDelay(), data.getAuthenticationRetry(), data.getMeetingScheduledDate(), data.getFromTime(), data.getToTime(), data.getScheduledToDate(), confRoom.getRoomName());
            }
            if (!data.getExternalParticipant().isEmpty()) {
                for (ExternalParticipantModel manualUser : data.getExternalParticipant()) {
                    ConferenceParticipant participant = new ConferenceParticipant();
                    participant.setCreatedBy(principal.getName());
                    participant.setCreatedOn(LocalDateTime.now());
                    participant.setConfigureConferrerId(conferenceId);
                    participant.setParticipantName(manualUser.getUsername());
                    participant.setAccessCode(accessCode);
                    participant.setConferencePassword(String.valueOf(this.generateFourDigitRandom()));
                    participant.setMobileNumber(data.getMobileNumber());
                    participant.setExtensions(manualUser.getExtension());
                    participant.setRemainderDial(Boolean.valueOf(false));
                    participant.setIsModeratorRecord(Integer.valueOf(0));
                    participant.setParticipantType(Integer.valueOf(0));
                    participant.setRetryDelay(data.getRetryDelay());
                    participant.setDialTry(data.getAuthenticationRetry());
                    participant.setMemberType("O");
                    EmailDetail email = new EmailDetail();
                    email.setCreatedTime(LocalDateTime.now());
                    email.setType("conf");
                    email.setMeetingDate(data.getMeetingScheduledDate());
                    email.setMeetingFromTime(data.getFromTime());
                    email.setMeetingToTime(data.getToTime());
                    email.setParticipant(manualUser.getUsername());
                    email.setAccessCode(accessCode);
                    email.setConferencePassword(participant.getConferencePassword());
                    email.setMailSubject(confRoom.getRoomName());
                    email.setFromUser(principal.getName());
                    this.emailDetailsRepository.save((Object)email);
                    this.conferenceParticipantRepository.save((Object)participant);
                }
            }
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("Meeting created successfully");
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Failed to create meeting: {}", (Object)e.getMessage());
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Failed to create meeting");
        }
        return returnValue;
    }

    public RequestResponse updateMeetingRoomDetails(ConferenceMeetingModel data, Principal authentication) {
        RequestResponse returnValue = new RequestResponse();
        try {
            Optional roomId = this.conferenceRoomRepository.findById(data.getId());
            if (roomId.isPresent()) {
                Optional conference = this.configureConferenceRepository.findByRoomId(((ConferenceRoom)roomId.get()).getId());
                if (conference.isPresent()) {
                    Optional moderator = this.conferenceParticipantRepository.findByConfigureConferrerIdAndParticipantType(((ConfigureConference)conference.get()).getId(), Integer.valueOf(1));
                    if (moderator.isPresent()) {
                        ConferenceParticipant participant = (ConferenceParticipant)moderator.get();
                        if (data.getParticipantName() != null) {
                            participant.setParticipantName(data.getParticipantName());
                        }
                        if (data.getEmailId() != null) {
                            participant.setEmailId(data.getEmailId());
                        }
                        if (data.getMobileNumber() != null) {
                            participant.setMobileNumber(data.getMobileNumber());
                        }
                        if (data.getExtensions() != null) {
                            participant.setExtensions(data.getExtensions());
                        }
                        ConfigureConference conferenceData = (ConfigureConference)conference.get();
                        if (data.getMeetingScheduledDate() != null) {
                            conferenceData.setScheduledDate(data.getMeetingScheduledDate());
                        }
                        if (data.getScheduledToDate() != null) {
                            conferenceData.setScheduledToDate(data.getScheduledToDate());
                        }
                        if (data.getFromTime() != null) {
                            conferenceData.setFromTime(data.getFromTime());
                        }
                        if (data.getToTime() != null) {
                            conferenceData.setToTime(data.getToTime());
                        }
                        if (data.getVoiceRecognition() != null) {
                            if (data.getVoiceRecognition().equals(true)) {
                                conferenceData.setVoiceRecognition(Integer.valueOf(1));
                            } else if (data.getVoiceRecognition().equals(false)) {
                                conferenceData.setVoiceRecognition(Integer.valueOf(0));
                            }
                        }
                        if (data.getPasswordRequired() != null) {
                            if (data.getPasswordRequired().equals(true)) {
                                conferenceData.setPasswordRequired(Integer.valueOf(1));
                            } else if (data.getPasswordRequired().equals(false)) {
                                conferenceData.setPasswordRequired(Integer.valueOf(0));
                            }
                        }
                        if (data.getNameAnnouncementRequired() != null) {
                            if (data.getNameAnnouncementRequired().equals(true)) {
                                conferenceData.setNameAnnouncementRequired(Integer.valueOf(1));
                            } else if (data.getNameAnnouncementRequired().equals(false)) {
                                conferenceData.setNameAnnouncementRequired(Integer.valueOf(0));
                            }
                        }
                        if (data.getConferenceRetryCount() != null) {
                            conferenceData.setRetryCount(data.getConferenceRetryCount());
                        }
                        if (data.getRetryDelay() != null) {
                            conferenceData.setRetryDelay(data.getRetryDelay());
                        }
                        if (data.getRecording() != null) {
                            if (data.getRecording().equals(true)) {
                                conferenceData.setRecording(Integer.valueOf(1));
                            } else if (data.getRecording().equals(false)) {
                                conferenceData.setRecording(Integer.valueOf(0));
                            }
                        }
                        if (data.getMeetingType() != null) {
                            if (data.getMeetingType().equals("Dialer Assisted")) {
                                conferenceData.setDialerAssisted(Integer.valueOf(1));
                            } else {
                                conferenceData.setDialerAssisted(Integer.valueOf(0));
                            }
                            if (data.getMeetingType().equals("Meet Me Conference")) {
                                conferenceData.setMeetMeConference(Integer.valueOf(1));
                            } else {
                                conferenceData.setMeetMeConference(Integer.valueOf(0));
                            }
                        }
                        if (data.getRPtt() != null) {
                            if (data.getRPtt().equals(true)) {
                                conferenceData.setRPtt(Integer.valueOf(1));
                            } else if (data.getRPtt().equals(false)) {
                                conferenceData.setRPtt(Integer.valueOf(0));
                            }
                        }
                        if (data.getCoralConfGreetingsPath() != null) {
                            conferenceData.setCoralConfGreetingsPath(data.getCoralConfGreetingsPath());
                        }
                        if (data.getConferenceType() != null) {
                            if (data.getConferenceType().equals("a")) {
                                conferenceData.setConferenceType("a");
                            } else {
                                conferenceData.setConferenceType("v");
                            }
                        }
                        if (data.getConferenceMode() != null) {
                            if (data.getConferenceMode().equals("C")) {
                                conferenceData.setConferenceMode("C");
                            } else if (data.getConferenceMode().equals("I")) {
                                conferenceData.setConferenceMode("I");
                            }
                        }
                        conferenceData.setModifiedBy(authentication.getName());
                        conferenceData.setModifiedOn(LocalDateTime.now());
                        ConferenceRoom roomData = (ConferenceRoom)roomId.get();
                        if (data.getRoomName() != null) {
                            roomData.setRoomName(data.getRoomName());
                        }
                        if (data.getBeepInterval() != null) {
                            roomData.setBeepInterval(data.getBeepInterval());
                        }
                        if (data.getRetryCount() != null) {
                            roomData.setRetryCount(data.getRetryCount());
                        }
                        if (data.getFromTime() != null) {
                            roomData.setFromTime(data.getFromTime());
                        }
                        if (data.getToTime() != null) {
                            roomData.setToTime(data.getToTime());
                        }
                        if (data.getDidMapping() != null) {
                            roomData.setDidMapping(data.getDidMapping());
                        }
                        if (data.getDetail() != null) {
                            roomData.setDetail(data.getDetail());
                        }
                        this.conferenceRoomRepository.save((Object)roomData);
                        this.configureConferenceRepository.save((Object)conferenceData);
                        this.conferenceParticipantRepository.save((Object)participant);
                        if (!data.getParticipantList().isEmpty() && moderator.isPresent()) {
                            List participants = this.conferenceParticipantRepository.findByConfigureConferrerIdAndIsModeratorRecord(((ConferenceParticipant)moderator.get()).getConfigureConferrerId(), Integer.valueOf(0));
                            if (!participants.isEmpty()) {
                                for (ConferenceParticipant row : participants) {
                                    this.conferenceParticipantRepository.delete((Object)row);
                                }
                            }
                            for (MemberListModel memberModel : data.getParticipantList()) {
                                if (memberModel.getMemberType().equals("U")) {
                                    Optional userInfo = this.userRepository.findByUsername(memberModel.getUsername());
                                    if (!userInfo.isPresent() || ((User)userInfo.get()).getUsername().equals(authentication.getName())) continue;
                                    ConferenceParticipant newParticipant = new ConferenceParticipant();
                                    newParticipant.setCreatedBy(authentication.getName());
                                    newParticipant.setCreatedOn(LocalDateTime.now());
                                    newParticipant.setConfigureConferrerId(((ConferenceParticipant)moderator.get()).getConfigureConferrerId());
                                    newParticipant.setParticipantName(((User)userInfo.get()).getUsername());
                                    newParticipant.setEmailId(((User)userInfo.get()).getEmailId());
                                    newParticipant.setAccessCode(((ConferenceParticipant)moderator.get()).getAccessCode());
                                    newParticipant.setConferencePassword(String.valueOf(this.generateFourDigitRandom()));
                                    newParticipant.setMobileNumber(((User)userInfo.get()).getContactNo());
                                    newParticipant.setExtensions(((User)userInfo.get()).getContactNo());
                                    newParticipant.setRemainderDial(Boolean.valueOf(true));
                                    newParticipant.setIsModeratorRecord(Integer.valueOf(0));
                                    newParticipant.setParticipantType(Integer.valueOf(0));
                                    newParticipant.setMemberType("U");
                                    EmailDetail emailParticipant = new EmailDetail();
                                    emailParticipant.setCreatedTime(LocalDateTime.now());
                                    emailParticipant.setType("conf");
                                    emailParticipant.setEmailId(((User)userInfo.get()).getEmailId());
                                    emailParticipant.setMeetingDate(data.getMeetingScheduledDate());
                                    emailParticipant.setMeetingFromTime(data.getFromTime());
                                    emailParticipant.setMeetingToTime(data.getToTime());
                                    emailParticipant.setParticipant(data.getParticipantName());
                                    emailParticipant.setAccessCode(((ConferenceParticipant)moderator.get()).getAccessCode());
                                    emailParticipant.setConferencePassword(participant.getConferencePassword());
                                    emailParticipant.setMailSubject(roomData.getRoomName());
                                    this.conferenceParticipantRepository.save((Object)newParticipant);
                                    this.emailDetailsRepository.save((Object)emailParticipant);
                                    continue;
                                }
                                if (!memberModel.getMemberType().equals("D")) continue;
                                List directoryData = this.confPhoneBookRepository.findByOffEXtn(memberModel.getExtension());
                                ConfPhoneBook confPhoneBook = (ConfPhoneBook)directoryData.get(0);
                                ConferenceParticipant newParticipant = new ConferenceParticipant();
                                newParticipant.setCreatedBy(authentication.getName());
                                newParticipant.setCreatedOn(LocalDateTime.now());
                                newParticipant.setConfigureConferrerId(((ConferenceParticipant)moderator.get()).getConfigureConferrerId());
                                if (confPhoneBook.getName() != null && StringUtils.hasText((String)confPhoneBook.getName())) {
                                    newParticipant.setParticipantName(confPhoneBook.getName());
                                } else {
                                    newParticipant.setParticipantName(confPhoneBook.getOffEXtn());
                                }
                                newParticipant.setAccessCode(((ConferenceParticipant)moderator.get()).getAccessCode());
                                newParticipant.setConferencePassword(String.valueOf(this.generateFourDigitRandom()));
                                newParticipant.setMobileNumber(confPhoneBook.getOffEXtn());
                                newParticipant.setExtensions(confPhoneBook.getOffEXtn());
                                newParticipant.setRemainderDial(Boolean.valueOf(true));
                                newParticipant.setIsModeratorRecord(Integer.valueOf(0));
                                newParticipant.setParticipantType(Integer.valueOf(0));
                                newParticipant.setMemberType("D");
                                EmailDetail emailParticipant = new EmailDetail();
                                emailParticipant.setCreatedTime(LocalDateTime.now());
                                emailParticipant.setType("conf");
                                emailParticipant.setMeetingDate(data.getMeetingScheduledDate());
                                emailParticipant.setMeetingFromTime(data.getFromTime());
                                emailParticipant.setMeetingToTime(data.getToTime());
                                emailParticipant.setParticipant(data.getParticipantName());
                                emailParticipant.setAccessCode(((ConferenceParticipant)moderator.get()).getAccessCode());
                                emailParticipant.setConferencePassword(participant.getConferencePassword());
                                emailParticipant.setMailSubject(roomData.getRoomName());
                                this.conferenceParticipantRepository.save((Object)newParticipant);
                                this.emailDetailsRepository.save((Object)emailParticipant);
                            }
                            if (!data.getExternalParticipant().isEmpty()) {
                                for (ExternalParticipantModel manualUser : data.getExternalParticipant()) {
                                    ConferenceParticipant otherParticipant = new ConferenceParticipant();
                                    otherParticipant.setCreatedBy(authentication.getName());
                                    otherParticipant.setCreatedOn(LocalDateTime.now());
                                    otherParticipant.setConfigureConferrerId(((ConferenceParticipant)moderator.get()).getConfigureConferrerId());
                                    otherParticipant.setParticipantName(manualUser.getUsername());
                                    otherParticipant.setAccessCode(((ConferenceParticipant)moderator.get()).getAccessCode());
                                    otherParticipant.setConferencePassword(String.valueOf(this.generateFourDigitRandom()));
                                    otherParticipant.setMobileNumber(data.getMobileNumber());
                                    otherParticipant.setExtensions(manualUser.getExtension());
                                    otherParticipant.setRemainderDial(Boolean.valueOf(false));
                                    otherParticipant.setIsModeratorRecord(Integer.valueOf(0));
                                    otherParticipant.setParticipantType(Integer.valueOf(0));
                                    otherParticipant.setRetryDelay(data.getRetryDelay());
                                    otherParticipant.setDialTry(data.getAuthenticationRetry());
                                    otherParticipant.setMemberType("O");
                                    EmailDetail email = new EmailDetail();
                                    email.setCreatedTime(LocalDateTime.now());
                                    email.setType("conf");
                                    email.setMeetingDate(data.getMeetingScheduledDate());
                                    email.setMeetingFromTime(data.getFromTime());
                                    email.setMeetingToTime(data.getToTime());
                                    email.setParticipant(manualUser.getUsername());
                                    email.setAccessCode(((ConferenceParticipant)moderator.get()).getAccessCode());
                                    email.setConferencePassword(participant.getConferencePassword());
                                    email.setMailSubject(roomData.getRoomName());
                                    email.setFromUser(authentication.getName());
                                    this.emailDetailsRepository.save((Object)email);
                                    this.conferenceParticipantRepository.save((Object)otherParticipant);
                                }
                            }
                        }
                        returnValue.setStatus(Constants.Error.OK);
                        returnValue.setMessage("Meeting conference updated successfully");
                        logger.info(returnValue.getMessage());
                    } else {
                        returnValue.setStatus(Constants.Error.ERROR);
                        returnValue.setMessage("Invalid Moderator");
                        logger.error(returnValue.getMessage());
                    }
                } else {
                    returnValue.setStatus(Constants.Error.ERROR);
                    returnValue.setMessage("Invalid Conference selected");
                    logger.error(returnValue.getMessage());
                }
            } else {
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("Invalid meeting room");
                logger.error(returnValue.getMessage());
            }
        }
        catch (DataException e) {
            logger.error(e.getMessage(), (Throwable)e);
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Not appropriate data");
            return returnValue;
        }
        return returnValue;
    }

    public RequestResponse deleteConferenceParticipantById(InputIdModel data) {
        RequestResponse returnValue = new RequestResponse();
        try {
            for (Integer id : data.getIntId()) {
                Optional meetingRoom = this.conferenceRoomRepository.findById(id);
                if (meetingRoom.isPresent()) {
                    Optional conference = this.configureConferenceRepository.findByRoomId(id);
                    if (conference.isPresent()) {
                        List participantsList = this.conferenceParticipantRepository.findByConfigureConferrerId(((ConfigureConference)conference.get()).getId());
                        if (participantsList != null && !participantsList.isEmpty()) {
                            for (ConferenceParticipant participant : participantsList) {
                                this.conferenceParticipantRepository.deleteById((Object)participant.getId());
                            }
                        }
                        this.configureConferenceRepository.deleteById((Object)((ConfigureConference)conference.get()).getId());
                    }
                    this.conferenceRoomRepository.deleteById((Object)id);
                    returnValue.setStatus(Constants.Error.OK);
                    returnValue.setMessage("Meeting deleted Successfully");
                    logger.info(returnValue.getMessage());
                    continue;
                }
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("Record Not Found");
                logger.info(returnValue.getMessage());
            }
        }
        catch (UnknownError e) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Something went wrong");
            returnValue.setMessageDetail("Contact with Administrator");
            logger.error(e.getMessage());
        }
        return returnValue;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RequestResponse uploadWavFile(MultipartFile musicFile, Integer recordId, String type) {
        RequestResponse returnValue = new RequestResponse();
        String originalFilename = musicFile.getOriginalFilename();
        if (musicFile == null || !originalFilename.endsWith(".wav")) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Invalid file format. Only .wav files are allowed.");
            returnValue.setMessageDetail("Empty file or Invalid file selected");
            logger.error(returnValue.getMessageDetail());
            return returnValue;
        }
        String pathToUpload = "/usr/local/freeswitch/sounds/en/us/callie/ivr";
        Path uploadPath = Paths.get(pathToUpload, new String[0]);
        if (!Files.exists(uploadPath, new LinkOption[0])) {
            try {
                Files.createDirectories(uploadPath, new FileAttribute[0]);
            }
            catch (Exception e) {
                returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                returnValue.setMessage("Not Found ");
                returnValue.setMessageDetail("path not exist for uploading the file");
                logger.error(returnValue.getMessageDetail() + e.getMessage());
                return returnValue;
            }
        }
        try (InputStream inputStream = musicFile.getInputStream();){
            String filename;
            if (type.equals("default")) {
                filename = recordId != null ? "default.wav" : "default.wav";
            } else if (recordId != null) {
                filename = "conf_" + recordId + ".wav";
            } else {
                Integer conferenceId = null;
                Integer maxConferenceId = this.configureConferenceRepository.findMaxId();
                conferenceId = maxConferenceId != null ? Integer.valueOf(maxConferenceId + 1) : Integer.valueOf(1);
                filename = "conf_" + conferenceId + ".wav";
            }
            Path filePath = uploadPath.resolve(filename.trim());
            Files.copy(inputStream, filePath, StandardCopyOption.REPLACE_EXISTING);
            returnValue.setData((Object)filename);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("wav file uploaded successfully");
            RequestResponse requestResponse = returnValue;
            return requestResponse;
        }
        catch (IOException e) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Not Found ");
            returnValue.setMessageDetail("path not exist, for upload file");
            logger.error(returnValue.getMessageDetail(), (Object)e.getMessage());
            return returnValue;
        }
    }

    public RequestResponse getAll(Principal principal) {
        MeetingAndActiveParticipantModel returnData = new MeetingAndActiveParticipantModel();
        List list = this.conferenceRoomParticipantRepository.findAll();
        ArrayList<ConferenceMeetingModel> addValue = new ArrayList<ConferenceMeetingModel>();
        RequestResponse returnValue = new RequestResponse();
        for (ConferenceDetails meetingInfo : list) {
            if (!StringUtils.hasLength((String)meetingInfo.getStatus()) || "C".equals(meetingInfo.getStatus()) || !meetingInfo.getCreatedBy().equals(principal.getName())) continue;
            ConferenceMeetingModel data = new ConferenceMeetingModel();
            data.setId(meetingInfo.getId());
            data.setRoomName(this.replaceRoomNameForList(meetingInfo.getRoomName()));
            data.setBeepInterval(meetingInfo.getBeepInterval());
            data.setRetryCount(meetingInfo.getRetryCount());
            data.setDidMapping(meetingInfo.getDidMapping());
            data.setMeetingScheduledDate(meetingInfo.getMeetingScheduledDate());
            data.setScheduledToDate(meetingInfo.getScheduledToDate());
            data.setFromTime(meetingInfo.getFromTime());
            data.setToTime(meetingInfo.getToTime());
            data.setVoiceRecognition(meetingInfo.getVoiceRecognition());
            data.setPasswordRequired(meetingInfo.getPasswordRequired());
            data.setNameAnnouncementRequired(meetingInfo.getNameAnnouncementRequired());
            data.setMeetingType(meetingInfo.getMeetingType());
            data.setConferenceRetryCount(meetingInfo.getRetryCount());
            data.setRetryDelay(meetingInfo.getRetryDelay());
            data.setRecording(meetingInfo.getRecording());
            data.setConferenceType(meetingInfo.getConferenceType());
            data.setCoralConfGreetingsPath(meetingInfo.getCoralConfGreetingsPath());
            data.setParticipantName(meetingInfo.getParticipantName());
            data.setEmailId(meetingInfo.getEmailId());
            data.setMobileNumber(meetingInfo.getMobileNumber());
            data.setExtensions(meetingInfo.getExtensions());
            data.setAccessCode(meetingInfo.getAccessCode());
            data.setConferencePassword(meetingInfo.getConferencePassword());
            data.setStatus(meetingInfo.getStatus());
            data.setRPtt(meetingInfo.getRPtt());
            data.setModId(meetingInfo.getModId());
            data.setPId(meetingInfo.getPId());
            data.setCreatedBy(meetingInfo.getCreatedBy());
            data.setAuthenticationRetry(meetingInfo.getAuthenticationRetry());
            data.setMaxParticipants(meetingInfo.getMaxParticipants());
            data.setConferenceMode(meetingInfo.getConferenceMode());
            data.setParticipantList(this.participantListOfConference(meetingInfo.getModId(), principal));
            data.setDetail(meetingInfo.getDetail());
            data.setExternalParticipant(this.otherParticipantList(meetingInfo.getModId(), principal));
            data.setBlockedStatus(meetingInfo.getBlockedStatus());
            addValue.add(data);
        }
        returnData.setMeetingList(addValue);
        returnData.setActiveMeeting(this.getAllParticipantMeeting(principal.getName(), principal));
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setData((Object)returnData);
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    private void saveParticipant(String createdBy, User user, String accessCode, Integer roomId, boolean isModerator, int retryDelay, LocalDate meetingScheduledDate, LocalDate meetingScheduledToDate, LocalTime scheduledFromTime, LocalTime scheduledToTime, Integer authenticationRetry, Integer configureConferenceId, String roomName) {
        if (user == null) {
            return;
        }
        ConferenceParticipant participant = new ConferenceParticipant();
        Optional userInfo = this.userRepository.findByUsername(createdBy);
        participant.setCreatedBy(createdBy);
        participant.setCreatedOn(LocalDateTime.now());
        participant.setConfigureConferrerId(configureConferenceId);
        participant.setParticipantName(isModerator ? createdBy : user.getUsername());
        participant.setEmailId(isModerator ? ((User)userInfo.get()).getEmailId() : user.getEmailId());
        participant.setAccessCode(accessCode);
        participant.setConferencePassword(String.valueOf(this.generateFourDigitRandom()));
        participant.setMobileNumber(isModerator ? ((User)userInfo.get()).getContactNo() : user.getContactNo());
        participant.setExtensions(isModerator ? ((User)userInfo.get()).getContactNo() : user.getContactNo());
        participant.setRemainderDial(Boolean.valueOf(isModerator));
        participant.setIsModeratorRecord(Integer.valueOf(isModerator ? 1 : 0));
        participant.setParticipantType(Integer.valueOf(isModerator ? 1 : 0));
        participant.setRetryDelay(Integer.valueOf(retryDelay));
        participant.setDialTry(authenticationRetry);
        participant.setMemberType("U");
        EmailDetail email = new EmailDetail();
        email.setCreatedTime(LocalDateTime.now());
        email.setType("conf");
        email.setEmailId(user.getEmailId());
        email.setMeetingDate(meetingScheduledDate);
        email.setMeetingFromTime(scheduledFromTime);
        email.setMeetingToTime(scheduledToTime);
        email.setParticipant(user.getUsername());
        email.setAccessCode(accessCode);
        email.setConferencePassword(participant.getConferencePassword());
        email.setMailSubject(roomName);
        email.setFromUser(createdBy);
        this.emailDetailsRepository.save((Object)email);
        this.conferenceParticipantRepository.save((Object)participant);
    }

    private void saveDirectoryMember(String createdBy, String accessCode, ConfPhoneBook data, Integer roomId, Integer configureConferenceId, Integer retryDelay, Integer authenticationRetry, LocalDate meetingScheduledDate, LocalTime scheduledToTime, LocalTime scheduledFromTime, LocalDate meetingToDate, String roomName) {
        ConferenceParticipant participant = new ConferenceParticipant();
        participant.setCreatedBy(createdBy);
        participant.setCreatedOn(LocalDateTime.now());
        participant.setConfigureConferrerId(configureConferenceId);
        if (data.getName() != null && StringUtils.hasText((String)data.getName())) {
            participant.setParticipantName(data.getName());
        } else {
            participant.setParticipantName(data.getOffEXtn());
        }
        participant.setAccessCode(accessCode);
        participant.setConferencePassword(String.valueOf(this.generateFourDigitRandom()));
        participant.setMobileNumber(data.getMobileNumber());
        participant.setExtensions(data.getOffEXtn());
        participant.setRemainderDial(Boolean.valueOf(false));
        participant.setIsModeratorRecord(Integer.valueOf(0));
        participant.setParticipantType(Integer.valueOf(0));
        participant.setRetryDelay(retryDelay);
        participant.setDialTry(authenticationRetry);
        participant.setMemberType("D");
        EmailDetail email = new EmailDetail();
        email.setCreatedTime(LocalDateTime.now());
        email.setType("conf");
        email.setMeetingDate(meetingScheduledDate);
        email.setMeetingFromTime(scheduledFromTime);
        email.setMeetingToTime(scheduledToTime);
        email.setParticipant(data.getName());
        email.setAccessCode(accessCode);
        email.setConferencePassword(participant.getConferencePassword());
        email.setMailSubject(roomName);
        email.setFromUser(createdBy);
        this.emailDetailsRepository.save((Object)email);
        this.conferenceParticipantRepository.save((Object)participant);
    }

    private List<MeetingDetailModel> getAllParticipantMeeting(String participantName, Principal principal) {
        ArrayList<MeetingDetailModel> addValue = new ArrayList<MeetingDetailModel>();
        List participantList = this.conferenceParticipantRepository.findByParticipantName(participantName);
        if (!participantList.isEmpty()) {
            for (ConferenceParticipant participantData : participantList) {
                Optional conferenceData;
                if (participantData.getCreatedBy().equals(participantName) || !(conferenceData = this.configureConferenceRepository.findById(participantData.getConfigureConferrerId())).isPresent() || !this.checkValidDate(((ConfigureConference)conferenceData.get()).getScheduledToDate()) || ((ConfigureConference)conferenceData.get()).getStatus().equals("C")) continue;
                MeetingDetailModel data = new MeetingDetailModel();
                data.setAccessCode(participantData.getAccessCode());
                data.setConferencePassword(participantData.getConferencePassword());
                data.setRoomName(this.getRoomName(((ConfigureConference)conferenceData.get()).getRoomId()));
                data.setModId(((ConfigureConference)conferenceData.get()).getId());
                data.setPId(participantData.getId());
                data.setMeetingScheduledDate(((ConfigureConference)conferenceData.get()).getScheduledDate());
                data.setScheduledToDate(((ConfigureConference)conferenceData.get()).getScheduledToDate());
                data.setFromTime(((ConfigureConference)conferenceData.get()).getFromTime());
                data.setToTime(((ConfigureConference)conferenceData.get()).getToTime());
                data.setConferenceType(((ConfigureConference)conferenceData.get()).getConferenceType());
                data.setParticipantName(participantData.getParticipantName());
                data.setMobileNumber(participantData.getMobileNumber());
                data.setExtensions(participantData.getExtensions());
                data.setEmailId(participantData.getEmailId());
                data.setCreatedBy(participantData.getCreatedBy());
                data.setParticipantList(this.participantListOfConference(participantData.getConfigureConferrerId(), principal));
                if (((ConfigureConference)conferenceData.get()).getRPtt() != null) {
                    data.setRPtt(Boolean.valueOf(((ConfigureConference)conferenceData.get()).getRPtt() == 1));
                }
                if (((ConfigureConference)conferenceData.get()).getMeetMeConference().equals(1)) {
                    data.setMeetingType("Meet Me Conference");
                } else if (((ConfigureConference)conferenceData.get()).getDialerAssisted().equals(1)) {
                    data.setMeetingType("Dialer Assisted");
                }
                data.setRecording(Boolean.valueOf(((ConfigureConference)conferenceData.get()).getRecording() == 1));
                data.setPasswordRequired(Boolean.valueOf(((ConfigureConference)conferenceData.get()).getPasswordRequired() == 1));
                data.setDidMapping(this.getDidMapping(((ConfigureConference)conferenceData.get()).getRoomId()));
                data.setConferenceMode(((ConfigureConference)conferenceData.get()).getConferenceMode());
                data.setBlockedStatus(participantData.getBarred());
                addValue.add(data);
            }
        }
        return addValue;
    }

    private String getRoomName(Integer id) {
        Optional meetingRoom = this.conferenceRoomRepository.findById(id);
        if (meetingRoom.isPresent()) {
            return ((ConferenceRoom)meetingRoom.get()).getRoomName();
        }
        return "";
    }

    private boolean checkValidDate(LocalDate date) {
        LocalDate currentDate = LocalDate.now();
        return !date.isBefore(currentDate);
    }

    private boolean checkPastMeetings(LocalDate date, LocalTime time) {
        LocalDateTime meetingDateTime = LocalDateTime.of(date, time);
        LocalDateTime currentDateTime = LocalDateTime.now();
        return meetingDateTime.isBefore(currentDateTime);
    }

    private List<MemberListModel> participantListOfConference(Integer conferenceId, Principal principal) {
        ArrayList<MemberListModel> addValue = new ArrayList<MemberListModel>();
        List conferenceParticipants = this.conferenceParticipantRepository.findByConfigureConferrerId(conferenceId);
        if (!conferenceParticipants.isEmpty()) {
            for (ConferenceParticipant participantData : conferenceParticipants) {
                MemberListModel data = new MemberListModel();
                if (participantData.getParticipantName() == null || participantData.getParticipantName().equals(principal.getName())) continue;
                if (participantData.getMemberType() != null) {
                    data.setId(Long.valueOf(participantData.getId().longValue()));
                    data.setUsername(participantData.getParticipantName());
                    data.setExtension(participantData.getExtensions());
                    data.setMemberType(participantData.getMemberType());
                    addValue.add(data);
                    continue;
                }
                data.setId(Long.valueOf(participantData.getId().longValue()));
                data.setUsername(participantData.getParticipantName());
                data.setExtension(participantData.getExtensions());
                data.setMemberType("O");
                addValue.add(data);
            }
        }
        if (addValue.isEmpty()) {
            return Collections.emptyList();
        }
        return addValue;
    }

    private List<ExternalParticipantModel> otherParticipantList(Integer conferenceId, Principal principal) {
        ArrayList<ExternalParticipantModel> addValue = new ArrayList<ExternalParticipantModel>();
        List conferenceParticipants = this.conferenceParticipantRepository.findByConfigureConferrerId(conferenceId);
        if (!conferenceParticipants.isEmpty()) {
            for (ConferenceParticipant conferenceParticipant : conferenceParticipants) {
                ExternalParticipantModel data = new ExternalParticipantModel();
                if (conferenceParticipant.getParticipantName() == null || conferenceParticipant.getParticipantName().equals(principal.getName()) || conferenceParticipant.getMemberType() == null || !conferenceParticipant.getMemberType().equals("O")) continue;
                data.setUsername(conferenceParticipant.getParticipantName());
                data.setExtension(conferenceParticipant.getExtensions());
                data.setMemberType(conferenceParticipant.getMemberType());
                addValue.add(data);
            }
        }
        if (addValue.isEmpty()) {
            return Collections.emptyList();
        }
        return addValue;
    }

    public boolean isDateTimeWithinRange(LocalDateTime selectedDateTime, LocalDateTime fromDateTime, LocalDateTime toDateTime) {
        return !selectedDateTime.isBefore(fromDateTime) && !selectedDateTime.isAfter(toDateTime);
    }

    public String getDidMapping(Integer roomId) {
        Optional conferenceRoom = this.conferenceRoomRepository.findById(roomId);
        if (conferenceRoom.isPresent()) {
            return ((ConferenceRoom)conferenceRoom.get()).getDidMapping();
        }
        return "";
    }

    public RequestResponse getPastMeetings(Principal principal) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList addValue = new ArrayList();
        try {
            List conferenceList = principal.getName().equals("admin") || this.userService.checkGroupAdmin(principal.getName()) ? this.conferenceRoomRepository.findAll() : this.conferenceRoomRepository.findByCreatedBy(principal.getName());
            for (ConferenceRoom confRoomData : conferenceList) {
                Optional confHistory = this.configureConferenceRepository.findByRoomId(confRoomData.getId());
                confHistory.ifPresent(history -> {
                    if (this.checkPastMeetings(((ConfigureConference)confHistory.get()).getScheduledToDate(), ((ConfigureConference)confHistory.get()).getToTime()) && ((ConfigureConference)confHistory.get()).getStatus() != "C") {
                        PastMeetingModel data = new PastMeetingModel();
                        data.setRoomId(confRoomData.getId());
                        data.setCreatedBy(history.getCreatedBy());
                        data.setConferenceName(confRoomData.getRoomName());
                        data.setAccessCode(history.getAccessCode());
                        data.setModId(((ConfigureConference)confHistory.get()).getId());
                        data.setFromDate(history.getScheduledDate());
                        data.setToDate(history.getScheduledToDate());
                        data.setFromTime(history.getFromTime());
                        data.setToTime(history.getToTime());
                        data.setBackupStatus(history.getBackupStatus());
                        data.setBackupPath(history.getBackupPath());
                        addValue.add(data);
                    }
                });
            }
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("list of past meetings");
            returnValue.setData(conferenceList.isEmpty() ? Collections.emptyList() : addValue);
            logger.info("list of meetings fetched successfully");
        }
        catch (Exception e) {
            e.printStackTrace();
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("error in getting list of meetings");
            returnValue.setData(Collections.emptyList());
            logger.error("Unable to get list of meetings", (Object)e.getMessage());
        }
        return returnValue;
    }

    public RequestResponse getRecordingList(String accessCode) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList<ConfRecListModel> addValue = new ArrayList<ConfRecListModel>();
        String path = String.format("/home/coralswitch/%s/recordings/conference/%s", this.executer.getServerCode(), accessCode);
        try {
            File f = new File(path);
            if (!f.exists()) {
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("No data present");
                returnValue.setData(Collections.emptyList());
                logger.error("Invalid path,please check path of recording");
                return returnValue;
            }
            File[] fileList = f.listFiles();
            if (fileList.length == 0) {
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("Not any recording present");
                returnValue.setData(Collections.emptyList());
                logger.error("Not any recording exist of selected conferenceRoom");
            } else {
                for (File row : fileList) {
                    if (!row.isFile()) continue;
                    String filename = row.getName();
                    if (this.isValidFileName(filename)) {
                        int lastDashIndex = filename.lastIndexOf("-");
                        String id = filename.substring(0, lastDashIndex);
                        String fileName = filename.substring(lastDashIndex + 1).replace(".wav", "");
                        String fullPath = row.getAbsolutePath();
                        ConfRecListModel recording = new ConfRecListModel(id, this.replaceRoomNameForList(fileName), fullPath);
                        addValue.add(recording);
                        continue;
                    }
                    logger.error("Invalid file name:{}", (Object)filename);
                }
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("List of recordings");
                returnValue.setData(addValue);
                logger.info("recordings list fetched successfully");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("error in getting list of recordings");
            returnValue.setData(Collections.emptyList());
            logger.error("unable to get list of recordings", (Object)e.getMessage());
        }
        return returnValue;
    }

    private boolean isValidFileName(String filename) {
        return filename.matches("\\d{4}-\\d{2}-\\d{2}-\\d{2}-\\d{2}-\\d{2}\\.\\d{3}-\\w+\\.wav");
    }

    public RequestResponse recordingProcess(ConfRecProcessModel data) {
        RequestResponse returnValue = new RequestResponse();
        String filePath = String.format("/home/coralswitch/%s/recordings/conference/%s/", this.executer.getServerCode(), data.getAccessCode());
        try {
            Optional checkConference = this.configureConferenceRepository.findByAccessCode(data.getAccessCode());
            if (checkConference.isPresent()) {
                String exe1 = "";
                LocalDateTime dateTime = LocalDateTime.now();
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd-HH-mm-ss.SSS");
                String formattedDateTime = dateTime.format(formatter);
                if (data.getState().equalsIgnoreCase("start")) {
                    filePath = filePath + formattedDateTime + "-" + this.replaceRoomNameForCreate(data.getFileName()) + ".wav";
                } else if (data.getState().equalsIgnoreCase("stop")) {
                    filePath = filePath + this.latestFile(data.getAccessCode()).trim();
                }
                logger.info("selected file for action:", (Object)filePath);
                logger.info("Actual file name for process:{}", (Object)filePath);
                if (data.getState().equalsIgnoreCase("start")) {
                    returnValue.setMessageDetail("start recording ");
                    exe1 = String.format("fs_cli -x \"conference %s record %s\"", data.getAccessCode(), filePath);
                    ((ConfigureConference)checkConference.get()).setRecording(Integer.valueOf(1));
                    this.configureConferenceRepository.save(checkConference.get());
                } else if (data.getState().equalsIgnoreCase("stop")) {
                    returnValue.setMessageDetail("stop recording ");
                    exe1 = String.format("fs_cli -x \"conference %s norecord %s\"", data.getAccessCode(), filePath);
                    ((ConfigureConference)checkConference.get()).setRecording(Integer.valueOf(0));
                    this.configureConferenceRepository.save(checkConference.get());
                } else if (data.getState().equalsIgnoreCase("pause")) {
                    returnValue.setMessageDetail("pause recording ");
                    exe1 = String.format("fs_cli -x \"conference %s pause %s\"", data.getAccessCode(), filePath);
                } else if (data.getState().equalsIgnoreCase("resume")) {
                    returnValue.setMessageDetail("resume recording ");
                    exe1 = String.format("fs_cli -x \"conference %s resume %s\"", data.getAccessCode(), filePath);
                }
                logger.info("command for current process is:{}", (Object)exe1);
                logger.info(returnValue.getMessageDetail());
                this.command.executeCommand(exe1);
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("command execute successfully");
            } else {
                logger.error("Enter valid conferenceNumber/AccessCode");
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("Unable to find accessCode");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(e.getMessage());
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Error on executing command for recording");
        }
        return returnValue;
    }

    public String latestFile(String accessCode) {
        String path = String.format("/home/coralswitch/%s/recordings/conference/%s/", this.executer.getServerCode(), accessCode);
        File directory = new File(path);
        File[] files = directory.listFiles();
        Arrays.sort(files, (file1, file2) -> {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss.SSS");
                Date date1 = sdf.parse(file1.getName().split("\\.")[0]);
                Date date2 = sdf.parse(file2.getName().split("\\.")[0]);
                return date2.compareTo(date1);
            }
            catch (ParseException e) {
                e.printStackTrace();
                return 0;
            }
        });
        if (files != null && files.length > 0) {
            String latestFileName = files[0].getName();
            return latestFileName;
        }
        return "No files found in the directory.";
    }

    public RequestResponse createBackupFileAsync(RecBackupModel data) {
        RequestResponse returnValue = new RequestResponse();
        String path = String.format("/home/coralswitch/%s/recordings/conference/%s", this.executer.getServerCode(), data.getAccessCode());
        try {
            File f = new File(path);
            if (!f.exists()) {
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("No data present");
                returnValue.setMessageDetail("Invalid path of recordings");
                logger.error("Invalid path,please check path of recording");
                return returnValue;
            }
            File[] fileList = f.listFiles();
            if (fileList.length == 0) {
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("Selected conference have no recordings");
                logger.error("Conference have empty recordings:{}", (Object)path);
                return returnValue;
            }
            FileStore fileStore = Files.getFileStore(Paths.get(backupFilePath, new String[0]));
            Integer existingFile = 0;
            Long selectedSize = 0L;
            for (File row : fileList) {
                if (!row.isFile()) continue;
                Integer n = existingFile;
                Integer n2 = existingFile = Integer.valueOf(existingFile + 1);
                selectedSize = selectedSize + row.length();
            }
            long usableSpace = fileStore.getUsableSpace();
            long requiredSpace = selectedSize * (long)this.freeSpace.intValue();
            logger.info("Total size of existing files: " + selectedSize + " bytes");
            if (usableSpace < requiredSpace) {
                logger.error("Not Enough space to create backup");
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("Not enough space for backup");
                return returnValue;
            }
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Contact to administrator");
            returnValue.setMessageDetail("Error on making backup");
            logger.error("Something went wrong:{}", (Object)e.getMessage());
            return returnValue;
        }
        String uuid = UUID.randomUUID().toString();
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Backup started");
        returnValue.setMessageDetail("Tar file creation In-progress");
        data.setUuid(uuid);
        this.executorService.submit(() -> {
            try {
                RequestResponse response = this.createBackupFile(data);
                this.updateBackupStatus(response, data);
            }
            catch (Exception e) {
                e.printStackTrace();
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("data backup failed");
                returnValue.setMessage(e.getMessage());
                logger.error(e.getMessage());
            }
        });
        return returnValue;
    }

    public RequestResponse createBackupFile(RecBackupModel data) {
        RequestResponse returnValue = new RequestResponse();
        try {
            String recordingFolder = String.format("/home/coralswitch/%s/recordings/conference/%s", this.executer.getServerCode(), data.getAccessCode());
            logger.info("final folder pf backup is:{}", (Object)recordingFolder);
            String command = "";
            PdfReportFilters pdfReportFilters = new PdfReportFilters();
            pdfReportFilters.setId(data.getUuid());
            pdfReportFilters.setCreatedOnDate(LocalDateTime.now());
            pdfReportFilters.setPdfLocation(backupFilePath + data.getFileName() + ".tar");
            pdfReportFilters.setReportName("Conference");
            pdfReportFilters.setStatus("in progress");
            pdfReportFilters.setStartEpoch(Long.valueOf(System.currentTimeMillis() / 1000L));
            this.pdfReportRepository.save((Object)pdfReportFilters);
            if (data.isDeleteFile()) {
                command = String.format("tar -cvf %s --remove-files %s", backupFilePath + data.getFileName() + ".tar", recordingFolder);
                logger.info("user hit command backup with delete:{}", (Object)command);
            } else {
                command = String.format("tar -cvf %s %s", backupFilePath + data.getFileName() + ".tar", recordingFolder);
                logger.info("user hit command backup without delete:{}", (Object)command);
            }
            this.executer.executeCommand(command);
            String verifyTar = String.format("tar -tf %s &> /dev/null; echo $?", backupFilePath + data.getFileName() + ".tar");
            logger.info("command of checking exitStatus:{}", (Object)verifyTar);
            String exitCode = this.executer.executeCommand(verifyTar);
            if (exitCode.startsWith("0")) {
                logger.info("tar backup executed successfully");
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("backup of data successfully");
                this.updateBackupStatus(returnValue, data);
                if (data.isDeleteFile()) {
                    this.updateConferenceStatus(data.getAccessCode(), backupFilePath + data.getFileName() + ".tar", "D");
                } else {
                    this.updateConferenceStatus(data.getAccessCode(), backupFilePath + data.getFileName() + ".tar", "B");
                }
            } else {
                logger.error("tar process not execute successfully");
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("Improper tar executed");
            }
            return returnValue;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(e.getMessage());
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Error while taking back-up");
            this.updateBackupStatus(returnValue, data);
            return returnValue;
        }
    }

    public void updateBackupStatus(RequestResponse response, RecBackupModel data) {
        String status = response.getStatus() == Constants.Error.OK ? "success" : "failure";
        Optional pdfReportOptional = this.pdfReportRepository.findById((Object)data.getUuid());
        if (pdfReportOptional.isPresent()) {
            PdfReportFilters pdfReportFilters = (PdfReportFilters)pdfReportOptional.get();
            pdfReportFilters.setStatus(status);
            pdfReportFilters.setEndEpoch(Long.valueOf(System.currentTimeMillis() / 1000L));
            this.pdfReportRepository.save((Object)pdfReportFilters);
        }
    }

    public void updateConferenceStatus(String accessCode, String backupPath, String backupStatus) {
        Optional conferenceData = this.configureConferenceRepository.findByAccessCode(accessCode);
        if (conferenceData.isPresent()) {
            ((ConfigureConference)conferenceData.get()).setBackupPath(backupPath);
            ((ConfigureConference)conferenceData.get()).setBackupStatus(backupStatus);
            this.configureConferenceRepository.save(conferenceData.get());
        }
    }

    public RequestResponse restoreBackup(RecBackupModel data) {
        RequestResponse returnValue = new RequestResponse();
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Restore started");
        returnValue.setMessageDetail("file restore In-progress");
        this.executorService.submit(() -> {
            try {
                RequestResponse requestResponse = this.createRestore(data);
            }
            catch (Exception e) {
                e.printStackTrace();
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("data restore failed");
                returnValue.setMessage(e.getMessage());
                logger.error(e.getMessage());
            }
        });
        return returnValue;
    }

    public RequestResponse createRestore(RecBackupModel data) {
        RequestResponse returnValue = new RequestResponse();
        try {
            String restorePath = String.format("/home/coralswitch/%s/recordings/conference/%s", this.executer.getServerCode(), data.getAccessCode());
            logger.info("final folder for restore is:{}", (Object)restorePath);
            String command = "";
            command = String.format("tar -xvf %s -C /", data.getFileName());
            logger.info("user hit command to restore the file:{} and command:{}", (Object)data.getFileName(), (Object)command);
            this.executer.executeCommand(command);
            String verifyRestoreCmd = String.format("echo $?", new Object[0]);
            logger.info("command of checking exitStatus:{}", (Object)verifyRestoreCmd);
            String exitCode = this.executer.executeCommand(verifyRestoreCmd);
            if (exitCode.startsWith("0")) {
                logger.info("RestoreCmd executed successfully");
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("Restore of data successfully");
                this.updateConferenceStatus(data.getAccessCode(), "", "");
            } else {
                logger.error("restore process not execute successfully");
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("Improper restore executed");
            }
            return returnValue;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(e.getMessage());
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Error while executing restore");
            return returnValue;
        }
    }

    public RequestResponse getBackupList(SearchRequest searchRequestData, Principal principal) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = principal.getName().equals("admin") || this.userService.checkGroupAdmin(principal.getName()) ? ConferenceBackupViewSpecification.generateFilters((SearchRequest)searchRequestData, (String)"") : ConferenceBackupViewSpecification.generateFilters((SearchRequest)searchRequestData, (String)principal.getName());
        Sort sort = null;
        if (searchRequestData.sortDirection.equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).ascending();
        } else if (searchRequestData.sortDirection.equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).descending();
        }
        Page page = null;
        page = sort == null ? this.conferenceBackupViewRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.conferenceBackupViewRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)page.getContent());
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getActiveConference() {
        RequestResponse returnValue = new RequestResponse();
        ArrayList<ActiveConfModel> activeConfList = new ArrayList<ActiveConfModel>();
        List conferenceList = this.channelsRepository.findByApplication("conference");
        if (!conferenceList.isEmpty()) {
            HashSet<String> uniqueAccessCodes = new HashSet<String>();
            for (Channels record : conferenceList) {
                if (!uniqueAccessCodes.add(record.getAccessCode())) continue;
                ActiveConfModel result = new ActiveConfModel();
                result.setUuid(record.getUuid());
                result.setConferenceNumber(record.getConferenceNumber());
                result.setConferenceName(this.getRoomName(record.getAccessCode()));
                result.setName(record.getName());
                result.setAccessCode(record.getAccessCode());
                result.setCidName(record.getCidName());
                result.setCidNumber(record.getCidNumber());
                result.setInitialCidName(record.getInitialCidName());
                result.setInitialCidNum(record.getInitialCidNum());
                result.setCreatedOn(record.getCreated());
                activeConfList.add(result);
            }
            returnValue.setData(activeConfList);
            returnValue.setMessage("list of active conference");
        } else {
            returnValue.setData(Collections.emptyList());
            returnValue.setMessage("No any active conference exist");
            logger.error(returnValue.getMessage());
        }
        return returnValue;
    }

    public String replaceRoomNameForList(String roomName) {
        String result = roomName.replace("_", " ");
        return result;
    }

    public String replaceRoomNameForCreate(String roomName) {
        String result = roomName.replace(" ", "_");
        return result;
    }

    public String getRoomName(String accessCode) {
        List data = this.conferenceRoomRepository.findByAccessCode(accessCode);
        if (!data.isEmpty()) {
            String result = ((ConferenceRoom)data.get(0)).getRoomName();
            return result;
        }
        return "";
    }

    public RequestResponse getAllMeetingDetail() {
        MeetingAndActiveParticipantModel returnData = new MeetingAndActiveParticipantModel();
        List list = this.conferenceRoomParticipantRepository.findAll();
        ArrayList<ConferenceMeetingModel> addValue = new ArrayList<ConferenceMeetingModel>();
        RequestResponse returnValue = new RequestResponse();
        for (ConferenceDetails meetingInfo : list) {
            if (!StringUtils.hasLength((String)meetingInfo.getStatus()) || "C".equals(meetingInfo.getStatus()) || !"I".equals(meetingInfo.getConferenceMode())) continue;
            ConferenceMeetingModel data = new ConferenceMeetingModel();
            data.setId(meetingInfo.getId());
            data.setRoomName(this.replaceRoomNameForList(meetingInfo.getRoomName()));
            data.setBeepInterval(meetingInfo.getBeepInterval());
            data.setRetryCount(meetingInfo.getRetryCount());
            data.setDidMapping(meetingInfo.getDidMapping());
            data.setMeetingScheduledDate(meetingInfo.getMeetingScheduledDate());
            data.setScheduledToDate(meetingInfo.getScheduledToDate());
            data.setFromTime(meetingInfo.getFromTime());
            data.setToTime(meetingInfo.getToTime());
            data.setVoiceRecognition(meetingInfo.getVoiceRecognition());
            data.setPasswordRequired(meetingInfo.getPasswordRequired());
            data.setNameAnnouncementRequired(meetingInfo.getNameAnnouncementRequired());
            data.setMeetingType(meetingInfo.getMeetingType());
            data.setConferenceRetryCount(meetingInfo.getRetryCount());
            data.setRetryDelay(meetingInfo.getRetryDelay());
            data.setRecording(meetingInfo.getRecording());
            data.setConferenceType(meetingInfo.getConferenceType());
            data.setCoralConfGreetingsPath(meetingInfo.getCoralConfGreetingsPath());
            data.setParticipantName(meetingInfo.getParticipantName());
            data.setEmailId(meetingInfo.getEmailId());
            data.setMobileNumber(meetingInfo.getMobileNumber());
            data.setExtensions(meetingInfo.getExtensions());
            data.setAccessCode(meetingInfo.getAccessCode());
            data.setConferencePassword(meetingInfo.getConferencePassword());
            data.setStatus(meetingInfo.getStatus());
            data.setRPtt(meetingInfo.getRPtt());
            data.setModId(meetingInfo.getModId());
            data.setPId(meetingInfo.getPId());
            data.setCreatedBy(meetingInfo.getCreatedBy());
            data.setAuthenticationRetry(meetingInfo.getAuthenticationRetry());
            data.setMaxParticipants(meetingInfo.getMaxParticipants());
            data.setConferenceMode(meetingInfo.getConferenceMode());
            data.setParticipantList(this.memberListOfMeeting(meetingInfo.getModId()));
            data.setDetail(meetingInfo.getDetail());
            data.setExternalParticipant(this.externalMemberList(meetingInfo.getModId()));
            data.setBlockedStatus(meetingInfo.getBlockedStatus());
            addValue.add(data);
        }
        returnData.setMeetingList(addValue);
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setData((Object)returnData);
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    private List<MemberListModel> memberListOfMeeting(Integer conferenceId) {
        ArrayList<MemberListModel> addValue = new ArrayList<MemberListModel>();
        List conferenceParticipants = this.conferenceParticipantRepository.findByConfigureConferrerId(conferenceId);
        if (!conferenceParticipants.isEmpty()) {
            for (ConferenceParticipant participantData : conferenceParticipants) {
                MemberListModel data = new MemberListModel();
                if (participantData.getParticipantName() == null) continue;
                if (participantData.getMemberType() != null) {
                    data.setId(Long.valueOf(participantData.getId().longValue()));
                    data.setUsername(participantData.getParticipantName());
                    data.setExtension(participantData.getExtensions());
                    data.setMemberType(participantData.getMemberType());
                    addValue.add(data);
                    continue;
                }
                data.setId(Long.valueOf(participantData.getId().longValue()));
                data.setUsername(participantData.getParticipantName());
                data.setExtension(participantData.getExtensions());
                data.setMemberType("O");
                addValue.add(data);
            }
        }
        if (addValue.isEmpty()) {
            return Collections.emptyList();
        }
        return addValue;
    }

    private List<ExternalParticipantModel> externalMemberList(Integer conferenceId) {
        ArrayList<ExternalParticipantModel> addValue = new ArrayList<ExternalParticipantModel>();
        List conferenceParticipants = this.conferenceParticipantRepository.findByConfigureConferrerId(conferenceId);
        if (!conferenceParticipants.isEmpty()) {
            for (ConferenceParticipant conferenceParticipant : conferenceParticipants) {
                ExternalParticipantModel data = new ExternalParticipantModel();
                if (conferenceParticipant.getParticipantName() == null || conferenceParticipant.getMemberType() == null || !conferenceParticipant.getMemberType().equals("O")) continue;
                data.setUsername(conferenceParticipant.getParticipantName());
                data.setExtension(conferenceParticipant.getExtensions());
                data.setMemberType(conferenceParticipant.getMemberType());
                addValue.add(data);
            }
        }
        if (addValue.isEmpty()) {
            return Collections.emptyList();
        }
        return addValue;
    }

    @Transactional(value="switchTransactionManager")
    public RequestResponse createToMeeting(RdSOMeetingModel data, Principal principal) {
        RequestResponse returnValue = new RequestResponse();
        try {
            String zoneOfUser = this.extensionSecondaryService.getZoneOfUser(principal.getName());
            this.db.initializeSequenceForCofigureConference();
            this.db.initializeSequenceForConferenceRoom();
            Long currentEpoch = Instant.now().getEpochSecond();
            Integer roomId = this.conferenceRoomRepository.findMaxId() != null ? this.conferenceRoomRepository.findMaxId() + 1 : 1;
            Integer conferenceId = this.configureConferenceRepository.findMaxId() != null ? this.configureConferenceRepository.findMaxId() + 1 : 1;
            String accessCode = String.valueOf(this.generateFourDigitRandom());
            ConferenceRoom confRoom = new ConferenceRoom();
            confRoom.setCreatedBy(principal.getName());
            confRoom.setCreatedOn(LocalDateTime.now());
            confRoom.setDidMapping(data.getDidMapping());
            confRoom.setRoomName(this.replaceRoomNameForCreate(data.getRoomName() + ":" + currentEpoch));
            confRoom.setFromTime(LocalTime.of(0, 0, 1));
            confRoom.setToTime(LocalTime.of(23, 59, 0));
            confRoom.setActive(Boolean.valueOf(true));
            confRoom.setAuthenticationRetry(Integer.valueOf(1));
            confRoom.setAccessCode(accessCode);
            confRoom.setMaxParticipants(Integer.valueOf(50));
            confRoom.setBeepInterval(Integer.valueOf(2));
            confRoom.setRetryCount(Integer.valueOf(5));
            confRoom.setMeetingType(data.getType());
            if (zoneOfUser != null) {
                confRoom.setZone(zoneOfUser);
            }
            if (data.getParticipants() != null && !data.getParticipants().isEmpty()) {
                try {
                    ObjectMapper objectMapper = new ObjectMapper();
                    String participantsJson = objectMapper.writeValueAsString((Object)data.getParticipants());
                    confRoom.setParticipants(participantsJson);
                }
                catch (Exception e) {
                    logger.error("Error converting participants to JSON", (Throwable)e);
                }
            }
            confRoom.setDeviceNumber(data.getDeviceNumber());
            confRoom.setDeviceType(data.getDeviceType());
            confRoom.setMeetingStatus(data.getMeetingStatus());
            this.conferenceRoomRepository.save((Object)confRoom);
            Optional getConference = this.conferenceRoomRepository.findById(roomId);
            try {
                TrainAlert row = new TrainAlert();
                row.setAccessCode(accessCode);
                row.setCreatedBy(principal.getName());
                row.setCreatedOn(Long.valueOf(Instant.now().getEpochSecond()));
                row.setDescription("conference-created");
                row.setDidMapping(data.getDidMapping());
                row.setEventSeverity("low");
                row.setEventType("Alert-Notification");
                row.setRoomName(data.getRoomName());
                row.setType(data.getType());
                row.setZone(((ConferenceRoom)getConference.get()).getZone());
                this.trainAlertService.create(row);
                logger.info("event sends to all user");
            }
            catch (Exception row) {
                // empty catch block
            }
            ConfigureConference conference = new ConfigureConference();
            conference.setCreatedBy(principal.getName());
            conference.setCreatedOn(LocalDateTime.now());
            conference.setScheduledDate(LocalDate.now());
            conference.setScheduledToDate(LocalDate.now());
            conference.setFromTime(LocalTime.of(0, 0, 1));
            conference.setToTime(LocalTime.of(23, 59, 0));
            conference.setMainModerator(principal.getName());
            conference.setRoomId(roomId);
            conference.setAccessCode(accessCode);
            conference.setVoiceRecognition(Integer.valueOf(0));
            conference.setPasswordRequired(Integer.valueOf(0));
            conference.setNameAnnouncementRequired(Integer.valueOf(0));
            conference.setDialerAssisted(Integer.valueOf(0));
            conference.setMeetMeConference(Integer.valueOf(0));
            conference.setRecording(Integer.valueOf(1));
            conference.setSource("uc");
            conference.setConferenceType("v");
            conference.setRPtt(Integer.valueOf(0));
            conference.setCoralConfGreetingsPath("ivr/conf_" + conferenceId + ".wav");
            conference.setStatus("N");
            conference.setActive(Boolean.valueOf(true));
            conference.setConferenceMode("I");
            this.configureConferenceRepository.save((Object)conference);
            Optional userData = this.userRepository.findByUsername(principal.getName());
            this.saveParticipant(principal.getName(), (User)userData.get(), accessCode, confRoom.getId(), true, 0, LocalDate.now(), LocalDate.now(), LocalTime.of(0, 0, 1), LocalTime.of(23, 59, 0), Integer.valueOf(5), conferenceId, confRoom.getRoomName());
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("Meeting created successfully");
            data.setId(roomId);
            data.setAccessCode(accessCode);
            data.setDidMapping(data.getDidMapping());
            data.setZone(zoneOfUser);
            returnValue.setData((Object)data);
            if (data.getParticipants() != null && !data.getParticipants().isEmpty()) {
                logger.info("Sending events to selected participants:{}", (Object)data.getParticipants());
                for (ParticipantModel participant : data.getParticipants()) {
                    String participantNumber = participant.getNumber();
                    String username = this.extensionsService.getAssignedUser(participantNumber);
                    logger.info("Event send to this extension:{} and user:{}", (Object)participant, (Object)username);
                    if (username == null || username.equals(principal.getName())) continue;
                    Messaging.sendEvent((EventNotification)this.sendMeetingEvents(username, data.getMeetingStatus(), principal, (ConferenceRoom)getConference.get()));
                }
            } else {
                data.setParticipants(null);
                List userList = this.userService.getUserByZone(((ConferenceRoom)getConference.get()).getZone());
                logger.info("Zone of user:{}", (Object)userList);
                for (String userName : userList) {
                    if (userName == null || userName.equals(principal.getName())) continue;
                    Messaging.sendEvent((EventNotification)this.sendMeetingEvents(userName, data.getMeetingStatus(), principal, (ConferenceRoom)getConference.get()));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Failed to create meeting: {}", (Object)e.getMessage());
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Failed to create meeting");
        }
        return returnValue;
    }

    public RequestResponse getMeetingListRDso(String zone) {
        List list1 = this.conferenceRoomParticipantRepository.findAll();
        ArrayList<RdSOMeetingModel> addValue = new ArrayList<RdSOMeetingModel>();
        RequestResponse returnValue = new RequestResponse();
        if (zone == null || !StringUtils.hasLength((String)zone)) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Invalid zone selected");
            logger.error(returnValue.getMessage() + "selected zone is:{}", (Object)zone);
            return returnValue;
        }
        for (ConferenceDetails meetingInfo : list1) {
            if (meetingInfo.getZone() == null || !meetingInfo.getZone().equals(zone)) continue;
            RdSOMeetingModel data = new RdSOMeetingModel();
            data.setId(meetingInfo.getId());
            data.setDidMapping(meetingInfo.getDidMapping());
            String roomName = meetingInfo.getRoomName();
            if (roomName != null && roomName.contains(":")) {
                roomName = roomName.substring(0, roomName.indexOf(":"));
            }
            data.setRoomName(roomName);
            data.setMeetingType(meetingInfo.getMeetingType());
            data.setConferenceType(meetingInfo.getConferenceType());
            data.setCoralConfGreetingsPath(meetingInfo.getCoralConfGreetingsPath());
            data.setAccessCode(meetingInfo.getAccessCode());
            data.setConferencePassword(meetingInfo.getConferencePassword());
            data.setStatus(meetingInfo.getStatus());
            data.setCreatedBy(meetingInfo.getCreatedBy());
            data.setConferenceMode(meetingInfo.getConferenceMode());
            data.setZone(meetingInfo.getZone());
            data.setDeviceNumber(meetingInfo.getDeviceNumber());
            data.setDeviceType(meetingInfo.getDeviceType());
            data.setMeetingStatus(meetingInfo.getMeetingStatus());
            addValue.add(data);
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("list of meeting of zone:" + zone);
        returnValue.setData(addValue);
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse updateMeetingStatus(MeetingStatusUpdateModel data, Principal principal) {
        RequestResponse returnValue = new RequestResponse();
        Optional info = this.conferenceRoomRepository.findById(data.getId());
        if (info.isPresent()) {
            ((ConferenceRoom)info.get()).setMeetingStatus(data.getValue());
            this.conferenceRoomRepository.save(info.get());
            try {
                TrainAlert row = new TrainAlert();
                row.setAccessCode(((ConferenceRoom)info.get()).getAccessCode());
                row.setCreatedBy(principal.getName());
                row.setCreatedOn(Long.valueOf(Instant.now().getEpochSecond()));
                if (data.getValue() == 0) {
                    row.setDescription("conference-created");
                    row.setEventSeverity("low");
                } else if (data.getValue() == 1) {
                    row.setDescription("conference-started");
                    row.setEventSeverity("high");
                } else if (data.getValue() == 2) {
                    row.setDescription("disconnected");
                    row.setEventSeverity("close");
                } else {
                    row.setDescription("default");
                    row.setEventSeverity("NA");
                }
                row.setDidMapping(((ConferenceRoom)info.get()).getDidMapping());
                row.setEventType("Alert-Notification");
                String roomName = "";
                if (((ConferenceRoom)info.get()).getRoomName() != null && ((ConferenceRoom)info.get()).getRoomName().contains(":")) {
                    roomName = ((ConferenceRoom)info.get()).getRoomName().substring(0, ((ConferenceRoom)info.get()).getRoomName().indexOf(":"));
                    row.setRoomName(roomName);
                } else {
                    row.setRoomName(((ConferenceRoom)info.get()).getRoomName());
                }
                row.setType(((ConferenceRoom)info.get()).getMeetingType());
                row.setZone(((ConferenceRoom)info.get()).getZone());
                this.trainAlertService.create(row);
                logger.info("event sends to all user");
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error(e.getMessage());
            }
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("data update successfully");
        } else {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("data not found");
            logger.error(returnValue.getMessage() + "of id", (Object)data);
        }
        logger.info("current value for update is:{}", (Object)data.getValue());
        logger.info("logged user name is:{}", (Object)principal.getName());
        if (info.isPresent() && ((ConferenceRoom)info.get()).getParticipants() != null && !((ConferenceRoom)info.get()).getParticipants().isEmpty()) {
            logger.info("Event send according to participant list");
            try {
                ObjectMapper objectMapper = new ObjectMapper();
                List participants = (List)objectMapper.readValue(((ConferenceRoom)info.get()).getParticipants(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
                for (ParticipantModel participant : participants) {
                    String participantNumber = participant.getNumber();
                    String username = this.extensionsService.getAssignedUser(participantNumber);
                    logger.info("Event send to this extension:{} and user:{}", (Object)participant, (Object)username);
                    if (username == null || username.equals(principal.getName()) || ((ConferenceRoom)info.get()).getMeetingStatus() == null) continue;
                    Messaging.sendEvent((EventNotification)this.sendMeetingEvents(username, data.getValue(), principal, (ConferenceRoom)info.get()));
                }
            }
            catch (Exception e) {
                logger.error("Error deserializing participants from JSON: {}", (Object)e.getMessage());
            }
        } else {
            List userList = this.userService.getUserByZone(((ConferenceRoom)info.get()).getZone());
            logger.info("Zone of user:{}", (Object)userList);
            for (String userName : userList) {
                if (userName == null || userName.equals(principal.getName())) continue;
                Messaging.sendEvent((EventNotification)this.sendMeetingEvents(userName, data.getValue(), principal, (ConferenceRoom)info.get()));
                logger.info("Event send to this user:{}", (Object)userName);
            }
        }
        return returnValue;
    }

    public EventNotification sendMeetingEvents(String username, Integer status, Principal principal, ConferenceRoom conferenceData) {
        EventDetail eventInfo = new EventDetail();
        EventNotification data = new EventNotification();
        data.setEventEpoch(Long.valueOf(Instant.now().getEpochSecond()));
        data.setEventSeverity("Emergency");
        data.setEventType("Alert Notification");
        data.setEventLevel(status);
        data.setSubscriber(username);
        if (status == 0) {
            eventInfo.setDescription("conference-created");
        } else if (status == 1) {
            eventInfo.setDescription("conference-started");
        } else if (status == 2) {
            eventInfo.setDescription("disconnected");
        } else {
            eventInfo.setDescription("default");
        }
        eventInfo.setCreatedBy(principal.getName());
        eventInfo.setAccessCode(conferenceData.getAccessCode());
        eventInfo.setDidMapping(conferenceData.getDidMapping());
        eventInfo.setMeetingName(conferenceData.getRoomName());
        eventInfo.setType(conferenceData.getMeetingType());
        eventInfo.setZone(conferenceData.getZone());
        data.setEventData(eventInfo);
        return data;
    }

    public RequestResponse getMeetingListByStatus() {
        List list1 = this.conferenceRoomRepository.findAllWithMeetingStatus();
        ArrayList<RdSOMeetingModel> addValue = new ArrayList<RdSOMeetingModel>();
        RequestResponse returnValue = new RequestResponse();
        for (ConferenceRoom meetingInfo : list1) {
            RdSOMeetingModel data = new RdSOMeetingModel();
            data.setId(meetingInfo.getId());
            String roomName = meetingInfo.getRoomName();
            if (roomName != null && roomName.contains(":")) {
                roomName = this.replaceRoomNameForList(roomName.substring(0, roomName.indexOf(":")));
            }
            data.setRoomName(roomName);
            data.setDidMapping(meetingInfo.getDidMapping());
            data.setMeetingType(meetingInfo.getMeetingType());
            data.setAccessCode(meetingInfo.getAccessCode());
            data.setCreatedBy(meetingInfo.getCreatedBy());
            data.setZone(meetingInfo.getZone());
            data.setDeviceNumber(meetingInfo.getDeviceNumber());
            data.setDeviceType(meetingInfo.getDeviceType());
            data.setMeetingStatus(meetingInfo.getMeetingStatus());
            data.setCreatedOn(meetingInfo.getCreatedOn());
            data.setType(meetingInfo.getMeetingType());
            addValue.add(data);
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("list of meeting");
        returnValue.setMessageDetail("Meeting with status 0 or 1");
        returnValue.setData(addValue);
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public List<RdSOMeetingModel> entityToModelConversion(List<ConferenceRoom> getData) {
        ArrayList<RdSOMeetingModel> addValue = new ArrayList<RdSOMeetingModel>();
        for (ConferenceRoom meetingInfo : getData) {
            RdSOMeetingModel data = new RdSOMeetingModel();
            Integer meetingStatus = meetingInfo.getMeetingStatus();
            data.setId(meetingInfo.getId());
            String roomName = meetingInfo.getRoomName();
            if (roomName != null && roomName.contains(":")) {
                roomName = this.replaceRoomNameForList(roomName.substring(0, roomName.indexOf(":")));
            }
            data.setRoomName(roomName);
            data.setDidMapping(meetingInfo.getDidMapping());
            data.setMeetingType(meetingInfo.getMeetingType());
            data.setAccessCode(meetingInfo.getAccessCode());
            data.setCreatedBy(meetingInfo.getCreatedBy());
            data.setZone(meetingInfo.getZone());
            data.setDeviceNumber(meetingInfo.getDeviceNumber());
            data.setDeviceType(meetingInfo.getDeviceType());
            if (meetingStatus != null && meetingStatus.equals(0)) {
                data.setMainStatus("Created");
            } else if (meetingStatus != null && meetingStatus.equals(1)) {
                data.setMainStatus("Answered");
            } else if (meetingStatus != null && meetingStatus.equals(2)) {
                data.setMainStatus("End Without Solution");
            } else if (meetingStatus != null && meetingStatus.equals(3)) {
                data.setMainStatus("End With Solution");
            }
            data.setMeetingStatus(meetingStatus);
            data.setCreatedOn(meetingInfo.getCreatedOn());
            data.setClosedBy(meetingInfo.getClosedBy());
            data.setClosingRemarks(meetingInfo.getClosingRemarks());
            data.setType(meetingInfo.getMeetingType());
            if (meetingInfo.getParticipants() != null) {
                try {
                    ObjectMapper objectMapper = new ObjectMapper();
                    List participants = (List)objectMapper.readValue(meetingInfo.getParticipants(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
                    data.setParticipants(participants);
                }
                catch (Exception e) {
                    logger.error("Error deserializing participants from JSON: {}", (Object)e.getMessage());
                }
            }
            addValue.add(data);
        }
        return addValue;
    }

    public RequestResponse getFilteredList(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        this.db.initializeSequenceForCofigureConference();
        this.db.initializeSequenceForConferenceRoom();
        Specification filters = ConferenceRoomSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.sortDirection.equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).ascending();
        } else if (searchRequestData.sortDirection.equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).descending();
        }
        Page page = null;
        page = sort == null ? this.conferenceRoomRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.conferenceRoomRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)this.entityToModelConversion(page.getContent()));
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse updateStatusRemarks(MeetingAddressedModel data, Principal principal) {
        RequestResponse returnValue = new RequestResponse();
        if (data.getAccessCode() != null && StringUtils.hasText((String)data.getAccessCode())) {
            List list = this.conferenceRoomRepository.findByAccessCode(data.getAccessCode());
            if (!list.isEmpty()) {
                ConferenceRoom getMeeting = (ConferenceRoom)list.get(0);
                String remarks = getMeeting.getClosedBy();
                if (remarks != null && StringUtils.hasText((String)remarks)) {
                    getMeeting.setMeetingStatus(Integer.valueOf(3));
                    returnValue.setStatus(Constants.Error.OK);
                    returnValue.setMessage("Meeting Addressed");
                    returnValue.setMessageDetail("Meeting already Addressed By Someone");
                } else {
                    getMeeting.setClosedBy(principal.getName());
                    getMeeting.setClosingRemarks(data.getRemarks());
                    getMeeting.setMeetingStatus(Integer.valueOf(3));
                    returnValue.setStatus(Constants.Error.OK);
                    returnValue.setMessage("Meeting Addressed");
                }
                this.conferenceRoomRepository.save((Object)getMeeting);
            } else {
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("Selected accessCode Not Exist");
                logger.error(returnValue.getMessage());
            }
        } else {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Invalid accessCode Data");
            logger.error(returnValue.getMessage());
        }
        return returnValue;
    }

    public RequestResponse joinMeetingDispatcher(String accessCode, Principal principal) {
        RequestResponse returnValue = new RequestResponse();
        if (accessCode != null && StringUtils.hasText((String)accessCode)) {
            List list = this.conferenceRoomRepository.findByAccessCode(accessCode);
            if (!list.isEmpty()) {
                RequestResponse updateStatusOne = this.updateStatus(accessCode);
                ConferenceRoom meeting = (ConferenceRoom)list.get(0);
                if (updateStatusOne.getStatus().equals((Object)Constants.Error.OK)) {
                    if (meeting.getParticipants() != null && !meeting.getParticipants().isEmpty()) {
                        try {
                            ObjectMapper objectMapper = new ObjectMapper();
                            List participants = (List)objectMapper.readValue(meeting.getParticipants(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
                            for (ParticipantModel participant : participants) {
                                String participantNumber = participant.getNumber();
                                String username = this.extensionsService.getAssignedUser(participantNumber);
                                logger.info("Event send to this extension:{} and user:{}", (Object)participant, (Object)username);
                                if (username == null || username.equals(principal.getName())) continue;
                                Messaging.sendEvent((EventNotification)this.sendMeetingEvents(username, meeting.getMeetingStatus(), principal, meeting));
                            }
                        }
                        catch (Exception e) {
                            logger.error("Error deserializing participants from JSON: {}", (Object)e.getMessage());
                        }
                    } else {
                        List userList = this.userService.getUserByZone(meeting.getZone());
                        logger.info("Zone of user:{}", (Object)userList);
                        for (String userName : userList) {
                            if (userName == null || userName.equals(principal.getName())) continue;
                            Messaging.sendEvent((EventNotification)this.sendMeetingEvents(userName, meeting.getMeetingStatus(), principal, meeting));
                        }
                    }
                }
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("Dispatcher joined");
                logger.info(returnValue.getMessage());
            } else {
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("Selected accessCode Not Exist");
                logger.error(returnValue.getMessage());
            }
        } else {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Invalid accessCode Data");
            logger.error(returnValue.getMessage());
        }
        return returnValue;
    }

    public RequestResponse updateStatus(String accessCode) {
        RequestResponse returnValue = new RequestResponse();
        try {
            ConferenceRoom data = this.conferenceRoomRepository.getData(accessCode);
            data.setMeetingStatus(Integer.valueOf(1));
            this.conferenceRoomRepository.save((Object)data);
            returnValue.setStatus(Constants.Error.OK);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(e.getMessage());
            returnValue.setStatus(Constants.Error.ERROR);
        }
        return returnValue;
    }

    public RequestResponse requestPtt(HttpServletRequest request, String infoDetails) {
        RequestResponse returnValue = new RequestResponse();
        try {
            String clientIP = HttpUtils.getRequestIp((HttpServletRequest)request);
            McxParticipant participant = this.getParticipantFromIP(clientIP);
            if (participant != null) {
                String userName = participant.getParticipantNo();
                if (infoDetails.equalsIgnoreCase("requestPTT")) {
                    EventNotifyModel data = new EventNotifyModel(Constants.EventStatus.REQUEST_PTT, null, "PTT Request By user:" + userName, Integer.valueOf(0), Long.valueOf(Instant.now().getEpochSecond()), userName, userName, Boolean.valueOf(false), null);
                    Messaging.sendAlert((EventNotifyModel)data);
                    logger.info("Ptt request by user-{}", (Object)userName);
                    returnValue.setStatus(Constants.Error.OK);
                    returnValue.setMessage("Ptt request by user-" + userName);
                } else if (infoDetails.equalsIgnoreCase("releasePTT")) {
                    EventNotifyModel data = new EventNotifyModel(Constants.EventStatus.RELEASE_PTT, null, "PTT Release By user:" + userName, Integer.valueOf(0), Long.valueOf(Instant.now().getEpochSecond()), userName, userName, Boolean.valueOf(false), null);
                    Messaging.sendAlert((EventNotifyModel)data);
                    logger.info("Ptt release by user-{}", (Object)userName);
                    returnValue.setStatus(Constants.Error.OK);
                    returnValue.setMessage("Ptt release by user-" + userName);
                }
            } else {
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("Unable to find participant for IP : " + clientIP);
                returnValue.setMessageDetail("Contact to Administrator");
                logger.info(returnValue.getMessage());
            }
            logger.info(returnValue.getMessage());
        }
        catch (Exception ex) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Unable to return value");
            returnValue.setMessageDetail("Records not found");
            logger.error(returnValue.getMessageDetail(), (Throwable)ex);
        }
        return returnValue;
    }

    public McxParticipant getParticipantFromIP(String clientIP) {
        List participants = this.mcxParticipantRepository.findByConnectedIpAddressOrderByKeepAliveEpochDesc(clientIP);
        if (participants.isEmpty()) {
            return null;
        }
        return (McxParticipant)participants.get(0);
    }

    public RequestResponse getAllRecordings(Principal principal, String accessCode) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList<ConferenceRecordingModel> recordings = new ArrayList<ConferenceRecordingModel>();
        try {
            String serverCode = this.restoreByClusterService.getServerCode();
            logger.info("serverCode: {}", (Object)serverCode);
            if (!StringUtils.hasText((String)serverCode)) {
                logger.info("ServerCode is empty, cannot fetch recordings");
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("OK 0");
                returnValue.setData(recordings);
                return returnValue;
            }
            String basePath = "/home/coralswitch/" + serverCode + "/recordings/conference/";
            List rooms = this.conferenceRoomRepository.findByCreatedBy(principal.getName());
            if (rooms == null || rooms.isEmpty()) {
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("OK 0");
                returnValue.setData(recordings);
                return returnValue;
            }
            Set<Object> userAccessCodes = rooms.stream().map(ConferenceRoom::getAccessCode).filter(StringUtils::hasText).collect(Collectors.toSet());
            if (StringUtils.hasText((String)accessCode)) {
                if (!userAccessCodes.contains(accessCode)) {
                    returnValue.setStatus(Constants.Error.OK);
                    returnValue.setMessage("OK:0");
                    returnValue.setData(recordings);
                    return returnValue;
                }
                userAccessCodes = Collections.singleton(accessCode);
            }
            HashSet<String> seenAbsolutePaths = new HashSet<String>();
            for (String code : userAccessCodes) {
                File[] files;
                File folder = new File(basePath + code);
                if (!folder.exists() || !folder.isDirectory() || (files = folder.listFiles((dir, name) -> name.toLowerCase().endsWith(".wav"))) == null || files.length == 0) continue;
                for (File f : files) {
                    String abs = f.getAbsolutePath();
                    if (!seenAbsolutePaths.add(abs)) continue;
                    ConferenceRecordingModel model = new ConferenceRecordingModel();
                    model.setRecordingFile(f.getName());
                    model.setPath(abs);
                    model.setAccessCode(code);
                    recordings.add(model);
                }
            }
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("OK size:" + recordings.size());
            returnValue.setData(recordings);
            logger.info("Found {} recordings for user {}", (Object)recordings.size(), (Object)principal.getName());
        }
        catch (Exception e) {
            logger.error("Error fetching recordings", (Throwable)e);
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Error while fetching recordings: " + e.getMessage());
        }
        return returnValue;
    }
}

