/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.pbx.acdGroup.service;

import com.coraltele.db.coralapps.callcenter.entity.Queue;
import com.coraltele.db.coralapps.callcenter.repository.QueueRepository;
import com.coraltele.db.telephony.pbx.entity.DidMapping;
import com.coraltele.db.telephony.pbx.entity.Extension;
import com.coraltele.db.telephony.pbx.entity.ExtensionsServices;
import com.coraltele.db.telephony.pbx.repository.DidMappingRepository;
import com.coraltele.db.telephony.pbx.repository.ExtensionsRepository;
import com.coraltele.db.telephony.pbx.repository.ExtensionsServicesRepository;
import com.coraltele.db.telephony.pbx.specification.ExtensionOcGroupSpecification;
import com.coraltele.db.users.main.entity.User;
import com.coraltele.db.users.main.repository.UserRepository;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.pbx.cos.service.InboundCosService;
import com.coraltele.service.pbx.cos.service.OutboundCosService;
import com.coraltele.service.pbx.didmapping.service.DidMappingService;
import com.coraltele.service.pbx.extension.model.ExtensionsModel;
import com.coraltele.service.pbx.extension_service.model.ServiceCodeAttribute;
import com.coraltele.service.pbx.extension_service.service.ExtensionsServicesService;
import com.coraltele.service.user.model.UserModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
public class AcdService {
    private static final Logger logger = LogManager.getLogger(AcdService.class);
    @Autowired
    private ExtensionsRepository extensionsRepository;
    @Autowired
    private ExtensionsServicesRepository extensionsServicesRepository;
    @Autowired
    private OutboundCosService outBoundCosService;
    @Autowired
    private InboundCosService inBoundCosService;
    @Autowired
    private ExtensionsServicesService extensionsServicesService;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private DidMappingRepository didMappingRepository;
    @Autowired
    private DidMappingService didMappingService;
    @Autowired
    private QueueRepository queueRepository;

    public boolean checkExtensionsFromGivenRange(ServiceCodeAttribute range) {
        for (int i = Integer.parseInt(range.getFrom()); i <= Integer.parseInt(range.getTo()); ++i) {
            Optional extensions = this.extensionsRepository.findByExtension(String.valueOf(i));
            if (!extensions.isPresent()) continue;
            return true;
        }
        return false;
    }

    @Transactional(value="switchTransactionManager")
    public RequestResponse createExtensionByGivenRange(ServiceCodeAttribute extensionRange) {
        logger.debug("create new extension : {} ==> {}", (Object)extensionRange.getFrom(), (Object)extensionRange.getTo());
        RequestResponse returnValue = new RequestResponse();
        boolean checkOutbound = this.outBoundCosService.checkOutboundCosWithZerosCos();
        boolean checkInbound = this.inBoundCosService.checkInboundCosWithZerosCos();
        boolean checkExtensionRange = this.checkExtensionsFromGivenRange(extensionRange);
        try {
            if (!checkExtensionRange) {
                if (!checkOutbound) {
                    this.outBoundCosService.createOutboundCoswithZerosCos();
                }
                if (!checkInbound) {
                    this.inBoundCosService.createInboundCosWithZerosCos();
                }
                this.extensionsServicesService.createMultipleExtensionServices(extensionRange);
                for (int i = Integer.parseInt(extensionRange.getFrom()); i <= Integer.parseInt(extensionRange.getTo()); ++i) {
                    String[] suffixes;
                    Extension extensions = new Extension();
                    extensions.setExtension(String.valueOf(i));
                    extensions.setExtensionType("ocgroup");
                    extensions.setDayOutboundCos("0");
                    extensions.setDayInboundCos("0");
                    extensions.setNightOutboundCos("0");
                    extensions.setNightInboundCos("0");
                    if (StringUtils.hasLength((String)extensionRange.getStrategy())) {
                        extensions.setStrategy(extensionRange.getStrategy());
                    } else {
                        extensions.setStrategy("longest-ideal-agent");
                    }
                    extensions.setRecord(extensionRange.getRecord());
                    extensions.setDMon(Integer.valueOf(0));
                    extensions.setDTue(Integer.valueOf(0));
                    extensions.setDWed(Integer.valueOf(0));
                    extensions.setDThu(Integer.valueOf(0));
                    extensions.setDFri(Integer.valueOf(0));
                    extensions.setDSat(Integer.valueOf(0));
                    extensions.setDSun(Integer.valueOf(0));
                    this.extensionsRepository.save((Object)extensions);
                    for (String suffix : suffixes = new String[]{"_AT", "_AS", "_AV"}) {
                        Queue queue = new Queue();
                        queue.setSystemName("ACD_" + i + suffix);
                        queue.setDescription("ACD_" + i + suffix);
                        queue.setAdvertiseDialing(Boolean.valueOf(false));
                        queue.setRecord(extensionRange.getRecord());
                        queue.setTimeBaseScore("system");
                        queue.setMaxWaitTime(Integer.valueOf(0));
                        queue.setMaxWaitTimeWithNoAgent(Integer.valueOf(0));
                        queue.setMaxWaitTimeWithNoAgentTimeReached(Integer.valueOf(5));
                        queue.setTierRulesApply(Boolean.valueOf(false));
                        queue.setTierRuleWaitSecond(Integer.valueOf(300));
                        queue.setTierRuleWaitMultiplyLevel(Boolean.valueOf(true));
                        queue.setTierRuleNoAgentNoWait(Boolean.valueOf(false));
                        queue.setDiscardAbandonedAfter(Integer.valueOf(60));
                        queue.setAbandonedResumeAllowed(Boolean.valueOf(false));
                        queue.setRbTonAgentTrying(Boolean.valueOf(false));
                        queue.setIsPlayPosition(Boolean.valueOf(false));
                        if (StringUtils.hasLength((String)extensionRange.getStrategy())) {
                            queue.setStrategy(extensionRange.getStrategy());
                        } else {
                            queue.setStrategy("longest-ideal-agent");
                        }
                        this.queueRepository.save((Object)queue);
                    }
                }
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("Extensions created");
                returnValue.setMessageDetail("All extensions have created successfully");
                logger.info("Extension saved : {}", (Object)returnValue.getMessage());
            } else {
                returnValue.setStatus(Constants.Error.EXTENSION_RANGE_ALREADY_EXISTS);
                returnValue.setMessage("Can't create");
                returnValue.setMessageDetail("Extensions already created");
                logger.error(returnValue.getMessageDetail());
            }
        }
        catch (Exception ex) {
            returnValue.setStatus(Constants.Error.EXTENSION_RANGE_ALREADY_EXISTS);
            returnValue.setMessage("Can't Create ");
            returnValue.setMessageDetail("Extension already present, from given range");
            logger.error(returnValue.getMessageDetail(), (Throwable)ex);
        }
        return returnValue;
    }

    public RequestResponse updateAcd(ExtensionsModel model) {
        RequestResponse response = new RequestResponse();
        try {
            if (model.getId() == null) {
                return this.createErrorResponse("Extension ID is required for update.");
            }
            Optional existingExtensionOptional = this.extensionsRepository.findById((Object)model.getId());
            if (!existingExtensionOptional.isPresent()) {
                return this.createErrorResponse("Extension not found.");
            }
            Extension existingExtension = (Extension)existingExtensionOptional.get();
            this.updateAssignedUser(existingExtension, model);
            this.updateExtensionFields(existingExtension, model);
            this.updateDidAndDodNumbers(existingExtension, model);
            this.updateExtensionRange(existingExtension, model);
            this.updateQueue(existingExtension, model);
            this.extensionsRepository.save((Object)existingExtension);
            response.setStatus(Constants.Error.OK);
            response.setMessage("Extension updated successfully.");
        }
        catch (Exception ex) {
            response.setStatus(Constants.Error.EXTENSION_RANGE_ALREADY_EXISTS);
            response.setMessage("Can't update extension.");
            response.setMessageDetail("Extension already present from given range.");
            logger.error(response.getMessageDetail(), (Throwable)ex);
        }
        return response;
    }

    public void updateQueue(Extension existingExtension, ExtensionsModel model) {
        String[] suffixes;
        String extensionExistInExtension = existingExtension.getExtension();
        for (String suffix : suffixes = new String[]{"_AT", "_AS", "_AV"}) {
            String systemName = "ACD_" + extensionExistInExtension + suffix;
            Optional queueUpdateOptional = this.queueRepository.findBySystemName(systemName);
            if (!queueUpdateOptional.isPresent()) continue;
            Queue queueToUpdate = (Queue)queueUpdateOptional.get();
            if (StringUtils.hasLength((String)model.getStrategy())) {
                queueToUpdate.setStrategy(model.getStrategy());
            } else {
                queueToUpdate.setStrategy("longest-ideal-agent");
            }
            this.queueRepository.save((Object)queueToUpdate);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void updateAssignedUser(Extension existingExtension, ExtensionsModel model) {
        if (model.getAssignedUser() != null) {
            Optional userOptional = this.userRepository.findByUsername(model.getAssignedUser());
            if (!userOptional.isPresent()) throw new RuntimeException("User is not valid");
            User user = (User)userOptional.get();
            user.setContactNo(model.getExtension());
            existingExtension.setAssignedUser(model.getAssignedUser());
            this.userRepository.save((Object)user);
            return;
        } else {
            existingExtension.setAssignedUser(null);
            List userList = this.userRepository.findByContactNo(model.getExtension());
            if (userList.isEmpty()) return;
            User user = (User)userList.get(0);
            user.setContactNo(null);
            this.userRepository.save((Object)user);
        }
    }

    @Transactional(value="switchTransactionManager")
    private void updateExtensionFields(Extension existingExtension, ExtensionsModel model) {
        existingExtension.setAcdCallback(model.getAcdCallback());
        existingExtension.setColumn3(model.getAnswerStation());
        existingExtension.setColumn4(model.getAnswerVip());
        existingExtension.setColumn5(model.getAnswerBack());
        existingExtension.setBusyReleaseInterval(model.getBusyReleaseInterval());
        existingExtension.setIsCampOnMode(model.getIsCampOnMode());
        existingExtension.setCampOnHoldMusic(model.getCampOnHoldMusic());
        existingExtension.setIsCallCenterBased(model.getIsCallCenterBased());
        existingExtension.setChimePath(model.getChimePath());
        existingExtension.setChimeInterval(model.getChimeInterval());
        existingExtension.setFromTime(model.getFromTime());
        existingExtension.setColumn1(model.getFilepath());
        existingExtension.setFailOver(model.getFailOver());
        existingExtension.setDayInboundCos(model.getDayInboundCos());
        existingExtension.setNightInboundCos(model.getNightInboundCos());
        existingExtension.setManufacturerId(model.getManufacturerId());
        existingExtension.setModelCode(model.getModelCode());
        existingExtension.setName(model.getName());
        existingExtension.setNonworkingApp(model.getNonworkingApp());
        existingExtension.setNonworkingData(model.getNonworkingData());
        existingExtension.setNightRingTime(model.getNightRingTime());
        existingExtension.setDayOutboundCos(model.getDayOutboundCos());
        existingExtension.setNightOutboundCos(model.getNightOutboundCos());
        existingExtension.setOverrideMoh(model.getOverrideMoh());
        existingExtension.setAcdPickupGroup(model.getAcdPickupGroup());
        existingExtension.setPforkStr(model.getPforkStr());
        existingExtension.setParkExpiryInterval(model.getParkExpiryInterval());
        existingExtension.setRecord(model.getRecord());
        existingExtension.setRingTime(model.getRingTime());
        existingExtension.setRluCode(model.getRluCode());
        existingExtension.setSipPassword(model.getSipPassword());
        existingExtension.setSrtP(model.getSrtP());
        existingExtension.setColumn6(model.getSerialCall());
        existingExtension.setStrategy(model.getStrategy());
        existingExtension.setToTime(model.getToTime());
        existingExtension.setTimezone(model.getTimezone());
        existingExtension.setColumn2(model.getTextPath());
        existingExtension.setTpi(model.getTpi());
        existingExtension.setTimeOutInSecond(model.getTimeOutInSecond());
        existingExtension.setData(model.getTransferNumber());
        existingExtension.setVoicemail(model.getVoicemail());
        existingExtension.setZrtP(model.getZrtP());
        existingExtension.setAutoLift(model.getAutoLift());
        existingExtension.setPassword(model.getIvrPassword());
        existingExtension.setColumn11(model.getTenantCode());
        existingExtension.setVideoCall(model.getVideoCall());
        if (model.getModelCode() != null && model.getModelCode() != "") {
            existingExtension.setModelDetailId(Integer.valueOf(Integer.parseInt(model.getModelCode())));
        } else {
            existingExtension.setModelDetailId(null);
        }
        existingExtension.setDMon(Integer.valueOf(Boolean.TRUE.equals(model.getMonday()) ? 1 : 0));
        existingExtension.setDTue(Integer.valueOf(Boolean.TRUE.equals(model.getTuesday()) ? 2 : 0));
        existingExtension.setDWed(Integer.valueOf(Boolean.TRUE.equals(model.getWednesday()) ? 3 : 0));
        existingExtension.setDThu(Integer.valueOf(Boolean.TRUE.equals(model.getThursday()) ? 4 : 0));
        existingExtension.setDFri(Integer.valueOf(Boolean.TRUE.equals(model.getFriday()) ? 5 : 0));
        existingExtension.setDSat(Integer.valueOf(Boolean.TRUE.equals(model.getSaturday()) ? 6 : 0));
        existingExtension.setDSun(Integer.valueOf(Boolean.TRUE.equals(model.getSunday()) ? 7 : 0));
        existingExtension.setDidNumber(model.getDidNumber());
        existingExtension.setDodNumber(model.getDodNumber());
        existingExtension.setColumn7(model.getAnswerTrunk());
    }

    @Transactional(value="switchTransactionManager")
    private void updateDidAndDodNumbers(Extension existingExtension, ExtensionsModel model) {
        this.updateDidMapping(existingExtension, model.getDidNumber(), model.getDodNumber());
    }

    @Transactional(value="switchTransactionManager")
    private void updateDidMapping(Extension existingExtension, String didNumber, String dodNumber) {
        Optional didMappingOptional = this.didMappingRepository.findByExtNumber(existingExtension.getExtension());
        if (didMappingOptional.isPresent()) {
            DidMapping didMapping = (DidMapping)didMappingOptional.get();
            didMapping.setDidNumber(didNumber);
            didMapping.setDodNumber(dodNumber);
            this.didMappingRepository.save((Object)didMapping);
        } else if (didNumber != null || dodNumber != null) {
            DidMapping newDidMapping = new DidMapping();
            newDidMapping.setExtNumber(existingExtension.getExtension());
            newDidMapping.setDidNumber(didNumber);
            newDidMapping.setDodNumber(dodNumber);
            this.didMappingRepository.save((Object)newDidMapping);
        }
    }

    @Transactional(value="switchTransactionManager")
    private void updateExtensionRange(Extension existingExtension, ExtensionsModel model) {
        ExtensionsServices extensionsServices;
        this.extensionsServicesService.deleteAllExtension(existingExtension.getExtension());
        String extension = existingExtension.getExtension();
        if (model.getCfaData() != null && !model.getCfaData().isEmpty()) {
            extensionsServices = new ExtensionsServices();
            extensionsServices.setExtension(String.valueOf(extension));
            extensionsServices.setData(model.getCfaData());
            extensionsServices.setServiceCode("fwd-all");
            this.extensionsServicesRepository.save((Object)extensionsServices);
        }
        if (model.getIsd() != null && model.getIsd().equals(Boolean.TRUE)) {
            extensionsServices = new ExtensionsServices();
            extensionsServices.setExtension(String.valueOf(extension));
            extensionsServices.setServiceCode("dialing-isd");
            this.extensionsServicesRepository.save((Object)extensionsServices);
        }
        if (model.getStd() != null && model.getStd().equals(Boolean.TRUE)) {
            extensionsServices = new ExtensionsServices();
            extensionsServices.setExtension(String.valueOf(extension));
            extensionsServices.setServiceCode("dialing-std");
            this.extensionsServicesRepository.save((Object)extensionsServices);
        }
        if (model.getLocal() != null && model.getLocal().equals(Boolean.TRUE)) {
            extensionsServices = new ExtensionsServices();
            extensionsServices.setExtension(String.valueOf(extension));
            extensionsServices.setServiceCode("dialing-local");
            this.extensionsServicesRepository.save((Object)extensionsServices);
        }
        if (model.getIntercom() != null && model.getIntercom().equals(Boolean.TRUE)) {
            extensionsServices = new ExtensionsServices();
            extensionsServices.setExtension(String.valueOf(extension));
            extensionsServices.setServiceCode("dialing-intercom");
            this.extensionsServicesRepository.save((Object)extensionsServices);
        }
    }

    private RequestResponse createErrorResponse(String message) {
        RequestResponse response = new RequestResponse();
        response.setStatus(Constants.Error.ERROR);
        response.setMessage(message);
        return response;
    }

    public RequestResponse getUserWithNoExtension() {
        UserModel userModel;
        RequestResponse response = new RequestResponse();
        List userList = this.userRepository.findByContactNo(null);
        List userList1 = this.userRepository.findByContactNo("");
        ArrayList<UserModel> userModels = new ArrayList<UserModel>();
        for (User user : userList) {
            userModel = new UserModel();
            userModel.setUsername(user.getUsername());
            userModels.add(userModel);
        }
        for (User user : userList1) {
            userModel = new UserModel();
            userModel.setUsername(user.getUsername());
            userModels.add(userModel);
        }
        response.setMessage("List of user");
        response.setMessageDetail("List of users with no assigned contact " + userModels.size());
        response.setData(userModels);
        return response;
    }

    public RequestResponse deleteBySingleExtensionValue(String extension) {
        logger.debug("Delete extension {}", (Object)extension);
        RequestResponse returnValue = new RequestResponse();
        Optional data = this.extensionsRepository.findByExtension(extension);
        if (!data.isPresent()) {
            returnValue.setStatus(Constants.Error.BAD_CREDENTIAL);
            returnValue.setMessage("Unable to delete");
            returnValue.setMessageDetail("Record Not Found");
        } else {
            if (((Extension)data.get()).getExtension() != null) {
                this.extensionsServicesService.deleteByExtension(((Extension)data.get()).getExtension());
            }
            if (((Extension)data.get()).getExtension() != null) {
                this.didMappingService.deleteDidMapping(((Extension)data.get()).getExtension());
            }
            if (((Extension)data.get()).getExtension() != null) {
                String[] suffixes;
                for (String suffix : suffixes = new String[]{"_AT", "_AS", "_AV"}) {
                    String systemName = "ACD_" + extension + suffix;
                    Optional queueToDelete = this.queueRepository.findBySystemName(systemName);
                    if (!queueToDelete.isPresent()) continue;
                    this.queueRepository.deleteBySystemName(systemName);
                }
            }
            this.extensionsRepository.deleteById((Object)((Extension)data.get()).getId());
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("Deleted");
            returnValue.setMessageDetail("Data deleted successfully");
            logger.info(returnValue.getMessage());
        }
        return returnValue;
    }

    public RequestResponse getFilteredExtensionByType(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = ExtensionOcGroupSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.getSortDirection().equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "extension" : searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.getSortDirection().equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "extension" : searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.extensionsRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.extensionsRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)this.entityToModelConversion(page.getContent()));
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public List<ExtensionsModel> entityToModelConversion(List<Extension> list) {
        ArrayList<ExtensionsModel> addValue = new ArrayList<ExtensionsModel>();
        for (Extension data : list) {
            List extensionsServicesList;
            ExtensionsModel extension = new ExtensionsModel();
            extension.setId(data.getId());
            extension.setFailOver(data.getFailOver());
            extension.setABarTimeout(data.getABarTimeout());
            extension.setAccountCode(data.getAccountCode());
            extension.setAcdCallback(data.getAcdCallback());
            extension.setAcdPickupGroup(data.getAcdPickupGroup());
            extension.setAlertInfo(data.getAlertInfo());
            extension.setAnonymousCallRejection(data.getAnonymousCallRejection());
            extension.setApplicationId(data.getApplicationId());
            extension.setAutoLift(data.getAutoLift());
            extension.setBrowserExt(data.getBrowserExt());
            extension.setBusyReleaseInterval(data.getBusyReleaseInterval());
            extension.setCFNATime(data.getCFNATime());
            extension.setCallContext(data.getCallContext());
            extension.setCallForwardNumber(data.getCallForwardNumber());
            extension.setCallTrace(data.getCallTrace());
            extension.setCallWaitingStatus(data.getCallWaitingStatus());
            extension.setCallerIdStatus(data.getCallerIdStatus());
            extension.setCallerOverrideToHoldParty(data.getCallerOverrideToHoldParty());
            extension.setCallerStrip(data.getCallerStrip());
            extension.setCampOnHoldMusic(data.getCampOnHoldMusic());
            extension.setCampOnRetryInterval(data.getCampOnRetryInterval());
            extension.setCanBroadcast(data.getCanBroadcast());
            extension.setCanMulticast(data.getCanMulticast());
            extension.setCheckIn(data.getCheckIn());
            extension.setCheckInEpoch(data.getCheckInEpoch());
            extension.setChimeInterval(data.getChimeInterval());
            extension.setChimePath(data.getChimePath());
            extension.setCodeBlueSentSmsConfig(data.getCodeBlueSentSmsConfig());
            extension.setCollaboration(data.getCollaboration());
            extension.setFilepath(data.getColumn1());
            extension.setTextPath(data.getColumn2());
            extension.setAnswerStation(data.getColumn3());
            extension.setAnswerVip(data.getColumn4());
            extension.setAnswerBack(data.getColumn5());
            extension.setSerialCall(data.getColumn6());
            extension.setAnswerTrunk(data.getColumn7());
            extension.setColumn8(data.getColumn8());
            extension.setColumn9(data.getColumn9());
            extension.setColumn10(data.getColumn10());
            extension.setTenantCode(data.getColumn11());
            extension.setColumn12(data.getColumn12());
            extension.setColumn13(data.getColumn13());
            extension.setColumn14(data.getColumn14());
            extension.setColumn15(data.getColumn15());
            extension.setColumn16(data.getColumn16());
            extension.setConfPwd(data.getConfPwd());
            extension.setConferenceMode(data.getConferenceMode());
            extension.setConfigEmailId(data.getConfigEmailId());
            extension.setConfirmationWavFile(data.getConfirmationWavFile());
            extension.setControlName(data.getControlName());
            extension.setCoralAcdCallType(data.getCoralAcdCallType());
            extension.setCurrentChannel(data.getCurrentChannel());
            extension.setCustomeDestination(data.getCustomeDestination());
            extension.setExtension(data.getExtension());
            extension.setExtensionType(data.getExtensionType());
            extension.setName(data.getName());
            extension.setCFNATime(data.getCFNATime());
            extension.setVideoCall(data.getVideoCall());
            extension.setWavFilename(data.getWavFilename());
            extension.setPCMA(data.getPCMA());
            extension.setPCMU(data.getPCMU());
            extension.setG722(data.getG722());
            extension.setG726(data.getG726());
            extension.setG729(data.getG729());
            extension.setG723(data.getG723());
            extension.setOpus(data.getOpus());
            extension.setVp8(data.getVp8());
            extension.setH263(data.getH263());
            extension.setH264(data.getH264());
            extension.setDayInboundCos(data.getDayInboundCos());
            extension.setNightInboundCos(data.getNightInboundCos());
            extension.setDayOutboundCos(data.getDayOutboundCos());
            extension.setNightOutboundCos(data.getNightOutboundCos());
            extension.setSecondaryDayInboundCos(data.getSecondaryDayInboundCos());
            extension.setSecondaryDayOutboundCos(data.getSecondaryDayOutboundCos());
            extension.setSecondaryNightInboundCos(data.getSecondaryNightInboundCos());
            extension.setSecondaryNightOutboundCos(data.getSecondaryNightOutboundCos());
            extension.setPrimaryDayInboundCos(data.getPrimaryDayInboundCos());
            extension.setPrimaryDayOutboundCos(data.getPrimaryDayOutboundCos());
            extension.setIMEINumber(data.getIMEINumber());
            extension.setTimeOutInSecond(data.getTimeOutInSecond());
            extension.setRingTime(data.getRingTime());
            extension.setCompany(data.getCompany());
            extension.setDepartment(data.getDepartment());
            extension.setDesignation(data.getDesignation());
            extension.setSecretary(data.getSecretary());
            extension.setCollaboration(data.getCollaboration());
            extension.setAccountCode(data.getAccountCode());
            extension.setData(data.getData());
            extension.setExtGroupId(data.getExtGroupId());
            extension.setPforkStr(data.getPforkStr());
            extension.setRecord(data.getRecord());
            extension.setEmailId(data.getEmailId());
            extension.setRluCode(data.getRluCode());
            extension.setCallWaitingStatus(data.getCallWaitingStatus());
            extension.setRingBackTone(data.getRingBackTone());
            extension.setGroupCode(data.getGroupCode());
            extension.setIsCampOnMode(data.getIsCampOnMode());
            extension.setCallTransferToVm(data.getCallTransferToVm());
            extension.setWelcomeGreeting(data.getWelcomeGreeting());
            extension.setOverflowToBoss(data.getOverflowToBoss());
            extension.setSplitRecordingFileInMinutes(data.getSplitRecordingFileInMinutes());
            extension.setPhoneStatus(data.getPhoneStatus());
            extension.setDayMode(data.getDayMode());
            extension.setNightMode(data.getNightMode());
            extension.setNonworkingData(data.getNonworkingData());
            extension.setNonworkingApp(data.getNonworkingApp());
            extension.setManufacturerId(data.getManufacturerId());
            if (data.getModelDetailId() != null) {
                extension.setModelCode(data.getModelDetailId().toString());
            } else {
                extension.setModelCode(null);
            }
            extension.setPersonalVmGreeting(data.getPersonalVmGreeting());
            extension.setMacId(data.getMacId());
            extension.setSrtP(data.getSrtP());
            extension.setZrtP(data.getZrtP());
            extension.setSunday(Boolean.valueOf(data.getDSun() != null && data.getDSun() != 0));
            extension.setMonday(Boolean.valueOf(data.getDMon() != null && data.getDMon() != 0));
            extension.setTuesday(Boolean.valueOf(data.getDTue() != null && data.getDTue() != 0));
            extension.setWednesday(Boolean.valueOf(data.getDWed() != null && data.getDWed() != 0));
            extension.setThursday(Boolean.valueOf(data.getDThu() != null && data.getDThu() != 0));
            extension.setFriday(Boolean.valueOf(data.getDFri() != null && data.getDFri() != 0));
            extension.setSaturday(Boolean.valueOf(data.getDSat() != null && data.getDSat() != 0));
            extension.setFromTime(data.getFromTime());
            extension.setToTime(data.getToTime());
            extension.setFriFromTime(data.getFriFromTime());
            extension.setFriToTime(data.getFriToTime());
            extension.setFlexibleTimings(data.getFlexibleTimings());
            extension.setMonFromTime(data.getMonFromTime());
            extension.setMonToTime(data.getMonToTime());
            extension.setTueFromTime(data.getTueFromTime());
            extension.setTueToTime(data.getTueToTime());
            extension.setWedFromTime(data.getWedFromTime());
            extension.setWedToTime(data.getWedToTime());
            extension.setThuFromTime(data.getThuFromTime());
            extension.setThuToTime(data.getThuToTime());
            extension.setSatFromTime(data.getSatFromTime());
            extension.setSatToTime(data.getSatToTime());
            extension.setNightRingTime(data.getNightRingTime());
            extension.setXmpPId(data.getXmpPId());
            extension.setAssignedUser(data.getAssignedUser());
            extension.setSmsText(data.getSmsText());
            extension.setIsSent(data.getIsSent());
            extension.setNoOfRetry(data.getNoOfRetry());
            extension.setUrl(data.getUrl());
            extension.setDialNumber(data.getDialNumber());
            extension.setSmsNumber(data.getSmsNumber());
            extension.setStar(data.getStar());
            extension.setParkExpiryInterval(data.getParkExpiryInterval());
            extension.setDestinationStrip(data.getDestinationStrip());
            extension.setOutboundGatewayGroup(data.getOutboundGatewayGroup());
            extension.setMaxChannel(data.getMaxChannel());
            extension.setIsCliBaseRouting(data.getIsCliBaseRouting());
            extension.setIsCallCenterBased(data.getIsCallCenterBased());
            extension.setStrategy(data.getStrategy());
            extension.setRestrictFeatureAccess(data.getRestrictFeatureAccess());
            extension.setVoicemail(data.getVoicemail());
            extension.setQueryOn(data.getQueryOn());
            extension.setRetryVoiceMessage(data.getRetryVoiceMessage());
            extension.setGatewayControllerCode(data.getGatewayControllerCode());
            extension.setDenyPwdPrompt(data.getDenyPwdPrompt());
            extension.setTpi(data.getTpi());
            extension.setRingReady(data.getRingReady());
            extension.setOverrideMoh(data.getOverrideMoh());
            extension.setIsExtensionBasedAcd(data.getIsExtensionBasedAcd());
            extension.setDniBasedRouting(data.getDniBasedRouting());
            extension.setSide(data.getSide());
            extension.setPhysicalPlayerName(data.getPhysicalPlayerName());
            extension.setLogicalPlayerName(data.getLogicalPlayerName());
            extension.setTransferToAgentRingBack(data.getTransferToAgentRingBack());
            extension.setRadioNetCode(data.getRadioNetCode());
            extension.setHandleIsDnCause(data.getHandleIsDnCause());
            extension.setNetType(data.getNetType());
            extension.setRemoteUserIp(data.getRemoteUserIp());
            extension.setRemoteUserType(data.getRemoteUserType());
            extension.setNoAnsSmsTry(data.getNoAnsSmsTry());
            extension.setDialType(data.getDialType());
            extension.setEnableVideoCall(data.getEnableVideoCall());
            extension.setMasterCli(data.getMasterCli());
            extension.setUNma(data.getUNma());
            extension.setHomeRluCode(data.getHomeRluCode());
            extension.setSgwUser(data.getSgwUser());
            extension.setRegisterState(data.getRegisterState());
            extension.setIvrGroup(data.getIvrGroup());
            extension.setHotelLevel(data.getLevel());
            extension.setMissCallRedial(data.getMissCallRedial());
            extension.setMissCallDialDestination(data.getMissCallDialDestination());
            extension.setVmDiskQuota(data.getVmDiskQuota());
            extension.setWebApi(data.getWebApi());
            extension.setNoAnswerOverflowToBoss(data.getNoAnswerOverflowToBoss());
            extension.setPassword(data.getPassword());
            extension.setSipPassword(data.getSipPassword());
            extension.setVmPassword(data.getVmPassword());
            extension.setZone(data.getZone());
            extension.setExtensionIp(data.getExtensionIp());
            extension.setExtensionPort(data.getExtensionPort());
            extension.setTimezone(data.getTimezone());
            extension.setSunFromTime(data.getSunFromTime());
            extension.setSunToTime(data.getSunToTime());
            extension.setExtensionSubtype(data.getExtensionSubtype());
            extension.setIMSI(data.getIMSI());
            extension.setKValue(data.getKValue());
            extension.setOPopc(data.getOPopc());
            extension.setMsiSdn(data.getMsiSdn());
            extension.setPremiumCustomer(data.getPremiumCustomer());
            extension.setGroupType(data.getGroupType());
            extension.setIsFeedBack(data.getIsFeedBack());
            extension.setExtGroupCode(data.getExtGroupCode());
            extension.setPrimaryNightInboundCos(data.getPrimaryNightInboundCos());
            extension.setPrimaryNightOutboundCos(data.getPrimaryNightOutboundCos());
            extension.setXmpPPassword(data.getXmpPPassword());
            extension.setTransferNumber(data.getData());
            extension.setIvrPassword(data.getPassword());
            extension.setDidNumber(data.getDidNumber());
            extension.setDodNumber(data.getDodNumber());
            if (!this.extensionsServicesRepository.findAllByExtension(data.getExtension()).isEmpty() && !(extensionsServicesList = this.extensionsServicesRepository.findAllByExtension(data.getExtension())).isEmpty()) {
                boolean cfa = false;
                boolean intercom = false;
                boolean isd = false;
                boolean local = false;
                boolean std = false;
                String cfaData = null;
                for (ExtensionsServices extensionService : extensionsServicesList) {
                    switch (extensionService.getServiceCode()) {
                        case "fwd-all": {
                            cfa = true;
                            cfaData = extensionService.getData();
                            break;
                        }
                        case "dialing-intercom": {
                            intercom = true;
                            break;
                        }
                        case "dialing-isd": {
                            isd = true;
                            break;
                        }
                        case "dialing-local": {
                            local = true;
                            break;
                        }
                        case "dialing-std": {
                            std = true;
                        }
                    }
                }
                extension.setCfa(Boolean.valueOf(cfa));
                extension.setCfaData(cfaData);
                extension.setIntercom(Boolean.valueOf(intercom));
                extension.setIsd(Boolean.valueOf(isd));
                extension.setLocal(Boolean.valueOf(local));
                extension.setStd(Boolean.valueOf(std));
            }
            addValue.add(extension);
        }
        return addValue;
    }
}

