/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.externalApi.controller;

import com.coraltele.db.telephony.pbx.entity.Extension;
import com.coraltele.db.telephony.pbx.repository.ExtensionsRepository;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.helper.Telephony;
import com.coraltele.service.coralApps.pbx.service.CDRService;
import com.coraltele.service.externalApi.model.ClickToCall;
import com.coraltele.service.externalApi.service.ExternalApiService;
import com.coraltele.service.gis.service.GISService;
import com.coraltele.service.pbx.controlRluServer.service.ControlRluServerService;
import com.coraltele.service.pbx.extension.service.ExtensionsService;
import java.text.MessageFormat;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/v2/externalApi", "/app/v2/externalApi"})
@RestController
public class ExternalApiController {
    private static final Logger logger = LogManager.getLogger(ExternalApiController.class);
    @Autowired
    private ExternalApiService externalApiService;
    @Autowired
    private ControlRluServerService controlRluServerService;
    @Autowired
    private ExtensionsService extensionsService;
    @Autowired
    private GISService gisService;
    @Autowired
    CDRService cdrService;
    @Autowired
    ExtensionsRepository extensionsRepository;

    @PostMapping(value={"/callBack"})
    public ResponseEntity<RequestResponse> getCallBack(Authentication authentication) {
        RequestResponse returnValue = this.externalApiService.getCallBack(authentication);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/syncLDAP"})
    public ResponseEntity<RequestResponse> getLDAP() {
        RequestResponse returnValue = this.externalApiService.get();
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/call"})
    public ResponseEntity<RequestResponse> clickToCall(@RequestBody ClickToCall data) {
        RequestResponse returnValue = new RequestResponse();
        logger.info("initiating clickToCall IP for {} and CLICK_TO_CALL_REMOTE_SERVER: {} Constants.CLICK_TO_CALL_REMOTE_IP : {}", (Object)Constants.CLICK_TO_CALL_IP, (Object)Constants.CLICK_TO_CALL_REMOTE_SERVER, (Object)Constants.CLICK_TO_CALL_REMOTE_IP);
        if (!data.getPredefinedAction().booleanValue()) {
            if (Constants.CLICK_TO_CALL_IP != null && (Constants.CLICK_TO_CALL_IP.equals("sip-server") || Constants.CLICK_TO_CALL_IP.isEmpty())) {
                if (Constants.BACKWARD_COMPATIBILITY.booleanValue()) {
                    String callerRluCode = "";
                    String rluIP = "";
                    callerRluCode = this.controlRluServerService.getRluCodeFinal(data.getCaller());
                    rluIP = this.controlRluServerService.getVirtualIp(callerRluCode);
                    String calleeName = this.extensionsService.getExtensionName(data.getCallee());
                    logger.info("execute clickToCall callerNumber: {} callee : {}  callee_rlu:{} rluip :{}", (Object)data.getCaller(), (Object)data.getCallee(), (Object)callerRluCode, (Object)rluIP);
                    if (!StringUtils.hasLength((String)calleeName) || calleeName == null) {
                        calleeName = data.getCallee();
                    }
                    String clickToCallRemoteServerCommand = String.format("fs_cli -H %s -x \"bgapi originate {absoulte_codec_string='PCMU,PCMA',origination_caller_id_number=%s,origination_caller_id_name='%s',coral_app=uccall}user/%s &transfer(%s)\"", rluIP, data.getCallee(), calleeName, data.getCaller(), data.getCallee());
                    logger.info("command to execute call :{}", (Object)clickToCallRemoteServerCommand);
                    Telephony.makeCallBackCall((String)clickToCallRemoteServerCommand);
                } else {
                    String sofiaProfile = "";
                    String rluCode = "";
                    rluCode = this.controlRluServerService.getRluCodeFinal(data.getCaller());
                    sofiaProfile = this.controlRluServerService.getProfileName(data.getCaller());
                    String rluIP = this.controlRluServerService.getVirtualIp(rluCode);
                    logger.info("sofiaProfile:{} rluCode:{} rluIP:{}", (Object)rluCode, (Object)sofiaProfile, (Object)rluIP);
                    String calleeName = this.extensionsService.getExtensionName(data.getCallee());
                    Optional extOptional = this.extensionsRepository.findByExtension(data.getCallee());
                    if (extOptional.isPresent() && ((Extension)extOptional.get()).getSgwUser() != null && ((Extension)extOptional.get()).getSgwUser().equals(true)) {
                        logger.info("sgwUser :{}", (Object)((Extension)extOptional.get()).getSgwUser());
                        String command = String.format("fs_cli -x \"bgapi originate {audio_codec_string='PCMU,H264',origination_caller_id_number=%s,origination_caller_id_name='%s'}user/%s %s XML calltransfer\"", data.getCallee(), calleeName, data.getCaller(), data.getCallee());
                        logger.info("command to execute call :{}", (Object)command);
                        Telephony.makeCallBackCall((String)command);
                    } else {
                        String command = String.format("fs_cli -x \"bgapi originate {audio_codec_string='PCMU,H264',origination_caller_id_number=%s,origination_caller_id_name='%s'}sofia/%s/%s@%s %s XML calltransfer\"", data.getCallee(), calleeName, sofiaProfile, data.getCaller(), rluIP, data.getCallee());
                        logger.info("command to execute call :{}", (Object)command);
                        Telephony.makeCallBackCall((String)command);
                    }
                }
            } else {
                String command = MessageFormat.format("sudo kamcmd dlg.bridge_dlg \"sip:{0}@{1};ucPhone={4}\" sip:{2}@{3}", data.getCaller(), Constants.CLICK_TO_CALL_IP, data.getCallee(), Constants.CLICK_TO_CALL_IP, data.getCallee());
                logger.info("command to execute call :{}", (Object)command);
                Telephony.makeCallBackCall((String)command);
            }
        } else {
            this.clickToCallPredefined(data);
        }
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/zonePaging"})
    public ResponseEntity<RequestResponse> zonePaging(@RequestBody ClickToCall data) {
        RequestResponse returnValue = new RequestResponse();
        this.gisService.dialZoneWithoutGIS(data.getCallee());
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    private ResponseEntity<RequestResponse> clickToCallPredefined(ClickToCall data) {
        RequestResponse returnValue = new RequestResponse();
        if (data.getCallee().equals("400")) {
            Telephony.makeCallBackCall((String)"fs_cli -x \"bgapi originate {origination_caller_id_number=505}sofia/internal_nib1/506@192.168.7.101 &playback('/home/coralswitch/queuesounds/broadcastmsg.wav')\"");
            Telephony.makeCallBackCall((String)"fs_cli -x \"bgapi originate {origination_caller_id_number=505}sofia/internal_nib1/517@192.168.7.101 &playback('/home/coralswitch/queuesounds/broadcastmsg.wav')\"");
            Telephony.makeCallBackCall((String)"fs_cli -x \"bgapi originate {origination_caller_id_number=505}sofia/internal_nib1/514@192.168.7.101 &playback('/home/coralswitch/queuesounds/broadcastmsg.wav')\"");
        }
        if (data.getCallee().equals("401")) {
            Telephony.makeCallBackCall((String)"fs_cli -x \"bgapi originate {origination_caller_id_number=505}sofia/internal_nib1/506@192.168.7.101 &conference(pa505)\"");
            Telephony.makeCallBackCall((String)"fs_cli -x \"bgapi originate {origination_caller_id_number=505}sofia/internal_nib1/517@192.168.7.101 &conference(pa505)\"");
            Telephony.makeCallBackCall((String)"fs_cli -x \"bgapi originate {origination_caller_id_number=505}sofia/internal_nib1/514@192.168.7.101 &conference(pa505)\"");
            Telephony.makeCallBackCall((String)"fs_cli -x \"bgapi originate {origination_caller_id_number=505}sofia/internal_nib1/505@192.168.7.101 &conference(nzpa505+flags{nomoh|endconf|moderator})\"");
        }
        if (data.getCallee().equals("300")) {
            Telephony.makeCallBackCall((String)"fs_cli -x \"bgapi originate {origination_caller_id_number=505}sofia/internal_nib1/508@192.168.7.101 &playback('/home/coralswitch/queuesounds/broadcastmsg.wav')\"");
            Telephony.makeCallBackCall((String)"fs_cli -x \"bgapi originate {origination_caller_id_number=505}sofia/internal_nib1/515@192.168.7.101 &playback('/home/coralswitch/queuesounds/broadcastmsg.wav')\"");
        }
        if (data.getCallee().equals("301")) {
            Telephony.makeCallBackCall((String)"fs_cli -x \"bgapi originate {origination_caller_id_number=505}sofia/internal_nib1/508@192.168.7.101 &conference(pa505)\"");
            Telephony.makeCallBackCall((String)"fs_cli -x \"bgapi originate {origination_caller_id_number=505}sofia/internal_nib1/515@192.168.7.101 &conference(pa505)\"");
            Telephony.makeCallBackCall((String)"fs_cli -x \"bgapi originate {origination_caller_id_number=505}sofia/internal_nib1/505@192.168.7.101 &conference(szpa505+flags{nomoh|endconf|moderator})\"");
        }
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }
}

