/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.coralApps.callcenter.queue.service;

import com.coraltele.db.coralapps.callcenter.entity.Queue;
import com.coraltele.db.coralapps.callcenter.entity.QueueTL;
import com.coraltele.db.coralapps.callcenter.repository.AgentQueueViewRepository;
import com.coraltele.db.coralapps.callcenter.repository.QueueRepository;
import com.coraltele.db.coralapps.callcenter.repository.QueueTLRepository;
import com.coraltele.db.coralapps.callcenter.specification.AgentQueueSpecification;
import com.coraltele.db.coralapps.callcenter.specification.QueueSpecification;
import com.coraltele.db.coralapps.main.entity.Agent;
import com.coraltele.db.coralapps.main.entity.Tiers;
import com.coraltele.db.coralapps.main.repository.AgentRepository;
import com.coraltele.db.coralapps.main.repository.TiersRepository;
import com.coraltele.db.telephony.pbx.entity.DidMapping;
import com.coraltele.db.telephony.pbx.entity.Extension;
import com.coraltele.db.telephony.pbx.repository.DidMappingRepository;
import com.coraltele.db.telephony.pbx.repository.ExtensionsRepository;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.coralApps.callcenter.queue.model.AgentPositionModel;
import com.coraltele.service.coralApps.callcenter.queue.model.AgentQueueModel;
import com.coraltele.service.coralApps.callcenter.queue.model.QueueACDModel;
import com.coraltele.service.coralApps.callcenter.queue.model.QueueDropDownModel;
import com.coraltele.service.coralApps.callcenter.queue.model.QueueModel;
import com.coraltele.service.coralApps.callcenter.queue.model.QueueServicesModel;
import com.coraltele.service.coralApps.callcenter.queue.model.TiersPositionModel;
import com.coraltele.service.coralApps.main.service.AgentService;
import com.coraltele.service.user.service.UserService;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.Principal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class QueueService {
    private static final Logger logger = LogManager.getLogger(QueueService.class);
    @Autowired
    QueueRepository queueRepository;
    @Autowired
    ExtensionsRepository extensionsRepository;
    @Autowired
    DidMappingRepository didMappingRepository;
    @Autowired
    AgentService agentService;
    @Autowired
    TiersRepository tiersRepository;
    @Autowired
    AgentQueueViewRepository agentQueueRepository;
    @Autowired
    AgentRepository agentRepository;
    @Autowired
    QueueTLRepository queueTLRepository;
    @Autowired
    UserService userService;

    public RequestResponse create(QueueServicesModel data, Principal principal) throws RuntimeException {
        RequestResponse returnValue = new RequestResponse();
        if (data == null || data.getAcdNumber().trim().isEmpty() || data.getAcdNumber() == null || data.getDescription() == null) {
            returnValue.setStatus(Constants.Error.UNKNOWN_ERROR);
            returnValue.setMessage("parameter is required.");
            returnValue.setMessageDetail("Please provide a valid ACD Number with description.");
            logger.info(returnValue.getMessageDetail());
            return returnValue;
        }
        if (data.getFrom() != null && data.getTo() != null) {
            Integer from = Integer.parseInt(data.getFrom());
            Integer to = Integer.parseInt(data.getTo());
            Integer acdNumber = Integer.parseInt(data.getAcdNumber());
            if (acdNumber >= from && acdNumber <= to) {
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("Unable to Create Agents");
                returnValue.setMessageDetail("ACD Number should be different the range of 'From' to 'To'.");
                logger.info("ACD Number should be outside the range of 'From' to 'To'.");
                return returnValue;
            }
            boolean checkExtensionRange = this.agentService.checkExtensionsFromGivenRangeForAgent(data);
            if (checkExtensionRange) {
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("Unable to Create Agents");
                returnValue.setMessageDetail("Extension range already exists.");
                logger.info("unable to create agents, already exist");
                return returnValue;
            }
        }
        List listOfAcd = this.extensionsRepository.findByExtensionType("acd");
        Optional acdNumber = this.extensionsRepository.findByExtension(data.getAcdNumber());
        List didExtNumber = this.didMappingRepository.findAllByExtNumber(data.getAcdNumber());
        String system = null;
        try {
            if (acdNumber.isPresent()) {
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("Unable to create extension");
                returnValue.setMessageDetail("ACD Number Already Exists");
                logger.info("unable to create extension");
            } else if (didExtNumber.size() >= 1) {
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("Unable to create DidMapping");
                returnValue.setMessageDetail("Already exist");
                logger.info("unable to create DidMapping");
            } else {
                Optional checkDefaultQueue;
                if (data.getAcdNumber() != null) {
                    List oldTiers;
                    Extension extension = new Extension();
                    extension.setExtension(data.getAcdNumber());
                    extension.setExtensionType("acd");
                    ArrayList<String> possibleValues = new ArrayList<String>();
                    for (int i = 1; i <= 50; ++i) {
                        possibleValues.add(String.valueOf(i));
                    }
                    for (Extension ext : listOfAcd) {
                        possibleValues.remove(ext.getData());
                    }
                    if (possibleValues.isEmpty()) {
                        extension.setData("");
                        logger.info("Queue list is full,delete old records!!");
                    }
                    extension.setData((String)possibleValues.get(0));
                    system = (String)possibleValues.get(0);
                    Optional oldQueue = this.queueRepository.findBySystemName(system);
                    if (oldQueue.isPresent()) {
                        this.queueRepository.delete(oldQueue.get());
                        logger.info("Old queue deleted for system name: {}", (Object)system);
                    }
                    if (!(oldTiers = this.tiersRepository.findByQueue(system)).isEmpty()) {
                        for (Tiers tier : oldTiers) {
                            this.tiersRepository.delete((Object)tier);
                        }
                        logger.info("Old tiers deleted for queue: {}", (Object)system);
                    }
                    if (data.getFrom() != null && data.getTo() != null) {
                        RequestResponse agentResponse = this.agentService.createExtensionAgentByGivenRange(data, principal);
                        if (agentResponse.getStatus().equals((Object)Constants.Error.OK)) {
                            for (int i = Integer.parseInt(data.getFrom()); i <= Integer.parseInt(data.getTo()); ++i) {
                                Tiers tier = new Tiers();
                                tier.setAgent(String.valueOf(i));
                                tier.setQueue(system);
                                tier.setState("Ready");
                                tier.setLevel(Integer.valueOf(1));
                                tier.setPosition(Integer.valueOf(1));
                                this.tiersRepository.save((Object)tier);
                            }
                        } else {
                            returnValue.setStatus(Constants.Error.ERROR);
                            returnValue.setMessage("Unable to Create Agents");
                            returnValue.setMessageDetail(agentResponse.getMessageDetail());
                            logger.info("error during creation of agent: {}", (Object)agentResponse.getMessageDetail());
                            return returnValue;
                        }
                    }
                    this.extensionsRepository.save((Object)extension);
                }
                if (data.getDidNumber() != null || data.getDodNumber() != null) {
                    String joinedDidNumber = data.getDidNumber();
                    String joinedDodNumber = data.getDodNumber();
                    List<String> didNumbers = Arrays.asList(joinedDidNumber.split(","));
                    List<String> dodNumbers = Arrays.asList(joinedDodNumber.split(","));
                    int maxSize = Math.max(didNumbers.size(), dodNumbers.size());
                    for (int i = 0; i < maxSize; ++i) {
                        String didNumber = i < didNumbers.size() ? didNumbers.get(i) : "";
                        String dodNumber = i < dodNumbers.size() ? dodNumbers.get(i) : "";
                        DidMapping didMapping = new DidMapping();
                        didMapping.setDidNumber(didNumber);
                        didMapping.setDodNumber(dodNumber);
                        didMapping.setExtNumber(data.getAcdNumber());
                        this.didMappingRepository.save((Object)didMapping);
                    }
                }
                Queue queue = new Queue();
                queue.setCreatedOn(LocalDateTime.now());
                queue.setDescription(data.getDescription());
                queue.setSystemName(system);
                queue.setRecord(data.getRecord());
                queue.setTimeBaseScore("system");
                queue.setMaxWaitTime(Integer.valueOf(0));
                queue.setMaxWaitTimeWithNoAgent(Integer.valueOf(0));
                queue.setMaxWaitTimeWithNoAgentTimeReached(Integer.valueOf(5));
                queue.setTierRulesApply(Boolean.valueOf(false));
                queue.setTierRuleWaitSecond(Integer.valueOf(300));
                queue.setTierRuleWaitMultiplyLevel(Boolean.valueOf(true));
                queue.setTierRuleNoAgentNoWait(Boolean.valueOf(false));
                queue.setDiscardAbandonedAfter(Integer.valueOf(60));
                queue.setAbandonedResumeAllowed(Boolean.valueOf(false));
                queue.setAdvertiseDialing(Boolean.valueOf(false));
                queue.setRbTonAgentTrying(Boolean.valueOf(false));
                queue.setIsPlayPosition(Boolean.valueOf(false));
                queue.setStrategy("longest-ideal-agent");
                queue.setDispositionForm(data.getDispositionForm());
                queue.setAcdType(data.getAcdType());
                if (data.getMohSound() != null) {
                    queue.setMohSound("/home/coralswitch/queuesounds/" + data.getMohSound());
                }
                queue.setShortCode(data.getShortCode());
                queue.setQueueType(data.getQueueType());
                queue.setPaceRatio(BigDecimal.valueOf(1.0));
                if (data.getAcdType() != null && data.getAcdType() != 0) {
                    queue.setIsDisabled(Boolean.valueOf(true));
                    queue.setDialingActive(Boolean.valueOf(true));
                    queue.setIsAutoAns(Boolean.valueOf(false));
                }
                this.queueRepository.save((Object)queue);
                if (data.getDefaultQueue() != null && StringUtils.hasText((String)data.getDefaultQueue()) && !(checkDefaultQueue = this.queueRepository.findBySystemName(data.getDefaultQueue())).isPresent()) {
                    this.createQueue(data);
                }
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage(" created");
                returnValue.setMessageDetail("created successfully");
                logger.info(returnValue.getMessageDetail());
            }
        }
        catch (Exception ex) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Can't Create ");
            returnValue.setMessageDetail("something went wrong");
            logger.error(returnValue.getMessageDetail(), (Throwable)ex);
        }
        return returnValue;
    }

    public RequestResponse updateById(QueueModel data) {
        logger.debug("Update queue {}", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        Optional queue = this.queueRepository.findById(data.getId());
        if (!queue.isPresent()) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("not found");
            returnValue.setMessageDetail("selected data not found");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        if (StringUtils.hasLength((String)data.getSystemName()) && this.isQueueExist(data.getSystemName(), ((Queue)queue.get()).getSystemName())) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("selected queue already assigned");
            returnValue.setMessageDetail("select different queue");
            logger.error(returnValue.getMessage());
            return returnValue;
        }
        try {
            Optional queueOptional;
            Optional acdNumber;
            Object extension;
            if (data.getCreatedBy() != null) {
                ((Queue)queue.get()).setCreatedBy(data.getCreatedBy());
            }
            if (data.getDispositionForm() != null) {
                ((Queue)queue.get()).setDispositionForm(data.getDispositionForm());
            }
            if (data.getIsDisabled() != null) {
                ((Queue)queue.get()).setIsDisabled(data.getIsDisabled());
            }
            if (data.getDialingActive() != null) {
                ((Queue)queue.get()).setDialingActive(data.getDialingActive());
            }
            if (data.getDispositionUrl() != null) {
                ((Queue)queue.get()).setDispositionUrl(data.getDispositionUrl());
            }
            if (data.getPaceRatio() != null) {
                ((Queue)queue.get()).setPaceRatio(data.getPaceRatio());
            }
            if (data.getIsAutoAns() != null) {
                ((Queue)queue.get()).setIsAutoAns(data.getIsAutoAns());
            }
            if (data.getTransferMode() != null) {
                ((Queue)queue.get()).setTransferMode(data.getTransferMode());
            }
            if (data.getTimeOfDay() != null) {
                ((Queue)queue.get()).setTimeOfDay(data.getTimeOfDay());
            }
            if (data.getWDay() != null) {
                ((Queue)queue.get()).setWDay(data.getWDay());
            }
            if (data.getDialOutNum() != null) {
                ((Queue)queue.get()).setDialOutNum(data.getDialOutNum());
            }
            if (data.getCliDialOut() != null) {
                ((Queue)queue.get()).setCliDialOut(data.getCliDialOut());
            }
            if (data.getDMon() != null) {
                ((Queue)queue.get()).setDMon(Integer.valueOf(data.getDMon() != false ? 1 : 0));
            }
            if (data.getDTue() != null) {
                ((Queue)queue.get()).setDTue(Integer.valueOf(data.getDTue() != false ? 1 : 0));
            }
            if (data.getDWed() != null) {
                ((Queue)queue.get()).setDWed(Integer.valueOf(data.getDWed() != false ? 1 : 0));
            }
            if (data.getDThu() != null) {
                ((Queue)queue.get()).setDThu(Integer.valueOf(data.getDThu() != false ? 1 : 0));
            }
            if (data.getDFri() != null) {
                ((Queue)queue.get()).setDFri(Integer.valueOf(data.getDFri() != false ? 1 : 0));
            }
            if (data.getDSat() != null) {
                ((Queue)queue.get()).setDSat(Integer.valueOf(data.getDSat() != false ? 1 : 0));
            }
            if (data.getDSun() != null) {
                ((Queue)queue.get()).setDSun(Integer.valueOf(data.getDSun() != false ? 1 : 0));
            }
            if (data.getFromTime() != null) {
                ((Queue)queue.get()).setFromTime(data.getFromTime());
            }
            if (data.getToTime() != null) {
                ((Queue)queue.get()).setToTime(data.getToTime());
            }
            if (data.getNbhCallMode() != null) {
                ((Queue)queue.get()).setNbhCallMode(data.getNbhCallMode());
            }
            if (data.getIsDialingNbh() != null) {
                ((Queue)queue.get()).setIsDialingNbh(data.getIsDialingNbh());
            }
            if (data.getOutBoundQueue() != null) {
                ((Queue)queue.get()).setOutBoundQueue(data.getOutBoundQueue());
            }
            if (data.getAbdScheduler() != null) {
                ((Queue)queue.get()).setAbdScheduler(data.getAbdScheduler());
            }
            if (data.getNbhScheduler() != null) {
                ((Queue)queue.get()).setNbhScheduler(data.getNbhScheduler());
            }
            if (data.getAdvertiseDialing() != null) {
                ((Queue)queue.get()).setAdvertiseDialing(data.getAdvertiseDialing());
            }
            if (data.getStrategy() != null) {
                ((Queue)queue.get()).setStrategy(data.getStrategy());
            }
            if (data.getMohSound() != null) {
                ((Queue)queue.get()).setMohSound("/home/coralswitch/queuesounds/" + data.getMohSound());
            }
            if (data.getGreetingMessage() != null) {
                ((Queue)queue.get()).setGreetingMessage(data.getGreetingMessage());
            }
            if (data.getNbhMessage() != null) {
                ((Queue)queue.get()).setNbhMessage(data.getNbhMessage());
            }
            if (data.getRbTonAgentTrying() != null) {
                ((Queue)queue.get()).setRbTonAgentTrying(data.getRbTonAgentTrying());
            }
            if (data.getAllowPickUpCall() != null) {
                ((Queue)queue.get()).setAllowPickUpCall(data.getAllowPickUpCall());
            }
            if (data.getScriptPath() != null) {
                ((Queue)queue.get()).setScriptPath(data.getScriptPath());
            }
            if (data.getQueueMessage() != null) {
                ((Queue)queue.get()).setQueueMessage(data.getQueueMessage());
            }
            if (data.getCallAttendWaitTime() != null) {
                ((Queue)queue.get()).setCallAttendWaitTime(data.getCallAttendWaitTime());
            }
            if (data.getCallBackMessage() != null) {
                ((Queue)queue.get()).setCallBackMessage(data.getCallBackMessage());
            }
            if (data.getSmsText() != null) {
                ((Queue)queue.get()).setSmsText(data.getSmsText());
            }
            if (data.getSendSms() != null) {
                ((Queue)queue.get()).setSendSms(data.getSendSms());
            }
            if (data.getIsPlayPosition() != null) {
                ((Queue)queue.get()).setIsPlayPosition(data.getIsPlayPosition());
            }
            if (data.getNoAgentMessage() != null) {
                ((Queue)queue.get()).setNoAgentMessage(data.getNoAgentMessage());
            }
            if (data.getNoWaitNoIdleAgent() != null) {
                ((Queue)queue.get()).setNoWaitNoIdleAgent(data.getNoWaitNoIdleAgent());
            }
            if (data.getThirdPartyUrl() != null) {
                ((Queue)queue.get()).setThirdPartyUrl(data.getThirdPartyUrl());
            }
            if (data.getDescription() != null) {
                ((Queue)queue.get()).setDescription(data.getDescription());
            }
            if (data.getSystemName() != null) {
                if (StringUtils.hasLength((String)data.getSystemName()) && !(extension = this.extensionsRepository.findByData(data.getSystemName())).isEmpty()) {
                    Extension extensionData = (Extension)extension.get(0);
                    extensionData.setData(data.getSystemName());
                    this.extensionsRepository.save((Object)extensionData);
                }
                ((Queue)queue.get()).setSystemName(data.getSystemName());
            }
            if (data.getTimeBaseScore() != null) {
                ((Queue)queue.get()).setTimeBaseScore(data.getTimeBaseScore());
            }
            if (data.getMaxWaitTime() != null) {
                ((Queue)queue.get()).setMaxWaitTime(data.getMaxWaitTime());
            }
            if (data.getMaxWaitTimeWithNoAgent() != null) {
                ((Queue)queue.get()).setMaxWaitTimeWithNoAgent(data.getMaxWaitTimeWithNoAgent());
            }
            if (data.getMaxWaitTimeWithNoAgentTimeReached() != null) {
                ((Queue)queue.get()).setMaxWaitTimeWithNoAgentTimeReached(data.getMaxWaitTimeWithNoAgentTimeReached());
            }
            if (data.getTierRulesApply() != null) {
                ((Queue)queue.get()).setTierRulesApply(data.getTierRulesApply());
            }
            if (data.getTierRuleWaitSecond() != null) {
                ((Queue)queue.get()).setTierRuleWaitSecond(data.getTierRuleWaitSecond());
            }
            if (data.getTierRuleWaitMultiplyLevel() != null) {
                ((Queue)queue.get()).setTierRuleWaitMultiplyLevel(data.getTierRuleWaitMultiplyLevel());
            }
            if (data.getTierRuleNoAgentNoWait() != null) {
                ((Queue)queue.get()).setTierRuleNoAgentNoWait(data.getTierRuleNoAgentNoWait());
            }
            if (data.getDiscardAbandonedAfter() != null) {
                ((Queue)queue.get()).setDiscardAbandonedAfter(data.getDiscardAbandonedAfter());
            }
            if (data.getAbandonedResumeAllowed() != null) {
                ((Queue)queue.get()).setAbandonedResumeAllowed(data.getAbandonedResumeAllowed());
            }
            if (data.getRecord() != null) {
                ((Queue)queue.get()).setRecord(data.getRecord());
            }
            if (data.getQueueType() != null) {
                ((Queue)queue.get()).setQueueType(data.getQueueType());
            }
            if (data.getShortCode() != null) {
                ((Queue)queue.get()).setShortCode(data.getShortCode());
            }
            if (data.getNbhCallMode() != null) {
                ((Queue)queue.get()).setNbhCallMode(data.getNbhCallMode());
            }
            if (data.getTransferMode() != null) {
                ((Queue)queue.get()).setTransferMode(data.getTransferMode());
            }
            if (data.getNbhMessage() != null) {
                ((Queue)queue.get()).setNbhMessage(data.getNbhMessage());
            }
            if (data.getQueueMessage() != null) {
                ((Queue)queue.get()).setQueueMessage(data.getQueueMessage());
            }
            if (data.getNoAgentMessage() != null) {
                ((Queue)queue.get()).setNoAgentMessage(data.getNoAgentMessage());
            }
            if (data.getCallBackMessage() != null) {
                ((Queue)queue.get()).setCallBackMessage(data.getCallBackMessage());
            }
            if (data.getCallAttendWaitTime() != null) {
                ((Queue)queue.get()).setCallAttendWaitTime(data.getCallAttendWaitTime());
            }
            if (data.getAllowPickUpCall() != null) {
                ((Queue)queue.get()).setAllowPickUpCall(data.getAllowPickUpCall());
            }
            if (data.getRbTonAgentTrying() != null) {
                ((Queue)queue.get()).setRbTonAgentTrying(data.getRbTonAgentTrying());
            }
            if (data.getNoWaitNoIdleAgent() != null) {
                ((Queue)queue.get()).setNoWaitNoIdleAgent(data.getNoWaitNoIdleAgent());
            }
            if (data.getAdvertiseDialing() != null) {
                ((Queue)queue.get()).setAdvertiseDialing(data.getAdvertiseDialing());
            }
            if (data.getAcdNumber() != null && StringUtils.hasLength((String)data.getAcdNumber()) && ((Optional)(extension = this.extensionsRepository.findByExtension(data.getAcdNumber()))).isPresent()) {
                if (data.getDFri() != null) {
                    ((Extension)((Optional)extension).get()).setDFri(Integer.valueOf(data.getDFri() != false ? 1 : 0));
                }
                if (data.getDMon() != null) {
                    ((Extension)((Optional)extension).get()).setDMon(Integer.valueOf(data.getDMon() != false ? 1 : 0));
                }
                if (data.getDSat() != null) {
                    ((Extension)((Optional)extension).get()).setDSat(Integer.valueOf(data.getDSat() != false ? 1 : 0));
                }
                if (data.getDSun() != null) {
                    ((Extension)((Optional)extension).get()).setDSun(Integer.valueOf(data.getDSun() != false ? 1 : 0));
                }
                if (data.getDThu() != null) {
                    ((Extension)((Optional)extension).get()).setDThu(Integer.valueOf(data.getDThu() != false ? 1 : 0));
                }
                if (data.getDTue() != null) {
                    ((Extension)((Optional)extension).get()).setDTue(Integer.valueOf(data.getDTue() != false ? 1 : 0));
                }
                if (data.getDWed() != null) {
                    ((Extension)((Optional)extension).get()).setDWed(Integer.valueOf(data.getDWed() != false ? 1 : 0));
                }
                if (data.getFlexibleTimings() != null) {
                    ((Extension)((Optional)extension).get()).setFlexibleTimings(data.getFlexibleTimings());
                }
                if (data.getFriFromTime() != null) {
                    ((Extension)((Optional)extension).get()).setFriFromTime(data.getFriFromTime());
                }
                if (data.getFriToTime() != null) {
                    ((Extension)((Optional)extension).get()).setFriToTime(data.getFriToTime());
                }
                if (data.getFromTime() != null) {
                    ((Extension)((Optional)extension).get()).setFromTime(data.getFromTime());
                }
                if (data.getMonFromTime() != null) {
                    ((Extension)((Optional)extension).get()).setMonFromTime(data.getMonFromTime());
                }
                if (data.getMonToTime() != null) {
                    ((Extension)((Optional)extension).get()).setMonToTime(data.getMonToTime());
                }
                if (data.getSatFromTime() != null) {
                    ((Extension)((Optional)extension).get()).setSatFromTime(data.getSatFromTime());
                }
                if (data.getSatToTime() != null) {
                    ((Extension)((Optional)extension).get()).setSatToTime(data.getSatToTime());
                }
                if (data.getSunFromTime() != null) {
                    ((Extension)((Optional)extension).get()).setSunFromTime(data.getSunFromTime());
                }
                if (data.getSunToTime() != null) {
                    ((Extension)((Optional)extension).get()).setSunToTime(data.getSunToTime());
                }
                if (data.getThuFromTime() != null) {
                    ((Extension)((Optional)extension).get()).setThuFromTime(data.getThuFromTime());
                }
                if (data.getThuToTime() != null) {
                    ((Extension)((Optional)extension).get()).setThuToTime(data.getThuToTime());
                }
                if (data.getTimezone() != null) {
                    ((Extension)((Optional)extension).get()).setTimezone(data.getTimezone());
                }
                if (data.getToTime() != null) {
                    ((Extension)((Optional)extension).get()).setToTime(data.getToTime());
                }
                if (data.getTueFromTime() != null) {
                    ((Extension)((Optional)extension).get()).setTueFromTime(data.getTueFromTime());
                }
                if (data.getTueToTime() != null) {
                    ((Extension)((Optional)extension).get()).setTueToTime(data.getTueToTime());
                }
                if (data.getWedFromTime() != null) {
                    ((Extension)((Optional)extension).get()).setWedFromTime(data.getWedFromTime());
                }
                if (data.getWedToTime() != null) {
                    ((Extension)((Optional)extension).get()).setWedToTime(data.getWedToTime());
                }
                if (data.getNonWorkingApp() != null) {
                    ((Extension)((Optional)extension).get()).setNonworkingApp(data.getNonWorkingApp());
                }
                if (data.getNonWorkingData() != null) {
                    ((Extension)((Optional)extension).get()).setNonworkingData(data.getNonWorkingData());
                }
                this.extensionsRepository.save(((Optional)extension).get());
            }
            if ((StringUtils.hasLength((String)data.getDidNumber()) || StringUtils.hasLength((String)data.getDodNumber())) && data.getAcdNumber() != null && StringUtils.hasLength((String)data.getAcdNumber()) && (acdNumber = this.extensionsRepository.findByExtension(data.getAcdNumber())).isPresent()) {
                List didExtNumber = this.didMappingRepository.findAllByExtNumber(data.getAcdNumber());
                for (DidMapping didMappingData : didExtNumber) {
                    this.didMappingRepository.delete((Object)didMappingData);
                }
                String joinedDidNumber = data.getDidNumber();
                String joinedDodNumber = data.getDodNumber();
                List<String> didNumbers = Arrays.asList(joinedDidNumber.split(","));
                List<String> dodNumbers = Arrays.asList(joinedDodNumber.split(","));
                int maxSize = Math.max(didNumbers.size(), dodNumbers.size());
                for (int i = 0; i < maxSize; ++i) {
                    String didNumber = i < didNumbers.size() ? didNumbers.get(i) : "";
                    String dodNumber = i < dodNumbers.size() ? dodNumbers.get(i) : "";
                    DidMapping didMapping = new DidMapping();
                    didMapping.setDidNumber(didNumber);
                    didMapping.setDodNumber(dodNumber);
                    didMapping.setExtNumber(data.getAcdNumber());
                    this.didMappingRepository.save((Object)didMapping);
                }
            }
            this.queueRepository.save(queue.get());
            if (data.getSystemName() != null && StringUtils.hasLength((String)data.getSystemName()) && (queueOptional = this.queueRepository.findBySystemName(data.getSystemName())).isPresent()) {
                String queueValue = ((Queue)queueOptional.get()).getSystemName();
                List tiers = this.tiersRepository.findByQueue(queueValue);
                for (Tiers tier : tiers) {
                    String defaultQueue;
                    Optional queueOptional1;
                    Optional agent = this.agentRepository.findByName(tier.getAgent());
                    if (!agent.isPresent() || !(queueOptional1 = this.queueRepository.findBySystemName(defaultQueue = ((Agent)agent.get()).getDefaultQueue())).isPresent()) continue;
                    if (data.getDispositionForm() != null) {
                        ((Queue)queueOptional1.get()).setDispositionForm(data.getDispositionForm());
                    }
                    if (data.getDispositionUrl() != null) {
                        ((Queue)queueOptional1.get()).setDispositionUrl(data.getDispositionUrl());
                    }
                    this.queueRepository.save(queueOptional1.get());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Error on updating data");
            logger.error("ERROR:{},{}", (Object)e.getMessage(), (Object)returnValue.getMessage());
            return returnValue;
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("service updated successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getList(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = QueueSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.getSortDirection().equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.getSortDirection().equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.queueRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.queueRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)page.getContent());
        returnValue.setData((Object)responseData);
        logger.info("filter list returned!");
        return returnValue;
    }

    public RequestResponse deleteQueue(Integer id) {
        RequestResponse returnValue = new RequestResponse();
        Optional data = this.queueRepository.findById(id);
        List didMapping = new ArrayList();
        if (data.isPresent()) {
            Optional extension = this.extensionsRepository.findByExtensionTypeAndData("acd", ((Queue)data.get()).getSystemName());
            if (extension.isPresent()) {
                didMapping = this.didMappingRepository.findAllByExtNumber(((Extension)extension.get()).getExtension());
                this.extensionsRepository.delete(extension.get());
            }
            for (DidMapping didMapping2 : didMapping) {
                this.didMappingRepository.deleteById((Object)didMapping2.getId());
            }
            this.queueRepository.deleteById((Object)((Queue)data.get()).getId());
            List tiers = this.tiersRepository.findByQueue(((Queue)data.get()).getSystemName());
            if (!tiers.isEmpty()) {
                for (Tiers tier : tiers) {
                    this.tiersRepository.delete((Object)tier);
                }
            }
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("Deleted");
            returnValue.setMessageDetail("Queue deleted successfully");
            logger.info(returnValue.getMessage());
        } else {
            returnValue.setStatus(Constants.Error.BAD_CREDENTIAL);
            returnValue.setMessage("Unable to delete");
            returnValue.setMessageDetail(String.format("Queue not found : %s ", id));
            logger.info(returnValue.getMessage());
        }
        return returnValue;
    }

    public RequestResponse getById(int id) {
        RequestResponse returnValue = new RequestResponse();
        try {
            Optional queue = this.queueRepository.findById(Integer.valueOf(id));
            String a = ((Queue)queue.get()).getSystemName();
            List extension = this.extensionsRepository.findByData(a);
            if (!extension.isEmpty()) {
                Extension record = (Extension)extension.get(0);
                QueueModel data = new QueueModel();
                data.setFromTime(record.getFromTime());
                data.setToTime(record.getToTime());
                data.setTimezone(record.getTimezone());
                if (record.getDSun() == null || record.getDSun() == 0) {
                    data.setDSun(Boolean.valueOf(false));
                } else {
                    data.setDSun(Boolean.valueOf(true));
                }
                if (record.getDMon() == null || record.getDMon() == 0) {
                    data.setDMon(Boolean.valueOf(false));
                } else {
                    data.setDMon(Boolean.valueOf(true));
                }
                if (record.getDTue() == null || record.getDTue() == 0) {
                    data.setDTue(Boolean.valueOf(false));
                } else {
                    data.setDTue(Boolean.valueOf(true));
                }
                if (record.getDWed() == null || record.getDWed() == 0) {
                    data.setDWed(Boolean.valueOf(false));
                } else {
                    data.setDWed(Boolean.valueOf(true));
                }
                if (record.getDThu() == null || record.getDThu() == 0) {
                    data.setDThu(Boolean.valueOf(false));
                } else {
                    data.setDThu(Boolean.valueOf(true));
                }
                if (record.getDFri() == null || record.getDFri() == 0) {
                    data.setDFri(Boolean.valueOf(false));
                } else {
                    data.setDFri(Boolean.valueOf(true));
                }
                if (record.getDSat() == null || record.getDFri() == 0) {
                    data.setDSat(Boolean.valueOf(false));
                } else {
                    data.setDSat(Boolean.valueOf(true));
                }
                data.setNonWorkingApp(record.getNonworkingApp());
                data.setNonWorkingData(record.getNonworkingData());
                data.setFlexibleTimings(record.getFlexibleTimings());
                data.setSunFromTime(record.getSunFromTime());
                data.setSunToTime(record.getSunToTime());
                data.setMonFromTime(record.getMonFromTime());
                data.setMonToTime(record.getMonToTime());
                data.setTueFromTime(record.getTueFromTime());
                data.setTueToTime(record.getTueToTime());
                data.setWedFromTime(record.getWedFromTime());
                data.setWedToTime(record.getWedToTime());
                data.setThuFromTime(record.getThuFromTime());
                data.setThuToTime(record.getThuToTime());
                data.setFriFromTime(record.getFriFromTime());
                data.setFriToTime(record.getFriToTime());
                data.setSatFromTime(record.getSatFromTime());
                data.setSatToTime(record.getSatToTime());
                data.setId(Integer.valueOf(((Queue)queue.get()).getId()));
                data.setCreatedOn(((Queue)queue.get()).getCreatedOn());
                data.setCreatedBy(((Queue)queue.get()).getCreatedBy());
                data.setIsDisabled(((Queue)queue.get()).getIsDisabled());
                data.setDialingActive(((Queue)queue.get()).getDialingActive());
                data.setPaceRatio(((Queue)queue.get()).getPaceRatio());
                data.setIsAutoAns(((Queue)queue.get()).getIsAutoAns());
                data.setTransferMode(((Queue)queue.get()).getTransferMode());
                data.setTimeOfDay(((Queue)queue.get()).getTimeOfDay());
                data.setWDay(((Queue)queue.get()).getWDay());
                data.setDialOutNum(((Queue)queue.get()).getDialOutNum());
                data.setCliDialOut(((Queue)queue.get()).getCliDialOut());
                data.setFromTime(((Queue)queue.get()).getFromTime());
                data.setToTime(((Queue)queue.get()).getToTime());
                data.setNbhCallMode(((Queue)queue.get()).getNbhCallMode());
                data.setIsDialingNbh(((Queue)queue.get()).getIsDialingNbh());
                data.setOutBoundQueue(((Queue)queue.get()).getOutBoundQueue());
                data.setAbdScheduler(((Queue)queue.get()).getAbdScheduler());
                data.setNbhScheduler(((Queue)queue.get()).getNbhScheduler());
                data.setAdvertiseDialing(((Queue)queue.get()).getAdvertiseDialing());
                data.setStrategy(((Queue)queue.get()).getStrategy());
                if (((Queue)queue.get()).getMohSound() != null) {
                    String filePath = ((Queue)queue.get()).getMohSound();
                    int lastIndexOfSeparator = filePath.lastIndexOf(File.separator);
                    if (lastIndexOfSeparator != -1) {
                        String filename = filePath.substring(lastIndexOfSeparator + 1);
                        data.setMohSound(filename);
                    } else {
                        data.setMohSound(filePath);
                    }
                }
                data.setGreetingMessage(((Queue)queue.get()).getGreetingMessage());
                data.setNbhMessage(((Queue)queue.get()).getNbhMessage());
                data.setRbTonAgentTrying(((Queue)queue.get()).getRbTonAgentTrying());
                data.setAllowPickUpCall(((Queue)queue.get()).getAllowPickUpCall());
                data.setScriptPath(((Queue)queue.get()).getScriptPath());
                data.setQueueMessage(((Queue)queue.get()).getQueueMessage());
                data.setCallAttendWaitTime(((Queue)queue.get()).getCallAttendWaitTime());
                data.setCallBackMessage(((Queue)queue.get()).getCallBackMessage());
                data.setSmsText(((Queue)queue.get()).getSmsText());
                data.setSendSms(((Queue)queue.get()).getSendSms());
                data.setIsPlayPosition(((Queue)queue.get()).getIsPlayPosition());
                data.setNoAgentMessage(((Queue)queue.get()).getNoAgentMessage());
                data.setNoWaitNoIdleAgent(((Queue)queue.get()).getNoWaitNoIdleAgent());
                data.setThirdPartyUrl(((Queue)queue.get()).getThirdPartyUrl());
                data.setDescription(((Queue)queue.get()).getDescription());
                data.setSystemName(((Queue)queue.get()).getSystemName());
                data.setTimeBaseScore(((Queue)queue.get()).getTimeBaseScore());
                data.setMaxWaitTime(((Queue)queue.get()).getMaxWaitTime());
                data.setMaxWaitTimeWithNoAgent(((Queue)queue.get()).getMaxWaitTimeWithNoAgent());
                data.setMaxWaitTimeWithNoAgentTimeReached(((Queue)queue.get()).getMaxWaitTimeWithNoAgentTimeReached());
                data.setTierRulesApply(((Queue)queue.get()).getTierRulesApply());
                data.setTierRuleWaitSecond(((Queue)queue.get()).getTierRuleWaitSecond());
                data.setTierRuleWaitMultiplyLevel(((Queue)queue.get()).getTierRuleWaitMultiplyLevel());
                data.setTierRuleNoAgentNoWait(((Queue)queue.get()).getTierRuleNoAgentNoWait());
                data.setDiscardAbandonedAfter(((Queue)queue.get()).getDiscardAbandonedAfter());
                data.setAbandonedResumeAllowed(((Queue)queue.get()).getAbandonedResumeAllowed());
                data.setRecord(((Queue)queue.get()).getRecord());
                data.setShortCode(((Queue)queue.get()).getShortCode());
                data.setDispositionUrl(((Queue)queue.get()).getDispositionUrl());
                data.setNbhCallMode(((Queue)queue.get()).getNbhCallMode());
                data.setTransferMode(((Queue)queue.get()).getTransferMode());
                data.setNbhMessage(((Queue)queue.get()).getNbhMessage());
                data.setQueueMessage(((Queue)queue.get()).getQueueMessage());
                data.setNoAgentMessage(((Queue)queue.get()).getNoAgentMessage());
                data.setCallBackMessage(((Queue)queue.get()).getCallBackMessage());
                data.setCallAttendWaitTime(((Queue)queue.get()).getCallAttendWaitTime());
                data.setRbTonAgentTrying(((Queue)queue.get()).getRbTonAgentTrying());
                data.setNoWaitNoIdleAgent(((Queue)queue.get()).getNoWaitNoIdleAgent());
                data.setAdvertiseDialing(((Queue)queue.get()).getAdvertiseDialing());
                data.setDidNumber(this.getDidNumberAndDodNumber(((Queue)queue.get()).getSystemName(), "did"));
                data.setDodNumber(this.getDidNumberAndDodNumber(((Queue)queue.get()).getSystemName(), "dod"));
                data.setDispositionForm(((Queue)queue.get()).getDispositionForm());
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("Queue Found");
                returnValue.setData((Object)data);
                logger.info(returnValue.getMessage());
            } else {
                returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                returnValue.setMessage("Unable to return value");
                returnValue.setMessageDetail("Records not found");
                logger.info(returnValue.getMessageDetail());
            }
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.UNKNOWN_ERROR);
            returnValue.setMessage("Unable to return value");
            returnValue.setMessageDetail("contact with administrator");
            logger.info(returnValue.getMessage());
        }
        return returnValue;
    }

    public RequestResponse getAcdList(Principal principal) {
        RequestResponse returnValue = new RequestResponse();
        List tlList = this.queueTLRepository.findByTeamLeaderId(principal.getName());
        ArrayList<QueueACDModel> addValue = new ArrayList<QueueACDModel>();
        try {
            ArrayList queues = null;
            if (!this.userService.checkAdminUser(principal.getName()) && !this.userService.checkManagerUser(principal.getName())) {
                queues = new ArrayList();
                List queueTLData = this.queueTLRepository.findByTeamLeaderId(principal.getName());
                if (!queueTLData.isEmpty()) {
                    for (QueueTL row : queueTLData) {
                        Optional queueData;
                        if (row.getQueue() == null || !(queueData = this.queueRepository.findById(row.getQueue())).isPresent()) continue;
                        queues.add(queueData.get());
                    }
                } else {
                    logger.error("acd-queue list empty, first correct QueueTL association");
                }
            } else {
                queues = this.queueRepository.findAll();
            }
            if (!queues.isEmpty()) {
                for (Queue queue : queues) {
                    QueueACDModel data = new QueueACDModel();
                    Optional extension = this.extensionsRepository.findByExtensionTypeAndData("acd", queue.getSystemName());
                    if (!extension.isPresent() || ((Extension)extension.get()).getExtension() == null || ((Extension)extension.get()).getExtension().isEmpty()) continue;
                    data.setAcdNumber(((Extension)extension.get()).getExtension());
                    data.setId(queue.getId());
                    data.setDescription(queue.getDescription());
                    data.setShortCode(queue.getShortCode());
                    data.setQueue(queue.getSystemName());
                    data.setAcdType(queue.getAcdType());
                    addValue.add(data);
                }
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("ACD List");
                returnValue.setData(addValue);
                logger.info(returnValue.getMessage());
            } else {
                returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                returnValue.setMessage("Unable to return list");
                returnValue.setMessageDetail("Currently list is empty");
                logger.info(returnValue.getMessage());
            }
        }
        catch (Exception e) {
            logger.error("Error retrieving ACD list: {}", (Object)e.getMessage());
            returnValue.setStatus(Constants.Error.UNKNOWN_ERROR);
            returnValue.setMessage("Unable to return value");
            returnValue.setMessageDetail("Contact administrator");
        }
        return returnValue;
    }

    public RequestResponse getListAgentQueue(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = AgentQueueSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.sortDirection.equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.sortDirection.equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.agentQueueRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.agentQueueRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)page.getContent());
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse createTiers(AgentQueueModel data) {
        RequestResponse returnValue = new RequestResponse();
        if (data == null || data.getAgent().trim().isEmpty() || data.getQueue().trim().isEmpty()) {
            returnValue.setStatus(Constants.Error.UNKNOWN_ERROR);
            returnValue.setMessage("parameter is required.");
            returnValue.setMessageDetail("Please provide a existing agent and queue.");
            logger.info(returnValue.getMessageDetail());
            return returnValue;
        }
        logger.debug("retrieving agent and queue.");
        Optional queue = this.queueRepository.findBySystemName(data.getQueue());
        Optional agent = this.agentRepository.findByName(data.getAgent());
        if (!agent.isPresent()) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Not found ");
            returnValue.setMessageDetail("this agent not exist :" + data.getAgent());
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        if (!queue.isPresent()) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Not found ");
            returnValue.setMessageDetail("this queue not exist :" + data.getQueue());
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        Tiers tiers = new Tiers();
        tiers.setAgent(data.getAgent());
        tiers.setQueue(data.getQueue());
        tiers.setLevel(Integer.valueOf(1));
        tiers.setPosition(Integer.valueOf(1));
        tiers.setState("Ready");
        this.tiersRepository.save((Object)tiers);
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Updated ");
        returnValue.setMessageDetail("tier created successfully ");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse updatePosition(AgentPositionModel data) {
        RequestResponse returnValue = new RequestResponse();
        if (data == null || data.getAgent().trim().isEmpty() || data.getQueue().trim().isEmpty()) {
            returnValue.setStatus(Constants.Error.UNKNOWN_ERROR);
            returnValue.setMessage("Both parameter is required.");
            returnValue.setMessageDetail("Please provide a existing agent and queue.");
            logger.info(returnValue.getMessageDetail());
            return returnValue;
        }
        Optional tier = this.tiersRepository.findByAgentAndQueue(data.getAgent(), data.getQueue());
        if (!tier.isPresent()) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("record not found");
            returnValue.setMessageDetail("given agent and queue not exist");
            logger.info(returnValue.getMessageDetail());
            return returnValue;
        }
        if (data.getPosition() != null) {
            ((Tiers)tier.get()).setPosition(data.getPosition());
        }
        this.tiersRepository.save(tier.get());
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("tier updated successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public boolean isQueueExist(String systemName, String currentQueue) {
        if (systemName.equals(currentQueue)) {
            return false;
        }
        List listQueue = this.queueRepository.findAll();
        for (Queue data : listQueue) {
            if (!systemName.equals(data.getSystemName())) continue;
            return true;
        }
        return false;
    }

    public String getDidNumberAndDodNumber(String systemName, String type) {
        String acdNumber;
        List didMappingData;
        ArrayList<String> data = new ArrayList<String>();
        List extension = this.extensionsRepository.findByData(systemName);
        if (!extension.isEmpty() && !(didMappingData = this.didMappingRepository.findAllByExtNumber(acdNumber = ((Extension)extension.get(0)).getExtension())).isEmpty()) {
            for (DidMapping record : didMappingData) {
                if (type.equals("did")) {
                    data.add(record.getDidNumber());
                    continue;
                }
                data.add(record.getDodNumber());
            }
        }
        return String.join((CharSequence)",", data);
    }

    public RequestResponse getAll() {
        RequestResponse returnValue = new RequestResponse();
        ArrayList<QueueDropDownModel> addValue = new ArrayList<QueueDropDownModel>();
        List list = this.queueRepository.findAll();
        if (list != null && !list.isEmpty()) {
            for (Queue queue : list) {
                QueueDropDownModel data = new QueueDropDownModel();
                Optional extension = this.extensionsRepository.findByExtensionTypeAndData("acd", queue.getSystemName());
                if (!extension.isPresent() || ((Extension)extension.get()).getExtension() == null || ((Extension)extension.get()).getExtension().isEmpty()) continue;
                data.setId(Integer.valueOf(queue.getId()));
                data.setDescription(queue.getDescription());
                data.setSystemName(queue.getSystemName());
                addValue.add(data);
            }
            logger.info("queue list");
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("list of queue");
            returnValue.setData(addValue);
        } else {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Empty list of queue!");
            returnValue.setData(addValue);
            logger.error(returnValue.getMessage());
        }
        return returnValue;
    }

    public String getQueueDescription(Integer id) {
        Optional queue = this.queueRepository.findById(id);
        if (queue.isPresent()) {
            return ((Queue)queue.get()).getDescription() == null ? "" : ((Queue)queue.get()).getDescription();
        }
        return "";
    }

    public RequestResponse updatePositionInTiers(TiersPositionModel data, String arrowDirection) {
        logger.debug("Update Position {}", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        if (data.getId() == null) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Invalid input");
            returnValue.setMessageDetail("id1 must be provided");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        Optional tiers1 = this.tiersRepository.findById(data.getId());
        if (!tiers1.isPresent()) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Record not found");
            returnValue.setMessageDetail("Record not found");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        Tiers currentRecord = (Tiers)tiers1.get();
        Integer currentPosition = currentRecord.getPosition();
        switch (arrowDirection) {
            case "uppermost": {
                List allTiers = this.tiersRepository.findAllByOrderByPositionAsc();
                if (allTiers.isEmpty()) break;
                Tiers topRecord = (Tiers)allTiers.get(0);
                currentRecord.setPosition(topRecord.getPosition());
                topRecord.setPosition(currentPosition);
                this.tiersRepository.save((Object)topRecord);
                break;
            }
            case "up": {
                List aboveRecords = this.tiersRepository.findTopByPositionLessThanOrderByPositionDesc(currentPosition);
                if (aboveRecords.isEmpty()) break;
                Tiers above = (Tiers)aboveRecords.get(0);
                int abovePosition = above.getPosition();
                above.setPosition(currentPosition);
                currentRecord.setPosition(Integer.valueOf(abovePosition));
                this.tiersRepository.save((Object)above);
                break;
            }
            case "lowermost": {
                List allTiersDesc = this.tiersRepository.findAllByOrderByPositionDesc();
                if (allTiersDesc.isEmpty()) break;
                Tiers bottomRecord = (Tiers)allTiersDesc.get(0);
                currentRecord.setPosition(bottomRecord.getPosition());
                bottomRecord.setPosition(currentPosition);
                this.tiersRepository.save((Object)bottomRecord);
                break;
            }
            case "down": {
                List belowRecords = this.tiersRepository.findTopByPositionGreaterThanOrderByPositionAsc(currentPosition);
                if (belowRecords.isEmpty()) break;
                Tiers below = (Tiers)belowRecords.get(0);
                int belowPosition = below.getPosition();
                below.setPosition(currentPosition);
                currentRecord.setPosition(Integer.valueOf(belowPosition));
                this.tiersRepository.save((Object)below);
                break;
            }
            default: {
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("Invalid arrow direction");
                returnValue.setMessageDetail("Arrow direction must be 'uppermost', 'up', 'lowermost', or 'down'");
                logger.info(returnValue.getMessage());
                return returnValue;
            }
        }
        this.tiersRepository.save((Object)currentRecord);
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Updated");
        returnValue.setMessageDetail("Tiers updated successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse createDataInQueue(QueueModel data) {
        logger.debug("create new Queue : {} ", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        try {
            Optional existingQueueOpt = this.queueRepository.findBySystemName(data.getSystemName());
            if (existingQueueOpt.isPresent()) {
                Queue existingQueue = (Queue)existingQueueOpt.get();
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessageDetail("Queue with ACD Queue '" + data.getSystemName() + "' already exists: , Description: " + existingQueue.getDescription());
                logger.warn("Duplicate queue found for systemName={}", (Object)data.getSystemName());
                return returnValue;
            }
            Queue queue = new Queue();
            queue.setDescription(data.getDescription());
            queue.setSystemName(data.getSystemName());
            if (data.getIsDisabled() != null) {
                queue.setIsDisabled(data.getIsDisabled());
            } else {
                queue.setIsDisabled(Boolean.valueOf(false));
            }
            if (data.getDialingActive() != null) {
                queue.setDialingActive(data.getDialingActive());
            } else {
                queue.setDialingActive(Boolean.valueOf(false));
            }
            queue.setRecord(Boolean.valueOf(Boolean.TRUE.equals(data.getRecord())));
            if (data.getAdvertiseDialing() != null) {
                queue.setAdvertiseDialing(data.getAdvertiseDialing());
            } else {
                queue.setAdvertiseDialing(Boolean.valueOf(false));
            }
            queue.setDispositionUrl(data.getDispositionUrl());
            queue.setStrategy(data.getStrategy());
            queue.setShortCode(data.getShortCode());
            queue.setDispositionForm(data.getDispositionForm());
            this.queueRepository.save((Object)queue);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("OK");
            returnValue.setMessageDetail("Queue Created Successfully");
            logger.info(returnValue.getMessage());
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.BAD_CREDENTIAL);
            returnValue.setMessage("Unable to Create Queue");
            returnValue.setMessageDetail("Contact with Administrator");
            logger.error(returnValue.getMessageDetail(), (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse deleteQueueById(InputIdModel data) {
        RequestResponse response = new RequestResponse();
        ArrayList<Queue> queuesToDelete = new ArrayList<Queue>();
        ArrayList<Integer> notFoundIds = new ArrayList<Integer>();
        for (Integer id : data.getIntId()) {
            Optional optionalQueue = this.queueRepository.findById(id);
            if (!optionalQueue.isPresent()) {
                notFoundIds.add(id);
                continue;
            }
            Queue queue = (Queue)optionalQueue.get();
            String systemName = queue.getSystemName();
            List extensions = this.extensionsRepository.findByData(systemName);
            if (extensions != null && !extensions.isEmpty()) {
                extensions.forEach(extension -> extension.setData(null));
                this.extensionsRepository.saveAll((Iterable)extensions);
            }
            this.extensionsRepository.saveAll((Iterable)extensions);
            List tiers = this.tiersRepository.findByQueue(systemName);
            if (!tiers.isEmpty()) {
                this.tiersRepository.deleteAll((Iterable)tiers);
            }
            queuesToDelete.add(queue);
        }
        if (!queuesToDelete.isEmpty()) {
            this.queueRepository.deleteAll(queuesToDelete);
        }
        if (!notFoundIds.isEmpty()) {
            response.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            response.setMessage("Some records not found: " + notFoundIds);
        } else {
            response.setStatus(Constants.Error.OK);
            response.setMessage("OK");
        }
        response.setMessageDetail("Queue deletion process completed.");
        logger.info(response.getMessage());
        return response;
    }

    public RequestResponse updateQueueById(QueueModel data) {
        logger.debug("Update Queue {}", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        Optional queueOptional = this.queueRepository.findById(data.getId());
        if (!queueOptional.isPresent()) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Queue not found");
            returnValue.setMessageDetail("No Queue found with ID: " + data.getId());
            logger.warn(returnValue.getMessageDetail());
            return returnValue;
        }
        Queue queue = (Queue)queueOptional.get();
        if (data.getSystemName() != null && !data.getSystemName().equals(queue.getSystemName())) {
            Optional existingWithSystemName = this.queueRepository.findBySystemName(data.getSystemName());
            if (existingWithSystemName.isPresent()) {
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("Duplicate ACD Queue");
                returnValue.setMessageDetail("Queue with ACD Queue '" + data.getSystemName() + "' already exists. Description: " + ((Queue)existingWithSystemName.get()).getDescription());
                logger.warn("Duplicate systemName update attempt: {}", (Object)data.getSystemName());
                return returnValue;
            }
            queue.setSystemName(data.getSystemName());
        }
        queue.setDescription(data.getDescription());
        queue.setIsDisabled(data.getIsDisabled());
        queue.setDialingActive(data.getDialingActive());
        queue.setDispositionUrl(data.getDispositionUrl());
        queue.setStrategy(data.getStrategy());
        queue.setRecord(Boolean.valueOf(Boolean.TRUE.equals(data.getRecord())));
        queue.setShortCode(data.getShortCode());
        queue.setDispositionForm(data.getDispositionForm());
        if (data.getMohSound() != null) {
            queue.setMohSound("/home/coralswitch/queuesounds/" + data.getMohSound());
        } else {
            queue.setMohSound("/home/coralswitch/queuesounds/");
        }
        queue.setStrategy(data.getStrategy());
        queue.setTimeBaseScore(data.getTimeBaseScore());
        queue.setMaxWaitTime(data.getMaxWaitTime());
        queue.setMaxWaitTimeWithNoAgent(data.getMaxWaitTimeWithNoAgent());
        queue.setMaxWaitTimeWithNoAgentTimeReached(data.getMaxWaitTimeWithNoAgentTimeReached());
        queue.setTierRuleWaitSecond(data.getTierRuleWaitSecond());
        queue.setTierRulesApply(Boolean.valueOf(Boolean.TRUE.equals(data.getTierRulesApply())));
        queue.setTierRuleWaitMultiplyLevel(Boolean.valueOf(Boolean.TRUE.equals(data.getTierRuleWaitMultiplyLevel())));
        queue.setTierRuleNoAgentNoWait(Boolean.valueOf(Boolean.TRUE.equals(data.getTierRuleNoAgentNoWait())));
        queue.setDiscardAbandonedAfter(data.getDiscardAbandonedAfter());
        queue.setAllowPickUpCall(Boolean.valueOf(Boolean.TRUE.equals(data.getAllowPickUpCall())));
        queue.setAbandonedResumeAllowed(Boolean.valueOf(Boolean.TRUE.equals(data.getAbandonedResumeAllowed())));
        queue.setExtension(data.getExtension());
        queue.setDialingActive(Boolean.valueOf(Boolean.TRUE.equals(data.getDialingActive())));
        queue.setTransferMode(data.getTransferMode());
        queue.setPaceRatio(data.getPaceRatio());
        queue.setNbhCallMode(data.getNbhCallMode());
        queue.setGreetingMessage(data.getGreetingMessage());
        queue.setNbhMessage(data.getNbhMessage());
        queue.setQueueMessage(data.getQueueMessage());
        queue.setDispositionUrl(data.getDispositionUrl());
        queue.setNbhCallMode(data.getNbhCallMode());
        this.queueRepository.save((Object)queue);
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Updated");
        returnValue.setMessageDetail("Queue updated successfully");
        logger.info(returnValue.getMessageDetail());
        return returnValue;
    }

    public RequestResponse getAllByFilter(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = QueueSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.getSortDirection().equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "name" : searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.getSortDirection().equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "name" : searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.queueRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.queueRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)this.entityToModelConversion(page.getContent()));
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public List<QueueModel> entityToModelConversion(List<Queue> queue) {
        ArrayList<QueueModel> addValue = new ArrayList<QueueModel>();
        for (Queue row : queue) {
            QueueModel data = new QueueModel();
            data.setId(Integer.valueOf(row.getId()));
            data.setDescription(row.getDescription());
            data.setSystemName(row.getSystemName());
            data.setIsDisabled(row.getIsDisabled());
            data.setDialingActive(row.getDialingActive());
            data.setDispositionUrl(row.getDispositionUrl());
            data.setStrategy(row.getStrategy());
            data.setRecord(row.getRecord());
            data.setShortCode(row.getShortCode());
            data.setDispositionForm(row.getDispositionForm());
            addValue.add(data);
        }
        return addValue;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RequestResponse uploadWavFile(MultipartFile musicFile, String fileName) {
        RequestResponse returnValue = new RequestResponse();
        String originalFilename = musicFile.getOriginalFilename();
        if (musicFile == null || !originalFilename.endsWith(".wav")) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Invalid file format. Only .wav files are allowed.");
            returnValue.setMessageDetail("Empty file or Invalid file selected");
            logger.error(returnValue.getMessageDetail());
            return returnValue;
        }
        String pathToUpload = "/home/coralswitch/queuesounds";
        Path uploadPath = Paths.get(pathToUpload, new String[0]);
        if (!Files.exists(uploadPath, new LinkOption[0])) {
            try {
                Files.createDirectories(uploadPath, new FileAttribute[0]);
            }
            catch (Exception e) {
                returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                returnValue.setMessage("Not Found ");
                returnValue.setMessageDetail("path not exist for uploading the file");
                logger.error(returnValue.getMessageDetail() + e.getMessage());
                return returnValue;
            }
        }
        try (InputStream inputStream = musicFile.getInputStream();){
            Path filePath = uploadPath.resolve(fileName.trim());
            Files.copy(inputStream, filePath, StandardCopyOption.REPLACE_EXISTING);
            returnValue.setData((Object)fileName);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("wav file uploaded successfully");
            RequestResponse requestResponse = returnValue;
            return requestResponse;
        }
        catch (IOException e) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Not Found ");
            returnValue.setMessageDetail("path not exist, for upload file");
            logger.error(returnValue.getMessageDetail(), (Object)e.getMessage());
            return returnValue;
        }
    }

    public void createQueue(QueueServicesModel data) {
        Queue queue = new Queue();
        queue.setCreatedOn(LocalDateTime.now());
        queue.setDescription(data.getDescription());
        queue.setSystemName(data.getDefaultQueue());
        queue.setRecord(data.getRecord());
        queue.setTimeBaseScore("system");
        queue.setMaxWaitTime(Integer.valueOf(0));
        queue.setMaxWaitTimeWithNoAgent(Integer.valueOf(0));
        queue.setMaxWaitTimeWithNoAgentTimeReached(Integer.valueOf(5));
        queue.setTierRulesApply(Boolean.valueOf(false));
        queue.setTierRuleWaitSecond(Integer.valueOf(300));
        queue.setTierRuleWaitMultiplyLevel(Boolean.valueOf(true));
        queue.setTierRuleNoAgentNoWait(Boolean.valueOf(false));
        queue.setDiscardAbandonedAfter(Integer.valueOf(60));
        queue.setAbandonedResumeAllowed(Boolean.valueOf(false));
        queue.setAdvertiseDialing(Boolean.valueOf(false));
        queue.setRbTonAgentTrying(Boolean.valueOf(false));
        queue.setIsPlayPosition(Boolean.valueOf(false));
        queue.setStrategy("longest-ideal-agent");
        queue.setDispositionForm(data.getDispositionForm());
        queue.setAcdType(data.getAcdType());
        if (data.getMohSound() != null) {
            queue.setMohSound("/home/coralswitch/queuesounds/" + data.getMohSound());
        }
        queue.setShortCode(data.getShortCode());
        queue.setQueueType(data.getQueueType());
        queue.setPaceRatio(BigDecimal.valueOf(1.0));
        if (data.getAcdType() != null && data.getAcdType() != 0) {
            queue.setIsDisabled(Boolean.valueOf(true));
            queue.setDialingActive(Boolean.valueOf(true));
            queue.setIsAutoAns(Boolean.valueOf(false));
        }
        this.queueRepository.save((Object)queue);
    }

    public String getSystemName(Integer id) {
        Optional data = this.queueRepository.findById(id);
        if (data.isPresent()) {
            return ((Queue)data.get()).getSystemName();
        }
        return "";
    }

    public void createQueue1(String defaultQueue, String formName) {
        Queue queue = new Queue();
        queue.setCreatedOn(LocalDateTime.now());
        queue.setDescription("Queue-" + defaultQueue);
        queue.setSystemName(defaultQueue);
        queue.setRecord(Boolean.valueOf(false));
        queue.setTimeBaseScore("system");
        queue.setMaxWaitTime(Integer.valueOf(0));
        queue.setMaxWaitTimeWithNoAgent(Integer.valueOf(0));
        queue.setMaxWaitTimeWithNoAgentTimeReached(Integer.valueOf(5));
        queue.setTierRulesApply(Boolean.valueOf(false));
        queue.setTierRuleWaitSecond(Integer.valueOf(300));
        queue.setTierRuleWaitMultiplyLevel(Boolean.valueOf(true));
        queue.setTierRuleNoAgentNoWait(Boolean.valueOf(false));
        queue.setDiscardAbandonedAfter(Integer.valueOf(60));
        queue.setAbandonedResumeAllowed(Boolean.valueOf(false));
        queue.setAdvertiseDialing(Boolean.valueOf(false));
        queue.setRbTonAgentTrying(Boolean.valueOf(false));
        queue.setIsPlayPosition(Boolean.valueOf(false));
        queue.setStrategy("longest-ideal-agent");
        queue.setDispositionForm(formName);
        queue.setAcdType(Integer.valueOf(0));
        queue.setShortCode("");
        queue.setQueueType("");
        queue.setPaceRatio(BigDecimal.valueOf(1.0));
        queue.setIsDisabled(Boolean.valueOf(true));
        queue.setDialingActive(Boolean.valueOf(true));
        queue.setIsAutoAns(Boolean.valueOf(false));
        this.queueRepository.save((Object)queue);
    }

    public RequestResponse getAllQueue() {
        List list = this.queueRepository.findAll();
        ArrayList<QueueModel> addValue = new ArrayList<QueueModel>();
        RequestResponse returnValue = new RequestResponse();
        for (Queue row : list) {
            QueueModel data = new QueueModel();
            data.setSystemName(row.getSystemName());
            data.setDescription(row.getDescription() + " (Queue " + row.getSystemName() + ")");
            addValue.add(data);
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setData(addValue);
        logger.info(returnValue.getMessage());
        return returnValue;
    }
}

