/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.configuration.nodeConfiguration.controller;

import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.service.configuration.nodeConfiguration.model.WAnsModel;
import com.coraltele.service.configuration.nodeConfiguration.service.WAnsService;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.text.MessageFormat;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/v2/wAns"})
@RestController
public class WAnsController {
    private static final Logger logger = LogManager.getLogger(WAnsController.class);
    private static final String CONTROLLER_NAME = "wAns";
    @Autowired
    WAnsService wAnsService;

    @PostMapping(value={"/list"})
    public ResponseEntity<RequestResponse> getAllWAns(@RequestBody SearchRequest data) {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            String dataReceived = objectMapper.writeValueAsString((Object)data);
            String message = MessageFormat.format("{1} received for listing : {0}", CONTROLLER_NAME, dataReceived);
            logger.info(message);
            RequestResponse returnValue = this.wAnsService.getList(data);
            if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
                message = MessageFormat.format("{1} data processed successfully for listing : {0}", CONTROLLER_NAME, dataReceived);
                logger.info(message);
                return ResponseEntity.ok((Object)returnValue);
            }
            message = MessageFormat.format("{1} unable to process data for listing: {0}", CONTROLLER_NAME, dataReceived);
            logger.info(message);
            return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
        }
        catch (JsonProcessingException e) {
            RequestResponse returnValue = new RequestResponse();
            returnValue.setStatus(Constants.Error.UNKNOWN_ERROR);
            returnValue.setMessage("Invalid json data");
            return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
        }
    }

    @PostMapping(value={"/register"})
    public ResponseEntity<RequestResponse> registerWAns(@RequestBody WAnsModel data) {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            String dataReceived = objectMapper.writeValueAsString((Object)data);
            String message = MessageFormat.format("{1} received for registering : {0}", CONTROLLER_NAME, dataReceived);
            logger.info(message);
            RequestResponse returnValue = this.wAnsService.register(data);
            if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
                message = MessageFormat.format("{1} data processed successfully for registering : {0}", CONTROLLER_NAME, dataReceived);
                logger.info(message);
                return ResponseEntity.ok((Object)returnValue);
            }
            message = MessageFormat.format("{1} unable to process data for registering: {0}", CONTROLLER_NAME, dataReceived);
            logger.info(message);
            return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
        }
        catch (JsonProcessingException e) {
            RequestResponse returnValue = new RequestResponse();
            returnValue.setStatus(Constants.Error.UNKNOWN_ERROR);
            returnValue.setMessage("Invalid json data");
            return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
        }
    }

    @PostMapping(value={"/update"})
    public ResponseEntity<RequestResponse> updateWAns(@RequestBody WAnsModel data) {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            String dataReceived = objectMapper.writeValueAsString((Object)data);
            String message = MessageFormat.format("{1} received for update : {0}", CONTROLLER_NAME, dataReceived);
            logger.info(message);
            RequestResponse returnValue = this.wAnsService.update(data);
            if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
                message = MessageFormat.format("{1} data processed successfully for update : {0}", CONTROLLER_NAME, dataReceived);
                logger.info(message);
                return ResponseEntity.ok((Object)returnValue);
            }
            message = MessageFormat.format("{1} unable to process data for update: {0}", CONTROLLER_NAME, dataReceived);
            logger.info(message);
            return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
        }
        catch (JsonProcessingException e) {
            RequestResponse returnValue = new RequestResponse();
            returnValue.setStatus(Constants.Error.UNKNOWN_ERROR);
            returnValue.setMessage("Invalid json data");
            return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
        }
    }

    @PostMapping(value={"/delete"})
    public ResponseEntity<RequestResponse> deleteWAns(@RequestBody InputIdModel data) {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            String dataReceived = objectMapper.writeValueAsString((Object)data);
            String message = MessageFormat.format("{1} received for delete : {0}", CONTROLLER_NAME, dataReceived);
            logger.info(message);
            RequestResponse returnValue = this.wAnsService.delete(data);
            if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
                message = MessageFormat.format("{1} data processed successfully for delete : {0}", CONTROLLER_NAME, dataReceived);
                logger.info(message);
                return ResponseEntity.ok((Object)returnValue);
            }
            message = MessageFormat.format("{1} unable to process data for delete: {0}", CONTROLLER_NAME, dataReceived);
            logger.info(message);
            return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
        }
        catch (JsonProcessingException e) {
            RequestResponse returnValue = new RequestResponse();
            returnValue.setStatus(Constants.Error.UNKNOWN_ERROR);
            returnValue.setMessage("Invalid json data");
            return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
        }
    }
}

