/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.helper;

import com.coraltele.db.telephony.pbx.entity.ControlRluServer;
import com.coraltele.db.telephony.pbx.repository.ControlRluServerRepository;
import com.coraltele.helper.Telephony;
import com.coraltele.helper.XmlRpcClientConfigModel;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.xmlrpc.client.AsyncCallback;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientConfig;
import org.apache.xmlrpc.client.XmlRpcClientConfigImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class TelephonyV2 {
    private static final Logger logger = LoggerFactory.getLogger(TelephonyV2.class);
    @Autowired
    private ControlRluServerRepository controlRluServerRepository;
    private Map<String, XmlRpcClientConfigModel> rluClientMap = new HashMap();

    @PostConstruct
    public void init() {
        try {
            List servers = this.controlRluServerRepository.findAll();
            for (ControlRluServer server : servers) {
                String rluCode = server.getRluCode();
                String virtualIp = server.getVirtualIp();
                if (rluCode == null || virtualIp == null) continue;
                if (virtualIp.contains(":")) {
                    virtualIp = virtualIp.split(":")[0];
                }
                XmlRpcClientConfigImpl configImpl = new XmlRpcClientConfigImpl();
                configImpl.setServerURL(new URL("http://" + virtualIp + ":8089/RPC2"));
                configImpl.setBasicUserName("freeswitch");
                configImpl.setBasicPassword("works");
                XmlRpcClient client = new XmlRpcClient();
                client.setConfig((XmlRpcClientConfig)configImpl);
                XmlRpcClientConfigModel rpcConfig = new XmlRpcClientConfigModel(configImpl, client);
                this.rluClientMap.put(rluCode, rpcConfig);
            }
        }
        catch (MalformedURLException ex) {
            LoggerFactory.getLogger(Telephony.class).error("Error in XmlRPCClient setup: {}", (Object)ex.getMessage(), (Object)ex);
        }
    }

    public XmlRpcClient getClientForRluCode(String rluCode) {
        XmlRpcClientConfigModel config = (XmlRpcClientConfigModel)this.rluClientMap.get(rluCode);
        return config != null ? config.getClient() : null;
    }

    public synchronized void executeCommand(String rluCode, String arg0, String arg1, String arg2) {
        try {
            if (arg0.isEmpty()) {
                arg0 = "freeswitch.api";
            }
            logger.info("arg1 : {}, command : {}", (Object)arg1, (Object)arg2);
            if (!arg1.isEmpty() && !arg2.isEmpty()) {
                XmlRpcClient client = this.getClientForRluCode(rluCode);
                if (client != null) {
                    String resp = (String)client.execute(arg0, new Object[]{arg1, arg2});
                    logger.info(resp);
                } else {
                    logger.error("Unable to create Xml Rpc Client");
                }
            }
        }
        catch (Exception ex) {
            logger.error("Error in executeCommand() {}", (Object)ex.getMessage(), (Object)ex);
        }
    }

    public synchronized String executeCommandAndReturnStatus(String rluCode, String arg0, String arg1, String arg2) {
        try {
            if (arg0.isEmpty()) {
                arg0 = "freeswitch.api";
            }
            logger.info("arg1 : {}, command : {}", (Object)arg1, (Object)arg2);
            if (!arg1.isEmpty() && !arg2.isEmpty()) {
                XmlRpcClient client = this.getClientForRluCode(rluCode);
                if (client != null) {
                    String resp = (String)client.execute(arg0, new Object[]{arg1, arg2});
                    logger.info(resp);
                    return resp;
                }
                logger.error("Unable to create Xml Rpc Client");
            }
        }
        catch (Exception ex) {
            logger.error("Error in executeCommand() {}", (Object)ex.getMessage(), (Object)ex);
        }
        return "";
    }

    public synchronized void executeCommandAsync(String rluCode, String arg0, String arg1, String arg2) {
        try {
            if (arg0.isEmpty()) {
                arg0 = "freeswitch.api";
            }
            logger.info("arg1 : {}, command : {}", (Object)arg1, (Object)arg2);
            if (!arg1.isEmpty() && !arg2.isEmpty()) {
                XmlRpcClient client = this.getClientForRluCode(rluCode);
                if (client != null) {
                    client.executeAsync(arg0, new Object[]{arg1, arg2}, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
                } else {
                    logger.error("Unable to create Xml Rpc Client");
                }
            }
        }
        catch (Exception ex) {
            logger.error("Error in executeCommand() {}", (Object)ex.getMessage(), (Object)ex);
        }
    }

    public static void makeCallBackCall(String command) {
        try {
            logger.info("callback : Executing command : {}", (Object)command);
            try {
                Object[] finalcommand = TelephonyV2.readFullCommand((String)command);
                logger.info("callback : cmd : " + Arrays.toString(finalcommand));
                Process p = Runtime.getRuntime().exec((String[])finalcommand);
                p.waitFor();
                logger.info("command", finalcommand);
            }
            catch (InterruptedException ie) {
                logger.error("callback : Error in makeCallBackCall(); Error {}", (Object)ie.getMessage());
            }
            catch (Exception ii) {
                logger.error("callback : Error in makeCallBackCall(); Error {}", (Object)ii.getMessage());
            }
        }
        catch (Exception e) {
            logger.error("callback : Exception at makeCallBackCall() : {}", (Object)e.getMessage());
        }
    }

    public static String[] readFullCommand(String cmd) {
        String[] cmd1 = new String[]{"/bin/sh", "-c", cmd};
        return cmd1;
    }

    static /* synthetic */ Logger access$000() {
        return logger;
    }
}

