/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.user.userGroup.service;

import com.coraltele.db.telephony.pbx.entity.Extension;
import com.coraltele.db.telephony.pbx.repository.ControlRluServerRepository;
import com.coraltele.db.telephony.pbx.repository.ExtensionsRepository;
import com.coraltele.db.telephony.uc.entity.view.ConfPhoneBook;
import com.coraltele.db.telephony.uc.repository.ConfPhoneBookRepository;
import com.coraltele.db.users.main.entity.User;
import com.coraltele.db.users.main.entity.UserGroup;
import com.coraltele.db.users.main.entity.UserGroupMaster;
import com.coraltele.db.users.main.repository.RoleRepository;
import com.coraltele.db.users.main.repository.UserGroupMasterRepository;
import com.coraltele.db.users.main.repository.UserGroupRepository;
import com.coraltele.db.users.main.repository.UserRepository;
import com.coraltele.db.users.main.repository.UserRoleRepository;
import com.coraltele.db.users.main.specification.UserGroupSpecification;
import com.coraltele.helper.BashCmd;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.user.model.UserListModel;
import com.coraltele.service.user.service.UserService;
import com.coraltele.service.user.userGroup.model.GroupUserAssociationModel;
import com.coraltele.service.user.userGroup.model.GroupWithUserListModel;
import com.coraltele.service.user.userGroup.model.UserGroupModel;
import com.coraltele.service.user.userGroupMaster.model.UserGroupMasterModel;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.security.Principal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class UserGroupService {
    private static final Logger logger = LogManager.getLogger(UserGroupService.class);
    @Autowired
    UserGroupRepository userGroupRepository;
    @Autowired
    UserRepository userRepository;
    @Autowired
    UserGroupMasterRepository userGroupMasterRepository;
    @Autowired
    ExtensionsRepository extensionsRepository;
    @Autowired
    UserRoleRepository userRoleRepository;
    @Autowired
    RoleRepository roleRepository;
    @Autowired
    ConfPhoneBookRepository confPhoneBookRepository;
    @Autowired
    ControlRluServerRepository controlRluServerRepository;
    @Autowired
    BashCmd bashCmd;
    @Autowired
    UserService usersService;

    public RequestResponse createData(UserGroupModel data, Principal principal) {
        logger.debug("Create new UserGroup : {} ", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        try {
            String createdBy = principal.getName();
            LocalDateTime createdOn = LocalDateTime.now();
            Long users = data.getUsers();
            List group = data.getGroup();
            List existingUserGroup = this.userGroupRepository.findByUsers(users);
            if (!existingUserGroup.isEmpty()) {
                this.userGroupRepository.deleteAll((Iterable)existingUserGroup);
            }
            for (Long groups : group) {
                UserGroup userGroup = new UserGroup();
                userGroup.setCreatedBy(createdBy);
                userGroup.setCreatedOn(createdOn);
                userGroup.setGroup(groups);
                userGroup.setUsers(users);
                this.userGroupRepository.save((Object)userGroup);
            }
            Optional user = this.userRepository.findById(users.intValue());
            if (user.isPresent()) {
                User info = (User)user.get();
                ObjectMapper obj = new ObjectMapper();
                ArrayList<String> groupData = new ArrayList<String>();
                for (Long groupId : data.getGroup()) {
                    Optional userGroupMaster = this.userGroupMasterRepository.findById((Object)groupId.intValue());
                    if (!userGroupMaster.isPresent()) continue;
                    groupData.add(((UserGroupMaster)userGroupMaster.get()).getDescription());
                }
                info.setUserGroup(obj.writeValueAsString(groupData));
                this.userRepository.save((Object)info);
            }
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("OK");
            returnValue.setMessageDetail("UserGroup Created Successfully");
            logger.info(returnValue.getMessage());
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.BAD_CREDENTIAL);
            returnValue.setMessage("Unable To Create UserGroup");
            returnValue.setMessageDetail("Contact With Administrator");
            logger.error(returnValue.getMessageDetail(), (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse getAllUserGroupByFilter(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = UserGroupSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.sortDirection.equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).ascending();
        } else if (searchRequestData.sortDirection.equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).descending();
        }
        Page page = null;
        page = sort == null ? this.userGroupRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.userGroupRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)page.getContent());
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse groupWithUserList(Principal principal) {
        RequestResponse returnValue = new RequestResponse();
        try {
            Optional loggedUser;
            ArrayList<Long> uniqueExistingGroup = new ArrayList<Long>();
            ArrayList<Long> currentUserList = new ArrayList<Long>();
            GroupWithUserListModel data = new GroupWithUserListModel();
            List groupMasterList = this.userGroupMasterRepository.findAll();
            List directoryUser = this.confPhoneBookRepository.findAll();
            if (!groupMasterList.isEmpty()) {
                for (Object groupMaster : groupMasterList) {
                    uniqueExistingGroup.add(groupMaster.getId().longValue());
                }
                ArrayList<GroupUserAssociationModel> groupOfUserModel = new ArrayList<GroupUserAssociationModel>();
                if (!uniqueExistingGroup.isEmpty()) {
                    for (Long groupId : uniqueExistingGroup) {
                        List userGroupData = this.userGroupRepository.findByGroup(groupId);
                        ArrayList<UserListModel> userListData = new ArrayList<UserListModel>();
                        GroupUserAssociationModel groupWithUserData = new GroupUserAssociationModel();
                        Optional groupMaster = this.userGroupMasterRepository.findById((Object)groupId.intValue());
                        if (groupMaster.isPresent()) {
                            groupWithUserData.setId(((UserGroupMaster)groupMaster.get()).getId());
                            groupWithUserData.setGroupName(((UserGroupMaster)groupMaster.get()).getDescription());
                        }
                        if (!userGroupData.isEmpty()) {
                            Iterator iterator = userGroupData.iterator();
                            while (iterator.hasNext()) {
                                Integer userId;
                                UserGroup userGroup = (UserGroup)iterator.next();
                                Optional userInfo = this.userRepository.findById(userGroup.getUsers().intValue());
                                if (userInfo.isPresent() && !((User)userInfo.get()).getUsername().equals(principal.getName()) && (this.usersService.isUcUser(userId = ((User)userInfo.get()).getId()) || this.usersService.isConferenceUser(userId)) && this.usersService.isPhoneUsers(((User)userInfo.get()).getContactNo())) {
                                    currentUserList.add(Long.valueOf(((User)userInfo.get()).getId().intValue()));
                                    UserListModel userData = new UserListModel();
                                    userData.setId(Long.valueOf(((User)userInfo.get()).getId().intValue()));
                                    userData.setUsername(((User)userInfo.get()).getUsername());
                                    userData.setUserType("U");
                                    userData.setExtension(((User)userInfo.get()).getContactNo());
                                    userData.setDescription(((User)userInfo.get()).getDescription());
                                    userListData.add(userData);
                                }
                                groupWithUserData.setUserList(userListData);
                            }
                        } else {
                            groupWithUserData.setUserList(Collections.emptyList());
                        }
                        groupOfUserModel.add(groupWithUserData);
                    }
                    data.setGroup(groupOfUserModel);
                }
            } else {
                data.setGroup(Collections.emptyList());
            }
            ArrayList<UserListModel> userListModelData = new ArrayList<UserListModel>();
            List userList = this.userRepository.findAllByOrderById();
            ArrayList<Long> leftUsersId = new ArrayList<Long>();
            for (User user : userList) {
                long userId = user.getId().intValue();
                if (currentUserList.contains(userId)) continue;
                leftUsersId.add(userId);
            }
            if (!leftUsersId.isEmpty()) {
                for (Long id : leftUsersId) {
                    Integer userId;
                    Optional userData = this.userRepository.findById(id.intValue());
                    if (!userData.isPresent() || ((User)userData.get()).getUsername().equals(principal.getName()) || !this.usersService.isUcUser(userId = ((User)userData.get()).getId()) && !this.usersService.isConferenceUser(userId) || !this.usersService.isPhoneUsers(((User)userData.get()).getContactNo())) continue;
                    UserListModel userListModel = new UserListModel();
                    userListModel.setId(Long.valueOf(((User)userData.get()).getId().intValue()));
                    userListModel.setUsername(((User)userData.get()).getUsername());
                    userListModel.setDescription(((User)userData.get()).getDescription());
                    userListModel.setExtension(((User)userData.get()).getContactNo());
                    userListModel.setUserType("U");
                    userListModelData.add(userListModel);
                }
            }
            if (!this.usersService.isConferenceUser(((User)(loggedUser = this.userRepository.findByUsername(principal.getName())).get()).getId())) {
                for (ConfPhoneBook confPhoneBook : directoryUser) {
                    UserListModel userListModel = new UserListModel();
                    userListModel.setId(confPhoneBook.getId());
                    userListModel.setUsername(confPhoneBook.getName());
                    userListModel.setDescription(confPhoneBook.getStatusDescription());
                    userListModel.setExtension(confPhoneBook.getOffEXtn());
                    userListModel.setUserType("D");
                    userListModelData.add(userListModel);
                }
            }
            data.setUserList(userListModelData);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("List of Users Associated with Groups");
            returnValue.setData((Object)data);
            logger.info("list fetch successfully for group with users");
            return returnValue;
        }
        catch (Exception e) {
            e.printStackTrace();
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Error while fetching data");
            logger.error(e.getMessage());
            return returnValue;
        }
    }

    public RequestResponse groupWithUserListForLocal(Principal principal) {
        RequestResponse returnValue = new RequestResponse();
        String rluCode = "";
        ArrayList<String> contactNumbers = new ArrayList<String>();
        rluCode = Constants.SERVER_RLU_CODE;
        logger.info("Rlu_Code of current server is:{}", (Object)rluCode);
        List extensionList = this.extensionsRepository.findByRluCode(rluCode);
        if (extensionList != null && !extensionList.isEmpty()) {
            for (Extension ext : extensionList) {
                contactNumbers.add(ext.getExtension());
            }
        }
        try {
            String contactNo;
            ArrayList<Long> uniqueExistingGroup = new ArrayList<Long>();
            ArrayList<Long> currentUserList = new ArrayList<Long>();
            GroupWithUserListModel data = new GroupWithUserListModel();
            List groupMasterList = this.userGroupMasterRepository.findAll();
            List directoryUser = this.confPhoneBookRepository.findAll();
            if (groupMasterList != null && !groupMasterList.isEmpty()) {
                for (Object groupMaster : groupMasterList) {
                    uniqueExistingGroup.add(groupMaster.getId().longValue());
                }
                ArrayList<GroupUserAssociationModel> groupOfUserModel = new ArrayList<GroupUserAssociationModel>();
                if (!uniqueExistingGroup.isEmpty()) {
                    for (Long groupId : uniqueExistingGroup) {
                        Iterator userGroupData = this.userGroupRepository.findByGroup(groupId);
                        ArrayList<UserListModel> userListData = new ArrayList<UserListModel>();
                        GroupUserAssociationModel groupWithUserData = new GroupUserAssociationModel();
                        Optional groupMaster = this.userGroupMasterRepository.findById((Object)groupId.intValue());
                        if (groupMaster.isPresent()) {
                            groupWithUserData.setId(((UserGroupMaster)groupMaster.get()).getId());
                            groupWithUserData.setGroupName(((UserGroupMaster)groupMaster.get()).getDescription());
                        }
                        if (userGroupData != null && !userGroupData.isEmpty()) {
                            Iterator iterator = userGroupData.iterator();
                            while (iterator.hasNext()) {
                                Integer userId;
                                String contactNo2;
                                UserGroup userGroup = (UserGroup)iterator.next();
                                Optional userInfo = this.userRepository.findById(userGroup.getUsers().intValue());
                                if (!userInfo.isPresent() || ((User)userInfo.get()).getUsername().equals(principal.getName()) || !contactNumbers.contains(contactNo2 = ((User)userInfo.get()).getContactNo()) || !this.usersService.isUcUser(userId = ((User)userInfo.get()).getId()) && !this.usersService.isConferenceUser(userId) || !this.usersService.isPhoneUsers(contactNo2)) continue;
                                currentUserList.add(Long.valueOf(((User)userInfo.get()).getId().intValue()));
                                UserListModel userData = new UserListModel();
                                userData.setId(Long.valueOf(((User)userInfo.get()).getId().intValue()));
                                userData.setUsername(((User)userInfo.get()).getUsername());
                                userData.setUserType("U");
                                userData.setExtension(contactNo2);
                                userData.setDescription(((User)userInfo.get()).getDescription());
                                userListData.add(userData);
                            }
                        }
                        groupWithUserData.setUserList(userListData);
                        groupOfUserModel.add(groupWithUserData);
                    }
                }
                data.setGroup(groupOfUserModel);
            } else {
                data.setGroup(Collections.emptyList());
            }
            ArrayList<UserListModel> userListModelData = new ArrayList<UserListModel>();
            List userList = this.userRepository.findAllByOrderById();
            ArrayList<Long> leftUsersId = new ArrayList<Long>();
            if (userList != null && !userList.isEmpty()) {
                for (User user : userList) {
                    long userId = user.getId().intValue();
                    if (currentUserList.contains(userId)) continue;
                    leftUsersId.add(userId);
                }
                if (!leftUsersId.isEmpty()) {
                    for (Long id : leftUsersId) {
                        Integer userId;
                        Optional userData = this.userRepository.findById(id.intValue());
                        if (!userData.isPresent() || ((User)userData.get()).getUsername().equals(principal.getName()) || !contactNumbers.contains(contactNo = ((User)userData.get()).getContactNo()) || !this.usersService.isUcUser(userId = ((User)userData.get()).getId()) && !this.usersService.isConferenceUser(userId) || !this.usersService.isPhoneUsers(contactNo)) continue;
                        UserListModel userListModel = new UserListModel();
                        userListModel.setId(Long.valueOf(userId.intValue()));
                        userListModel.setUsername(((User)userData.get()).getUsername());
                        userListModel.setDescription(((User)userData.get()).getDescription());
                        userListModel.setExtension(contactNo);
                        userListModel.setUserType("U");
                        userListModelData.add(userListModel);
                    }
                }
            }
            Optional loggedUser = this.userRepository.findByUsername(principal.getName());
            if (directoryUser != null && !directoryUser.isEmpty() && !this.usersService.isConferenceUser(((User)loggedUser.get()).getId())) {
                for (ConfPhoneBook confPhoneBook : directoryUser) {
                    contactNo = confPhoneBook.getOffEXtn();
                    if (!contactNumbers.contains(contactNo)) continue;
                    UserListModel userListModel = new UserListModel();
                    userListModel.setId(confPhoneBook.getId());
                    userListModel.setUsername(confPhoneBook.getName());
                    userListModel.setDescription(confPhoneBook.getStatusDescription());
                    userListModel.setExtension(contactNo);
                    userListModel.setUserType("D");
                    userListModelData.add(userListModel);
                }
            }
            data.setUserList(userListModelData);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("List of Users Associated with Groups");
            returnValue.setData((Object)data);
            logger.info("List fetched successfully for group with users");
            return returnValue;
        }
        catch (Exception e) {
            e.printStackTrace();
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Error while fetching data");
            logger.error(e.getMessage());
            return returnValue;
        }
    }

    public RequestResponse getUserListByGroup(Long id) {
        RequestResponse returnValue = new RequestResponse();
        try {
            GroupUserAssociationModel data = new GroupUserAssociationModel();
            Optional groupExist = this.userGroupMasterRepository.findById((Object)id.intValue());
            if (groupExist.isPresent()) {
                data.setId(((UserGroupMaster)groupExist.get()).getId());
                data.setGroupName(((UserGroupMaster)groupExist.get()).getDescription());
                List list = this.userGroupRepository.findByGroup(id);
                if (!list.isEmpty()) {
                    ArrayList<UserListModel> userList = new ArrayList<UserListModel>();
                    for (UserGroup userGroup : list) {
                        Optional userData = this.userRepository.findById(userGroup.getUsers().intValue());
                        if (!userData.isPresent()) continue;
                        UserListModel existUser = new UserListModel();
                        existUser.setId(Long.valueOf(((User)userData.get()).getId().intValue()));
                        existUser.setUsername(((User)userData.get()).getUsername());
                        existUser.setDescription(((User)userData.get()).getDescription());
                        existUser.setExtension(((User)userData.get()).getContactNo());
                        userList.add(existUser);
                    }
                    data.setUserList(userList);
                    returnValue.setStatus(Constants.Error.OK);
                    returnValue.setMessage("Data fetched successfully");
                    returnValue.setData((Object)data);
                } else {
                    returnValue.setStatus(Constants.Error.OK);
                    returnValue.setMessage("Group have no users");
                    returnValue.setData((Object)data);
                    logger.info("Empty user in selected group");
                }
            } else {
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("Invalid group selected");
                logger.error("Invalid group for fetching data");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Error while fetching data");
            logger.error(e.getMessage());
        }
        return returnValue;
    }

    public RequestResponse getAllUniqueGroup() {
        List list = (List)this.userGroupRepository.findAll();
        HashSet<Long> group = new HashSet<Long>();
        RequestResponse returnValue = new RequestResponse();
        for (UserGroup userGroup : list) {
            group.add(userGroup.getGroup());
        }
        ArrayList<UserGroupMasterModel> addValue = new ArrayList<UserGroupMasterModel>();
        for (Long code : group) {
            UserGroupMasterModel data = new UserGroupMasterModel();
            Optional groupCode = this.userGroupMasterRepository.findById((Object)code.intValue());
            if (groupCode == null) continue;
            data.setCode(((UserGroupMaster)groupCode.get()).getCode());
            addValue.add(data);
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setData(addValue);
        logger.info(returnValue.getMessage());
        return returnValue;
    }
}

