/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.uc.service;

import com.coraltele.db.billing.main.entity.Voicemail;
import com.coraltele.db.billing.main.entity.VoicemailMsgs;
import com.coraltele.db.billing.main.repository.VoicemailMsgsRepository;
import com.coraltele.db.billing.main.repository.VoicemailRepository;
import com.coraltele.db.billing.main.specification.VoicemailMsgsSpecification;
import com.coraltele.db.telephony.pbx.entity.Extension;
import com.coraltele.db.telephony.pbx.repository.ExtensionsRepository;
import com.coraltele.db.users.main.entity.User;
import com.coraltele.db.users.main.repository.UserRepository;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.billing.main.uc_notification.service.UcNotificationService;
import com.coraltele.service.billing.main.voicemail_msgs.model.VoicemailTransferModel;
import com.coraltele.service.pbx.emailDetail.model.CustomEmailDetailModel;
import com.coraltele.service.pbx.emailDetail.service.EmailDetailService;
import com.coraltele.service.pbx.extension.service.ExtensionsService;
import com.coraltele.service.uc.model.CustomerAccountProfileModel;
import com.coraltele.service.uc.model.VMTransferDetailsModel;
import com.coraltele.service.uc.service.CustomerAccountService;
import com.coraltele.service.uc.service.UCService;
import com.coraltele.service.uc.service.VMTransferDetailsService;
import com.coraltele.service.user.service.UserService;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class VoicemailService {
    private static final Logger logger = LogManager.getLogger(VoicemailService.class);
    @Autowired
    VoicemailRepository voicemailRepository;
    @Autowired
    VMTransferDetailsService vmTransferDetailsService;
    @Autowired
    CustomerAccountService customerAccountService;
    @Autowired
    UCService ucService;
    @Autowired
    EmailDetailService emailDetailService;
    @Autowired
    UcNotificationService ucNotificationService;
    @Autowired
    ExtensionsService extensionsService;
    @Autowired
    VoicemailMsgsRepository voicemailMsgsRepository;
    @Autowired
    ExtensionsRepository extensionsRepository;
    @Autowired
    UserRepository userRepository;
    @Autowired
    UserService userService;

    public RequestResponse getAllVoiceMail(SearchRequest searchRequestData, Authentication authentication) {
        this.ucNotificationService.updateNotificationForVoicemail(authentication);
        RequestResponse returnValue = new RequestResponse();
        Specification filters = VoicemailMsgsSpecification.generateFilters((SearchRequest)searchRequestData, (String)this.extensionsService.getExtension(authentication.getName(), "phone"));
        Sort sort = null;
        if (searchRequestData.getSortDirection().equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "createdOn" : searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.getSortDirection().equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "createdOn" : searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.voicemailRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.voicemailRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)page.getContent());
        returnValue.setData((Object)responseData);
        returnValue.setMessageDetail("filtered list");
        logger.info(returnValue.getMessageDetail());
        return returnValue;
    }

    public RequestResponse createVMTransferDetails(VMTransferDetailsModel dataList, Authentication authentication) {
        RequestResponse returnValue = new RequestResponse();
        List ucData = this.voicemailRepository.findByUserName(authentication.getName());
        Long keyValue = Long.parseLong(((Voicemail)ucData.get(0)).getId());
        RequestResponse getRequestResponse = this.vmTransferDetailsService.createVMTransferDetails(dataList, authentication, keyValue);
        returnValue.setStatus(getRequestResponse.getStatus());
        returnValue.setMessage(getRequestResponse.getMessage());
        returnValue.setMessageDetail(getRequestResponse.getMessageDetail());
        returnValue.setData(getRequestResponse.getData());
        return returnValue;
    }

    public RequestResponse voiceMailTransfer(VoicemailTransferModel dataList, Authentication authentication) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList<String> ucUsers = new ArrayList<String>();
        try {
            for (String extension : dataList.getExtension()) {
                VoicemailMsgs voicemail = new VoicemailMsgs();
                Optional ucData = this.voicemailMsgsRepository.findByUuid(dataList.getId());
                voicemail.setCidName(((VoicemailMsgs)ucData.get()).getCidName());
                voicemail.setCidNumber(((VoicemailMsgs)ucData.get()).getCidNumber());
                voicemail.setCoralId(((VoicemailMsgs)ucData.get()).getCoralId());
                voicemail.setCreatedEpoch(Integer.valueOf((int)(System.currentTimeMillis() / 1000L)));
                voicemail.setDestinationUcUser(this.extensionsService.getAssignedUser(extension));
                ucUsers.add(this.extensionsService.getAssignedUser(extension));
                voicemail.setDomain(((VoicemailMsgs)ucData.get()).getDomain());
                voicemail.setFilePath(((VoicemailMsgs)ucData.get()).getFilePath());
                voicemail.setFlags(((VoicemailMsgs)ucData.get()).getFlags());
                voicemail.setForwardedBy(((VoicemailMsgs)ucData.get()).getForwardedBy());
                voicemail.setInFolder(((VoicemailMsgs)ucData.get()).getInFolder());
                voicemail.setIsNotified(((VoicemailMsgs)ucData.get()).getIsNotified());
                voicemail.setIsRead(((VoicemailMsgs)ucData.get()).getIsRead());
                voicemail.setIsSlaveData(((VoicemailMsgs)ucData.get()).getIsSlaveData());
                voicemail.setMailSent(((VoicemailMsgs)ucData.get()).getMailSent());
                voicemail.setMessageLen(((VoicemailMsgs)ucData.get()).getMessageLen());
                voicemail.setNoOfTry(((VoicemailMsgs)ucData.get()).getNoOfTry());
                voicemail.setReadEpoch(Long.valueOf(0L));
                voicemail.setReadFlags(((VoicemailMsgs)ucData.get()).getReadFlags());
                voicemail.setRemarks(dataList.getRemarks());
                voicemail.setSourceServerCode(((VoicemailMsgs)ucData.get()).getSourceServerCode());
                voicemail.setSourceUcUser(authentication.getName());
                voicemail.setUsername(extension);
                voicemail.setUuid(UUID.randomUUID().toString());
                this.voicemailMsgsRepository.save((Object)voicemail);
            }
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("OK");
            returnValue.setMessageDetail("Voicemail Transferred Successfully");
            this.ucNotificationService.updateVoiceMailCount(ucUsers);
            logger.info(returnValue.getMessage());
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.BAD_CREDENTIAL);
            returnValue.setMessage("Unable To Transfer Voicemail");
            returnValue.setMessageDetail("Contact With Administrator");
            logger.error(returnValue.getMessageDetail(), (Throwable)e);
        }
        return returnValue;
    }

    public String getFile(String userName, String id) {
        List list = this.voicemailRepository.findByIdAndUserName(id, this.extensionsService.getExtension(userName, "phone"));
        if (list.isEmpty()) {
            return null;
        }
        return ((Voicemail)list.get(0)).getFilepath();
    }

    public RequestResponse getUnLoggedUser(String userName) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList<CustomerAccountProfileModel> addValue = new ArrayList<CustomerAccountProfileModel>();
        List list = this.extensionsRepository.findByExtensionType("phone");
        if (list.isEmpty()) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Not found");
            returnValue.setMessageDetail("Unable to return data");
            logger.info(returnValue.getMessage());
        } else {
            for (Extension row : list) {
                boolean hasRoleUsers;
                List user;
                if (row.getAssignedUser() == null || !StringUtils.hasText((String)row.getAssignedUser()) || row.getAssignedUser().equals(userName) || (user = this.userRepository.findByContactNo(row.getExtension())).isEmpty() || !(hasRoleUsers = this.userService.isUcUser(((User)user.get(0)).getId()))) continue;
                CustomerAccountProfileModel data = new CustomerAccountProfileModel();
                data.setProfileId(row.getAssignedUser());
                data.setExtension(row.getExtension());
                data.setId(row.getId());
                addValue.add(data);
            }
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("Found : " + addValue.size());
            returnValue.setMessageDetail("List of Data");
            returnValue.setData(addValue);
            logger.info(returnValue.getMessage());
        }
        return returnValue;
    }

    public String getProfileId(String file) {
        Optional profileId = this.voicemailRepository.findByFilepath(file);
        if (profileId.isPresent()) {
            return ((Voicemail)profileId.get()).getId();
        }
        return null;
    }

    public RequestResponse emailTransfer(CustomEmailDetailModel attachment, Authentication authentication) {
        RequestResponse returnValue = new RequestResponse();
        String type = "voicemail";
        String fileId = this.getProfileId(attachment.getFilePath());
        returnValue = this.emailDetailService.createEmailDetail(attachment, fileId, type, authentication);
        returnValue.setStatus(returnValue.getStatus());
        returnValue.setMessage(returnValue.getMessage());
        returnValue.setMessageDetail(returnValue.getMessageDetail());
        returnValue.setData(returnValue.getData());
        return returnValue;
    }

    public RequestResponse readVoicemail(InputIdModel data) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList<VoicemailMsgs> addValue = new ArrayList<VoicemailMsgs>();
        logger.info("list of message updated {}", (Object)data.getStringId());
        for (String row : data.getStringId()) {
            Optional currentRecord = this.voicemailMsgsRepository.findByUuid(row);
            if (!currentRecord.isPresent()) continue;
            VoicemailMsgs dataToSave = (VoicemailMsgs)currentRecord.get();
            dataToSave.setReadEpoch(Long.valueOf(System.currentTimeMillis() / 1000L));
            addValue.add(dataToSave);
        }
        this.voicemailMsgsRepository.saveAll(addValue);
        returnValue.setMessage("Message Read");
        returnValue.setMessageDetail("successfully updated");
        logger.info(returnValue.getMessage(), (Object)returnValue.getMessageDetail());
        return returnValue;
    }

    public RequestResponse deleteVoicemail(InputIdModel data) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList<VoicemailMsgs> addValue = new ArrayList<VoicemailMsgs>();
        logger.info("list of message updated {}", (Object)data.getStringId());
        for (String row : data.getStringId()) {
            Optional currentRecord = this.voicemailMsgsRepository.findByUuid(row);
            if (!currentRecord.isPresent()) continue;
            VoicemailMsgs dataToSave = (VoicemailMsgs)currentRecord.get();
            dataToSave.setReadEpoch(Long.valueOf(System.currentTimeMillis() / 1000L));
            addValue.add(dataToSave);
        }
        this.voicemailMsgsRepository.deleteAll(addValue);
        returnValue.setMessage("Message Read");
        returnValue.setMessageDetail("successfully updated");
        logger.info(returnValue.getMessage(), (Object)returnValue.getMessageDetail());
        return returnValue;
    }
}

