/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.telemetry.main.userCoordinate.service;

import com.coraltele.db.telemetry.main.entity.UserCoordinate;
import com.coraltele.db.telemetry.main.entity.UserZone;
import com.coraltele.db.telemetry.main.repository.UserCoordinateRepository;
import com.coraltele.db.telemetry.main.repository.UserZoneRepository;
import com.coraltele.db.telemetry.main.specification.UserCoordinateSpecification;
import com.coraltele.db.telephony.pbx.entity.Extension;
import com.coraltele.db.telephony.pbx.repository.ExtensionsRepository;
import com.coraltele.db.users.main.entity.User;
import com.coraltele.helper.Constants;
import com.coraltele.helper.DateFormatUtility;
import com.coraltele.helper.HttpUtils;
import com.coraltele.helper.RequestResponse;
import com.coraltele.helper.Telephony;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.model.VoiceMessageModel;
import com.coraltele.service.coralApps.pbx.service.CDRService;
import com.coraltele.service.gis.model.AreaSelectedModel;
import com.coraltele.service.pbx.controlRluServer.service.ControlRluServerService;
import com.coraltele.service.pbx.extension.model.MCXCallModel;
import com.coraltele.service.pbx.extension.model.PlayFileModel;
import com.coraltele.service.pbx.extension.service.ExtensionsService;
import com.coraltele.service.telemetry.main.userCoordinate.model.EntityUserCoordinateModel;
import com.coraltele.service.telemetry.main.userCoordinate.model.UserCoordinateModel;
import com.coraltele.service.telemetry.main.userCoordinate.model.UserPointModel;
import com.coraltele.service.user.service.UserService;
import com.coraltele.service.user.userRouteShift.userShift.model.CoordinateModel;
import com.coraltele.service.user.userRouteShift.userShift.service.UserShiftService;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.security.Principal;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class UserCoordinateService {
    private static final Logger logger = LogManager.getLogger(UserCoordinateService.class);
    @Autowired
    UserCoordinateRepository userCoordinateRepository;
    @Autowired
    UserShiftService userShiftService;
    @Autowired
    ExtensionsRepository extensionsRepository;
    @Autowired
    UserZoneRepository userZoneRepository;
    @Autowired
    ControlRluServerService controlRluServerService;
    @Autowired
    ExtensionsService extensionsService;
    @Autowired
    CDRService cdrService;
    @Autowired
    UserService userService;

    public void dialSelected(AreaSelectedModel areaSelected, Principal principal) {
        List numbersToDial = this.userCoordinateRepository.getNumbersInAreaSelected(areaSelected.get_northEast().getLng(), areaSelected.get_northEast().getLat(), areaSelected.get_southWest().getLng(), areaSelected.get_southWest().getLat());
        HashSet<String> uniqueExtensions = new HashSet<String>();
        if (areaSelected.getDepartment() != null && StringUtils.hasText((String)areaSelected.getDepartment())) {
            logger.info("Call initiate for Selected department: {}", (Object)areaSelected.getDepartment());
            for (UserCoordinate imsi : numbersToDial) {
                if (imsi.getDepartment() == null || !imsi.getDepartment().equals(areaSelected.getDepartment())) continue;
                uniqueExtensions.add(imsi.getExtensionNumber());
            }
        } else {
            logger.info("Call initiate for all departments");
            for (UserCoordinate imsi : numbersToDial) {
                uniqueExtensions.add(imsi.getExtensionNumber());
            }
        }
        Optional currentUser = this.userService.getUserByName(principal.getName());
        String dispatcherNumber = Constants.DISPATCHER_NUMBER;
        if (currentUser.isPresent() && StringUtils.hasText((String)((User)currentUser.get()).getContactNo())) {
            dispatcherNumber = ((User)currentUser.get()).getContactNo();
        }
        logger.info("List of Extensions for Call:{}", uniqueExtensions);
        ArrayList<String> recipientList = new ArrayList<String>();
        for (String extension : uniqueExtensions) {
            try {
                if (Constants.CONFERENCE_PROVIDER == 4 || this.extensionsService.getRegisteredExtension().contains(extension)) {
                    String dialCMD;
                    if (Constants.CONFERENCE_PROVIDER == 4) {
                        recipientList.add(extension);
                    } else if (this.extensionsService.getSgwUser(extension)) {
                        dialCMD = "fs_cli -x \"bgapi originate {sip_h_X-Broadcast_Speaker=true,absolute_codec_string='OPUS,PCMU,PCMA',ignore_early_media=true,origination_caller_id_number=" + dispatcherNumber + "}user/" + extension + " &playback('/home/coralswitch/queuesounds/broadcastmsg.wav')\"";
                        logger.info("Command for Call:{}", (Object)dialCMD);
                        Telephony.makeCallBackCall((String)dialCMD);
                    } else {
                        dialCMD = "fs_cli -x \"bgapi originate {sip_h_X-Broadcast_Speaker=true,absolute_codec_string='OPUS,PCMU,PCMA',ignore_early_media=true,origination_caller_id_number=" + dispatcherNumber + "}sofia/" + Constants.DISPATCHER_PROFILE_NAME + "/" + extension + "@" + Constants.DISPATCHER_SIP_SERVER + " &playback('/home/coralswitch/queuesounds/broadcastmsg.wav')\"";
                        logger.info("Command for Call:{}", (Object)dialCMD);
                        Telephony.makeCallBackCall((String)dialCMD);
                    }
                    this.userService.uploadAnnouncementFile(extension, "/home/coralswitch/queuesounds/broadcastmsg.wav", Long.valueOf(System.currentTimeMillis() / 1000L), "Area Selection broadCast", principal.getName());
                    continue;
                }
                logger.error("Not Registered:Call not originate for Number:{}", (Object)extension);
            }
            catch (Exception e) {
                logger.error("Error While making call:{}", (Object)e.getMessage());
            }
        }
        if (recipientList.size() > 0 && Constants.CONFERENCE_PROVIDER == 4) {
            VoiceMessageModel voiceMessage = new VoiceMessageModel();
            voiceMessage.setBroadcastSourceNumber(dispatcherNumber);
            voiceMessage.setBroadcastType("Area Selection BroadCast");
            voiceMessage.setRecipients(recipientList.toArray(new String[0]));
            voiceMessage.setBroadcastDialNumber(dispatcherNumber);
            voiceMessage.setBroadcastUUID(UUID.randomUUID().toString());
            voiceMessage.setMessageFile("broadcastmsg.wav");
            HttpUtils.sendVoiceMessagePPDR((VoiceMessageModel)voiceMessage);
            logger.info("Area Selection BroadCast sent to PPDR with details: {}", (Object)voiceMessage);
        }
    }

    public void createUser(String name) {
        Extension extData;
        UserCoordinate data = new UserCoordinate();
        if (StringUtils.hasText((String)this.userShiftService.getContactNumber(name)) && (extData = this.getExtensionDetail(this.userShiftService.getContactNumber(name))) != null) {
            data.setDepartment(extData.getDepartment());
            data.setZone(extData.getZone());
        }
        data.setUsername(name);
        data.setExtensionNumber(this.userShiftService.getContactNumber(name));
        data.setGeoX("0");
        data.setGeoY("0");
        data.setCreatedOn(Long.valueOf(Instant.now().getEpochSecond()));
        data.setUpdatedOn(Long.valueOf(0L));
        this.userCoordinateRepository.save((Object)data);
    }

    public Extension getExtensionDetail(String extension) {
        Optional extensionData = this.extensionsRepository.findByExtension(extension);
        if (extensionData.isPresent()) {
            return (Extension)extensionData.get();
        }
        return null;
    }

    public RequestResponse callingToSelectedZone(String zoneName) {
        RequestResponse returnValue = new RequestResponse();
        Optional userZone = this.userZoneRepository.findByName(zoneName);
        ArrayList<Coordinate> areaCoordinates = new ArrayList<Coordinate>();
        ArrayList<CoordinateModel> coordinateModels = new ArrayList<CoordinateModel>();
        ArrayList<String> insideUser = new ArrayList<String>();
        ArrayList<String> outsideUser = new ArrayList<String>();
        if (userZone.isPresent()) {
            if (((UserZone)userZone.get()).getCoordinate() != null) {
                for (Coordinate coordinate : ((UserZone)userZone.get()).getCoordinate().getCoordinates()) {
                    CoordinateModel coordModel = new CoordinateModel();
                    coordModel.setLongitude(String.valueOf(coordinate.x));
                    coordModel.setLatitude(String.valueOf(coordinate.y));
                    coordinateModels.add(coordModel);
                    areaCoordinates.add(new Coordinate(coordinate.x, coordinate.y));
                }
            } else {
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("Invalid Zone Coordinate");
                returnValue.setMessageDetail("Selected Zone not valid:" + ((UserZone)userZone.get()).getName());
                logger.error(returnValue.getMessage(), (Object)returnValue.getMessageDetail());
                return returnValue;
            }
        }
        List userCoordinate = this.userCoordinateRepository.findAll();
        for (UserCoordinate userData : userCoordinate) {
            Point userPoint;
            if (userData.getGeoX() == null || userData.getGeoY() == null) continue;
            GeometryFactory geometryFactory = new GeometryFactory();
            Polygon areaPolygon = geometryFactory.createPolygon(areaCoordinates.toArray(new Coordinate[0]));
            if (areaPolygon.contains((Geometry)(userPoint = geometryFactory.createPoint(new Coordinate(Double.parseDouble(userData.getGeoX()), Double.parseDouble(userData.getGeoY())))))) {
                insideUser.add(userData.getExtensionNumber());
                continue;
            }
            outsideUser.add(userData.getExtensionNumber());
        }
        logger.info("List of Inside user:{}", insideUser);
        logger.info("List of Outside error:{}", outsideUser);
        if (!insideUser.isEmpty()) {
            logger.info("Call initiate for all department");
            for (String number : insideUser) {
                String dialCMD = "fs_cli -x \"bgapi originate {origination_caller_id_number=" + Constants.DISPATCHER_NUMBER + "}sofia/" + Constants.DISPATCHER_PROFILE_NAME + "/" + number + "@" + Constants.DISPATCHER_SIP_SERVER + " &playback('/home/coralswitch/queuesounds/broadcastmsg.wav')\"";
                logger.info(dialCMD);
                Telephony.makeCallBackCall((String)dialCMD);
            }
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Invalid Zone Coordinate");
            returnValue.setMessageDetail("Selected Zone not valid:" + ((UserZone)userZone.get()).getName());
            return returnValue;
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Selected zone have no user");
        returnValue.setMessageDetail("No user present inside zone");
        return returnValue;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RequestResponse playFileForZone(Principal principal, PlayFileModel data) {
        RequestResponse returnValue = new RequestResponse();
        String callerNumber = "";
        logger.info("play file initiate for Zone:{}", (Object)data.getZone());
        if (!StringUtils.hasLength((String)data.getZone()) || !StringUtils.hasLength((String)data.getZone())) {
            logger.error("Invalid Zone type:{}", (Object)data.getZone());
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Invalid Zone");
            return returnValue;
        }
        try {
            List groupNameList = this.extensionsRepository.findByExtensionTypeAndZone("ec", data.getZone());
            if (groupNameList.isEmpty()) {
                logger.error("Not any record exist of given group zone:{}", (Object)data.getZone());
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("No data present in given zone");
                return returnValue;
            }
            Extension groupNameData = (Extension)groupNameList.get(0);
            callerNumber = groupNameData.getExtension();
            logger.info("Caller number of selected group is:{}", (Object)callerNumber);
            String rluCode = this.controlRluServerService.getRluCodeFinal(callerNumber);
            String sofiaProfile = this.controlRluServerService.getProfileName(callerNumber);
            logger.info("sofiaProfile:{}", (Object)sofiaProfile);
            String ip = this.cdrService.getIpProxyServer();
            Optional userZone = this.userZoneRepository.findByName(data.getZone());
            ArrayList<Coordinate> areaCoordinates = new ArrayList<Coordinate>();
            ArrayList<CoordinateModel> coordinateModels = new ArrayList<CoordinateModel>();
            ArrayList<String> insideUser = new ArrayList<String>();
            insideUser.add(this.userShiftService.getContactNumber(principal.getName()));
            ArrayList<String> outsideUser = new ArrayList<String>();
            if (!userZone.isPresent()) {
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("Selected zone not exist");
                returnValue.setMessageDetail("Verify the coordinate of selected zone:" + ((UserZone)userZone.get()).getName());
                return returnValue;
            }
            if (((UserZone)userZone.get()).getCoordinate() == null) {
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("Selected Zone not exist");
                returnValue.setMessageDetail("Selected Zone not valid:" + ((UserZone)userZone.get()).getName());
                logger.error(returnValue.getMessage(), (Object)returnValue.getMessageDetail());
                return returnValue;
            }
            for (Coordinate coordinate : ((UserZone)userZone.get()).getCoordinate().getCoordinates()) {
                CoordinateModel coordModel = new CoordinateModel();
                coordModel.setLongitude(String.valueOf(coordinate.x));
                coordModel.setLatitude(String.valueOf(coordinate.y));
                coordinateModels.add(coordModel);
                areaCoordinates.add(new Coordinate(coordinate.x, coordinate.y));
            }
            List userCoordinate = this.userCoordinateRepository.findAll();
            for (UserCoordinate userData : userCoordinate) {
                Point userPoint;
                if (userData.getGeoX() == null || userData.getGeoY() == null) continue;
                GeometryFactory geometryFactory = new GeometryFactory();
                Polygon areaPolygon = geometryFactory.createPolygon(areaCoordinates.toArray(new Coordinate[0]));
                if (areaPolygon.contains((Geometry)(userPoint = geometryFactory.createPoint(new Coordinate(Double.parseDouble(userData.getGeoY()), Double.parseDouble(userData.getGeoX())))))) {
                    insideUser.add(userData.getExtensionNumber());
                    continue;
                }
                outsideUser.add(userData.getExtensionNumber());
            }
            logger.info("List of Inside user:{}", insideUser);
            logger.info("List of Outside error:{}", outsideUser);
            if (insideUser.isEmpty()) {
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("Selected zone have no user");
                returnValue.setMessageDetail("No user present inside zone");
                return returnValue;
            }
            logger.info("Call initiate for all department");
            Iterator iterator = insideUser.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    returnValue.setStatus(Constants.Error.ERROR);
                    returnValue.setMessage("Invalid Zone Coordinate");
                    returnValue.setMessageDetail("Selected Zone not valid:" + ((UserZone)userZone.get()).getName());
                    return returnValue;
                }
                String number = (String)iterator.next();
                String command = String.format("fs_cli -x \"bgapi originate {sip_h_X-Broadcast_Speaker=true,ignore_early_media=true,absolute_codec_string='OPUS,PCMU,PCMA',origination_caller_id_number=%s,sip_h_X-coral_dial_type=paging}sofia/%s/%s@%s &playback('/home/coralswitch/queuesounds/%s')\"", callerNumber, sofiaProfile, number, ip, data.getWavFile());
                logger.info(command);
                Telephony.makeCallBackCall((String)command);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("error during call initiation:{}", (Object)e.getMessage());
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Unable to execute call");
        }
        return returnValue;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RequestResponse zoneCall(Principal principal, MCXCallModel data) {
        RequestResponse returnValue = new RequestResponse();
        String callerNumber = "";
        logger.info("Call initiate for Zone:{}", (Object)data.getZone());
        if (!StringUtils.hasLength((String)data.getZone()) || !StringUtils.hasLength((String)data.getCallType())) {
            logger.error("Invalid call type:{} or zone:{}", (Object)data.getCallType(), (Object)data.getZone());
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Invalid call type or zone");
            return returnValue;
        }
        try {
            String loggedInNumber = this.extensionsService.getExtensionOfUser(principal.getName());
            String ip = this.cdrService.getIpProxyServer();
            List groupNameList = this.extensionsRepository.findByExtensionTypeAndZone("ec", data.getZone());
            if (groupNameList.isEmpty()) {
                logger.error("Not any record exist of given group zone:{}", (Object)data.getZone());
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("No data present in given zone");
                return returnValue;
            }
            Extension groupNameData = (Extension)groupNameList.get(0);
            callerNumber = groupNameData.getExtension();
            logger.info("Caller number of selected group is:{}", (Object)callerNumber);
            String rluCode = this.controlRluServerService.getRluCodeFinal(callerNumber);
            String sofiaProfile = this.controlRluServerService.getProfileName(callerNumber);
            logger.info("sofiaProfile:{}", (Object)sofiaProfile);
            Optional userZone = this.userZoneRepository.findByName(data.getZone());
            ArrayList<Coordinate> areaCoordinates = new ArrayList<Coordinate>();
            ArrayList<CoordinateModel> coordinateModels = new ArrayList<CoordinateModel>();
            ArrayList<String> insideUser = new ArrayList<String>();
            insideUser.add(this.userShiftService.getContactNumber(principal.getName()));
            ArrayList<String> outsideUser = new ArrayList<String>();
            if (!userZone.isPresent()) {
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("Selected zone not exist");
                returnValue.setMessageDetail("Verify the coordinate of selected zone:" + ((UserZone)userZone.get()).getName());
                return returnValue;
            }
            if (((UserZone)userZone.get()).getCoordinate() == null) {
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("Selected zone not exist");
                returnValue.setMessageDetail("Selected Zone not valid:" + ((UserZone)userZone.get()).getName());
                logger.error(returnValue.getMessage(), (Object)returnValue.getMessageDetail());
                return returnValue;
            }
            for (Coordinate coordinate : ((UserZone)userZone.get()).getCoordinate().getCoordinates()) {
                CoordinateModel coordModel = new CoordinateModel();
                coordModel.setLongitude(String.valueOf(coordinate.x));
                coordModel.setLatitude(String.valueOf(coordinate.y));
                coordinateModels.add(coordModel);
                areaCoordinates.add(new Coordinate(coordinate.x, coordinate.y));
            }
            List userCoordinate = this.userCoordinateRepository.findAll();
            for (UserCoordinate userData : userCoordinate) {
                Point userPoint;
                if (userData.getGeoX() == null || userData.getGeoY() == null) continue;
                GeometryFactory geometryFactory = new GeometryFactory();
                Polygon areaPolygon = geometryFactory.createPolygon(areaCoordinates.toArray(new Coordinate[0]));
                if (areaPolygon.contains((Geometry)(userPoint = geometryFactory.createPoint(new Coordinate(Double.parseDouble(userData.getGeoY()), Double.parseDouble(userData.getGeoX()))))) && !userData.getExtensionNumber().equals(loggedInNumber)) {
                    insideUser.add(userData.getExtensionNumber());
                    continue;
                }
                outsideUser.add(userData.getExtensionNumber());
            }
            logger.info("List of Inside user:{}", insideUser);
            logger.info("List of Outside error:{}", outsideUser);
            if (insideUser.isEmpty()) return returnValue;
            Iterator iterator = insideUser.iterator();
            while (iterator.hasNext()) {
                String command;
                String destination = (String)iterator.next();
                logger.info("Caller:{} and destination:{}", (Object)callerNumber, (Object)destination);
                logger.info("Type of call is:{}", (Object)data.getCallType());
                if (data.getCallType().equalsIgnoreCase("presenter")) {
                    command = "";
                    command = data.getIsAudioOnly() != null && data.getIsAudioOnly().booleanValue() ? (data.getIsBroadCast() != null && data.getIsBroadCast().booleanValue() ? String.format("fs_cli -x \"bgapi originate {ignore_early_media=true,absolute_codec_string='PCMU,PCMA',origination_caller_id_number=%s,sip_h_X-coral_dial_type=ec,sip_h_X-mcxvideo=0}sofia/%s/%s@%s &conference(%s@video-mcu-stereo)\"", callerNumber, sofiaProfile, destination, ip, callerNumber) : String.format("fs_cli -x \"bgapi originate {ignore_early_media=true,absolute_codec_string='PCMU,PCMA',origination_caller_id_number=%s,sip_h_X-coral_dial_type=ec,sip_h_X-mcxvideo=1}sofia/%s/%s@%s &conference(%s@video-mcu-stereo)\"", callerNumber, sofiaProfile, destination, ip, callerNumber)) : (data.getIsBroadCast() != null && data.getIsBroadCast() != false ? String.format("fs_cli -x \"bgapi originate {ignore_early_media=true,origination_caller_id_number=%s,sip_h_X-coral_dial_type=ec,sip_h_X-mcxvideo=0}sofia/%s/%s@%s &conference(%s@video-mcu-stereo)\"", callerNumber, sofiaProfile, destination, ip, callerNumber) : String.format("fs_cli -x \"bgapi originate {ignore_early_media=true,origination_caller_id_number=%s,sip_h_X-coral_dial_type=ec,sip_h_X-mcxvideo=1}sofia/%s/%s@%s &conference(%s@video-mcu-stereo)\"", callerNumber, sofiaProfile, destination, ip, callerNumber));
                    logger.info("command to execute call is:::{}", (Object)command);
                    Telephony.makeCallBackCall((String)command);
                    returnValue.setStatus(Constants.Error.OK);
                    returnValue.setMessage("Call execute successfully");
                    continue;
                }
                if (!data.getCallType().equalsIgnoreCase("muxing")) {
                    returnValue.setStatus(Constants.Error.ERROR);
                    returnValue.setMessage("Invalid call type");
                    logger.error("Invalid call type select:{}", (Object)data.getCallType());
                    return returnValue;
                }
                command = "";
                command = data.getIsAudioOnly() != null && data.getIsAudioOnly().booleanValue() ? (data.getIsBroadCast() != null && data.getIsBroadCast().booleanValue() ? String.format("fs_cli -x \"bgapi originate {ignore_early_media=true,absolute_codec_string='PCMU,PCMA',origination_caller_id_number=%s,sip_h_X-coral_dial_type=ec,sip_h_X-mcxvideo=0}sofia/%s/%s@%s &conference(%s@videomux)\"", callerNumber, sofiaProfile, destination, ip, callerNumber) : String.format("fs_cli -x \"bgapi originate {ignore_early_media=true,absolute_codec_string='PCMU,PCMA',origination_caller_id_number=%s,sip_h_X-coral_dial_type=ec,sip_h_X-mcxvideo=1}sofia/%s/%s@%s &conference(%s@videomux)\"", callerNumber, sofiaProfile, destination, ip, callerNumber)) : (data.getIsBroadCast() != null && data.getIsBroadCast() != false ? String.format("fs_cli -x \"bgapi originate {ignore_early_media=true,origination_caller_id_number=%s,sip_h_X-coral_dial_type=ec,sip_h_X-mcxvideo=0}sofia/%s/%s@%s &conference(%s@videomux)\"", callerNumber, sofiaProfile, destination, ip, callerNumber) : String.format("fs_cli -x \"bgapi originate {ignore_early_media=true,origination_caller_id_number=%s,sip_h_X-coral_dial_type=ec,sip_h_X-mcxvideo=1}sofia/%s/%s@%s &conference(%s@videomux)\"", callerNumber, sofiaProfile, destination, ip, callerNumber));
                logger.info("command to execute call is:::{}", (Object)command);
                Telephony.makeCallBackCall((String)command);
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("Call execute successfully");
            }
            return returnValue;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("error during call initiation:{}", (Object)e.getMessage());
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Unable to execute call");
        }
        return returnValue;
    }

    public RequestResponse createData(UserCoordinateModel data) {
        logger.debug("create new UserCoordinate : {} ", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        try {
            UserCoordinate userCoordinate = new UserCoordinate();
            if (data.getConnected() != null) {
                userCoordinate.setConnected(data.getConnected());
            } else {
                userCoordinate.setConnected(Boolean.valueOf(true));
            }
            userCoordinate.setUsername(data.getUsername());
            userCoordinate.setEmergencyStatus(this.getOrDefault(data.getEmergencyStatus()));
            userCoordinate.setExtensionName(this.getOrDefault(data.getExtensionName()));
            userCoordinate.setExtensionNumber(data.getExtensionNumber());
            userCoordinate.setGeoX(this.getOrDefault(data.getGeoX()));
            userCoordinate.setGeoY(this.getOrDefault(data.getGeoY()));
            userCoordinate.setHaddredd(this.getOrDefault(data.getHaddredd()));
            userCoordinate.setName(this.getOrDefault(data.getName()));
            userCoordinate.setOaddress(this.getOrDefault(data.getOAddress()));
            userCoordinate.setZone(this.getOrDefault(data.getZone()));
            userCoordinate.setDepartment(this.getOrDefault(data.getDepartment()));
            userCoordinate.setDeviceType(data.getDeviceType());
            userCoordinate.setDirection(data.getDirection());
            userCoordinate.setCreatedOn(DateFormatUtility.localDateTimeToEpoch((LocalDateTime)LocalDateTime.now()));
            userCoordinate.setBloodgroup(data.getBloodgroup());
            userCoordinate.setPecname(data.getPecname());
            userCoordinate.setPecnumber(data.getPecnumber());
            userCoordinate.setSecname(data.getSecName());
            userCoordinate.setSecnumber(data.getSecnumber());
            userCoordinate.setMeddetails(data.getMeddetails());
            userCoordinate.setAlias(data.getAlias());
            userCoordinate.setRegistrationType(data.getRegistrationType());
            userCoordinate.setTrainNumber(data.getTrainNumber());
            userCoordinate.setRadioLinkEpoch(data.getRadioLinkEpoch());
            userCoordinate.setRLinkStatus(data.getRLinkStatus());
            try {
                this.updateZoneAndDepartment(data.getExtensionNumber(), data.getZone(), data.getDepartment());
                ObjectMapper objectMapper = new ObjectMapper();
                String jsonData = objectMapper.writeValueAsString((Object)data.getData());
                userCoordinate.setData(jsonData);
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error(e.getMessage());
            }
            this.userCoordinateRepository.save((Object)userCoordinate);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("OK");
            returnValue.setMessageDetail("User coordinate created successfully");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.BAD_CREDENTIAL);
            returnValue.setMessage("Unable to create UserCoordinate");
            returnValue.setMessageDetail("Contact with administrator");
            logger.error(returnValue.getMessageDetail(), (Throwable)e);
            return returnValue;
        }
    }

    private String getOrDefault(String value) {
        return value != null ? value : "";
    }

    public RequestResponse updateById(UserCoordinateModel data, Principal principal) {
        logger.debug("Update UserCoordinate {}", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        Optional userCoordinate = this.userCoordinateRepository.findById((Object)data.getId());
        if (!userCoordinate.isPresent()) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("not found");
            returnValue.setMessageDetail("User coordinate not found");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        UserCoordinate imsi = (UserCoordinate)userCoordinate.get();
        if (data.getConnected() != null) {
            imsi.setConnected(data.getConnected());
        } else {
            imsi.setConnected(Boolean.valueOf(false));
        }
        imsi.setUsername(data.getUsername());
        imsi.setEmergencyStatus(this.getOrDefault(data.getEmergencyStatus()));
        imsi.setExtensionName(this.getOrDefault(data.getExtensionName()));
        imsi.setExtensionNumber(data.getExtensionNumber());
        imsi.setGeoX(this.getOrDefault(data.getGeoX()));
        imsi.setGeoY(this.getOrDefault(data.getGeoY()));
        imsi.setHaddredd(this.getOrDefault(data.getHaddredd()));
        imsi.setName(this.getOrDefault(data.getName()));
        imsi.setOaddress(this.getOrDefault(data.getOAddress()));
        imsi.setZone(this.getOrDefault(data.getZone()));
        imsi.setDepartment(this.getOrDefault(data.getDepartment()));
        imsi.setDeviceType(data.getDeviceType());
        imsi.setDirection(data.getDirection());
        imsi.setUpdatedBy(principal.getName());
        imsi.setUpdatedOn(DateFormatUtility.localDateTimeToEpoch((LocalDateTime)LocalDateTime.now()));
        imsi.setBloodgroup(data.getBloodgroup());
        imsi.setPecname(data.getPecname());
        imsi.setPecnumber(data.getPecnumber());
        imsi.setSecname(data.getSecName());
        imsi.setSecnumber(data.getSecnumber());
        imsi.setMeddetails(data.getMeddetails());
        imsi.setAlias(data.getAlias());
        imsi.setRegistrationType(data.getRegistrationType());
        imsi.setTrainNumber(data.getTrainNumber());
        imsi.setRadioLinkEpoch(data.getRadioLinkEpoch());
        imsi.setRLinkStatus(data.getRLinkStatus());
        imsi.setDeviceId(data.getDeviceId());
        try {
            this.updateZoneAndDepartment(data.getExtensionNumber(), data.getZone(), data.getDepartment());
            ObjectMapper objectMapper = new ObjectMapper();
            String jsonData = objectMapper.writeValueAsString((Object)data.getData());
            imsi.setData(jsonData);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(e.getMessage());
        }
        this.userCoordinateRepository.save((Object)imsi);
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Updated");
        returnValue.setMessageDetail("UserCoordinate Updated successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse deleteById(InputIdModel data) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList addValue = new ArrayList();
        for (Integer ids : data.getIntId()) {
            Optional imsi = this.userCoordinateRepository.findById((Object)ids);
            if (imsi.isPresent()) {
                addValue.add(imsi.get());
                this.userCoordinateRepository.deleteAll(addValue);
                continue;
            }
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Records not found ");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setMessageDetail("Records Deleted Successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getAllUserCoordinateFilter(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = UserCoordinateSpecification.generateFilters((SearchRequest)searchRequestData, (boolean)false);
        Sort sort = null;
        if (searchRequestData.sortDirection.equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).ascending();
        } else if (searchRequestData.sortDirection.equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).descending();
        }
        Page page = null;
        page = sort == null ? this.userCoordinateRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.userCoordinateRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)this.entityToModelConversion(page.getContent()));
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getAllUserCoordinateEmergency(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = UserCoordinateSpecification.generateFilters((SearchRequest)searchRequestData, (boolean)true);
        Sort sort = null;
        if (searchRequestData.sortDirection.equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).ascending();
        } else if (searchRequestData.sortDirection.equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).descending();
        }
        Page page = null;
        page = sort == null ? this.userCoordinateRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.userCoordinateRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)this.entityToModelConversion(page.getContent()));
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public void updateZoneAndDepartment(String extension, String zone, String department) {
        Optional extensionData = this.extensionsRepository.findByExtension(extension);
        if (extensionData.isPresent()) {
            ((Extension)extensionData.get()).setZone(zone);
            ((Extension)extensionData.get()).setDepartment(department);
            this.extensionsRepository.save(extensionData.get());
        }
    }

    public RequestResponse getAllUserCoordinate() {
        List list = this.userCoordinateRepository.findAll();
        ArrayList<UserPointModel> addValue = new ArrayList<UserPointModel>();
        RequestResponse returnValue = new RequestResponse();
        for (UserCoordinate data : list) {
            UserPointModel userPointModel = new UserPointModel();
            userPointModel.setUserId(data.getUsername());
            userPointModel.setLatitude(data.getGeoX());
            userPointModel.setLongitude(data.getGeoY());
            userPointModel.setColorCode(this.userService.getColor(data.getUsername()));
            userPointModel.setRsRpSim1(data.getRsRpSim1());
            userPointModel.setRsRpSim2(data.getRsRpSim2());
            addValue.add(userPointModel);
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setData(addValue);
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public List<EntityUserCoordinateModel> entityToModelConversion(List<UserCoordinate> list) {
        ArrayList<EntityUserCoordinateModel> addValue = new ArrayList<EntityUserCoordinateModel>();
        for (UserCoordinate row : list) {
            EntityUserCoordinateModel data = new EntityUserCoordinateModel();
            data.setId(row.getId());
            data.setUuid(row.getUuid());
            data.setUsername(row.getUsername());
            data.setExtensionNumber(row.getExtensionNumber());
            data.setExtensionName(row.getExtensionName());
            data.setGeoX(row.getGeoX());
            data.setGeoY(row.getGeoY());
            data.setName(row.getName());
            data.setZone(row.getZone());
            data.setDepartment(row.getDepartment());
            data.setCreatedOn(row.getCreatedOn());
            data.setUpdatedOn(row.getUpdatedOn());
            data.setUpdatedBy(row.getUpdatedBy());
            data.setConnected(row.getConnected());
            data.setEmergencyStatus(row.getEmergencyStatus());
            data.setBloodGroup(row.getBloodgroup());
            data.setHAddredd(row.getHaddredd());
            data.setOAddress(row.getOaddress());
            data.setPecName(row.getPecname());
            data.setPecNumber(row.getPecnumber());
            data.setSecName(row.getSecname());
            data.setSecNumber(row.getSecnumber());
            data.setMedDetails(row.getMeddetails());
            data.setAlias(row.getAlias());
            data.setDirection(row.getDirection());
            data.setDeviceType(row.getDeviceType());
            data.setRegistrationType(row.getRegistrationType());
            data.setTrainNumber(row.getTrainNumber());
            data.setRLinkStatus(row.getRLinkStatus());
            data.setRadioLinkEpoch(row.getRadioLinkEpoch());
            data.setRsRpSim1(row.getRsRpSim1());
            data.setRsRpSim2(row.getRsRpSim2());
            data.setDeviceId(row.getDeviceId());
            data.setBatteryPercentage(row.getBatteryPercentage());
            data.setEmergencyCreatedOn(row.getEmergencyCreatedOn());
            data.setDesignation(this.userService.getDesignationByUsername(row.getUsername()));
            addValue.add(data);
        }
        return addValue;
    }
}

