/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.telemetry.main.lastTenCalls.service;

import com.coraltele.db.coralapps.callcenter.repository.QueueRepository;
import com.coraltele.db.telemetry.main.entity.view.DialedCallView;
import com.coraltele.db.telemetry.main.repository.DialedCallViewRepository;
import com.coraltele.db.telemetry.main.specification.DialedCallViewSpecification;
import com.coraltele.helper.DateFormatUtility;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.telemetry.main.lastTenCalls.model.LastTenCallModel;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class DialedCallService {
    private static final Logger logger = LogManager.getLogger(DialedCallService.class);
    @Autowired
    DialedCallViewRepository dialedCallViewRepository;
    @Autowired
    DateFormatUtility dateFormatUtility;
    @Autowired
    QueueRepository queueRepository;

    public RequestResponse getAllByFilter(SearchRequest searchRequestData, Principal principal) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = DialedCallViewSpecification.generateFilters((SearchRequest)searchRequestData, (Principal)principal);
        Sort sort = null;
        if (searchRequestData.getSortDirection().equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "startTime" : searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.getSortDirection().equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "startTime" : searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.dialedCallViewRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.dialedCallViewRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)this.entityToModelConversion(page.getContent()));
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public List<LastTenCallModel> entityToModelConversion(List<DialedCallView> lastAgent) {
        ArrayList<LastTenCallModel> addValue = new ArrayList<LastTenCallModel>();
        for (DialedCallView row : lastAgent) {
            LastTenCallModel data = new LastTenCallModel();
            data.setUuid(row.getUuid());
            data.setAgentName(row.getAgentName());
            if (row.getStartTime() != null) {
                data.setStartTime(DateFormatUtility.epochToLocalDateTimeAsStringForSecond((Long)row.getStartTime()));
            }
            data.setCustomerNumber(row.getCustomerNumber());
            data.setDirection(row.getDirection());
            data.setQueue(row.getQueue());
            data.setQueueName(row.getQueueName());
            data.setRecordingFile(row.getRecordingFile());
            data.setTalkDuration(DateFormatUtility.findLocalTime((Long)row.getTalkDuration().longValue()));
            addValue.add(data);
        }
        return addValue;
    }
}

