/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.telemetry.coralnms.widget.service;

import com.coraltele.db.telemetry.coralnms.entity.API;
import com.coraltele.db.telemetry.coralnms.entity.Sensor;
import com.coraltele.db.telemetry.coralnms.entity.Widget;
import com.coraltele.db.telemetry.coralnms.entity.WidgetType;
import com.coraltele.db.telemetry.coralnms.repository.APIRepository;
import com.coraltele.db.telemetry.coralnms.repository.SenorRepository;
import com.coraltele.db.telemetry.coralnms.repository.WidgetRepository;
import com.coraltele.db.telemetry.coralnms.repository.WidgetTypeRepository;
import com.coraltele.db.telemetry.coralnms.specification.WidgetSpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.telemetry.coralnms.widget.model.DataTypeModel;
import com.coraltele.service.telemetry.coralnms.widget.model.WidgetModel;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class WidgetService {
    private static final Logger logger = LogManager.getLogger(WidgetService.class);
    @Autowired
    WidgetRepository widgetRepository;
    @Autowired
    WidgetTypeRepository widgetTypeRepository;
    @Autowired
    APIRepository apiRepository;
    @Autowired
    SenorRepository senorRepository;

    public RequestResponse create(WidgetModel data) {
        logger.debug("create new widget : {} ", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        try {
            Optional api;
            Optional widgetType;
            Optional sensor;
            Widget widget = new Widget();
            widget.setName(data.getName());
            widget.setCode(data.getCode());
            widget.setChartType(data.getChartType());
            widget.setApiURL(data.getApiURL());
            widget.setThresholdLower(data.getThresholdLower());
            widget.setThresholdUpper(data.getThresholdUpper());
            if (data.getSensor() != null && (sensor = this.senorRepository.findById(data.getSensor())).isPresent()) {
                widget.setSensor((Sensor)sensor.get());
            }
            widget.setSensorAttribute(data.getSensorAttribute());
            widget.setLocation(data.getLocation());
            widget.setLegendField(data.getLegendField());
            widget.setValueField(data.getValueField());
            widget.setColumns(data.getColumns());
            widget.setActions(data.getActions());
            widget.setLegendFieldDataType(data.getLegendFieldDataType());
            widget.setValueFieldDataType(data.getValueFieldDataType());
            if (data.getWidgetType() != null && (widgetType = this.widgetTypeRepository.findById(data.getWidgetType())).isPresent()) {
                widget.setWidgetType((WidgetType)widgetType.get());
            }
            if (data.getApi() != null && (api = this.apiRepository.findById(data.getApi())).isPresent()) {
                widget.setApi((API)api.get());
            }
            widget.setShowLegends(data.getShowLegends());
            widget.setRefreshInterval(data.getRefreshInterval());
            widget.setImageName(data.getImageName());
            widget.setWidth(data.getWidth());
            widget.setHeight(data.getHeight());
            widget.setMinValue(data.getMinValue());
            widget.setMaxValue(data.getMaxValue());
            widget.setMetricsName(data.getMetricsName());
            widget.setMetricsDataDuration(data.getMetricsDataDuration());
            widget.setMetricsDataDivision(data.getMetricsDataDivision());
            widget.setMetricsInvertValue(data.getMetricsInvertValue());
            widget.setMetricsInstanceName(data.getMetricsInstanceName());
            widget.setCategory(data.getCategory());
            widget.setIsDefaultDashboard(data.getIsDefaultDashboard());
            widget.setEnabled(data.getEnabled());
            widget.setExport(data.getExport());
            widget.setUuid(UUID.randomUUID().toString());
            this.widgetRepository.save((Object)widget);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("OK");
            returnValue.setMessageDetail("Widget Created Successfully");
            logger.info(returnValue.getMessage());
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.UNKNOWN_ERROR);
            returnValue.setMessage("Unable To Create Widget");
            returnValue.setMessageDetail("Contact With Administrator");
            logger.error(returnValue.getMessageDetail(), (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse update(WidgetModel data) {
        Widget widget;
        logger.debug("Update widget {}", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        Optional dataFound = this.widgetRepository.findById(data.getId());
        if (dataFound.isPresent()) {
            Optional api;
            Optional widgetType;
            Optional sensor;
            widget = (Widget)dataFound.get();
            if (data.getName() != null) {
                widget.setName(data.getName());
            }
            if (data.getCode() != null) {
                widget.setCode(data.getCode());
            }
            if (data.getChartType() != null) {
                widget.setChartType(data.getChartType());
            }
            if (data.getApiURL() != null) {
                widget.setApiURL(data.getApiURL());
            }
            if (data.getThresholdLower() != null) {
                widget.setThresholdLower(data.getThresholdLower());
            }
            if (data.getThresholdUpper() != null) {
                widget.setThresholdUpper(data.getThresholdUpper());
            }
            if (data.getSensor() != null && (sensor = this.senorRepository.findById(data.getSensor())).isPresent()) {
                widget.setSensor((Sensor)sensor.get());
            }
            if (data.getSensorAttribute() != null) {
                widget.setSensorAttribute(data.getSensorAttribute());
            }
            if (data.getLocation() != null) {
                widget.setLocation(data.getLocation());
            }
            if (data.getLegendField() != null) {
                widget.setLegendField(data.getLegendField());
            }
            if (data.getValueField() != null) {
                widget.setValueField(data.getValueField());
            }
            if (data.getColumns() != null) {
                widget.setColumns(data.getColumns());
            }
            if (data.getActions() != null) {
                widget.setActions(data.getActions());
            }
            if (data.getLegendFieldDataType() != null) {
                widget.setLegendFieldDataType(data.getLegendFieldDataType());
            }
            if (data.getValueFieldDataType() != null) {
                widget.setValueFieldDataType(data.getValueFieldDataType());
            }
            if (data.getWidgetType() != null && (widgetType = this.widgetTypeRepository.findById(data.getWidgetType())).isPresent()) {
                widget.setWidgetType((WidgetType)widgetType.get());
            }
            if (data.getApi() != null && (api = this.apiRepository.findById(data.getApi())).isPresent()) {
                widget.setApi((API)api.get());
            }
            if (data.getShowLegends() != null) {
                widget.setShowLegends(data.getShowLegends());
            }
            if (data.getRefreshInterval() != null) {
                widget.setRefreshInterval(data.getRefreshInterval());
            }
            if (data.getImageName() != null) {
                widget.setImageName(data.getImageName());
            }
            if (data.getWidth() != null) {
                widget.setWidth(data.getWidth());
            }
            if (data.getHeight() != null) {
                widget.setHeight(data.getHeight());
            }
            if (data.getMinValue() != null) {
                widget.setMinValue(data.getMinValue());
            }
            if (data.getMaxValue() != null) {
                widget.setMaxValue(data.getMaxValue());
            }
            if (data.getMetricsName() != null) {
                widget.setMetricsName(data.getMetricsName());
            }
            if (data.getMetricsDataDuration() != null) {
                widget.setMetricsDataDuration(data.getMetricsDataDuration());
            }
            if (data.getMetricsDataDivision() != null) {
                widget.setMetricsDataDivision(data.getMetricsDataDivision());
            }
            if (data.getMetricsInvertValue() != null) {
                widget.setMetricsInvertValue(data.getMetricsInvertValue());
            }
            if (data.getMetricsInstanceName() != null) {
                widget.setMetricsInstanceName(data.getMetricsInstanceName());
            }
            if (data.getCategory() != null) {
                widget.setCategory(data.getCategory());
            }
            if (data.getIsDefaultDashboard() != null) {
                widget.setIsDefaultDashboard(data.getIsDefaultDashboard());
            }
            if (data.getEnabled() != null) {
                widget.setEnabled(data.getEnabled());
            }
            if (data.getExport() != null) {
                widget.setExport(data.getExport());
            }
        } else {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Not Found");
            returnValue.setMessageDetail("Widget Not Found");
            logger.error(returnValue.getMessage());
            return returnValue;
        }
        this.widgetRepository.save((Object)widget);
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Updated");
        returnValue.setMessageDetail("Widget Updated Successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse delete(InputIdModel data) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList addValue = new ArrayList();
        for (Long id : data.getId()) {
            Optional widget = this.widgetRepository.findById(Integer.valueOf(id.intValue()));
            if (!widget.isPresent()) {
                returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                returnValue.setMessage(MessageFormat.format("Record Not Found With Id => {}", id));
                logger.info(returnValue.getMessage());
                return returnValue;
            }
            addValue.add(widget.get());
            this.widgetRepository.deleteAll(addValue);
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setMessageDetail("Records Has Been Deleted");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getList(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = WidgetSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.sortDirection.equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).ascending();
        } else if (searchRequestData.sortDirection.equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).descending();
        }
        Page page = null;
        page = sort == null ? this.widgetRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.widgetRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)page.getContent());
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getAll() {
        List list = this.widgetRepository.findAll();
        HashSet<String> uniqueDataTypes = new HashSet<String>();
        RequestResponse returnValue = new RequestResponse();
        for (Widget widget : list) {
            uniqueDataTypes.add(widget.getLegendFieldDataType());
            uniqueDataTypes.add(widget.getValueFieldDataType());
        }
        ArrayList<DataTypeModel> addValue = new ArrayList<DataTypeModel>();
        for (String dataType : uniqueDataTypes) {
            DataTypeModel data = new DataTypeModel();
            data.setDataType(dataType);
            addValue.add(data);
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setData(addValue);
        logger.info(returnValue.getMessage());
        return returnValue;
    }
}

