/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.pbx.systemConfig.service;

import com.coraltele.db.telephony.pbx.entity.SystemConfig;
import com.coraltele.db.telephony.pbx.repository.SystemConfigRepository;
import com.coraltele.helper.CallServerConfiguration;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.service.pbx.systemConfig.model.SystemConfigModel;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service
public class SystemConfigService {
    private static final Logger logger = LogManager.getLogger(SystemConfigService.class);
    @Autowired
    SystemConfigRepository systemConfigRepository;
    @Autowired
    private CallServerConfiguration callServerConfiguration;

    public RequestResponse getData() {
        RequestResponse returnValue = new RequestResponse();
        List list = this.systemConfigRepository.findAll();
        ArrayList<SystemConfigModel> addValue = new ArrayList<SystemConfigModel>();
        if (list.isEmpty()) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Not found");
            returnValue.setMessageDetail("Unable to return data");
            logger.info(returnValue.getMessage());
        } else {
            for (SystemConfig row : list) {
                SystemConfigModel data = new SystemConfigModel();
                data.setId(row.getId());
                data.setTpcBeepInterval(row.getTpcBeepInterval());
                data.setNoAnsForwardTimer(row.getNoAnsForwardTimer());
                data.setTransRecallTimer(row.getTransRecallTimer());
                data.setParkExpiryInterval(row.getParkExpiryInterval());
                data.setHoldExpiryInterval(row.getHoldExpiryInterval());
                data.setAlarmRingTimer(row.getAlarmRingTimer());
                data.setSmsText(row.getSmsText());
                data.setSmsUrl(row.getSmsUrl());
                data.setNoOfOldDaySmsSend(row.getNoOfOldDaySmsSend());
                data.setMaxSmsTry(row.getMaxSmsTry());
                data.setRingTimer(this.callServerConfiguration.getIntProperty("ringtime"));
                addValue.add(data);
            }
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Found");
        returnValue.setMessageDetail("Getting Data");
        returnValue.setData(addValue);
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse update(SystemConfigModel data, Authentication authentication) {
        RequestResponse returnValue = new RequestResponse();
        List currentRecord = this.systemConfigRepository.findAll();
        if (!currentRecord.isEmpty()) {
            SystemConfig systemConfig = (SystemConfig)currentRecord.get(0);
            if (data.getTpcBeepInterval() != null) {
                systemConfig.setTpcBeepInterval(data.getTpcBeepInterval());
            }
            if (data.getNoAnsForwardTimer() != null) {
                systemConfig.setNoAnsForwardTimer(data.getNoAnsForwardTimer());
            }
            if (data.getTransRecallTimer() != null) {
                systemConfig.setTransRecallTimer(data.getTransRecallTimer());
            }
            if (data.getParkExpiryInterval() != null) {
                systemConfig.setParkExpiryInterval(data.getParkExpiryInterval());
            }
            if (data.getHoldExpiryInterval() != null) {
                systemConfig.setHoldExpiryInterval(data.getHoldExpiryInterval());
            }
            if (data.getAlarmRingTimer() != null) {
                systemConfig.setAlarmRingTimer(data.getAlarmRingTimer());
            }
            if (data.getSmsUrl() != null) {
                systemConfig.setSmsUrl(data.getSmsUrl());
            }
            if (data.getSmsText() != null) {
                systemConfig.setSmsText(data.getSmsText());
            }
            if (data.getNoOfOldDaySmsSend() != null) {
                systemConfig.setNoOfOldDaySmsSend(data.getNoOfOldDaySmsSend());
            } else {
                systemConfig.setNoOfOldDaySmsSend(Integer.valueOf(1));
            }
            if (data.getMaxSmsTry() != null) {
                systemConfig.setMaxSmsTry(data.getMaxSmsTry());
            } else {
                systemConfig.setMaxSmsTry(Integer.valueOf(1));
            }
            if (data.getRingTimer() != null) {
                this.callServerConfiguration.setProperty("ringtime", data.getRingTimer().toString());
            }
            this.systemConfigRepository.save((Object)systemConfig);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage(" updated successfully");
            returnValue.setMessageDetail(MessageFormat.format("Data updated successfully of this id: {0}", data));
        } else {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage(MessageFormat.format("Unable to find the record {0}", data));
        }
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public void updateSyncId() {
        SystemConfig systemConfig;
        List currentRecord = this.systemConfigRepository.findAll();
        if (!currentRecord.isEmpty() && (systemConfig = (SystemConfig)currentRecord.get(0)).getUpdateId() != null) {
            systemConfig.setSyncId(systemConfig.getUpdateId());
            this.systemConfigRepository.save((Object)systemConfig);
        }
    }

    public RequestResponse getUpdatedId() {
        RequestResponse response = new RequestResponse();
        try {
            List systemConfigs = this.systemConfigRepository.findAll();
            HashMap<String, String> data = new HashMap<String, String>();
            if (!systemConfigs.isEmpty()) {
                SystemConfig config = (SystemConfig)systemConfigs.get(0);
                data.put("updatedId", config.getUpdateId());
            }
            response.setStatus(Constants.Error.OK);
            response.setMessage("Fetched updatedId successfully");
            response.setData(data);
        }
        catch (Exception e) {
            response.setStatus(Constants.Error.UNKNOWN_ERROR);
            response.setMessage("Failed to fetch updatedId");
            response.setMessageDetail(e.getMessage());
        }
        return response;
    }
}

