/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.pbx.ivrFile.service;

import com.coraltele.db.telephony.pbx.entity.IVRFile;
import com.coraltele.db.telephony.pbx.repository.IVRFileRepository;
import com.coraltele.helper.Constants;
import com.coraltele.helper.IVRUtility;
import com.coraltele.helper.RequestResponse;
import java.util.Optional;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.tika.Tika;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component
public class IVRFileService {
    private static final Logger logger = LogManager.getLogger(IVRFileService.class);
    @Autowired
    IVRFileRepository ivrFileRepository;
    @Autowired
    private IVRUtility iVRUtility;

    public RequestResponse create(String group, String description) {
        logger.debug("create data : {} {}", (Object)group, (Object)description);
        RequestResponse returnValue = new RequestResponse();
        String filename = UUID.randomUUID().toString().trim();
        try {
            IVRFile ivrFile = IVRFile.builder().fileGroup(group).fileName(filename).description(description).build();
            this.ivrFileRepository.save((Object)ivrFile);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("Created ");
            returnValue.setMessageDetail("Data Created Successfully ");
            logger.info(returnValue.getMessage());
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Unable To Create Data");
            returnValue.setMessageDetail("Please Contact Administrator");
            logger.error(returnValue.getMessageDetail(), (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse uploadFile(MultipartFile file, String language, String filename) {
        logger.debug("upload file : {} {} {}", (Object)file, (Object)language, (Object)filename);
        RequestResponse returnValue = new RequestResponse();
        try {
            if (file.isEmpty()) {
                returnValue.setStatus(Constants.Error.BAD_INPUT_DATA);
                returnValue.setMessage("File Can Not Be Empty");
                returnValue.setMessageDetail("kindly Upload The File");
                logger.error(returnValue.getMessageDetail());
            } else {
                Optional fileToUpload = this.ivrFileRepository.findByFileName(filename);
                if (fileToUpload.isPresent()) {
                    Tika tika = new Tika();
                    String mimeType = tika.detect(file.getInputStream());
                    if (mimeType.equals("audio/mpeg") || mimeType.equals("audio/mp3") || mimeType.equals("audio/x-wav") || mimeType.equals("audio/wav") || mimeType.equals("audio/vnd.wave")) {
                        String contentType = mimeType.equals("audio/mpeg") || mimeType.equals("audio/mp3") ? ".mp3" : ".wav";
                        boolean uploaded = this.iVRUtility.getFileToUpload(file, language, filename, contentType);
                        if (uploaded) {
                            returnValue.setStatus(Constants.Error.OK);
                            returnValue.setMessage(" Uploaded ");
                            returnValue.setMessageDetail("File Has Been Uploaded Successfully");
                            logger.info(returnValue.getMessage());
                        } else {
                            returnValue.setStatus(Constants.Error.ERROR);
                            returnValue.setMessage(" File Not Uploaded ");
                            returnValue.setMessageDetail("Contact With Administrator");
                            logger.error(returnValue.getMessageDetail());
                        }
                    } else {
                        returnValue.setStatus(Constants.Error.BAD_INPUT_DATA);
                        returnValue.setMessage("Can Not Upload The File");
                        returnValue.setMessageDetail(" File Must Be Either wav or mp3 ");
                        logger.error(returnValue.getMessageDetail());
                    }
                } else {
                    returnValue.setStatus(Constants.Error.BAD_INPUT_DATA);
                    returnValue.setMessage("Can Not Upload The File");
                    returnValue.setMessageDetail(" Invalid Filename ");
                    logger.error(returnValue.getMessageDetail());
                }
            }
        }
        catch (NullPointerException n) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Unable To Upload File");
            returnValue.setMessageDetail("File Or Path May Not Be Exist");
            logger.error(returnValue.getMessageDetail(), (Throwable)n);
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Unable To Upload File");
            returnValue.setMessageDetail("Please Contact Administrator");
            logger.error(returnValue.getMessageDetail(), (Throwable)e);
        }
        return returnValue;
    }
}

