/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.pbx.gatewayController.service;

import com.coraltele.db.telephony.pbx.entity.GatewayController;
import com.coraltele.db.telephony.pbx.repository.GatewayControllerRepository;
import com.coraltele.db.telephony.pbx.specification.GatewayControllerSpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.pbx.gatewayController.model.GatewayControllerModel;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class GatewayControllerService {
    private static final Logger logger = LogManager.getLogger(GatewayControllerService.class);
    @Autowired
    GatewayControllerRepository gatewayControllerRepository;

    public RequestResponse createData(GatewayControllerModel data) {
        logger.debug("create new gatewayController : {} ", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        try {
            GatewayController gatewayController = new GatewayController();
            gatewayController.setChannelLimit(data.getChannelLimit());
            gatewayController.setCreatedOn(LocalDateTime.now());
            gatewayController.setDescription(data.getDescription());
            gatewayController.setGatewayCode(data.getGatewayCode());
            gatewayController.setLastState(data.getLastState());
            gatewayController.setLastStateChanged(data.getLastStateChanged());
            if (data.getRCoc() != null) {
                gatewayController.setRCoc(data.getRCoc());
            } else {
                gatewayController.setRCoc(Boolean.valueOf(false));
            }
            this.gatewayControllerRepository.save((Object)gatewayController);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("OK");
            returnValue.setMessageDetail("GatewayController Created Successfully");
            logger.info(returnValue.getMessage());
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.BAD_CREDENTIAL);
            returnValue.setMessage("Unable to Create GatewayController");
            returnValue.setMessageDetail("Contact with Administrator");
            logger.error(returnValue.getMessageDetail(), (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse deleteById(InputIdModel data) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList addValue = new ArrayList();
        for (Integer ids : data.getIntId()) {
            Optional gatewayController = this.gatewayControllerRepository.findById((Object)ids);
            if (gatewayController.isPresent()) {
                addValue.add(gatewayController.get());
                this.gatewayControllerRepository.deleteAll(addValue);
                continue;
            }
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Records not found ");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setMessageDetail("GatewayController Deleted Successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse updateById(GatewayControllerModel data) {
        logger.debug("Update GatewayController {}", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        Optional gatewayController = this.gatewayControllerRepository.findById((Object)data.getId());
        if (!gatewayController.isPresent()) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("not found");
            returnValue.setMessageDetail("GatewayController not found");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        if (data.getChannelLimit() != null) {
            ((GatewayController)gatewayController.get()).setChannelLimit(data.getChannelLimit());
        }
        if (data.getDescription() != null) {
            ((GatewayController)gatewayController.get()).setDescription(data.getDescription());
        }
        if (data.getGatewayCode() != null) {
            ((GatewayController)gatewayController.get()).setGatewayCode(data.getGatewayCode());
        }
        if (data.getLastState() != null) {
            ((GatewayController)gatewayController.get()).setLastState(data.getLastState());
        }
        if (data.getLastStateChanged() != null) {
            ((GatewayController)gatewayController.get()).setLastStateChanged(data.getLastStateChanged());
        }
        if (data.getRCoc() != null) {
            ((GatewayController)gatewayController.get()).setRCoc(data.getRCoc());
        }
        this.gatewayControllerRepository.save(gatewayController.get());
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Updated");
        returnValue.setMessageDetail("GatewayController Updated successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getAllByFilter(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = GatewayControllerSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.getSortDirection().equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "channelLimit" : searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.getSortDirection().equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "channelLimit" : searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.gatewayControllerRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.gatewayControllerRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)this.entityToModelConversion(page.getContent()));
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public List<GatewayControllerModel> entityToModelConversion(List<GatewayController> gatewayController) {
        ArrayList<GatewayControllerModel> addValue = new ArrayList<GatewayControllerModel>();
        for (GatewayController data : gatewayController) {
            GatewayControllerModel gatewayControllerModel = new GatewayControllerModel();
            gatewayControllerModel.setId(data.getId());
            gatewayControllerModel.setChannelLimit(data.getChannelLimit());
            gatewayControllerModel.setCreatedOn(data.getCreatedOn());
            gatewayControllerModel.setDescription(data.getDescription());
            gatewayControllerModel.setGatewayCode(data.getGatewayCode());
            gatewayControllerModel.setLastState(data.getLastState());
            gatewayControllerModel.setLastStateChanged(data.getLastStateChanged());
            gatewayControllerModel.setRCoc(data.getRCoc());
            addValue.add(gatewayControllerModel);
        }
        return addValue;
    }

    public RequestResponse getAllGatewayController() {
        List list = this.gatewayControllerRepository.findAll();
        ArrayList<GatewayControllerModel> addValue = new ArrayList<GatewayControllerModel>();
        RequestResponse returnValue = new RequestResponse();
        for (GatewayController data : list) {
            GatewayControllerModel gatewayControllerModel = new GatewayControllerModel();
            gatewayControllerModel.setId(data.getId());
            gatewayControllerModel.setChannelLimit(data.getChannelLimit());
            gatewayControllerModel.setCreatedOn(data.getCreatedOn());
            gatewayControllerModel.setDescription(data.getDescription());
            gatewayControllerModel.setGatewayCode(data.getGatewayCode());
            gatewayControllerModel.setLastState(data.getLastState());
            gatewayControllerModel.setLastStateChanged(data.getLastStateChanged());
            gatewayControllerModel.setRCoc(data.getRCoc());
            addValue.add(gatewayControllerModel);
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setData(addValue);
        logger.info(returnValue.getMessage());
        return returnValue;
    }
}

