/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.pbx.fileConfiguration.defaultComparison.service;

import com.coraltele.db.telephony.pbx.entity.Extension;
import com.coraltele.db.telephony.pbx.entity.ExtensionsServices;
import com.coraltele.db.telephony.pbx.entity.view.DefaultComparison;
import com.coraltele.db.telephony.pbx.repository.DefaultComparisonRepository;
import com.coraltele.db.telephony.pbx.repository.ExtensionsRepository;
import com.coraltele.db.telephony.pbx.repository.ExtensionsServicesRepository;
import com.coraltele.db.telephony.pbx.specification.DefaultComparisonSpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.PasswordConversion;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.pbx.extension.service.ExtensionsService;
import com.coraltele.service.pbx.fileConfiguration.defaultComparison.model.ExtensionFileModel;
import com.coraltele.service.pbx.fileConfiguration.defaultConfiguration.model.ServiceCodeConfigurationModel;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class DefaultComparisonService {
    private static final Logger logger = LogManager.getLogger(DefaultComparisonService.class);
    private static String storePathConfiguration = "/etc/coraltele/conf/default.config";
    @Autowired
    private DefaultComparisonRepository defaultComparisonRepository;
    @Autowired
    private ExtensionsRepository extensionsRepository;
    @Autowired
    private ExtensionsServicesRepository extensionsServicesRepository;
    @Autowired
    private ExtensionsService extensionsService;
    @Autowired
    PasswordConversion PasswordConversion;

    public RequestResponse getComparedData(SearchRequest searchRequestData) throws IOException {
        RequestResponse returnValue = new RequestResponse();
        logger.debug("get list of data according to the applied conditions : {} ", (Object)searchRequestData);
        try {
            Specification filters = DefaultComparisonSpecification.generateFilters((SearchRequest)searchRequestData);
            Sort sort = null;
            if (searchRequestData.getSortDirection().equals("asc")) {
                sort = Sort.by((String[])new String[]{searchRequestData.getSortBy()}).ascending();
            } else if (searchRequestData.getSortDirection().equals("desc")) {
                sort = Sort.by((String[])new String[]{searchRequestData.getSortBy()}).descending();
            }
            Page page = null;
            page = sort == null ? this.defaultComparisonRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.defaultComparisonRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
            SearchResponse responseData = new SearchResponse();
            responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
            responseData.setPageSize((long)page.getSize());
            responseData.setTotalPages((long)page.getTotalPages());
            responseData.setTotalRecords(page.getTotalElements());
            responseData.setCurrentPageData((Object)page.getContent());
            returnValue.setData((Object)responseData);
            returnValue.setMessage("List of Filtered Data");
            logger.info(returnValue.getMessage());
        }
        catch (FileNotFoundException e) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("File Not Found");
            returnValue.setMessageDetail("Can Not Retrieve The Data, File Not Present .");
            logger.error("File Not Found. ", (Throwable)e);
        }
        catch (NullPointerException e) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("File May Be Empty");
            returnValue.setMessageDetail("Data May Be Inappropriate, Firstly Check Your File .");
            logger.error("List Is Empty. ", (Throwable)e);
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Unable To Deal With Data");
            returnValue.setMessageDetail("Contact With Administrator.");
            logger.error("Contact With Administrator. ", (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse extractPageContent(SearchRequest searchRequestData) throws IOException {
        RequestResponse returnValue = new RequestResponse();
        try {
            Specification filters = DefaultComparisonSpecification.generateFilters((SearchRequest)searchRequestData);
            Sort sort = null;
            if (searchRequestData.getSortDirection().equals("asc")) {
                sort = Sort.by((String[])new String[]{searchRequestData.getSortBy()}).ascending();
            } else if (searchRequestData.getSortDirection().equals("desc")) {
                sort = Sort.by((String[])new String[]{searchRequestData.getSortBy()}).descending();
            }
            Page page = null;
            page = sort == null ? this.defaultComparisonRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.defaultComparisonRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
            SearchResponse responseData = new SearchResponse();
            responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
            responseData.setPageSize((long)page.getSize());
            responseData.setTotalPages((long)page.getTotalPages());
            responseData.setTotalRecords(page.getTotalElements());
            ArrayList addValue = new ArrayList();
            addValue.addAll(page.getContent());
            responseData.setCurrentPageData((Object)this.setStatus(addValue));
            returnValue.setData((Object)responseData);
            returnValue.setMessage("List of Filtered Data");
            logger.info(returnValue.getMessage());
        }
        catch (FileNotFoundException e) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("File Not Found");
            returnValue.setMessageDetail("File Not Present.");
            logger.error("File Not Present At The Server:: ", (Throwable)e);
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Unable To Deal With Data");
            returnValue.setMessageDetail("Contact With Administrator.");
            logger.error("Contact With Administrator. ", (Throwable)e);
        }
        return returnValue;
    }

    public List<DefaultComparison> setStatus(List<DefaultComparison> data) throws IOException {
        FileInputStream input = new FileInputStream(storePathConfiguration);
        Properties prop = new Properties();
        prop.load(input);
        for (DefaultComparison row : data) {
            if ((String.valueOf(row.getRecord()) == null ? "null" : String.valueOf(row.getRecord())).equals(prop.getProperty("record")) && (String.valueOf(row.getEnableVideoCall()) == null ? "null" : String.valueOf(row.getEnableVideoCall())).equals(prop.getProperty("videoCall")) && (String.valueOf(row.getCallWaitingStatus()) == null ? "null" : String.valueOf(row.getCallWaitingStatus())).equals(prop.getProperty("callWaitingStatus")) && (String.valueOf(row.getRingTime()) == null ? "null" : String.valueOf(row.getRingTime())).equals(prop.getProperty("ringTime")) && (row.getDayOutboundCos() == null ? "null" : row.getDayOutboundCos()).equals(prop.getProperty("dayOutboundcos")) && (row.getDayInboundCos() == null ? "null" : row.getDayInboundCos()).equals(prop.getProperty("dayInboundcos")) && (row.getNightInboundCos() == null ? "null" : row.getNightInboundCos()).equals(prop.getProperty("nightInboundcos")) && (row.getNightOutboundCos() == null ? "null" : row.getNightOutboundCos()).equals(prop.getProperty("nightOutboundcos")) && row.getSipPassword().equals(this.PasswordConversion.encryptContains(prop.getProperty("sipPassword")).trim()) && (row.getDnd() == 1L ? "true" : "false").equals(prop.getProperty("dnd")) && (row.getIc() == 1L ? "true" : "false").equals(prop.getProperty("ic")) && (row.getIsd() == 1L ? "true" : "false").equals(prop.getProperty("isd")) && (row.getLocal() == 1L ? "true" : "false").equals(prop.getProperty("local")) && (row.getStd() == 1L ? "true" : "false").equals(prop.getProperty("std")) && !(row.getVm() == 1L ? "true" : "false").equals(prop.getProperty("vm"))) continue;
        }
        return data;
    }

    public RequestResponse attributesComparison() {
        RequestResponse returnValue = new RequestResponse();
        ArrayList<ExtensionFileModel> addValue = new ArrayList<ExtensionFileModel>();
        List extensionNumber = this.extensionsService.getExtensionNumber();
        if (extensionNumber.isEmpty()) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Not Found");
            returnValue.setMessageDetail("Blank Records Found");
            logger.error("Blank Records Found From Table");
        } else {
            try {
                FileInputStream input = new FileInputStream(storePathConfiguration);
                Properties prop = new Properties();
                prop.load(input);
                for (String extensionRow : extensionNumber) {
                    ArrayList<ServiceCodeConfigurationModel> serviceCodeData = new ArrayList<ServiceCodeConfigurationModel>();
                    Optional extension = this.extensionsRepository.findByExtension(extensionRow);
                    List extensionServiceList = this.extensionsServicesRepository.findAllByExtension(((Extension)extension.get()).getExtension());
                    ExtensionFileModel fileAttribute = new ExtensionFileModel();
                    fileAttribute.setId(((Extension)extension.get()).getId());
                    fileAttribute.setExtension(((Extension)extension.get()).getExtension());
                    fileAttribute.setName(((Extension)extension.get()).getName());
                    if (extensionServiceList.isEmpty()) {
                        fileAttribute.setServiceCodeAttributes(null);
                        fileAttribute.setVideoCall(((Extension)extension.get()).getVideoCall());
                        fileAttribute.setRecord(((Extension)extension.get()).getRecord());
                        fileAttribute.setCallWaitingStatus(((Extension)extension.get()).getCallWaitingStatus());
                        fileAttribute.setRingTime(((Extension)extension.get()).getRingTime());
                        fileAttribute.setDayInboundcos(((Extension)extension.get()).getDayInboundCos());
                        fileAttribute.setDayOutboundcos(((Extension)extension.get()).getDayOutboundCos());
                        fileAttribute.setNightInboundcos(((Extension)extension.get()).getNightInboundCos());
                        fileAttribute.setNightOutboundcos(((Extension)extension.get()).getNightOutboundCos());
                        fileAttribute.setSipPassword(((Extension)extension.get()).getSipPassword());
                        fileAttribute.setMatchStatus("No");
                    } else {
                        for (ExtensionsServices extensionServiceRow : extensionServiceList) {
                            ServiceCodeConfigurationModel serviceCodeAttributes = new ServiceCodeConfigurationModel();
                            if (extensionServiceRow.getServiceCode().equalsIgnoreCase("dialing-isd")) {
                                serviceCodeAttributes.setServiceCode("ISD");
                                serviceCodeAttributes.setValue((Object)true);
                                if (!prop.getProperty("isd").equals("true") || !fileAttribute.getMatchStatus().equals("Yes")) {
                                    fileAttribute.setMatchStatus("No");
                                }
                                serviceCodeData.add(serviceCodeAttributes);
                                continue;
                            }
                            if (extensionServiceRow.getServiceCode().equalsIgnoreCase("dialing-std")) {
                                serviceCodeAttributes.setServiceCode("STD");
                                serviceCodeAttributes.setValue((Object)true);
                                if (!prop.getProperty("std").equals("true") || !fileAttribute.getMatchStatus().equals("Yes")) {
                                    fileAttribute.setMatchStatus("No");
                                }
                                serviceCodeData.add(serviceCodeAttributes);
                                continue;
                            }
                            if (extensionServiceRow.getServiceCode().equalsIgnoreCase("dialing-local")) {
                                serviceCodeAttributes.setServiceCode("Local");
                                serviceCodeAttributes.setValue((Object)true);
                                if (!prop.getProperty("local").equals("true") || !fileAttribute.getMatchStatus().equals("Yes")) {
                                    fileAttribute.setMatchStatus("No");
                                }
                                serviceCodeData.add(serviceCodeAttributes);
                                continue;
                            }
                            if (extensionServiceRow.getServiceCode().equalsIgnoreCase("dialing-intercom")) {
                                serviceCodeAttributes.setServiceCode("IC");
                                serviceCodeAttributes.setValue((Object)true);
                                if (!prop.getProperty("ic").equals("true") || !fileAttribute.getMatchStatus().equals("Yes")) {
                                    fileAttribute.setMatchStatus("No");
                                }
                                serviceCodeData.add(serviceCodeAttributes);
                                continue;
                            }
                            if (extensionServiceRow.getServiceCode().equalsIgnoreCase("VM")) {
                                serviceCodeAttributes.setServiceCode("VM");
                                serviceCodeAttributes.setValue((Object)true);
                                if (!prop.getProperty("vm").equals("true") || !fileAttribute.getMatchStatus().equals("Yes")) {
                                    fileAttribute.setMatchStatus("No");
                                }
                                serviceCodeData.add(serviceCodeAttributes);
                                continue;
                            }
                            if (!extensionServiceRow.getServiceCode().equalsIgnoreCase("dnd")) continue;
                            serviceCodeAttributes.setServiceCode("DND");
                            serviceCodeAttributes.setValue((Object)true);
                            if (!prop.getProperty("dnd").equals("true") || !fileAttribute.getMatchStatus().equals("Yes")) {
                                fileAttribute.setMatchStatus("No");
                            }
                            serviceCodeData.add(serviceCodeAttributes);
                        }
                        fileAttribute.setVideoCall(((Extension)extension.get()).getVideoCall());
                        if (!Boolean.valueOf(prop.getProperty("videoCall")).equals(((Extension)extension.get()).getVideoCall()) || !fileAttribute.getMatchStatus().equals("Yes")) {
                            fileAttribute.setMatchStatus("No");
                        }
                        fileAttribute.setRecord(((Extension)extension.get()).getRecord());
                        if (!Boolean.valueOf(prop.getProperty("record")).equals(((Extension)extension.get()).getRecord()) || !fileAttribute.getMatchStatus().equals("Yes")) {
                            fileAttribute.setMatchStatus("No");
                        }
                        fileAttribute.setCallWaitingStatus(((Extension)extension.get()).getCallWaitingStatus());
                        if (!prop.getProperty("callWaitingStatus").equals(String.valueOf(((Extension)extension.get()).getCallWaitingStatus())) || !fileAttribute.getMatchStatus().equals("Yes")) {
                            fileAttribute.setMatchStatus("No");
                        }
                        fileAttribute.setRingTime(((Extension)extension.get()).getRingTime());
                        if (!prop.getProperty("ringTime").equals(String.valueOf(((Extension)extension.get()).getRingTime())) || !fileAttribute.getMatchStatus().equals("Yes")) {
                            fileAttribute.setMatchStatus("No");
                        }
                        fileAttribute.setDayInboundcos(((Extension)extension.get()).getDayInboundCos());
                        if (!prop.getProperty("dayInboundcos").equals(((Extension)extension.get()).getDayInboundCos()) || !fileAttribute.getMatchStatus().equals("Yes")) {
                            fileAttribute.setMatchStatus("No");
                        }
                        fileAttribute.setDayOutboundcos(((Extension)extension.get()).getDayOutboundCos());
                        if (!prop.getProperty("dayOutboundcos").equals(((Extension)extension.get()).getDayOutboundCos()) || !fileAttribute.getMatchStatus().equals("Yes")) {
                            fileAttribute.setMatchStatus("No");
                        }
                        fileAttribute.setNightInboundcos(((Extension)extension.get()).getNightInboundCos());
                        if (!prop.getProperty("nightInboundcos").equals(((Extension)extension.get()).getNightInboundCos()) || !fileAttribute.getMatchStatus().equals("Yes")) {
                            fileAttribute.setMatchStatus("No");
                        }
                        fileAttribute.setNightOutboundcos(((Extension)extension.get()).getNightOutboundCos());
                        if (!prop.getProperty("nightOutboundcos").equals(((Extension)extension.get()).getNightOutboundCos()) || !fileAttribute.getMatchStatus().equals("Yes")) {
                            fileAttribute.setMatchStatus("No");
                        }
                        fileAttribute.setSipPassword(((Extension)extension.get()).getSipPassword());
                        if (!this.PasswordConversion.encryptContains(prop.getProperty("sipPassword")).equals(((Extension)extension.get()).getSipPassword()) || !fileAttribute.getMatchStatus().equals("Yes")) {
                            fileAttribute.setMatchStatus("No");
                        }
                        fileAttribute.setServiceCodeAttributes(serviceCodeData);
                    }
                    addValue.add(fileAttribute);
                }
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("Operation Succeeded Successfully.");
                returnValue.setMessageDetail("Records Have Been Fetched And Compared Successfully");
                returnValue.setData(addValue);
                logger.info("Records Have Been Fetched And Compared Successfully.");
            }
            catch (FileNotFoundException e) {
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("File Not Found");
                returnValue.setMessageDetail("File Not Present.");
                logger.error("File Not Present At The Server:: ", (Throwable)e);
            }
            catch (IOException e) {
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("Can't Fetch Data From File");
                returnValue.setMessageDetail("Unable to Access Data From File.");
                logger.error("Unable to Access Data From File ", (Throwable)e);
            }
            catch (Exception e) {
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("Unable To Deal With Data");
                returnValue.setMessageDetail("Contact With administrator.");
                logger.error("Contact With administrator. ", (Throwable)e);
            }
        }
        return returnValue;
    }
}

