/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.pbx.distortionFile.service;

import com.coraltele.db.telephony.pbx.entity.DistortionFile;
import com.coraltele.db.telephony.pbx.repository.DistortionFileRepository;
import com.coraltele.db.telephony.pbx.specification.DistortionFileSpecification;
import com.coraltele.helper.BashCmd;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.helper.Telephony;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.pbx.distortionFile.model.DistortionFileModel;
import com.coraltele.service.pbx.distortionFile.model.DistortionPlayModel;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class DistortionFileService {
    private static final Logger logger = LogManager.getLogger(DistortionFileService.class);
    private final AtomicReference<Thread> playbackThreadRef = new AtomicReference();
    private final AtomicReference<Boolean> stopPlaybackFlag = new AtomicReference<Boolean>(false);
    @Autowired
    DistortionFileRepository distortionFileRepository;
    @Autowired
    BashCmd commandExecuter;

    public RequestResponse createData(DistortionFileModel data) {
        logger.debug("create new distortionFile : {} ", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        try {
            DistortionFile distortionFile = new DistortionFile();
            distortionFile.setAudioName(data.getAudioName());
            distortionFile.setPath("/etc/coraltele/sounds/en/us/callie/" + data.getPath());
            this.distortionFileRepository.save((Object)distortionFile);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("OK");
            returnValue.setMessageDetail("DistortionFile Created Successfully");
            logger.info(returnValue.getMessage());
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.BAD_CREDENTIAL);
            returnValue.setMessage("Unable to Create DistortionFile");
            returnValue.setMessageDetail("Contact with Administrator");
            logger.error(returnValue.getMessageDetail(), (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse deleteById(InputIdModel data) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList<DistortionFile> filesToDelete = new ArrayList<DistortionFile>();
        for (Integer id : data.getIntId()) {
            Optional distortionFile = this.distortionFileRepository.findById(Integer.valueOf(id));
            if (distortionFile.isPresent()) {
                DistortionFile file = (DistortionFile)distortionFile.get();
                filesToDelete.add(file);
                try {
                    String filePath = file.getPath();
                    Path path = Paths.get(filePath, new String[0]);
                    if (Files.exists(path, new LinkOption[0])) {
                        Files.delete(path);
                        continue;
                    }
                    logger.warn("File at path " + filePath + " does not exist.");
                    continue;
                }
                catch (IOException e) {
                    returnValue.setStatus(Constants.Error.ERROR);
                    returnValue.setMessage("Error deleting the file");
                    returnValue.setMessageDetail("Could not delete file: " + e.getMessage());
                    logger.error("Error deleting file from path", (Throwable)e);
                    return returnValue;
                }
            }
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Record with ID " + id + " not found");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        this.distortionFileRepository.deleteAll(filesToDelete);
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Records deleted successfully");
        returnValue.setMessageDetail("Records and their corresponding files deleted.");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse updateById(DistortionFileModel data) {
        logger.debug("Update DistortionFile {}", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        Optional distortionFile = this.distortionFileRepository.findById(data.getId());
        if (!distortionFile.isPresent()) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("not found");
            returnValue.setMessageDetail("DistortionFile not found");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        if (data.getAudioName() != null) {
            ((DistortionFile)distortionFile.get()).setAudioName(data.getAudioName());
        }
        if (data.getPath() != null) {
            ((DistortionFile)distortionFile.get()).setPath(data.getPath());
        }
        this.distortionFileRepository.save(distortionFile.get());
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Updated");
        returnValue.setMessageDetail("DistortionFile Updated successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getAllDistortionFile() {
        List list = (List)this.distortionFileRepository.findAll();
        ArrayList<DistortionFileModel> addValue = new ArrayList<DistortionFileModel>();
        RequestResponse returnValue = new RequestResponse();
        for (DistortionFile data : list) {
            DistortionFileModel distortionFileModel = new DistortionFileModel();
            distortionFileModel.setAudioName(data.getAudioName());
            distortionFileModel.setPath(data.getPath());
            distortionFileModel.setId(data.getId());
            addValue.add(distortionFileModel);
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setData(addValue);
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public String getFile(Integer id) {
        Optional data = this.distortionFileRepository.findById(id);
        if (data.isPresent()) {
            return ((DistortionFile)data.get()).getPath();
        }
        return null;
    }

    public RequestResponse getAllByFilter(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = DistortionFileSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.getSortDirection().equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "id" : searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.getSortDirection().equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "id" : searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.distortionFileRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.distortionFileRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)page.getContent());
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse playDistortionFile(DistortionPlayModel data) {
        RequestResponse returnValue = new RequestResponse();
        String filePath = "/etc/coraltele/sounds/en/us/callie";
        try {
            File file = new File(filePath);
            if (file.exists()) {
                String command = "";
                command = String.format("fs_cli -x \"conference %s play %s\"", data.getAccessCode(), data.getPath());
                logger.info("command for play distortion :{}", (Object)command);
                returnValue.setMessage("file play successfully");
                Telephony.makeCallBackCall((String)command);
                returnValue.setStatus(Constants.Error.OK);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("error on play distortion:{}", (Object)e.getMessage());
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Unable to play file");
        }
        return returnValue;
    }

    public RequestResponse uploadWavFile(MultipartFile musicFile) {
        RequestResponse returnValue = new RequestResponse();
        if (musicFile == null) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("No file provided");
            returnValue.setMessageDetail("Please select a file to upload.");
            logger.error(returnValue.getMessageDetail());
            return returnValue;
        }
        String originalFilename = musicFile.getOriginalFilename();
        if (!originalFilename.endsWith(".wav")) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Invalid file format. Only .wav files are allowed.");
            returnValue.setMessageDetail("Invalid file format");
            logger.error(returnValue.getMessageDetail());
            return returnValue;
        }
        String pathToUpload = "/etc/coraltele/sounds/en/us/callie";
        Path uploadPath = Paths.get(pathToUpload, new String[0]);
        if (!Files.exists(uploadPath, new LinkOption[0])) {
            try {
                Files.createDirectories(uploadPath, new FileAttribute[0]);
            }
            catch (Exception e) {
                returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                returnValue.setMessage("Not Found ");
                returnValue.setMessageDetail("path not exist for uploading the file");
                logger.error(returnValue.getMessageDetail() + e.getMessage());
                return returnValue;
            }
        }
        Path filePath = uploadPath.resolve(originalFilename.trim());
        try {
            if (Files.exists(filePath, new LinkOption[0])) {
                Files.delete(filePath);
                returnValue.setMessageDetail("Replacing existing file");
            }
            try (InputStream inputStream = musicFile.getInputStream();){
                Files.copy(inputStream, filePath, StandardCopyOption.REPLACE_EXISTING);
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("WAV file uploaded successfully");
                returnValue.setData((Object)originalFilename);
            }
        }
        catch (IOException e) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Not Found ");
            returnValue.setMessageDetail("path not exist, for upload file");
            logger.error(returnValue.getMessageDetail(), (Object)e.getMessage());
        }
        return returnValue;
    }

    public RequestResponse playDistortionFileInLoop(DistortionPlayModel data) {
        RequestResponse returnValue = new RequestResponse();
        String filePath = data.getPath();
        File file = new File(filePath);
        try {
            if (file.exists()) {
                Thread playbackThread = new Thread(() -> {
                    try {
                        String playCommand = String.format("fs_cli -x \"conference %s play %s\"", data.getAccessCode(), filePath);
                        logger.info("Command for playing distortion: {}", (Object)playCommand);
                        long duration = this.getFileDurationInMilliseconds(filePath);
                        logger.info("Total Duration of file is :{} ms", (Object)duration);
                        if (duration <= 0L) {
                            logger.error("Invalid file duration, stopping playback");
                            return;
                        }
                        this.stopPlaybackFlag.set(false);
                        while (!Thread.currentThread().isInterrupted() && !((Boolean)this.stopPlaybackFlag.get()).booleanValue()) {
                            Telephony.makeCallBackCall((String)playCommand);
                            Thread.sleep(duration);
                        }
                    }
                    catch (InterruptedException e) {
                        logger.info("Playback thread interrupted");
                        Thread.currentThread().interrupt();
                    }
                    catch (Exception e) {
                        logger.error("Error in playback thread: {}", (Object)e.getMessage(), (Object)e);
                    }
                });
                this.playbackThreadRef.set(playbackThread);
                playbackThread.start();
                returnValue.setMessage("File playback started successfully in loop");
                returnValue.setStatus(Constants.Error.OK);
            } else {
                returnValue.setMessage("File not found at the specified path");
                returnValue.setStatus(Constants.Error.ERROR);
                logger.error("File not found: {}", (Object)filePath);
            }
        }
        catch (Exception e) {
            logger.error("Error starting playback: {}", (Object)e.getMessage(), (Object)e);
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Unable to start file playback");
        }
        return returnValue;
    }

    public RequestResponse stopDistortionFilePlayback(String conferenceNumber) {
        RequestResponse returnValue = new RequestResponse();
        this.stopPlaybackFlag.set(true);
        Thread playbackThread = (Thread)this.playbackThreadRef.get();
        if (playbackThread != null) {
            playbackThread.interrupt();
            this.playbackThreadRef.set(null);
        }
        try {
            String stopCommand = String.format("fs_cli -x \"conference %s stop all\"", conferenceNumber);
            logger.info("Executing stop command: {}", (Object)stopCommand);
            String stopResponse = this.commandExecuter.executeCommand(stopCommand);
            logger.info("Stop command response: {}", (Object)stopResponse);
            returnValue.setMessage("Playback stopped successfully");
            returnValue.setStatus(Constants.Error.OK);
        }
        catch (Exception e) {
            logger.error("Error stopping playback: {}", (Object)e.getMessage(), (Object)e);
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Unable to stop file playback");
        }
        return returnValue;
    }

    private long getFileDurationInMilliseconds(String filePath) {
        try {
            String command = String.format("ffmpeg -i %s 2>&1 | grep Duration | awk '{print $2}'", filePath);
            logger.info("Command to calculate file duration: {}", (Object)command);
            String durationString = this.commandExecuter.executeCommand(command).trim();
            logger.info("Response of command: {}", (Object)durationString);
            if (durationString != null && !durationString.isEmpty()) {
                durationString = durationString.replace(",", "");
                String[] parts = durationString.split("[.:]");
                int hours = Integer.parseInt(parts[0]);
                int minutes = Integer.parseInt(parts[1]);
                int seconds = Integer.parseInt(parts[2]);
                int milliseconds = Integer.parseInt(parts[3]);
                return (long)(hours * 3600 + minutes * 60 + seconds) * 1000L + (long)milliseconds;
            }
        }
        catch (Exception e) {
            logger.error("Error getting file duration: {}", (Object)e.getMessage(), (Object)e);
        }
        return 0L;
    }
}

