/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.pbx.didmapping.service;

import com.coraltele.db.telephony.pbx.entity.CLIServerCommandLog;
import com.coraltele.db.telephony.pbx.entity.DidMapping;
import com.coraltele.db.telephony.pbx.repository.DidMappingRepository;
import com.coraltele.db.telephony.pbx.specification.DidMappingSpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.helper.ReturnField;
import com.coraltele.model.CliCommandData;
import com.coraltele.model.InputAction;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.pbx.cLIServerCommandLog.service.CLIServerCommandLogService;
import com.coraltele.service.pbx.didmapping.model.DidMappingModel;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;

@Component
public class DidMappingService {
    private static final Logger logger = LogManager.getLogger(DidMappingService.class);
    @Autowired
    private DidMappingRepository didMappingRepository;
    @Autowired
    private CLIServerCommandLogService cLIServerCommandLogService;

    public RequestResponse createDidMapping(DidMappingModel data) {
        RequestResponse returnValue = new RequestResponse();
        try {
            DidMapping didMapping = new DidMapping();
            didMapping.setDodNumber(data.getDodNumber());
            didMapping.setDidNumber(data.getDidNumber());
            didMapping.setExtNumber(data.getExtNumber());
            didMapping.setContext(data.getContext());
            didMapping.setOutboundName(data.getOutboundName());
            this.didMappingRepository.save((Object)didMapping);
            ReturnField field = new ReturnField();
            field.setId(didMapping.getId().intValue());
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("DidMapping Registered");
            returnValue.setData((Object)field);
            logger.info("DidMapping saved : {}", (Object)returnValue.getMessage());
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.BAD_CREDENTIAL);
            returnValue.setMessage("unable to create DidMapping");
            returnValue.setMessageDetail("Contact with administrator");
            logger.error(returnValue.getMessageDetail(), (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse getById(int id) {
        RequestResponse returnValue = new RequestResponse();
        try {
            Optional didMapping = this.didMappingRepository.findById(Integer.valueOf(id));
            if (didMapping.isPresent()) {
                DidMappingModel data = new DidMappingModel();
                data.setId(((DidMapping)didMapping.get()).getId().intValue());
                data.setDidNumber(((DidMapping)didMapping.get()).getDidNumber());
                data.setDodNumber(((DidMapping)didMapping.get()).getDodNumber());
                data.setExtNumber(((DidMapping)didMapping.get()).getExtNumber());
                data.setContext(((DidMapping)didMapping.get()).getContext());
                data.setOutboundName(((DidMapping)didMapping.get()).getOutboundName());
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("didMApping Found");
                returnValue.setData((Object)data);
            } else {
                returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                returnValue.setMessage("Unable to return value");
                returnValue.setMessageDetail("Records not found");
                logger.info(returnValue.getMessage());
            }
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.UNKNOWN_ERROR);
            returnValue.setMessage("Unable to return value");
            returnValue.setMessageDetail("contact with administrator");
            logger.info(returnValue.getMessage());
        }
        return returnValue;
    }

    public RequestResponse updateDidMapping(HttpServletRequest request, int id, DidMappingModel data, Authentication authentication) {
        logger.debug("Update InboundCos {}", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        try {
            Optional didMapping = this.didMappingRepository.findById(Integer.valueOf(id));
            this.saveData(request, (DidMapping)didMapping.get(), authentication);
            if (didMapping.isPresent()) {
                ((DidMapping)didMapping.get()).setDidNumber(data.getDidNumber());
                ((DidMapping)didMapping.get()).setDodNumber(data.getDodNumber());
                ((DidMapping)didMapping.get()).setContext(data.getContext());
                ((DidMapping)didMapping.get()).setExtNumber(data.getExtNumber());
                ((DidMapping)didMapping.get()).setOutboundName(data.getOutboundName());
                this.didMappingRepository.save(didMapping.get());
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("Updated");
                returnValue.setMessageDetail("DidMapping Updated successfully");
                logger.info(returnValue.getMessage());
            } else {
                returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                returnValue.setMessage("not found");
                returnValue.setMessageDetail("DidMapping not found");
                logger.info(returnValue.getMessage());
            }
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.UNKNOWN_ERROR);
            returnValue.setMessage("Unable to update DidMapping");
            returnValue.setMessageDetail("please Contact to administrator");
            logger.error("error while fetching the data.", (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse deleteDidMapping(String id) {
        RequestResponse returnValue = new RequestResponse();
        Optional data = this.didMappingRepository.findByExtNumber(id);
        if (!data.isPresent()) {
            returnValue.setStatus(Constants.Error.BAD_CREDENTIAL);
            returnValue.setMessage("Unable to delete");
            returnValue.setMessageDetail(String.format("Extension not found in didMapping : %s ", id));
            logger.info(returnValue.getMessage());
        } else {
            this.didMappingRepository.deleteById((Object)((DidMapping)data.get()).getId());
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("Deleted");
            returnValue.setMessageDetail("Data deleted successfully");
            logger.info(returnValue.getMessage());
        }
        return returnValue;
    }

    public RequestResponse multipleDelete(List<String> ids) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList addValue = new ArrayList();
        for (String id : ids) {
            Optional didMapping = this.didMappingRepository.findByExtNumber(id);
            if (!didMapping.isPresent()) {
                returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                returnValue.setMessage("Can't Delete");
                returnValue.setMessageDetail(String.format("ExtNumber : %s not found in didMapping ", String.valueOf(id)));
                logger.info(returnValue.getMessage());
                return returnValue;
            }
            addValue.add(didMapping.get());
        }
        this.didMappingRepository.deleteAll(addValue);
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Delete");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public void saveData(HttpServletRequest request, DidMapping data, Authentication authentication) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        Map newMap = (Map)new ObjectMapper().readValue((InputStream)request.getInputStream(), Map.class);
        Set entrySet = newMap.entrySet();
        Iterator iterator = entrySet.iterator();
        ArrayList<InputAction> addValue = new ArrayList<InputAction>();
        CliCommandData cliCommandData = new CliCommandData();
        try {
            if (data.getId() != null && this.didMappingRepository.findById(data.getId()).isPresent()) {
                Optional oldData = this.didMappingRepository.findById(data.getId());
                Map oldMap = (Map)objectMapper.convertValue(oldData.get(), Map.class);
                while (iterator.hasNext()) {
                    Map.Entry mapEntry = iterator.next();
                    InputAction inputValue = new InputAction();
                    inputValue.setFieldName(mapEntry.getKey());
                    inputValue.setNewValue(mapEntry.getValue());
                    for (Map.Entry compare : oldMap.entrySet()) {
                        if (!mapEntry.getKey().equals(compare.getKey())) continue;
                        inputValue.setOldValue(compare.getValue());
                    }
                    addValue.add(inputValue);
                }
                cliCommandData.setData(addValue);
                cliCommandData.setEntity("didmapping");
                String dataReceived = objectMapper.writeValueAsString(addValue);
                CLIServerCommandLog dataLogs = new CLIServerCommandLog();
                dataLogs.setCLICommand(dataReceived);
                dataLogs.setRecordSource("dl");
                dataLogs.setServerCode("");
                dataLogs.setRecordCreatedBy(authentication.getName());
                dataLogs.setRecordCreatedOn(LocalDateTime.now());
                dataLogs.setOutputFileName("Name");
                dataLogs.setOutputFilePath("");
                this.cLIServerCommandLogService.save(dataLogs);
            }
        }
        catch (JsonProcessingException e) {
            logger.info((Object)e);
        }
    }

    public RequestResponse getDidMappingByFilter(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = DidMappingSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.sortDirection.equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).ascending();
        } else if (searchRequestData.sortDirection.equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).descending();
        }
        Page page = null;
        page = sort == null ? this.didMappingRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.didMappingRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)page.getContent());
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }
}

