/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.billing.main.agentStatus.service;

import com.coraltele.db.billing.main.repository.UserStatusViewRepository;
import com.coraltele.db.billing.main.specification.AgentStatusSpecification;
import com.coraltele.db.billing.main.specification.UserStatusViewSpecification;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.coralApps.callcenter.queueTL.service.QueueTLService;
import com.coraltele.service.user.service.UserService;
import java.security.Principal;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class UserStatusViewService {
    private static final Logger logger = LogManager.getLogger(UserStatusViewService.class);
    @Autowired
    UserStatusViewRepository userStatusViewRepository;
    @Autowired
    UserService userService;
    @Autowired
    QueueTLService queueTLService;

    public RequestResponse getAllAgentStatus(SearchRequest searchRequestData, Principal principal) {
        RequestResponse returnValue = new RequestResponse();
        List agentList = this.userService.getAgentList();
        boolean adminUser = false;
        boolean teamLeaderUser = false;
        boolean agentUser = false;
        boolean managerUser = false;
        if (this.userService.checkAdminUser(principal.getName())) {
            adminUser = true;
        } else if (this.userService.checkRoleTL(principal.getName())) {
            teamLeaderUser = true;
        } else if (this.userService.checkManagerUser(principal.getName())) {
            managerUser = true;
        } else {
            agentUser = true;
        }
        Specification filters = AgentStatusSpecification.generateFilters((SearchRequest)searchRequestData, (String)principal.getName(), (List)agentList, (boolean)adminUser, (boolean)teamLeaderUser, (boolean)agentUser, (boolean)managerUser, (List)this.queueTLService.getAgentListByTL(principal.getName()));
        Sort sort = null;
        if (searchRequestData.getSortDirection().equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "extensionNo" : searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.getSortDirection().equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "extensionNo" : searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.userStatusViewRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.userStatusViewRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)page.getContent());
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getAllUserStatus(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = UserStatusViewSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.getSortDirection().equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "extensionNo" : searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.getSortDirection().equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "extensionNo" : searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.userStatusViewRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.userStatusViewRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)page.getContent());
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }
}

