/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.helper;

import com.coraltele.db.telephony.pbx.entity.ControlRluServer;
import com.coraltele.db.telephony.pbx.repository.ControlRluServerRepository;
import com.coraltele.db.telephony.pbx.repository.ExtensionsRepository;
import com.coraltele.db.users.main.entity.Menu;
import com.coraltele.db.users.main.entity.Role;
import com.coraltele.db.users.main.entity.User;
import com.coraltele.db.users.main.entity.UserRole;
import com.coraltele.db.users.main.repository.MenuRepository;
import com.coraltele.db.users.main.repository.RoleRepository;
import com.coraltele.db.users.main.repository.UserRepository;
import com.coraltele.db.users.main.repository.UserRoleRepository;
import com.coraltele.helper.Bootstrap;
import com.coraltele.helper.Constants;
import com.coraltele.helper.JsonUtils;
import com.coraltele.helper.RoleDetailsModel;
import com.coraltele.service.user.model.ActiveMenusModel;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.PostConstruct;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class BootstrapController {
    private static final Logger logger = LogManager.getLogger(BootstrapController.class);
    @Autowired
    private ApplicationContext context;
    @Autowired
    private RoleRepository roleRepository;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private UserRoleRepository userRoleRepository;
    @Autowired
    ControlRluServerRepository controlRluServerRepository;
    @Autowired
    ExtensionsRepository extensionsRepository;
    @Autowired
    MenuRepository menuRepository;

    @PostConstruct
    public void startClusterService() {
        logger.info("Starting Bootstrap Service...");
        logger.info("Updating Views for Billing");
        Bootstrap.updateBillingSchema((ApplicationContext)this.context, (String)"views");
        logger.info("Updating Views for Users");
        Bootstrap.updateUsersSchema((ApplicationContext)this.context, (String)"views");
        this.createAndUpdateRole();
        this.createAndUpdateMenu();
        this.createAdminRole();
        this.getVirtualIp();
    }

    public void createAndUpdateRole() {
        List roles = JsonUtils.readListFromJson((String)"default-data/m_role.json", (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        Set jsonShortcodes = roles.stream().map(r -> r.getShortcode().trim()).collect(Collectors.toSet());
        List dbRoles = StreamSupport.stream(this.roleRepository.findAll().spliterator(), false).collect(Collectors.toList());
        for (Role dbRole : dbRoles) {
            if (jsonShortcodes.contains(dbRole.getShortCode())) continue;
            dbRole.setEnabled(Integer.valueOf(0));
            this.roleRepository.save((Object)dbRole);
            logger.warn("Disabled Role: {}", (Object)dbRole.getShortCode());
        }
        for (RoleDetailsModel roleData : roles) {
            Optional existingRoleOpt = this.roleRepository.findByShortCode(roleData.getShortcode());
            if (existingRoleOpt.isPresent()) {
                Role role = (Role)existingRoleOpt.get();
                boolean updated = false;
                if (StringUtils.hasText((String)role.getDescription())) {
                    if (!role.getDescription().equalsIgnoreCase(roleData.getDescription())) {
                        role.setDescription(roleData.getDescription());
                        updated = true;
                    }
                } else {
                    role.setDescription(roleData.getDescription());
                    updated = true;
                }
                if (role.getEnabled() != null) {
                    if (role.getEnabled() != roleData.getEnabled()) {
                        role.setEnabled(roleData.getEnabled());
                        updated = true;
                    }
                } else {
                    role.setEnabled(roleData.getEnabled());
                    updated = true;
                }
                if (!updated) continue;
                this.roleRepository.save((Object)role);
                logger.info("Updated Role: {}", (Object)role.getShortCode());
                continue;
            }
            Role newRole = new Role();
            newRole.setShortCode(roleData.getShortcode());
            newRole.setDescription(roleData.getDescription());
            newRole.setEnabled(roleData.getEnabled());
            this.roleRepository.save((Object)newRole);
            logger.info("Inserted New Role: {}", (Object)newRole.getShortCode());
        }
    }

    public void createAdminRole() {
        try {
            Optional userOptional = this.userRepository.findByUsername("admin");
            Optional roleOptional = this.roleRepository.findByShortCode("ROLE_ADMIN");
            if (userOptional.isPresent() && roleOptional.isPresent()) {
                Role role;
                User user = (User)userOptional.get();
                boolean alreadyAssigned = this.userRoleRepository.existsByUserAndRole(user, role = (Role)roleOptional.get());
                if (!alreadyAssigned) {
                    UserRole userRole = new UserRole();
                    userRole.setUser(user);
                    userRole.setRole(role);
                    this.userRoleRepository.save((Object)userRole);
                    logger.info("ROLE_ADMIN assigned to admin user.");
                } else {
                    logger.info("Admin user already has ROLE_ADMIN assigned.");
                }
            } else {
                if (!userOptional.isPresent()) {
                    logger.warn("Admin user not found.");
                }
                if (!roleOptional.isPresent()) {
                    logger.warn("ROLE_ADMIN not found.");
                }
            }
        }
        catch (Exception e) {
            logger.error("Error while assigning ROLE_ADMIN to admin user: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public void getVirtualIp() {
        try {
            String virtualIp = "";
            List rluList = this.controlRluServerRepository.findAllByOrderByRluCodeAsc();
            if (Constants.DISPATCHER_SIP_SERVER == null || Constants.DISPATCHER_SIP_SERVER.trim().isEmpty()) {
                if (!rluList.isEmpty()) {
                    if (rluList.size() == 1) {
                        virtualIp = ((ControlRluServer)rluList.get(0)).getVirtualIp();
                    } else {
                        for (ControlRluServer rlu : rluList) {
                            if (!"main".equalsIgnoreCase(rlu.getRluCode())) continue;
                            virtualIp = rlu.getVirtualIp();
                            break;
                        }
                    }
                }
                Constants.DISPATCHER_SIP_SERVER = virtualIp;
                logger.info("Dispatcher Server: {}", (Object)virtualIp);
            } else {
                logger.info("Dispatcher Server already set: {}", (Object)Constants.DISPATCHER_SIP_SERVER);
            }
        }
        catch (Exception e) {
            logger.error("Error retrieving Dispatcher Server: {}", (Throwable)e);
        }
    }

    public void createAndUpdateMenu() {
        List menus = JsonUtils.readListFromJson((String)"default-data/m_menu.json", (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        for (ActiveMenusModel row : menus) {
            Optional existingMenuOptional = this.menuRepository.findByMenuName(row.getMenuName());
            if (existingMenuOptional.isPresent()) {
                Menu menu = (Menu)existingMenuOptional.get();
                boolean updated = false;
                if (StringUtils.hasText((String)menu.getIcon())) {
                    if (!menu.getIcon().equalsIgnoreCase(row.getIcon())) {
                        menu.setIcon(row.getIcon());
                        updated = true;
                    }
                } else {
                    menu.setIcon(row.getIcon());
                    updated = true;
                }
                if (StringUtils.hasText((String)menu.getKey())) {
                    if (menu.getKey().equalsIgnoreCase(row.getKey())) {
                        menu.setKey(row.getKey());
                        updated = true;
                    }
                } else {
                    menu.setKey(row.getKey());
                    updated = true;
                }
                if (StringUtils.hasText((String)menu.getUrlPath())) {
                    if (!menu.getUrlPath().equalsIgnoreCase(row.getUrl())) {
                        menu.setUrlPath(row.getUrl());
                        updated = true;
                    }
                } else {
                    menu.setUrlPath(row.getUrl());
                    updated = true;
                }
                if (StringUtils.hasText((String)menu.getMenuGroupName())) {
                    if (menu.getMenuGroupName().equalsIgnoreCase(row.getMenuGroupName())) {
                        menu.setMenuGroupName(row.getMenuGroupName());
                        updated = true;
                    }
                } else {
                    menu.setMenuGroupName(row.getMenuGroupName());
                    updated = true;
                }
                if (menu.getProductionReady() != null) {
                    if (menu.getProductionReady() != row.getProductionReady()) {
                        menu.setProductionReady(row.getProductionReady());
                        updated = true;
                    }
                } else {
                    menu.setProductionReady(row.getProductionReady());
                    updated = true;
                }
                if (menu.getCreation() != null) {
                    if (menu.getCreation() != row.getCreation()) {
                        menu.setCreation(row.getCreation());
                        updated = true;
                    }
                } else {
                    menu.setCreation(row.getCreation());
                    updated = true;
                }
                if (menu.getUpdation() != null) {
                    if (menu.getUpdation() != row.getUpdation()) {
                        menu.setUpdation(row.getUpdation());
                        updated = true;
                    }
                } else {
                    menu.setUpdation(row.getUpdation());
                    updated = true;
                }
                if (menu.getDeletion() != null) {
                    if (menu.getDeletion() != row.getDeletion()) {
                        menu.setDeletion(row.getDeletion());
                        updated = true;
                    }
                } else {
                    menu.setDeletion(row.getDeletion());
                    updated = true;
                }
                if (menu.getRead() != null) {
                    if (menu.getRead() != row.getRead()) {
                        menu.setRead(row.getRead());
                        updated = true;
                    }
                } else {
                    menu.setRead(row.getRead());
                    updated = true;
                }
                if (menu.getIsActive() == null || !menu.getIsActive().equals(false)) {
                    menu.setIsActive(row.getIsActive());
                    updated = true;
                }
                if (!updated) continue;
                this.menuRepository.save((Object)menu);
                logger.info("Updated Menu: {}", (Object)menu.getMenuName());
                continue;
            }
            Menu newMenu = new Menu();
            newMenu.setIcon(row.getIcon());
            newMenu.setKey(row.getKey());
            newMenu.setMenuName(row.getMenuName());
            newMenu.setUrlPath(row.getUrl());
            newMenu.setProductionReady(row.getProductionReady());
            newMenu.setCreation(row.getCreation());
            newMenu.setUpdation(row.getUpdation());
            newMenu.setDeletion(row.getDeletion());
            newMenu.setRead(row.getRead());
            newMenu.setIsActive(row.getIsActive());
            newMenu.setMenuGroupName(row.getMenuGroupName());
            this.menuRepository.save((Object)newMenu);
            logger.info("Inserted New Role: {}", (Object)newMenu.getMenuName());
        }
    }
}

