/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.db.users.main.entity;

import com.coraltele.helper.UuidUpdatable;
import com.coraltele.helper.UuidUpdateListener;
import java.time.LocalDateTime;
import java.util.UUID;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.PrePersist;
import javax.persistence.Table;
import lombok.Generated;

@Entity
@Table(name="m_user_token")
@EntityListeners(value={UuidUpdateListener.class})
public class UserToken
implements UuidUpdatable {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Integer id;
    private String username;
    @Column(name="createdon", columnDefinition="TIMESTAMP DEFAULT CURRENT_TIMESTAMP", nullable=true)
    private LocalDateTime createdOn;
    @Column(name="jwtauthkey", columnDefinition="VARCHAR(255) DEFAULT ''", nullable=true)
    private String jwtAuthKey;
    @Column(name="jwttokengeneratedtime", columnDefinition="bigint default 0", nullable=true)
    private Long jwtTokenGeneratedTime;
    @Column(name="jwttokenvalidtill", columnDefinition="bigint default 0", nullable=true)
    private Long jwtTokenValidTill;
    @Column(name="createdby", columnDefinition="VARCHAR(255) DEFAULT ''", nullable=true)
    private String createdBy;
    @Column(name="token_type", columnDefinition="VARCHAR(255) DEFAULT ''", nullable=true)
    private String tokenType;
    private String uuid;

    @PrePersist
    public void setValues() {
        if (this.uuid == null) {
            this.uuid = UUID.randomUUID().toString();
        }
        if (this.createdOn == null) {
            this.createdOn = LocalDateTime.now();
        }
    }

    @Generated
    public Integer getId() {
        return this.id;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public LocalDateTime getCreatedOn() {
        return this.createdOn;
    }

    @Generated
    public String getJwtAuthKey() {
        return this.jwtAuthKey;
    }

    @Generated
    public Long getJwtTokenGeneratedTime() {
        return this.jwtTokenGeneratedTime;
    }

    @Generated
    public Long getJwtTokenValidTill() {
        return this.jwtTokenValidTill;
    }

    @Generated
    public String getCreatedBy() {
        return this.createdBy;
    }

    @Generated
    public String getTokenType() {
        return this.tokenType;
    }

    @Generated
    public String getUuid() {
        return this.uuid;
    }

    @Generated
    public void setId(Integer id) {
        this.id = id;
    }

    @Generated
    public void setUsername(String username) {
        this.username = username;
    }

    @Generated
    public void setCreatedOn(LocalDateTime createdOn) {
        this.createdOn = createdOn;
    }

    @Generated
    public void setJwtAuthKey(String jwtAuthKey) {
        this.jwtAuthKey = jwtAuthKey;
    }

    @Generated
    public void setJwtTokenGeneratedTime(Long jwtTokenGeneratedTime) {
        this.jwtTokenGeneratedTime = jwtTokenGeneratedTime;
    }

    @Generated
    public void setJwtTokenValidTill(Long jwtTokenValidTill) {
        this.jwtTokenValidTill = jwtTokenValidTill;
    }

    @Generated
    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    @Generated
    public void setTokenType(String tokenType) {
        this.tokenType = tokenType;
    }

    @Generated
    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    @Generated
    public UserToken(Integer id, String username, LocalDateTime createdOn, String jwtAuthKey, Long jwtTokenGeneratedTime, Long jwtTokenValidTill, String createdBy, String tokenType, String uuid) {
        this.id = id;
        this.username = username;
        this.createdOn = createdOn;
        this.jwtAuthKey = jwtAuthKey;
        this.jwtTokenGeneratedTime = jwtTokenGeneratedTime;
        this.jwtTokenValidTill = jwtTokenValidTill;
        this.createdBy = createdBy;
        this.tokenType = tokenType;
        this.uuid = uuid;
    }

    @Generated
    public UserToken() {
    }
}

