/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.config;

import com.coraltele.config.AccessNotAllowed;
import com.coraltele.db.users.main.entity.User;
import com.coraltele.db.users.main.repository.UserRepository;
import com.coraltele.helper.JsonUtils;
import com.coraltele.helper.JwtUtil;
import com.coraltele.model.UserInfo;
import com.fasterxml.jackson.core.type.TypeReference;
import io.jsonwebtoken.Claims;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;

@Service
public class JwtUserDetailConfiguration
implements UserDetailsService {
    @Autowired(required=true)
    private UserRepository userRepository;
    @Autowired
    private JwtUtil jwtUtil;
    private List<Map<String, Object>> apiSecurityMappings = JsonUtils.readListFromJson((String)"default-data/api-security-mapping.json", (TypeReference)new /* Unavailable Anonymous Inner Class!! */);

    public UserInfo loadUserByUsername(String username) throws UsernameNotFoundException {
        Optional user = this.userRepository.findByUsername(username);
        if (!user.isPresent()) {
            throw new UsernameNotFoundException("User not found with username: " + username);
        }
        return new UserInfo(((User)user.get()).getUsername(), ((User)user.get()).getPassword(), new ArrayList(), ((User)user.get()).getUuidSecurity());
    }

    public UserInfo loadUserFromJWT(String jwtToken, String requestURL) throws UsernameNotFoundException, AccessNotAllowed {
        String userName = this.jwtUtil.getUsernameFromToken(jwtToken);
        Optional user = this.userRepository.findByUsername(userName);
        if (!user.isPresent()) {
            throw new UsernameNotFoundException("User not found with username: " + userName);
        }
        if (!this.jwtUtil.validateToken(jwtToken, ((User)user.get()).getUuidSecurity())) {
            throw new UsernameNotFoundException("Invalid JWT Token");
        }
        if (!userName.equals("admin")) {
            Claims claims = (Claims)this.jwtUtil.getClaimFromToken(jwtToken, allClaims -> allClaims);
            Object rolesObj = claims.get((Object)"roles");
            if (rolesObj == null) {
                throw new AccessNotAllowed("No roles found in JWT token for user: " + userName);
            }
            List<Object> userRoles = new ArrayList();
            if (rolesObj instanceof List) {
                userRoles = ((List)rolesObj).stream().map(Object::toString).collect(Collectors.toList());
            }
            if (this.apiSecurityMappings == null || this.apiSecurityMappings.isEmpty()) {
                throw new AccessNotAllowed("Unable to load API security mappings");
            }
            if (!this.hasAccess(userRoles, requestURL)) {
                throw new AccessNotAllowed("User " + userName + " does not have required role(s) to access endpoint: " + requestURL);
            }
        }
        return new UserInfo(((User)user.get()).getUsername(), ((User)user.get()).getPassword(), new ArrayList(), ((User)user.get()).getUuidSecurity());
    }

    private boolean hasAccess(List<String> userRoles, String requestURL) {
        boolean hasPermission = false;
        boolean endpointFound = false;
        block0: for (Map mapping : this.apiSecurityMappings) {
            String endpoint = (String)mapping.get("endpoint");
            if (!requestURL.contains(endpoint)) continue;
            endpointFound = true;
            List allowedRoles = (List)mapping.get("role");
            if (allowedRoles == null) break;
            for (String userRole : userRoles) {
                if (!allowedRoles.contains(userRole)) continue;
                hasPermission = true;
                break block0;
            }
        }
        return endpointFound && hasPermission;
    }
}

