/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.user.service;

import com.coraltele.db.users.main.entity.Menu;
import com.coraltele.db.users.main.entity.MenuGroup;
import com.coraltele.db.users.main.entity.User;
import com.coraltele.db.users.main.entity.UserRole;
import com.coraltele.db.users.main.repository.MenuGroupRepository;
import com.coraltele.db.users.main.repository.MenuRepository;
import com.coraltele.db.users.main.repository.UserRepository;
import com.coraltele.db.users.main.repository.UserRoleRepository;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.service.user.model.ActiveMenusModel;
import com.coraltele.service.user.model.MenuAndMenuGroupModel;
import com.coraltele.service.user.model.UserMenuActiveModel;
import com.coraltele.service.user.model.UserMenuModel;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserMenuService {
    @Autowired
    private MenuGroupRepository menuGroupRepository;
    @Autowired
    MenuRepository menuRepository;
    @Autowired
    UserRoleRepository userRoleRepository;
    @Autowired
    UserRepository userRepository;

    public List<UserMenuModel> getUserMenu() {
        RequestResponse returnValue = new RequestResponse();
        ArrayList<UserMenuModel> data = new ArrayList<UserMenuModel>();
        try {
            List menuGroupList = this.menuGroupRepository.findAll();
            if (!menuGroupList.isEmpty()) {
                for (MenuGroup row : menuGroupList) {
                    List menuData = this.menuRepository.findByMenuGroup(row.getId());
                    ArrayList<MenuAndMenuGroupModel> menus = new ArrayList<MenuAndMenuGroupModel>();
                    for (Menu menu : menuData) {
                        MenuAndMenuGroupModel menuModel = new MenuAndMenuGroupModel(menu.getMenuName(), menu.getId().intValue(), menu.getUrlPath(), menu.getIcon(), menu.getDescription(), menu.getSMenuSeq(), menu.getProduct());
                        menus.add(menuModel);
                    }
                    UserMenuModel userMenuModel = new UserMenuModel();
                    userMenuModel.setMenuGroup(row.getId());
                    userMenuModel.setName(row.getName());
                    userMenuModel.setDescription(row.getDescription());
                    userMenuModel.setIcon(row.getIcon());
                    userMenuModel.setMenus(menus);
                    data.add(userMenuModel);
                }
            }
            return data;
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Error occurred while retrieving user menu data.");
            return null;
        }
    }

    public List<UserMenuModel> getUserMenu(List<String> menuGroupList) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList<UserMenuModel> data = new ArrayList<UserMenuModel>();
        try {
            for (String menuGroup : menuGroupList) {
                ArrayList<MenuAndMenuGroupModel> menuListData = new ArrayList<MenuAndMenuGroupModel>();
                UserMenuModel menuGroupModel = new UserMenuModel();
                Optional mGroup = this.menuGroupRepository.findById(Integer.valueOf(menuGroup));
                if (!mGroup.isPresent()) continue;
                menuGroupModel.setId(((MenuGroup)mGroup.get()).getId());
                menuGroupModel.setDescription(((MenuGroup)mGroup.get()).getDescription());
                menuGroupModel.setName(((MenuGroup)mGroup.get()).getName());
                List menuList = this.menuRepository.findByMenuGroup(((MenuGroup)mGroup.get()).getId());
                for (Menu row : menuList) {
                    MenuAndMenuGroupModel records = new MenuAndMenuGroupModel();
                    if (!row.getIsActive().equals(true)) continue;
                    records.setMenuId(row.getId().intValue());
                    records.setDescription(row.getDescription());
                    records.setMenuName(row.getMenuName());
                    records.setSequence(row.getSMenuSeq());
                    records.setProduct(row.getProduct());
                    menuListData.add(records);
                }
                menuListData.sort(Comparator.comparing(MenuAndMenuGroupModel::getSequence));
                menuGroupModel.setMenus(menuListData);
                data.add(menuGroupModel);
            }
            return data;
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Error occurred while retrieving user menu data.");
            e.printStackTrace();
            return null;
        }
    }

    public List<String> menuOfParticularUser(String username) {
        ArrayList<String> returnValue = new ArrayList<String>();
        Optional user = this.userRepository.findByUsername(username);
        if (user.isPresent()) {
            List userRoles = this.userRoleRepository.findByUser((User)user.get());
            for (UserRole userRole : userRoles) {
                if (userRole.getMenuGroup() == null) continue;
                String menuGroupString = userRole.getMenuGroup();
                if (menuGroupString.startsWith("[") && menuGroupString.endsWith("]")) {
                    int[] menuGroupArray;
                    for (int menuGroupValue : menuGroupArray = this.parseMenuGroupString(menuGroupString)) {
                        returnValue.add(String.valueOf(menuGroupValue));
                    }
                    continue;
                }
                returnValue.add(menuGroupString);
            }
        }
        return returnValue;
    }

    private int[] parseMenuGroupString(String menuGroupString) {
        menuGroupString = menuGroupString.substring(1, menuGroupString.length() - 1);
        String[] menuGroupValues = menuGroupString.split(",");
        int[] menuGroupArray = new int[menuGroupValues.length];
        for (int i = 0; i < menuGroupValues.length; ++i) {
            menuGroupArray[i] = Integer.parseInt(menuGroupValues[i].trim());
        }
        return menuGroupArray;
    }

    public List<UserMenuActiveModel> getUserActiveMenu() {
        RequestResponse returnValue = new RequestResponse();
        ArrayList<UserMenuActiveModel> data = new ArrayList<UserMenuActiveModel>();
        try {
            List menuData = (List)this.menuRepository.findAll();
            HashMap<String, List> groupedMenus = new HashMap<String, List>();
            for (Menu menu : menuData) {
                if (!Boolean.TRUE.equals(menu.getIsActive())) continue;
                ActiveMenusModel menuModel = new ActiveMenusModel();
                menuModel.setIcon(menu.getIcon());
                menuModel.setKey(menu.getKey());
                menuModel.setMenuName(menu.getMenuName());
                menuModel.setProductionReady(menu.getProductionReady());
                menuModel.setUrl(menu.getUrlPath());
                menuModel.setCreation(menu.getCreation());
                menuModel.setUpdation(menu.getUpdation());
                menuModel.setRead(menu.getRead());
                menuModel.setDeletion(menu.getDeletion());
                menuModel.setMenuGroupName(menu.getMenuGroupName());
                menuModel.setIsActive(menu.getIsActive());
                groupedMenus.computeIfAbsent(menu.getMenuGroupName(), k -> new ArrayList()).add(menuModel);
            }
            UserMenuActiveModel userMenuActiveModel = new UserMenuActiveModel();
            userMenuActiveModel.setGroupMenus(groupedMenus);
            data.add(userMenuActiveModel);
            return data;
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Error occurred while retrieving user menu data.");
            return null;
        }
    }
}

