/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.telemetry.main.billingCDR.service;

import com.coraltele.db.telemetry.main.entity.BillingCDR;
import com.coraltele.db.telemetry.main.repository.BillingCDRRepository;
import com.coraltele.db.telemetry.main.specification.ExtensionBillingInBoundSpecification;
import com.coraltele.db.telemetry.main.specification.ExtensionBillingOutBoundSpecification;
import com.coraltele.db.telemetry.main.specification.ExtensionBillingSpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.DateFormatUtility;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.telemetry.main.billingCDR.model.BillingCDRBoundModel;
import com.coraltele.service.telemetry.main.billingCDR.model.BillingCDRModel;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class ExtensionBillingReportService {
    private static final Logger logger = LogManager.getLogger(ExtensionBillingReportService.class);
    @Autowired
    BillingCDRRepository billingCDRRepository;
    @Autowired
    DateFormatUtility dateFormatUtility;

    public RequestResponse getAllByFilter(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = ExtensionBillingSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.getSortDirection().equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "startEpoch" : searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.getSortDirection().equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "startEpoch" : searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.billingCDRRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.billingCDRRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)this.entityToModelConversion(page.getContent()));
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public List<BillingCDRModel> entityToModelConversion(List<BillingCDR> billingCDR) {
        ArrayList<BillingCDRModel> addValue = new ArrayList<BillingCDRModel>();
        for (BillingCDR row : billingCDR) {
            BillingCDRModel data = new BillingCDRModel();
            data.setAnswerEpoch(DateFormatUtility.epochToLocalDateTimeAsStringForSecondToHandleZero((Long)row.getAnswerEpoch()));
            if (row.getCallConnected() != null) {
                if (row.getCallConnected().booleanValue()) {
                    data.setCallConnected("Yes");
                } else {
                    data.setCallConnected("No");
                }
            } else {
                data.setCallConnected("No");
            }
            data.setCallerIdNumber(row.getCallerIdNumber());
            data.setCoralCallDirection(row.getCoralCallDirection());
            data.setDestinationNumber(row.getDestinationNumber());
            data.setDuration(DateFormatUtility.findLocalTime((Long)row.getDuration()));
            data.setEndEpoch(DateFormatUtility.epochToLocalDateTimeAsStringForSecondToHandleZero((Long)row.getEndEpoch()));
            data.setId(row.getId());
            data.setStartEpoch(DateFormatUtility.epochToLocalDateTimeAsStringForSecondToHandleZero((Long)row.getStartEpoch()));
            data.setStartDate((Object)this.dateFormatUtility.epochToLocalDate(row.getStartEpoch()));
            if (row.getMos().compareTo(BigDecimal.valueOf(0.0)) == 0) {
                data.setMos(BigDecimal.valueOf(4.3));
            } else {
                data.setMos(row.getMos());
            }
            data.setBillsec(DateFormatUtility.findLocalTime((Long)row.getBillsec()));
            data.setPulseRate(Long.valueOf(row.getPulseRate() != null ? row.getPulseRate() : 0L));
            data.setPulseVal(Long.valueOf(row.getPulseVal() != null ? row.getPulseVal() : 0L));
            data.setTalkDuration(DateFormatUtility.findLocalTime((Long)row.getTalkDuration()));
            Long costInPaise = row.getCostVal() != null ? row.getCostVal() : 0L;
            double costInRupees = (double)costInPaise.longValue() / 100.0;
            data.setCostVal(costInRupees);
            data.setCallerName(row.getCallerName());
            data.setDestinationName(row.getDestinationName());
            data.setDIDNumber(row.getDIDNumber());
            data.setDODNumber(row.getDODNumber());
            data.setCallType(row.getCallType());
            data.setDuration(row.getDuration().toString());
            data.setTalkDuration(row.getTalkDuration().toString());
            data.setCoralFeatureCode(row.getCoralFeatureCode());
            addValue.add(data);
        }
        return addValue;
    }

    public RequestResponse getAllByOutBound() {
        try {
            List gateways = this.billingCDRRepository.findDistinctGateways();
            RequestResponse response = new RequestResponse();
            response.setStatus(Constants.Error.OK);
            response.setMessage("Distinct gateways fetched successfully");
            response.setData((Object)gateways);
            return response;
        }
        catch (Exception e) {
            RequestResponse response = new RequestResponse();
            response.setStatus(Constants.Error.ERROR);
            response.setMessage("Failed to fetch gateways: " + e.getMessage());
            return response;
        }
    }

    public RequestResponse getAllByInBound() {
        try {
            List gateways = this.billingCDRRepository.findDistinctGateways();
            RequestResponse response = new RequestResponse();
            response.setStatus(Constants.Error.OK);
            response.setMessage("Distinct inbound gateways fetched successfully");
            response.setData((Object)gateways);
            return response;
        }
        catch (Exception e) {
            RequestResponse response = new RequestResponse();
            response.setStatus(Constants.Error.ERROR);
            response.setMessage("Failed to fetch inbound gateways: " + e.getMessage());
            return response;
        }
    }

    public RequestResponse getAllByInBoundFilter(SearchRequest searchRequest) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = ExtensionBillingInBoundSpecification.generateFilters((SearchRequest)searchRequest);
        Sort sort = null;
        if (searchRequest.getSortDirection().equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequest.getSortBy().equals("") || searchRequest.getSortBy() == null ? "startEpoch" : searchRequest.getSortBy()}).ascending();
        } else if (searchRequest.getSortDirection().equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequest.getSortBy().equals("") || searchRequest.getSortBy() == null ? "startEpoch" : searchRequest.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.billingCDRRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequest.getCurrentPage(), (int)(searchRequest.getPageSize() == 0 ? 10 : searchRequest.getPageSize()))) : this.billingCDRRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequest.getCurrentPage(), (int)(searchRequest.getPageSize() == 0 ? 10 : searchRequest.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequest.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequest.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)this.entityToModelConversionInBound(page.getContent()));
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public List<BillingCDRBoundModel> entityToModelConversionInBound(List<BillingCDR> billingCDR) {
        ArrayList<BillingCDRBoundModel> addValue = new ArrayList<BillingCDRBoundModel>();
        for (BillingCDR row : billingCDR) {
            BillingCDRBoundModel data = new BillingCDRBoundModel();
            data.setAnswerEpoch(DateFormatUtility.epochToLocalDateTimeAsStringForSecondToHandleZero((Long)row.getAnswerEpoch()));
            if (row.getCallConnected() != null) {
                if (row.getCallConnected().booleanValue()) {
                    data.setCallConnected("Yes");
                } else {
                    data.setCallConnected("No");
                }
            } else {
                data.setCallConnected("No");
            }
            data.setCallerIdNumber(row.getCallerIdNumber());
            data.setCoralCallDirection(row.getCoralCallDirection());
            data.setDestinationNumber(row.getDestinationNumber());
            data.setDuration(DateFormatUtility.findLocalTime((Long)row.getDuration()));
            data.setEndEpoch(DateFormatUtility.epochToLocalDateTimeAsStringForSecondToHandleZero((Long)row.getEndEpoch()));
            data.setId(row.getId());
            data.setStartEpoch(DateFormatUtility.epochToLocalDateTimeAsStringForSecondToHandleZero((Long)row.getStartEpoch()));
            data.setStartDate((Object)this.dateFormatUtility.epochToLocalDate(row.getStartEpoch()));
            if (row.getMos().compareTo(BigDecimal.valueOf(0.0)) == 0) {
                data.setMos(BigDecimal.valueOf(4.3));
            } else {
                data.setMos(row.getMos());
            }
            data.setBillsec(DateFormatUtility.findLocalTime((Long)row.getBillsec()));
            data.setPulseRate(Long.valueOf(row.getPulseRate() != null ? row.getPulseRate() : 0L));
            data.setPulseVal(Long.valueOf(row.getPulseVal() != null ? row.getPulseVal() : 0L));
            data.setTalkDuration(DateFormatUtility.findLocalTime((Long)row.getTalkDuration()));
            Long costInPaise = row.getCostVal() != null ? row.getCostVal() : 0L;
            double costInRupees = (double)costInPaise.longValue() / 100.0;
            data.setCostVal(costInRupees);
            data.setCallerName(row.getCallerName());
            data.setDestinationName(row.getDestinationName());
            data.setDIDNumber(row.getDIDNumber());
            data.setDODNumber(row.getDODNumber());
            data.setCallType(row.getCallType());
            data.setDuration(DateFormatUtility.findLocalTime((Long)row.getDuration()));
            data.setTalkDuration(DateFormatUtility.findLocalTime((Long)row.getTalkDuration()));
            data.setCoralGateway(row.getCoralInBoundGateway());
            data.setCoralGatewayName(row.getCoralInBoundGatewayName());
            addValue.add(data);
        }
        return addValue;
    }

    public RequestResponse getAllByOutBoundFilter(SearchRequest searchRequest) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = ExtensionBillingOutBoundSpecification.generateFilters((SearchRequest)searchRequest);
        Sort sort = null;
        if (searchRequest.getSortDirection().equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequest.getSortBy().equals("") || searchRequest.getSortBy() == null ? "startEpoch" : searchRequest.getSortBy()}).ascending();
        } else if (searchRequest.getSortDirection().equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequest.getSortBy().equals("") || searchRequest.getSortBy() == null ? "startEpoch" : searchRequest.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.billingCDRRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequest.getCurrentPage(), (int)(searchRequest.getPageSize() == 0 ? 10 : searchRequest.getPageSize()))) : this.billingCDRRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequest.getCurrentPage(), (int)(searchRequest.getPageSize() == 0 ? 10 : searchRequest.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequest.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequest.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)this.entityToModelConversionOutBound(page.getContent()));
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public List<BillingCDRBoundModel> entityToModelConversionOutBound(List<BillingCDR> billingCDR) {
        ArrayList<BillingCDRBoundModel> addValue = new ArrayList<BillingCDRBoundModel>();
        for (BillingCDR row : billingCDR) {
            BillingCDRBoundModel data = new BillingCDRBoundModel();
            data.setAnswerEpoch(DateFormatUtility.epochToLocalDateTimeAsStringForSecondToHandleZero((Long)row.getAnswerEpoch()));
            if (row.getCallConnected() != null) {
                if (row.getCallConnected().booleanValue()) {
                    data.setCallConnected("Yes");
                } else {
                    data.setCallConnected("No");
                }
            } else {
                data.setCallConnected("No");
            }
            data.setCallerIdNumber(row.getCallerIdNumber());
            data.setCoralCallDirection(row.getCoralCallDirection());
            data.setDestinationNumber(row.getDestinationNumber());
            data.setDuration(DateFormatUtility.findLocalTime((Long)row.getDuration()));
            data.setEndEpoch(DateFormatUtility.epochToLocalDateTimeAsStringForSecondToHandleZero((Long)row.getEndEpoch()));
            data.setId(row.getId());
            data.setStartEpoch(DateFormatUtility.epochToLocalDateTimeAsStringForSecondToHandleZero((Long)row.getStartEpoch()));
            data.setStartDate((Object)this.dateFormatUtility.epochToLocalDate(row.getStartEpoch()));
            if (row.getMos().compareTo(BigDecimal.valueOf(0.0)) == 0) {
                data.setMos(BigDecimal.valueOf(4.3));
            } else {
                data.setMos(row.getMos());
            }
            data.setBillsec(DateFormatUtility.findLocalTime((Long)row.getBillsec()));
            data.setPulseRate(Long.valueOf(row.getPulseRate() != null ? row.getPulseRate() : 0L));
            data.setPulseVal(Long.valueOf(row.getPulseVal() != null ? row.getPulseVal() : 0L));
            data.setTalkDuration(DateFormatUtility.findLocalTime((Long)row.getTalkDuration()));
            Long costInPaise = row.getCostVal() != null ? row.getCostVal() : 0L;
            double costInRupees = (double)costInPaise.longValue() / 100.0;
            data.setCostVal(costInRupees);
            data.setCallerName(row.getCallerName());
            data.setDestinationName(row.getDestinationName());
            data.setDIDNumber(row.getDIDNumber());
            data.setDODNumber(row.getDODNumber());
            data.setCallType(row.getCallType());
            data.setDuration(row.getDuration().toString());
            data.setTalkDuration(DateFormatUtility.findLocalTime((Long)row.getTalkDuration()));
            data.setCoralGateway(row.getCoralGateway());
            data.setCoralGatewayName(row.getCoralGatewayName());
            addValue.add(data);
        }
        return addValue;
    }
}

