/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.telemetry.coralnms.scada_asset.controller;

import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.service.telemetry.coralnms.scada_asset.model.SCADAAssetModel;
import com.coraltele.service.telemetry.coralnms.scada_asset.service.SCADAAssetService;
import java.security.Principal;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v2/SCADAAsset"})
public class SCADAAssetController {
    @Autowired
    private SCADAAssetService service;

    @PostMapping(value={"/create"})
    public ResponseEntity<RequestResponse> create(@RequestBody SCADAAssetModel data) {
        RequestResponse returnValue = this.service.create(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/{id}"})
    public ResponseEntity<RequestResponse> getById(@PathVariable(value="id") Long id) {
        RequestResponse returnValue = this.service.getById(id);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/update"})
    public ResponseEntity<RequestResponse> updateSCADAAsset(@RequestBody SCADAAssetModel data) {
        RequestResponse returnValue = this.service.updateSCADAAsset(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/serverGroupId/dropdown"})
    public ResponseEntity<RequestResponse> getServerGroupId() {
        RequestResponse returnValue = this.service.getServerGroupId();
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/list"})
    public ResponseEntity<RequestResponse> getSCADAAssetByFilter(@RequestBody SearchRequest searchRequestData) {
        RequestResponse returnValue = this.service.getSCADAAssetByFilter(searchRequestData);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/delete"})
    public ResponseEntity<RequestResponse> deleteData(@RequestBody InputIdModel id) {
        RequestResponse returnValue = this.service.deleteSCADAAssetById(id);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/list/assets"})
    public ResponseEntity<RequestResponse> getAssetsById(@RequestBody InputIdModel id) {
        RequestResponse returnValue = this.service.getAllCategory(id);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/mediaGateway"})
    public ResponseEntity<RequestResponse> getListOfAssetId() {
        RequestResponse returnValue = this.service.getListOfAssetId();
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/mediaGateway/{id}"})
    public ResponseEntity<RequestResponse> generateTokenAndURL(@PathVariable(value="id") Long id, Principal principal) {
        RequestResponse returnValue = this.service.generateTokenAndURL(id, principal);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/getAssetConfig/{assetId}"})
    public ResponseEntity<RequestResponse> getFormWithData(@PathVariable(value="assetId") Long assetId) {
        RequestResponse returnValue = this.service.getFormAndData(assetId);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/create/{assetId}"})
    public ResponseEntity<RequestResponse> createJsonData(@PathVariable(value="assetId") Long assetId, @RequestBody Map<String, Object> data) throws Exception {
        RequestResponse returnValue = this.service.createJsonFile(assetId, data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/updateConfiguration/{assetId}"})
    public ResponseEntity<RequestResponse> updateConfiguration(@PathVariable(value="assetId") Long assetId) throws Exception {
        RequestResponse returnValue = this.service.updateConfiguration(assetId);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/listAll"})
    public ResponseEntity<RequestResponse> getAll() {
        RequestResponse returnValue = this.service.getAllNodeName();
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }
}

