/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.pbx.pForkExtension.controller;

import com.coraltele.db.telephony.pbx.entity.PForkExtension;
import com.coraltele.db.telephony.pbx.repository.PForkExtensionRepository;
import com.coraltele.db.telephony.pbx.specification.PForkExtensionSpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.DownloadPdfService;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.service.background.DynamicPdfThreadService;
import com.coraltele.service.pbx.fwdExtension.model.FwdExtModel;
import com.coraltele.service.pbx.pForkExtension.service.PForkExtensionService;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"api/v2/pForkExtension"})
public class PForkExtensionController {
    private static final Logger logger = LogManager.getLogger(PForkExtensionController.class);
    @Autowired
    PForkExtensionService pForkExtensionService;
    @Autowired
    DynamicPdfThreadService generatingReports;
    @Autowired
    DownloadPdfService pdfDownloadService;
    @Autowired
    private DynamicPdfThreadService dynamicReportThreadService;
    @Autowired
    PForkExtensionRepository pForkExtensionRepository;
    private static final ConcurrentHashMap<String, String> columnMappings = new ConcurrentHashMap();

    @PostMapping(value={"/create"})
    public ResponseEntity<RequestResponse> addUser(@RequestBody FwdExtModel data, Principal principal) {
        RequestResponse returnValue = this.pForkExtensionService.createData(data, principal);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/update"})
    public ResponseEntity<RequestResponse> getUserById(@RequestBody FwdExtModel data, Principal principal) {
        RequestResponse returnValue = this.pForkExtensionService.update(data, principal);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/{day}/{ext}/list"})
    public ResponseEntity<RequestResponse> getListByDayAndExt(@PathVariable(value="day") String day, @PathVariable(value="ext") String extension) {
        RequestResponse returnValue = this.pForkExtensionService.getListByDayAndExt(day, extension);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/delete"})
    public ResponseEntity<RequestResponse> deleteMeeting(@RequestBody InputIdModel id) {
        RequestResponse returnValue = this.pForkExtensionService.deleteById(id);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/listAll/{extTypeList}"})
    public ResponseEntity<RequestResponse> getAcdPickUpGroup(@PathVariable(value="extTypeList") List<String> extTypeList) {
        RequestResponse returnValue = this.pForkExtensionService.getAcdPickUpGroup(extTypeList);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/list"})
    public ResponseEntity<RequestResponse> getAllFwdExtensionByFilter(@RequestBody SearchRequest searchRequestData) {
        RequestResponse returnValue = this.pForkExtensionService.getAllFwdExtensionByFilter(searchRequestData);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/downloadCSV"})
    public ResponseEntity<byte[]> downloadFilteredDataToCSV(@RequestBody SearchRequest searchRequestData) {
        try {
            logger.info("CSV file download started for cmsReport--");
            Specification filters = PForkExtensionSpecification.generateFilters((SearchRequest)searchRequestData);
            Sort sort = null;
            if ("asc".equals(searchRequestData.getSortDirection())) {
                sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().isEmpty() || searchRequestData.getSortBy() == null ? "complaintTime" : searchRequestData.getSortBy()}).ascending();
            } else if ("desc".equals(searchRequestData.getSortDirection())) {
                sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().isEmpty() || searchRequestData.getSortBy() == null ? "complaintTime" : searchRequestData.getSortBy()}).descending();
            }
            List filteredData = sort != null ? this.pForkExtensionRepository.findAll(filters, sort) : this.pForkExtensionRepository.findAll(filters);
            StringWriter stringWriter = new StringWriter();
            try (CSVPrinter csvPrinter = new CSVPrinter((Appendable)stringWriter, CSVFormat.DEFAULT);){
                logger.info("Original column names: " + searchRequestData.getColumnNames());
                List displayNames = searchRequestData.getColumnNames().stream().map(columnName -> columnMappings.getOrDefault(columnName, columnName)).collect(Collectors.toList());
                logger.info("Display names: " + displayNames);
                csvPrinter.printRecord(displayNames);
                for (PForkExtension item : filteredData) {
                    ArrayList<String> values = new ArrayList<String>();
                    for (String columnName2 : searchRequestData.getColumnNames()) {
                        values.add(this.getColumnValue(item, columnName2));
                    }
                    csvPrinter.printRecord(values);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                logger.error("Error while traversing data for cmsReport", (Object)e.getMessage());
            }
            String csvContent = stringWriter.toString();
            byte[] csvBytes = csvContent.getBytes(StandardCharsets.UTF_8);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
            headers.setContentDispositionFormData("attachment", "filtered_data.csv");
            logger.info("CSV data download successfully.");
            return new ResponseEntity((Object)csvBytes, (MultiValueMap)headers, HttpStatus.OK);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error while downloading cmsReport CSV file!", (Object)e.getMessage());
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }

    @PostMapping(value={"/generateAndDownloadPdf"})
    public CompletableFuture<ResponseEntity<?>> generateAndDownloadPdf(@RequestParam String reportType, @RequestBody SearchRequest searchRequestData, Principal principal) {
        String folderPath = "/tmp/";
        File folder = new File(folderPath);
        String fileNamePrefix = reportType + "_";
        File[] files = folder.listFiles((dir, name) -> name.startsWith(fileNamePrefix));
        if (files != null) {
            for (File file : files) {
                if (file.delete()) {
                    logger.info("Deleted existing report: {}" + file.getName());
                    continue;
                }
                logger.error("Failed to delete existing report: {}" + file.getName());
            }
        }
        String filePath = "/tmp/" + reportType + "_" + System.currentTimeMillis() + ".pdf";
        String id = UUID.randomUUID().toString();
        CompletableFuture generationFuture = this.dynamicReportThreadService.startGeneratingReportAsync(reportType, id, searchRequestData, filePath, principal);
        return generationFuture.thenApply(response -> {
            if (response.getStatus().equals((Object)Constants.Error.OK)) {
                ResponseEntity downloadResponse = this.pdfDownloadService.getPdfFile(filePath);
                if (downloadResponse.getStatusCode().is2xxSuccessful()) {
                    return ResponseEntity.ok().body(downloadResponse.getBody());
                }
                return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("Failed to download PDF. Reason: " + downloadResponse.getStatusCode()));
            }
            return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body(response);
        });
    }

    private String getColumnValue(PForkExtension item, String columnName) {
        switch (columnName) {
            case "id": {
                return this.checkNull((Object)item.getId());
            }
            case "createdOn": {
                return this.checkNull((Object)item.getCreatedOn());
            }
            case "createdBy": {
                return this.checkNull((Object)item.getCreatedBy());
            }
            case "extension": {
                return this.checkNull((Object)item.getExtension());
            }
            case "sunday": {
                if (item.getSunday() != null && item.getSunday() == 1) {
                    return "Yes";
                }
                return "No";
            }
            case "monday": {
                if (item.getMonday() != null && item.getMonday() == 1) {
                    return "Yes";
                }
                return "No";
            }
            case "tuesday": {
                if (item.getTuesday() != null && item.getTuesday() == 1) {
                    return "Yes";
                }
                return "No";
            }
            case "wednesday": {
                if (item.getWednesday() != null && item.getWednesday() == 1) {
                    return "Yes";
                }
                return "No";
            }
            case "thursday": {
                if (item.getThursday() != null && item.getThursday() == 1) {
                    return "Yes";
                }
                return "No";
            }
            case "friday": {
                if (item.getFriday() != null && item.getFriday() == 1) {
                    return "Yes";
                }
                return "No";
            }
            case "saturday": {
                if (item.getSaturday() != null && item.getSaturday() == 1) {
                    return "Yes";
                }
                return "No";
            }
            case "fromTime": {
                return this.checkNull((Object)item.getFromTime());
            }
            case "toTime": {
                return this.checkNull((Object)item.getToTime());
            }
            case "forwardExtension": {
                return this.checkNull((Object)item.getForwardExtension());
            }
            case "updatedOn": {
                return this.checkNull((Object)item.getUpdatedOn());
            }
            case "updatedBy": {
                return this.checkNull((Object)item.getUpdatedBy());
            }
        }
        return "";
    }

    private String checkNull(Object value) {
        return value != null ? value.toString() : "";
    }
}

